/*
	.-==========================================-.
	|~~ Long Jump Stats - eXtreme Modification ~~|
	.-==========================================-.

	Server cvars:

	===-

	// Enabled/Disables the plugin
	// 0 = disabled
	// 1 = enabled
	kz_ljs_enabled "1"

	// Maximum possible lj (not 4 cj)
	kz_max_lj "260.0"

	// 1337 lj (prints to all players)
	// To disable, set it to -1
	kz_leet_lj "250.0"

	// Professional lj (prints to all players)
	// To disable, set it to -1
	kz_pro_lj "245.0"

	// Good lj (prints to all players)
	// To disable, set it to -1
	kz_good_lj "240.0"

	// Minimal lj distance
	kz_min_lj "215.0"

	// Difrence between longjump and countjump for good/pro/leet/max jump
	kz_cj_dif "10.0"

	// Enables lj sounds
	// 0 = disabled
	// 1 = ultimate sounds
	// 2 = distance in voice
	kz_lj_sounds "1"

	// How dose plugin works
	// 0 = no top and no colorchat
	// 1 = prints good/pro/leet jumps
	// 2 = enables top10
	// 3 = prints good/pro/leet jumps and enables top10
	kz_ljs_tops "3"

	// Do you want to save ljtop after mapchange?
	kz_ljs_topsave "1"

	// How ranking will work?
	// 0 = names
	// 1 = steam ids
	// 2 = ips
	kz_ljs_rank_by "0"

	// Kz jumping color chat:
	// 0 = normal
	// 1 = red
	// 2 = green
	// 3 = blue
	// 4 = silver
	// 5 = team color

	kz_leet_lj_clr "1"
	kz_pro_lj_clr "2"
	kz_good_lj_clr "4"

	kz_leet_cj_clr "1"
	kz_pro_cj_clr "2"
	kz_good_cj_clr "4"

	// Colors of /ljstats (rrr ggg bbb)
	kz_ljstats_red "0"
	kz_ljstats_green "255"
	kz_ljstats_blue "159"

	// LongJump Stats Laser Beam
	// 0 = off
	// 1 = normal
	// 2 = uber beam
	kz_ljs_beam "2"

	// Enables protection 4 legal kreedz settings
	kz_legal_settings "1"

	// Is your server fast?
	// 0 = slow
	// 1 = normal
	// 2 = realy good ( >10mb/s or localhost/lan server )
	kz_ljs_fastserver "2"

	// Enables auto-setting 4 kz_ljs_fastserver cvar if it is 2
	kz_ljs_autoserver "1"

	// What is enabled on client when he connects to a server?
	// 0 = nothing
	// a = colorchat
	// b = ljstats
	// c = speed
	kz_ljs_connectenabler "abc"

	// Do you want cmds like /speed to be visible in the chat?
	kz_ljs_viscmds "1"

	// Speedometer type
	// 0 = show real speed and horizontal speed
	// 1 = show real speed
	// 2 = show horizontal speed
	kz_ljs_speedtype "0"

	.-==========================================-.


	Admin commands:

	==-

	amx_resetljrec - resets ljrec and ljtop
	amx_resetljtop - resets ljrec and ljtop

	.-==========================================-.


	Client commands:

	==-

	say /colorchat  - enables/disables colorchat
	say /lj10       - display tops menu
	say /ljrec      - display records menu
	say /ljsmenu    - display ljs menu
	say /ljstats    - enables/disables longjump stats
	say /ljsversion - prints plugin version
	say /speed      - enables/disables visible speed

	.-==========================================-.


	Installation:

	==-

	1. Extract all files and overwrite your cstrike folder
	2. Add kz_ljs_xm.amxx in addons/amxmodx/configs/plugins.ini list
	3. Restart your server/Change map
	!!! WARNING !!!
	To get better gocheck and hook protection write kz_ljs_xm.amxx
	in plugins.ini BEFORE your checkpoint and hook plugins!
	Good e.x. of plugins.ini
	-> kz_ljs_xm.amxx
	-> ProKreedz.amxx
	-> ProKreedz_Hook.amxx
	Bad e.x. of plugins.ini
	-> ProKreedz.amxx
	-> ProKreedz_Hook.amxx
	-> kz_ljs_xm.amxx

	.-==========================================-.


	Credits:

	==-

	Created by:
	Fatalis    ( 8.9.22.42:27017 )      ( http://www.KZMonkeys.net )
	Numb       ( 195.149.21.176:27016 ) ( http://sensation-kreedz.net )

	Special thanks to:
	Bentski    ( cs.bentski.lt:27015 )  ( http://kzlt.bentski.lt )
	~Val~      ( cs.groza.ru:27017 )    ( http://www.groza.ru )

	Hosted by:
	http://www.xtreme-jumps.eu/
	http://www.thebishop.fr/

	.-==========================================-.

	Have fun! =]


	P.S. You need legal kreedz settings 4 this to work!!!

*/

#include <amxmodx>
#include <amxmisc>
#include <colorchat>
#include <fakemeta>

#pragma semicolon 1

#define INFO_ONE 1
#define INFO_ZERO 0

// Ints & strings
new server_settings[34][27][16];
new plugin_id;
new plugin_file_name[64];
new pluginstatus;
new gBeam;
new strafes[33];
new goodsync[33];
new badsync[33];
new ljsDir[64];
new pre_type[33][32];
new top_names[10][33];
new top_authid[10][33];
new top_distance[10];
new top_maxspeed[10];
new top_prestrafe[10];
new top_strafes[10];
new top_sync[10];
new top_type[10][5];
new top_pretype[10][32];
new cj_names[10][33];
new cj_authid[10][33];
new cj_distance[10];
new cj_maxspeed[10];
new cj_prestrafe[10];
new cj_strafes[10];
new cj_sync[10];
new cj_pretype[10][32];
new lj_names[10][33];
new lj_authid[10][33];
new lj_distance[10];
new lj_maxspeed[10];
new lj_prestrafe[10];
new lj_strafes[10];
new lj_sync[10];
new lj_pretype[10][32];
new view_names[33][10][33];
new view_distance[33][10];
new view_maxspeed[33][10];
new view_prestrafe[33][10];
new view_strafes[33][10];
new view_sync[33][10];
new view_type[33][10][5];
new view_pretype[33][10][32];
new full_top_stats_selected_type[33];
new full_top_stats_selected_page[33];

// Bools
new bool:possible_lj_script[33][2];
new bool:tops_save;
new bool:gHasColorChat[33];
new bool:gHasSpeed[33];
new bool:gHasLjStats[33];
new bool:gInAir[33];
new bool:cjumped[33];
new bool:doubleducked[33];
new bool:cducked[33];
new bool:induck[33];
new bool:OnGround[33];
new bool:turning_right[33];
new bool:turning_left[33];
new bool:strafing_aw[33];
new bool:strafing_sd[33];

// Floats
new Float:vBeamPos[33][129][3];
new Float:vBeamPosStatus[33][129];
new Float:vBeamTime[33][129];
new Float:old_angle1[33];
new Float:angle[3];
new Float:vFramePos[33][2][3];
new Float:vFrameSpeed[33][2][3];
new Float:vDuckedAt[33][3];
new Float:vJumpedAt[33][3];
new Float:vJumpedAt2[3];
new Float:xDistance;
new Float:yDistance;
new Float:fDistance;
new Float:fDistance1;
new Float:fDistance2;
new Float:rDistance[2];
new Float:rLandPos[3];
new Float:vOrigin[3];
new Float:vOldOrigin[33][3];
new Float:vTraceEnd[3];
new Float:fMaxAirSpeed[33];
new Float:fMaxGroundSpeed[33];
new Float:vVelocity[3];
new Float:fSpeed;
new Float:gSpeed;
new Float:OldSpeed[33];
new Float:frame2time;
new Float:jumptime[33];
new Float:lasttime[33];
new Float:beam_jump_off_time[33];

// Plugin strings
new const gPLUGIN[] = "LjS - eXtreme Mod";
new const gVERSION[] = "2.2b7";
new const gVERSION_NUM[] = "22007";
new const gAUTHOR[] = "Fatalis & Numb";

// Cvars
new kz_ljs_enabled;
new kz_good_lj;
new kz_pro_lj;
new kz_leet_lj;
new kz_min_lj;
new kz_max_lj;
new kz_cj_dif;
new kz_lj_sounds;
new kz_leet_lj_clr;
new kz_pro_lj_clr;
new kz_good_lj_clr;
new kz_leet_cj_clr;
new kz_pro_cj_clr;
new kz_good_cj_clr;
new kz_ljstats_red;
new kz_ljstats_green;
new kz_ljstats_blue;
new kz_ljs_beam;
new kz_legal_settings;
new kz_ljs_fastserver;
new kz_ljs_autoserver;
new kz_ljs_speedtype;
new kz_ljs_connectenabler;
new kz_ljs_viscmds;
new kz_ljs_tops;
new kz_ljs_topsave;
new kz_ljs_rank_by;
new edgefriction;
new mp_footsteps;
new sv_cheats;
new sv_gravity;
new sv_airaccelerate;
new sv_maxspeed;
new sv_stepsize;
new sv_maxvelocity;
new sv_lan;

public plugin_init()
{
	if( tops_save )
		read_tops();
	
	new s_plugin_id[32], filename[255];
	
	format(s_plugin_id, 31, "%d", plugin_id);
	format(filename, 254, "%s/ljs_plugin_info.txt", ljsDir);
	
	if( file_exists(filename) )
		delete_file(filename);
	
	write_file(filename, gVERSION_NUM);
	write_file(filename, s_plugin_id);
	write_file(filename, plugin_file_name);
	write_file(filename, gPLUGIN);
	write_file(filename, gVERSION);
	write_file(filename, gAUTHOR);
}

public plugin_start()
{
	plugin_id = register_plugin(gPLUGIN, gVERSION, gAUTHOR);
	register_cvar("LongJumpStats", gVERSION, FCVAR_SERVER);
	register_dictionary("common.txt");
	
	
	register_forward(FM_Touch,           "fwdTouch",           1);
	register_forward(FM_PlayerPreThink,  "fwdPlayerPreThink",  0);
	register_forward(FM_PlayerPostThink, "fwdPlayerPostThink", 0);
	register_forward(FM_StartFrame,      "fwdStartFrame",      0);
	
	
	kz_ljs_enabled        = register_cvar("kz_ljs_enabled",        "1");		// enables/disables the plugin
	kz_good_lj            = register_cvar("kz_good_lj",            "240.0");	// good longjumps
	kz_pro_lj             = register_cvar("kz_pro_lj",             "245.0");	// professional longjumps
	kz_leet_lj            = register_cvar("kz_leet_lj",            "250.0");	// leet longjump
	kz_min_lj             = register_cvar("kz_min_lj",             "215.0");	// minimal longjump
	kz_max_lj             = register_cvar("kz_max_lj",             "260.0");	// maximal longjump
	kz_cj_dif             = register_cvar("kz_cj_dif",             "10.0");		// difrence between lj and cj
	kz_lj_sounds          = register_cvar("kz_lj_sounds",          "1");		// enables leet/pro/good lj/cj sounds
	kz_leet_lj_clr        = register_cvar("kz_leet_lj_clr",        "1");		// color of leet lj (1=red, 2=green, 3=blue, 4=gray, 5=team, 0=default)
	kz_pro_lj_clr         = register_cvar("kz_pro_lj_clr",         "2");		// color of pro lj
	kz_good_lj_clr        = register_cvar("kz_good_lj_clr",        "4");		// color of good lj
	kz_leet_cj_clr        = register_cvar("kz_leet_cj_clr",        "1");		// color of leet lj
	kz_pro_cj_clr         = register_cvar("kz_pro_cj_clr",         "2");		// color of pro lj
	kz_good_cj_clr        = register_cvar("kz_good_cj_clr",        "4");		// color of good lj
	kz_ljstats_red        = register_cvar("kz_ljstats_red",        "0");		// red color of /ljstats
	kz_ljstats_green      = register_cvar("kz_ljstats_green",      "255");		// green color of /ljstats
	kz_ljstats_blue       = register_cvar("kz_ljstats_blue",       "159");		// blue color of /ljstats
	kz_ljs_beam           = register_cvar("kz_ljs_beam",           "2");		// 0=beam off, 1=normal beam, 2=uber beam
	kz_legal_settings     = register_cvar("kz_legal_settings",     "1");		// enables protection 4 legal kreedz settings
	kz_ljs_fastserver     = register_cvar("kz_ljs_fastserver",     "1");            // Is your server fast? (0=slow, 1=normal, 2=good)
	kz_ljs_autoserver     = register_cvar("kz_ljs_autoserver",     "1");		// Authomaticaly detect what cvar of kz_ljs_fastserver shold be?
	kz_ljs_speedtype      = register_cvar("kz_ljs_speedtype",      "0");		// Speedometer type
	kz_ljs_connectenabler = register_cvar("kz_ljs_connectenabler", "abc");		// What is enabled at connect (0=nothing, a=colorchat, b=ljstats, c=speed)
	kz_ljs_viscmds        = register_cvar("kz_ljs_viscmds",        "1");		// Do you want say commands to be apeard on the chat?
	kz_ljs_tops           = register_cvar("kz_ljs_tops",           "3");		// LongJump top (0=Nothing, 1=ColorChat, 2=top, 3=top+ColorChat)
	kz_ljs_topsave        = register_cvar("kz_ljs_topsave",        "1");		// Do you want to save ljtop after mapchange?
	kz_ljs_rank_by        = register_cvar("kz_ljs_rank_by",        "0");		// How ranking will work? 0=name, 1=steam, 2=ip
	
	edgefriction          = get_cvar_pointer("edgefriction");
	mp_footsteps          = get_cvar_pointer("mp_footsteps");
	sv_cheats             = get_cvar_pointer("sv_cheats");
	sv_gravity            = get_cvar_pointer("sv_gravity");
	sv_airaccelerate      = get_cvar_pointer("sv_airaccelerate");
	sv_maxspeed           = get_cvar_pointer("sv_maxspeed");
	sv_stepsize           = get_cvar_pointer("sv_stepsize");
	sv_maxvelocity        = get_cvar_pointer("sv_maxvelocity");
	sv_lan                = get_cvar_pointer("sv_lan");
	
	
	server_settings[33][0] = "1";
	server_settings[33][1] = "260.0";
	server_settings[33][2] = "250.0";
	server_settings[33][3] = "245.0";
	server_settings[33][4] = "240.0";
	server_settings[33][5] = "215.0";
	server_settings[33][6] = "5.0";
	server_settings[33][7] = "1";
	server_settings[33][8] = "3";
	server_settings[33][9] = "1";
	server_settings[33][10] = "0";
	server_settings[33][11] = "1";
	server_settings[33][12] = "2";
	server_settings[33][13] = "4";
	server_settings[33][14] = "1";
	server_settings[33][15] = "2";
	server_settings[33][16] = "4";
	server_settings[33][17] = "0";
	server_settings[33][18] = "255";
	server_settings[33][19] = "159";
	server_settings[33][20] = "2";
	server_settings[33][21] = "1";
	server_settings[33][22] = "2";
	server_settings[33][23] = "1";
	server_settings[33][24] = "abc";
	server_settings[33][25] = "1";
	server_settings[33][26] = "0";
	configurate_plugin();
	
	
	register_menucmd(register_menuid("LongJump Stats Menu"),  1023, "LjsMenu_Select");
	register_menucmd(register_menuid("Top 10 Menu"),          1023, "MainTopMenu_Select");
	register_menucmd(register_menuid("Full top stats"),       1023, "FullTopMenu_Select");
	register_menucmd(register_menuid("Show best longjumper"), 1023, "LeetJumpMenu_Select");
	
	
	tops_save = true;
	new LJS_ADMIN = ADMIN_MAP;
	if( get_pcvar_num(kz_ljs_topsave) )
		LJS_ADMIN = ADMIN_RCON;
	else
		tops_save = false;
	
	register_concmd("amx_resetljrec",  "topreset",         LJS_ADMIN, "- resets ljrec and ljtops");
	register_concmd("amx_resetljtops", "topreset",         LJS_ADMIN, "- resets ljrec and ljtops");
	
	register_clcmd("say /colorchat",  "cmdColorChat",      ADMIN_ALL, "- enables/disables colorchat");
	register_clcmd("say /ljstats",    "cmdLjStats",        ADMIN_ALL, "- enables/disables longjump stats");
	register_clcmd("say /ljsversion", "cmdVersion",        ADMIN_ALL, "- prints plugin version");
	register_clcmd("say /speed",      "cmdSpeed",          ADMIN_ALL, "- enabled/disables visible speed");
	
	register_clcmd("say /ljsmenu",    "cmdLjsMenu",        ADMIN_ALL, "- display ljs menu");
	register_clcmd("say /cj15",       "cmdTopMenu",        -1,        "- display tops menu");
	register_clcmd("say /cjtop15",    "cmdTopMenu",        -1,        "- display tops menu");
	register_clcmd("say /cj10",       "cmdTopMenu",        -1,        "- display tops menu");
	register_clcmd("say /cjtop10",    "cmdTopMenu",        -1,        "- display tops menu");
	register_clcmd("say /cjtop",      "cmdTopMenu",        -1,        "- display tops menu");
	register_clcmd("say /lj15",       "cmdTopMenu",        -1,        "- display tops menu");
	register_clcmd("say /ljtop15",    "cmdTopMenu",        -1,        "- display tops menu");
	register_clcmd("say /lj10",       "cmdTopMenu",        ADMIN_ALL, "- display tops menu");
	register_clcmd("say /ljtop10",    "cmdTopMenu",        -1,        "- display tops menu");
	register_clcmd("say /ljtop",      "cmdTopMenu",        -1,        "- display tops menu");
	register_clcmd("say /ljrec",      "show_leet_ljumper", ADMIN_ALL, "- display records menu");
	register_clcmd("say /cjrec",      "show_leet_ljumper", -1,        "- display records menu");
	
	register_clcmd("say /tele",       "gocheck",           -1,        " - teleported");
	register_clcmd("say /tp",         "gocheck",           -1,        " - teleported");
	register_clcmd("say /gocheck",    "gocheck",           -1,        " - teleported");
	register_clcmd("say /gc",         "gocheck",           -1,        " - teleported");
	register_clcmd("say .tele",       "gocheck",           -1,        " - teleported");
	register_clcmd("say .tp",         "gocheck",           -1,        " - teleported");
	register_clcmd("say .gocheck",    "gocheck",           -1,        " - teleported");
	register_clcmd("say .gc",         "gocheck",           -1,        " - teleported");
	register_clcmd("/tele",           "gocheck",           -1,        " - teleported");
	register_clcmd("/tp",             "gocheck",           -1,        " - teleported");
	register_clcmd("/gocheck",        "gocheck",           -1,        " - teleported");
	register_clcmd("/gc",             "gocheck",           -1,        " - teleported");
	register_clcmd(".tele",           "gocheck",           -1,        " - teleported");
	register_clcmd(".tp",             "gocheck",           -1,        " - teleported");
	register_clcmd(".gocheck",        "gocheck",           -1,        " - teleported");
	register_clcmd(".gc",             "gocheck",           -1,        " - teleported");
	register_clcmd("say /stuck",      "gocheck",           -1,        " - teleported");
	register_clcmd("say /unstuck",    "gocheck",           -1,        " - teleported");
	register_clcmd("say .stuck",      "gocheck",           -1,        " - teleported");
	register_clcmd("say .unstuck",    "gocheck",           -1,        " - teleported");
	register_clcmd("/stuck",          "gocheck",           -1,        " - teleported");
	register_clcmd("/unstuck",        "gocheck",           -1,        " - teleported");
	register_clcmd(".stuck",          "gocheck",           -1,        " - teleported");
	register_clcmd(".unstuck",        "gocheck",           -1,        " - teleported");
	register_clcmd("say /start",      "gocheck",           -1,        " - reseted");
	register_clcmd("say /reset",      "gocheck",           -1,        " - reseted");
	register_clcmd("say /restart",    "gocheck",           -1,        " - reseted");
	register_clcmd("say /spawn",      "gocheck",           -1,        " - reseted");
	register_clcmd("say .start",      "gocheck",           -1,        " - reseted");
	register_clcmd("say .reset",      "gocheck",           -1,        " - reseted");
	register_clcmd("say .restart",    "gocheck",           -1,        " - reseted");
	register_clcmd("say .spawn",      "gocheck",           -1,        " - reseted");
	register_clcmd("/start",          "gocheck",           -1,        " - reseted");
	register_clcmd("/reset",          "gocheck",           -1,        " - reseted");
	register_clcmd("/restart",        "gocheck",           -1,        " - reseted");
	register_clcmd("/spawn",          "gocheck",           -1,        " - reseted");
	register_clcmd(".start",          "gocheck",           -1,        " - reseted");
	register_clcmd(".reset",          "gocheck",           -1,        " - reseted");
	register_clcmd(".restart",        "gocheck",           -1,        " - reseted");
	register_clcmd(".spawn",          "gocheck",           -1,        " - reseted");
	register_clcmd("+hook",           "gocheck",           -1,        " - used hook");
	register_clcmd("-hook",           "gocheck",           -1,        " - used hook");
	
	
	new dataDir[64];
	get_datadir(dataDir, 63);
	format(ljsDir, 63, "%s/ljs", dataDir);
	if( !dir_exists(ljsDir) )
		mkdir(ljsDir);
	
	get_plugin(plugin_id, plugin_file_name, 63, "", 0, "", 0, "", 0, "", 0);
}

public configurate_plugin()
{
	if( !get_ljsconfig(0) )
	{
		for( new i; i < 27; i++ )
			format(server_settings[0][i], 15, "%s", server_settings[33][i]);
	}
	setconfig_now(0);
}

public setconfig_now(player)
{
	set_cvar_string("kz_ljs_enabled", server_settings[player][0]);
	set_cvar_string("kz_max_lj", server_settings[player][1]);
	set_cvar_string("kz_leet_lj", server_settings[player][2]);
	set_cvar_string("kz_pro_lj", server_settings[player][3]);
	set_cvar_string("kz_good_lj", server_settings[player][4]);
	set_cvar_string("kz_min_lj", server_settings[player][5]);
	set_cvar_string("kz_cj_dif", server_settings[player][6]);
	set_cvar_string("kz_lj_sounds", server_settings[player][7]);
	set_cvar_string("kz_lj_top", server_settings[player][8]);
	set_cvar_string("kz_ljs_topsave", server_settings[player][9]);
	set_cvar_string("kz_ljs_rank_by", server_settings[player][10]);
	set_cvar_string("kz_leet_lj_clr", server_settings[player][11]);
	set_cvar_string("kz_pro_lj_clr", server_settings[player][12]);
	set_cvar_string("kz_good_lj_clr", server_settings[player][13]);
	set_cvar_string("kz_leet_cj_clr", server_settings[player][14]);
	set_cvar_string("kz_pro_cj_clr", server_settings[player][15]);
	set_cvar_string("kz_good_cj_clr", server_settings[player][16]);
	set_cvar_string("kz_ljstats_red", server_settings[player][17]);
	set_cvar_string("kz_ljstats_green", server_settings[player][18]);
	set_cvar_string("kz_ljstats_blue", server_settings[player][19]);
	set_cvar_string("kz_ljs_beam", server_settings[player][20]);
	set_cvar_string("kz_legal_settings", server_settings[player][21]);
	if( str_to_num(server_settings[player][22]) == 2 && str_to_num(server_settings[player][23]) )
	{
		if( !is_dedicated_server() && get_pcvar_num(sv_lan) != 0 )
			set_cvar_string("kz_ljs_fastserver", "2");
		else
			set_cvar_string("kz_ljs_fastserver", "1");
	}
	else
		set_cvar_string("kz_ljs_fastserver", server_settings[player][22]);
	set_pcvar_num(kz_ljs_autoserver, str_to_num(server_settings[player][23]));
	set_cvar_string("kz_ljs_connectenabler", server_settings[player][24]);
	set_cvar_string("kz_ljs_viscmds", server_settings[player][25]);
	set_cvar_string("kz_ljs_speedtype", server_settings[player][26]);
}

stock get_ljsconfig(player)
{
	static configsDir[64], filename[128];
	get_configsdir(configsDir, 63);
	format(filename, 127, "%s/ljstats.ini", configsDir);
	
	if( !dir_exists(configsDir) )
		mkdir(configsDir);
		
	if( !file_exists(filename) )
	{
		log_amx("LjS: Error: Configuration file <^"%s^"> not found!", filename);
		log_amx("LjS: Creating file...");
		write_file(filename, "; .-==========================================-.");
		write_file(filename, "; |~~ Long Jump Stats - eXtreme Modification ~~|");
		write_file(filename, "; .-==========================================-.");
		write_file(filename, "");
		write_file(filename, "");
		write_file(filename, "; Enabled/Disables the plugin");
		write_file(filename, "; 0 = disabled");
		write_file(filename, "; 1 = enabled");
		write_file(filename, "; Cvar kz_ljs_enabled (default ^"1^")");
		write_file(filename, "1");
		write_file(filename, "");
		write_file(filename, "; Maximum possible lj (not 4 cj)");
		write_file(filename, "; Cvar kz_max_lj (default ^"260.0^")");
		write_file(filename, "260.0");
		write_file(filename, "");
		write_file(filename, "; 1337 lj (prints to all players)");
		write_file(filename, "; To disable, set it to -1");
		write_file(filename, "; Cvar kz_leet_lj (default ^"250.0^")");
		write_file(filename, "250.0");
		write_file(filename, "");
		write_file(filename, "; Professional lj (prints to all players)");
		write_file(filename, "; To disable, set it to -1");
		write_file(filename, "; Cvar kz_pro_lj (default ^"245.0^")");
		write_file(filename, "245.0");
		write_file(filename, "");
		write_file(filename, "; Good lj (prints to all players)");
		write_file(filename, "; To disable, set it to -1");
		write_file(filename, "; Cvar kz_good_lj (default ^"240.0^")");
		write_file(filename, "240.0");
		write_file(filename, "");
		write_file(filename, "; Minimal lj distance");
		write_file(filename, "; Cvar kz_min_lj (default ^"215.0^")");
		write_file(filename, "215.0");
		write_file(filename, "");
		write_file(filename, "; Difrence between longjump and countjump for good/pro/leet/max jump");
		write_file(filename, "; Cvar kz_cj_dif (default ^"10.0^")");
		write_file(filename, "10.0");
		write_file(filename, "");
		write_file(filename, "; Enables lj sounds");
		write_file(filename, "; 0 = disabled");
		write_file(filename, "; 1 = ultimate sounds");
		write_file(filename, "; 2 = distance in voice");
		write_file(filename, "; Cvar kz_lj_sounds (default ^"1^")");
		write_file(filename, "1");
		write_file(filename, "");
		write_file(filename, "; How dose plugin works");
		write_file(filename, "; 0 = no top and no colorchat");
		write_file(filename, "; 1 = prints good/pro/leet jumps");
		write_file(filename, "; 2 = enables top10");
		write_file(filename, "; 3 = prints good/pro/leet jumps and enables top10");
		write_file(filename, "; Cvar kz_lj_top (default ^"3^")");
		write_file(filename, "3");
		write_file(filename, "");
		write_file(filename, "; Do you want to save ljtop after mapchange?");
		write_file(filename, "; Cvar kz_ljs_topsave (default ^"1^")");
		write_file(filename, "1");
		write_file(filename, "");
		write_file(filename, "; How ranking will work?");
		write_file(filename, "; 0 = names");
		write_file(filename, "; 1 = steam ids");
		write_file(filename, "; 2 = ips");
		write_file(filename, "; Cvar kz_ljs_rank_by (default ^"0^")");
		write_file(filename, "0");
		write_file(filename, "");
		write_file(filename, "; Kz jumping color chat:");
		write_file(filename, "; 0 = normal");
		write_file(filename, "; 1 = red");
		write_file(filename, "; 2 = green");
		write_file(filename, "; 3 = blue");
		write_file(filename, "; 4 = silver");
		write_file(filename, "; 5 = team color");
		write_file(filename, "");
		write_file(filename, "; Cvar kz_leet_lj_clr (default ^"1^")");
		write_file(filename, "1");
		write_file(filename, "; Cvar kz_pro_lj_clr (default ^"2^")");
		write_file(filename, "2");
		write_file(filename, "; Cvar kz_good_lj_clr (default ^"4^")");
		write_file(filename, "4");
		write_file(filename, "");
		write_file(filename, "; Cvar kz_leet_cj_clr (default ^"1^")");
		write_file(filename, "1");
		write_file(filename, "; Cvar kz_pro_cj_clr (default ^"2^")");
		write_file(filename, "2");
		write_file(filename, "; Cvar kz_good_cj_clr (default ^"4^")");
		write_file(filename, "4");
		write_file(filename, "");
		write_file(filename, "; Colors of /ljstats (rrr ggg bbb)");
		write_file(filename, "; Cvar kz_ljstats_red (default ^"0^")");
		write_file(filename, "0");
		write_file(filename, "; Cvar kz_ljstats_green (default ^"255^")");
		write_file(filename, "255");
		write_file(filename, "; Cvar kz_ljstats_blue (^"159^")");
		write_file(filename, "159");
		write_file(filename, "");
		write_file(filename, "; LongJump Stats Laser Beam");
		write_file(filename, "; 0 = off");
		write_file(filename, "; 1 = normal");
		write_file(filename, "; 2 = uber beam");
		write_file(filename, "; Cvar kz_ljs_beam (default ^"2^")");
		write_file(filename, "2");
		write_file(filename, "");
		write_file(filename, "; Enables protection 4 legal kreedz settings");
		write_file(filename, "; Cvar kz_legal_settings (default ^"1^")");
		write_file(filename, "1");
		write_file(filename, "");
		write_file(filename, "; Is your server fast?");
		write_file(filename, "; 0 = slow");
		write_file(filename, "; 1 = normal");
		write_file(filename, "; 2 = realy good ( >10mb/s or localhost/lan server )");
		write_file(filename, "; Cvar kz_ljs_fastserver (default ^"2^")");
		write_file(filename, "2");
		write_file(filename, "");
		write_file(filename, "; Enables auto-setting 4 kz_ljs_fastserver cvar if it is 2");
		write_file(filename, "; Cvar kz_ljs_autoserver (default ^"1^")");
		write_file(filename, "1");
		write_file(filename, "");
		write_file(filename, "; What is enabled on client when he connects to a server?");
		write_file(filename, "; 0 = nothing");
		write_file(filename, "; a = colorchat");
		write_file(filename, "; b = ljstats");
		write_file(filename, "; c = speed");
		write_file(filename, "; Cvar kz_ljs_connectenabler (default ^"abc^")");
		write_file(filename, "abc");
		write_file(filename, "");
		write_file(filename, "; Do you want cmds like /speed to be visible in the chat?");
		write_file(filename, "; Cvar kz_ljs_viscmds (default ^"1^")");
		write_file(filename, "1");
		write_file(filename, "");
		write_file(filename, "; Speedometer type");
		write_file(filename, "; 0 = show real speed and horizontal speed");
		write_file(filename, "; 1 = show real speed");
		write_file(filename, "; 2 = show horizontal speed");
		write_file(filename, "; Cvar kz_ljs_speedtype (default ^"0^")");
		write_file(filename, "0");
		if( file_exists(filename) )
		{
			log_amx("LjS: File <^"%s^"> successfully created.", filename);
			log_amx("LjS: All settings are setted by default.");
		}
		else
		{
			log_amx("LjS: Fatal-Error: Creation of <^"%s^"> file failed!", filename);
			log_amx("LjS: Disabeling plugin...");
			set_cvar_string("kz_ljs_enabled", "0");
			if( get_cvar_num("kz_ljs_enabled") )
			{
				if( !plugin_file_name[0] )
					return 0;
				
				log_amx("LjS: Fatal-Error: Omg, plugin cannot be disabled by cvar... Check your amxx!!!");
				log_amx("LjS: Disabeling plugin by turning off the code.");
				pause("ac", plugin_file_name);
			}
			return 0;
		}
	}
	
	new ljs_cvar_num;
	for( ljs_cvar_num = INFO_ZERO; ljs_cvar_num < 27; ljs_cvar_num++ )
		server_settings[player][ljs_cvar_num] = "";
	
	ljs_cvar_num = 0;
	new i, line, text[16], txtsize;
	for( i = INFO_ZERO; i < 255; i++ )
	{
		if( (line=read_file(filename, line, text, 15, txtsize)) != 0 )
		{
			if( text[0] == ';' || (text[0] == '/' && text[1] == '/') || !text[0] || text[0] == ' ' )
				continue;
			else
			{
				format(server_settings[player][ljs_cvar_num], 15, "%s", text);
				ljs_cvar_num += 1;
				if( ljs_cvar_num == 27 )
					break;
			}
		}
		else
			break;
	}
	
	delete_file(filename);
	write_file(filename, "; .-==========================================-.");
	write_file(filename, "; |~~ Long Jump Stats - eXtreme Modification ~~|");
	write_file(filename, "; .-==========================================-.");
	write_file(filename, "");
	write_file(filename, "");
	write_file(filename, "; Enabled/Disables the plugin");
	write_file(filename, "; 0 = disabled");
	write_file(filename, "; 1 = enabled");
	write_file(filename, "; Cvar kz_ljs_enabled (default ^"1^")");
	if( server_settings[player][0][0] )
		write_file(filename, server_settings[player][0]);
	else
	{
		fix_config(1, player);
		return 1;
	}
	write_file(filename, "");
	write_file(filename, "; Maximum possible lj (not 4 cj)");
	write_file(filename, "; Cvar kz_max_lj (default ^"260.0^")");
	if( server_settings[player][1][0] )
		write_file(filename, server_settings[player][1]);
	else
	{
		fix_config(2, player);
		return 1;
	}
	write_file(filename, "");
	write_file(filename, "; 1337 lj (prints to all players)");
	write_file(filename, "; To disable, set it to -1");
	write_file(filename, "; Cvar kz_leet_lj (default ^"250.0^")");
	if( server_settings[player][2][0] )
		write_file(filename, server_settings[player][2]);
	else
	{
		fix_config(3, player);
		return 1;
	}
	write_file(filename, "");
	write_file(filename, "; Professional lj (prints to all players)");
	write_file(filename, "; To disable, set it to -1");
	write_file(filename, "; Cvar kz_pro_lj (default ^"245.0^")");
	if( server_settings[player][3][0] )
		write_file(filename, server_settings[player][3]);
	else
	{
		fix_config(4, player);
		return 1;
	}
	write_file(filename, "");
	write_file(filename, "; Good lj (prints to all players)");
	write_file(filename, "; To disable, set it to -1");
	write_file(filename, "; Cvar kz_good_lj (default ^"240.0^")");
	if( server_settings[player][4][0] )
		write_file(filename, server_settings[player][4]);
	else
	{
		fix_config(5, player);
		return 1;
	}
	write_file(filename, "");
	write_file(filename, "; Minimal lj distance");
	write_file(filename, "; Cvar kz_min_lj (default ^"215.0^")");
	if( server_settings[player][5][0] )
		write_file(filename, server_settings[player][5]);
	else
	{
		fix_config(6, player);
		return 1;
	}
	write_file(filename, "");
	write_file(filename, "; Difrence between longjump and countjump for good/pro/leet/max jump");
	write_file(filename, "; Cvar kz_cj_dif (default ^"10.0^")");
	if( server_settings[player][6][0] )
		write_file(filename, server_settings[player][6]);
	else
	{
		fix_config(7, player);
		return 1;
	}
	write_file(filename, "");
	write_file(filename, "; Enables lj sounds");
	write_file(filename, "; 0 = disabled");
	write_file(filename, "; 1 = ultimate sounds");
	write_file(filename, "; 2 = distance in voice");
	write_file(filename, "; Cvar kz_lj_sounds (default ^"1^")");
	if( server_settings[player][7][0] )
		write_file(filename, server_settings[player][7]);
	else
	{
		fix_config(8, player);
		return 1;
	}
	write_file(filename, "");
	write_file(filename, "; How dose plugin works");
	write_file(filename, "; 0 = no top and no colorchat");
	write_file(filename, "; 1 = prints good/pro/leet jumps");
	write_file(filename, "; 2 = enables top10");
	write_file(filename, "; 3 = prints good/pro/leet jumps and enables top10");
	write_file(filename, "; Cvar kz_lj_top (default ^"3^")");
	if( server_settings[player][8][0] )
		write_file(filename, server_settings[player][8]);
	else
	{
		fix_config(9, player);
		return 1;
	}
	write_file(filename, "");
	write_file(filename, "; Do you want to save ljtop after mapchange?");
	write_file(filename, "; Cvar kz_ljs_topsave (default ^"1^")");
	if( server_settings[player][9][0] )
		write_file(filename, server_settings[player][9]);
	else
	{
		fix_config(10, player);
		return 1;
	}
	write_file(filename, "");
	write_file(filename, "; How ranking will work?");
	write_file(filename, "; 0 = names");
	write_file(filename, "; 1 = steam ids");
	write_file(filename, "; 2 = ips");
	write_file(filename, "; Cvar kz_ljs_rank_by (default ^"0^")");
	if( server_settings[player][10][0] )
		write_file(filename, server_settings[player][10]);
	else
	{
		fix_config(11, player);
		return 1;
	}
	write_file(filename, "");
	write_file(filename, "; Kz jumping color chat:");
	write_file(filename, "; 0 = normal");
	write_file(filename, "; 1 = red");
	write_file(filename, "; 2 = green");
	write_file(filename, "; 3 = blue");
	write_file(filename, "; 4 = silver");
	write_file(filename, "; 5 = team color");
	write_file(filename, "");
	write_file(filename, "; Cvar kz_leet_lj_clr (default ^"1^")");
	if( server_settings[player][11][0] )
		write_file(filename, server_settings[player][11]);
	else
	{
		fix_config(12, player);
		return 1;
	}
	write_file(filename, "; Cvar kz_pro_lj_clr (default ^"2^")");
	if( server_settings[player][12][0] )
		write_file(filename, server_settings[player][12]);
	else
	{
		fix_config(13, player);
		return 1;
	}
	write_file(filename, "; Cvar kz_good_lj_clr (default ^"4^")");
	if( server_settings[player][13][0] )
		write_file(filename, server_settings[player][13]);
	else
	{
		fix_config(14, player);
		return 1;
	}
	write_file(filename, "");
	write_file(filename, "; Cvar kz_leet_cj_clr (default ^"1^")");
	if( server_settings[player][14][0] )
		write_file(filename, server_settings[player][14]);
	else
	{
		fix_config(15, player);
		return 1;
	}
	write_file(filename, "; Cvar kz_pro_cj_clr (default ^"2^")");
	if( server_settings[player][15][0] )
		write_file(filename, server_settings[player][15]);
	else
	{
		fix_config(16, player);
		return 1;
	}
	write_file(filename, "; Cvar kz_good_cj_clr (default ^"4^")");
	if( server_settings[player][16][0] )
		write_file(filename, server_settings[player][16]);
	else
	{
		fix_config(17, player);
		return 1;
	}
	write_file(filename, "");
	write_file(filename, "; Colors of /ljstats (rrr ggg bbb)");
	write_file(filename, "; Cvar kz_ljstats_red (default ^"0^")");
	if( server_settings[player][17][0] )
		write_file(filename, server_settings[player][17]);
	else
	{
		fix_config(18, player);
		return 1;
	}
	write_file(filename, "; Cvar kz_ljstats_green (default ^"255^")");
	if( server_settings[player][18][0] )
		write_file(filename, server_settings[player][18]);
	else
	{
		fix_config(19, player);
		return 1;
	}
	write_file(filename, "; Cvar kz_ljstats_blue (^"159^")");
	if( server_settings[player][19][0] )
		write_file(filename, server_settings[player][19]);
	else
	{
		fix_config(20, player);
		return 1;
	}
	write_file(filename, "");
	write_file(filename, "; LongJump Stats Laser Beam");
	write_file(filename, "; 0 = off");
	write_file(filename, "; 1 = normal");
	write_file(filename, "; 2 = uber beam");
	write_file(filename, "; Cvar kz_ljs_beam (default ^"2^")");
	if( server_settings[player][20][0] )
		write_file(filename, server_settings[player][20]);
	else
	{
		fix_config(21, player);
		return 1;
	}
	write_file(filename, "");
	write_file(filename, "; Enables protection 4 legal kreedz settings");
	write_file(filename, "; Cvar kz_legal_settings (default ^"1^")");
	if( server_settings[player][21][0] )
		write_file(filename, server_settings[player][21]);
	else
	{
		fix_config(22, player);
		return 1;
	}
	write_file(filename, "");
	write_file(filename, "; Is your server fast?");
	write_file(filename, "; 0 = slow");
	write_file(filename, "; 1 = normal");
	write_file(filename, "; 2 = realy good ( >10mb/s or localhost/lan server )");
	write_file(filename, "; Cvar kz_ljs_fastserver (default ^"2^")");
	if( server_settings[player][22][0] )
		write_file(filename, server_settings[player][22]);
	else
	{
		fix_config(23, player);
		return 1;
	}
	write_file(filename, "");
	write_file(filename, "; Enables auto-setting 4 kz_ljs_fastserver cvar if it is 2");
	write_file(filename, "; Cvar kz_ljs_autoserver (default ^"1^")");
	if( server_settings[player][23][0] )
		write_file(filename, server_settings[player][23]);
	else
	{
		fix_config(24, player);
		return 1;
	}
	write_file(filename, "");
	write_file(filename, "; What is enabled on client when he connects to a server?");
	write_file(filename, "; 0 = nothing");
	write_file(filename, "; a = colorchat");
	write_file(filename, "; b = ljstats");
	write_file(filename, "; c = speed");
	write_file(filename, "; Cvar kz_ljs_connectenabler (default ^"abc^")");
	if( server_settings[player][24][0] )
		write_file(filename, server_settings[player][24]);
	else
	{
		fix_config(25, player);
		return 1;
	}
	write_file(filename, "");
	write_file(filename, "; Do you want cmds like /speed to be visible in the chat?");
	write_file(filename, "; Cvar kz_ljs_viscmds (default ^"1^")");
	if( server_settings[player][25][0] )
		write_file(filename, server_settings[player][25][0]);
	else
	{
		fix_config(26, player);
		return 1;
	}
	write_file(filename, "");
	write_file(filename, "; Speedometer type");
	write_file(filename, "; 0 = show real speed and horizontal speed");
	write_file(filename, "; 1 = show real speed");
	write_file(filename, "; 2 = show horizontal speed");
	write_file(filename, "; Cvar kz_ljs_speedtype (default ^"0^")");
	if( server_settings[player][26][0] )
		write_file(filename, server_settings[player][26]);
	else
	{
		fix_config(27, player);
		return 1;
	}
	
	return 1;
}

public fix_config(fix_since, player)
{
	static configsDir[64], filename[128];
	get_configsdir(configsDir, 63);
	format(filename, 127, "%s/ljstats.ini", configsDir);
	
	if( !(fix_since < 2) )
	{
		log_amx("LjS: Error: Settings that gows before #%d in <^"%s^"> cold be incurrent!", (fix_since+1), filename);
		log_amx("LjS: All other settings are setted by default. Please check the config file!");
	}
	else
	{
		log_amx("LjS: Error: Configuration file <^"%s^"> is not currect!", filename);
		log_amx("LjS: All settings are setted by default.");
		
		server_settings[player][0] = "1";
		write_file(filename, "1");
		write_file(filename, "");
		write_file(filename, "; Maximum possible lj (not 4 cj)");
		write_file(filename, "; Cvar kz_max_lj (default ^"260.0^")");
	}
	if( fix_since < 3 )
	{
		server_settings[player][1] = "260.0";
		write_file(filename, "260.0");
		write_file(filename, "");
		write_file(filename, "; 1337 lj (prints to all players)");
		write_file(filename, "; To disable, set it to -1");
		write_file(filename, "; Cvar kz_leet_lj (default ^"250.0^")");
	}
	if( fix_since < 4 )
	{
		server_settings[player][2] = "250.0";
		write_file(filename, "250.0");
		write_file(filename, "");
		write_file(filename, "; Professional lj (prints to all players)");
		write_file(filename, "; To disable, set it to -1");
		write_file(filename, "; Cvar kz_pro_lj (default ^"245.0^")");
	}
	if( fix_since < 5 )
	{
		server_settings[player][3] = "245.0";
		write_file(filename, "245.0");
		write_file(filename, "");
		write_file(filename, "; Good lj (prints to all players)");
		write_file(filename, "; To disable, set it to -1");
		write_file(filename, "; Cvar kz_good_lj (default ^"240.0^")");
	}
	if( fix_since < 6 )
	{
		server_settings[player][4] = "240.0";
		write_file(filename, "240.0");
		write_file(filename, "");
		write_file(filename, "; Minimal lj distance");
		write_file(filename, "; Cvar kz_min_lj (default ^"215.0^")");
	}
	if( fix_since < 7 )
	{
		server_settings[player][5] = "215.0";
		write_file(filename, "215.0");
		write_file(filename, "");
		write_file(filename, "; Difrence between longjump and countjump for good/pro/leet/max jump");
		write_file(filename, "; Cvar kz_cj_dif (default ^"10.0^")");
	}
	if( fix_since < 8 )
	{
		server_settings[player][6] = "10.0";
		write_file(filename, "10.0");
		write_file(filename, "");
		write_file(filename, "; Enables lj sounds");
		write_file(filename, "; 0 = disabled");
		write_file(filename, "; 1 = ultimate sounds");
		write_file(filename, "; 2 = distance in voice");
		write_file(filename, "; Cvar kz_lj_sounds (default ^"1^")");
	}
	if( fix_since < 9 )
	{
		server_settings[player][7] = "1";
		write_file(filename, "1");
		write_file(filename, "");
		write_file(filename, "; How dose plugin works");
		write_file(filename, "; 0 = no top and no colorchat");
		write_file(filename, "; 1 = prints good/pro/leet jumps");
		write_file(filename, "; 2 = enables top10");
		write_file(filename, "; 3 = prints good/pro/leet jumps and enables top10");
		write_file(filename, "; Cvar kz_lj_top (default ^"3^")");
	}
	if( fix_since < 10 )
	{
		server_settings[player][8] = "3";
		write_file(filename, "3");
		write_file(filename, "");
		write_file(filename, "; Do you want to save ljtop after mapchange?");
		write_file(filename, "; Cvar kz_ljs_topsave (default ^"1^")");
	}
	if( fix_since < 11 )
	{
		server_settings[player][9] = "1";
		write_file(filename, "1");
		write_file(filename, "");
		write_file(filename, "; How ranking will work?");
		write_file(filename, "; 0 = names");
		write_file(filename, "; 1 = steam ids");
		write_file(filename, "; 2 = ips");
		write_file(filename, "; Cvar kz_ljs_rank_by (default ^"0^")");
	}
	if( fix_since < 12 )
	{
		server_settings[player][10] = "0";
		write_file(filename, "0");
		write_file(filename, "");
		write_file(filename, "; Kz jumping color chat:");
		write_file(filename, "; 0 = normal");
		write_file(filename, "; 1 = red");
		write_file(filename, "; 2 = green");
		write_file(filename, "; 3 = blue");
		write_file(filename, "; 4 = silver");
		write_file(filename, "; 5 = team color");
		write_file(filename, "");
		write_file(filename, "; Cvar kz_leet_lj_clr (default ^"1^")");
	}
	if( fix_since < 13 )
	{
		server_settings[player][11] = "1";
		write_file(filename, "1");
		write_file(filename, "; Cvar kz_pro_lj_clr (default ^"2^")");
	}
	if( fix_since < 14 )
	{
		server_settings[player][12] = "2";
		write_file(filename, "2");
		write_file(filename, "; Cvar kz_good_lj_clr (default ^"4^")");
	}
	if( fix_since < 15 )
	{
		server_settings[player][13] = "4";
		write_file(filename, "4");
		write_file(filename, "");
		write_file(filename, "; Cvar kz_leet_cj_clr (default ^"1^")");
	}
	if( fix_since < 16 )
	{
		server_settings[player][14] = "1";
		write_file(filename, "1");
		write_file(filename, "; Cvar kz_pro_cj_clr (default ^"2^")");
	}
	if( fix_since < 17 )
	{
		server_settings[player][15] = "2";
		write_file(filename, "2");
		write_file(filename, "; Cvar kz_good_cj_clr (default ^"4^")");
	}
	if( fix_since < 18 )
	{
		server_settings[player][16] = "4";
		write_file(filename, "4");
		write_file(filename, "");
		write_file(filename, "; Colors of /ljstats (rrr ggg bbb)");
		write_file(filename, "; Cvar kz_ljstats_red (default ^"0^")");
	}
	if( fix_since < 19 )
	{
		server_settings[player][17] = "0";
		write_file(filename, "0");
		write_file(filename, "; Cvar kz_ljstats_green (default ^"255^")");
	}
	if( fix_since < 20 )
	{
		server_settings[player][18] = "255";
		write_file(filename, "255");
		write_file(filename, "; Cvar kz_ljstats_blue (^"159^")");
	}
	if( fix_since < 21 )
	{
		server_settings[player][19] = "159";
		write_file(filename, "159");
		write_file(filename, "");
		write_file(filename, "; LongJump Stats Laser Beam");
		write_file(filename, "; 0 = off");
		write_file(filename, "; 1 = normal");
		write_file(filename, "; 2 = uber beam");
		write_file(filename, "; Cvar kz_ljs_beam (default ^"2^")");
	}
	if( fix_since < 22 )
	{
		server_settings[player][20] = "2";
		write_file(filename, "2");
		write_file(filename, "");
		write_file(filename, "; Enables protection 4 legal kreedz settings");
		write_file(filename, "; Cvar kz_legal_settings (default ^"1^")");
	}
	if( fix_since < 23 )
	{
		server_settings[player][21] = "1";
		write_file(filename, "1");
		write_file(filename, "");
		write_file(filename, "; Is your server fast?");
		write_file(filename, "; 0 = slow");
		write_file(filename, "; 1 = normal");
		write_file(filename, "; 2 = realy good ( >10mb/s or localhost/lan server )");
		write_file(filename, "; Cvar kz_ljs_fastserver (default ^"2^")");
	}
	if( fix_since < 24 )
	{
		server_settings[player][22] = "2";
		write_file(filename, "2");
		write_file(filename, "");
		write_file(filename, "; Enables auto-setting 4 kz_ljs_fastserver cvar if it is 2");
		write_file(filename, "; Cvar kz_ljs_autoserver (default ^"1^")");
	}
	if( fix_since < 25 )
	{
		server_settings[player][23] = "1";
		write_file(filename, "1");
		write_file(filename, "");
		write_file(filename, "; What is enabled on client when he connects to a server?");
		write_file(filename, "; 0 = nothing");
		write_file(filename, "; a = colorchat");
		write_file(filename, "; b = ljstats");
		write_file(filename, "; c = speed");
		write_file(filename, "; Cvar kz_ljs_connectenabler (default ^"abc^")");
	}
	if( fix_since < 26 )
	{
		server_settings[player][24] = "abc";
		write_file(filename, "abc");
		write_file(filename, "");
		write_file(filename, "; Do you want cmds like /speed to be visible in the chat?");
		write_file(filename, "; Cvar kz_ljs_viscmds (default ^"1^")");
	}
	if( fix_since < 27 )
	{
		server_settings[player][25] = "1";
		write_file(filename, "1");
		write_file(filename, "");
		write_file(filename, "; Speedometer type");
		write_file(filename, "; 0 = show real speed and horizontal speed");
		write_file(filename, "; 1 = show real speed");
		write_file(filename, "; 2 = show horizontal speed");
		write_file(filename, "; Cvar kz_ljs_speedtype (default ^"0^")");
	}
	if( fix_since < 28 )
	{
		server_settings[player][26] = "0";
		write_file(filename, "0");
	}
}

public plugin_cfg()
{
	if( get_pcvar_num(kz_legal_settings) )
	{
		set_cvar_string("edgefriction", "2");
		set_cvar_string("mp_footsteps", "1");
		set_cvar_string("sv_cheats", "0");
		set_cvar_string("sv_gravity", "800");
		set_cvar_string("sv_airaccelerate", "10");
		set_cvar_string("sv_maxspeed", "320");
		set_cvar_string("sv_stepsize", "18");
		set_cvar_string("sv_maxvelocity", "2000");
	}
}

public plugin_precache()
{
	plugin_start();
	
	switch(random_num(1,6))
	{
		case 1: gBeam = precache_model("sprites/zbeam1.spr");
		case 2: gBeam = precache_model("sprites/zbeam2.spr");
		case 3: gBeam = precache_model("sprites/zbeam3.spr");
		case 4: gBeam = precache_model("sprites/zbeam4.spr");
		case 5: gBeam = precache_model("sprites/zbeam5.spr");
		case 6: gBeam = precache_model("sprites/zbeam6.spr");
	}
	
	if( get_pcvar_num(kz_lj_sounds) == 1 )
	{
		precache_sound("misc/impressive.wav");
		precache_sound("misc/mod_godlike.wav");
		precache_sound("misc/mod_wickedsick.wav");
		precache_sound("misc/perfect.wav");
	}
	
	if( get_pcvar_num(kz_ljs_enabled) )
		pluginstatus = INFO_ONE;
	else
		pluginstatus = INFO_ZERO;
}

public cmdTopMenu(id)
{
	new plugin_cvar = get_pcvar_num(kz_ljs_enabled);
	new ljtop_cvar = get_pcvar_num(kz_ljs_tops);
	
	if( plugin_cvar && (ljtop_cvar == 2 || ljtop_cvar == 3) )
	{
		if( top_distance[0] )
		{
			new MenuBody[512], len, keys;
			len = format(MenuBody, 511, "\yTop 10 Menu^n");
			len += format(MenuBody[len], 511-len, "^n\r1. \wDisplay total top");
			keys = (1<<0);
			
			if( lj_distance[0] )
			{
				len += format(MenuBody[len], 511-len, "^n\r2. \wDisplay lj top");
				keys |= (1<<1);
			}
			else
			
				len += format(MenuBody[len], 511-len, "^n\r2. \dDisplay lj top (no ljs)");
			
			if( cj_distance[0] )
			{
				len += format(MenuBody[len], 511-len, "^n\r3. \wDisplay cj top");
				keys |= (1<<2);
			}
			else
				len += format(MenuBody[len], 511-len, "^n\r3. \dDisplay cj top (no cjs)");
			
			len += format(MenuBody[len], 511-len, "^n^n^n\yTops full stats^n");
			len += format(MenuBody[len], 511-len, "^n\r4. \wTotal top stats");
			keys |= (1<<3);
			
			if( lj_distance[0] )
			{
				len += format(MenuBody[len], 511-len, "^n\r5. \wLj top stats");
				keys |= (1<<4);
			}
			else
				len += format(MenuBody[len], 511-len, "^n\r5. \dLj top stats (no ljs)");
			
			if( cj_distance[0] )
			{
				len += format(MenuBody[len], 511-len, "^n\r6. \wCj top stats");
				keys |= (1<<5);
			}
			else
				len += format(MenuBody[len], 511-len, "^n\r6. \dCj top stats (no cjs)");
			
			len += format(MenuBody[len], 511-len, "^n^n\r0. \wExit");
			keys |= (1<<9);
			
			show_menu(id, keys, MenuBody, -1, "Top 10 Menu");
		}
		else
			client_print(id, print_chat, "[XJ] Tops are not valid. No jumps were made.");
	}
	else if( !plugin_cvar )
		client_print(id, print_chat, "[XJ] Tops are not valid. Plugin has been disabled.");
	else
		client_print(id, print_chat, "[XJ] Tops are not valid. Tops have been disabled.");
	
	return ( (get_pcvar_num(kz_ljs_viscmds))?PLUGIN_CONTINUE:PLUGIN_HANDLED );
}

public MainTopMenu_Select(id, key)
{
	new plugin_cvar = get_pcvar_num(kz_ljs_enabled);
	new ljtop_cvar = get_pcvar_num(kz_ljs_tops);
	
	if( plugin_cvar && (ljtop_cvar == 2 || ljtop_cvar == 3) )
	{
		if( !top_distance[0] )
		{
			client_print(id, print_chat, "[XJ] Tops are not valid. Jumps have been reseted (no jumps).");
			return PLUGIN_HANDLED;
		}
		
		switch((key+1))
		{
			case 1:
			{
				if( top_distance[0] )
					show_top(id, 0);
				else
					cmdTopMenu(id);
			}
			case 2:
			{
				if( lj_distance[0] )
					show_top(id, 1);
				else
					cmdTopMenu(id);
			}
			case 3:
			{
				if( cj_distance[0] )
					show_top(id, 2);
				else
					cmdTopMenu(id);
			}
			case 4:
			{
				if( top_distance[0] )
					display_full_top_stats_menu(id, 0, 0);
				else
					cmdTopMenu(id);
			}
			case 5:
			{
				if( lj_distance[0] )
					display_full_top_stats_menu(id, 1, 0);
				else
					cmdTopMenu(id);
			}
			case 6:
			{
				if( cj_distance[0] )
					display_full_top_stats_menu(id, 2, 0);
				else
					cmdTopMenu(id);
			}
		}
	}
	else if( !plugin_cvar )
		client_print(id, print_chat, "[XJ] Tops are not valid. Plugin has been disabled.");
	else
		client_print(id, print_chat, "[XJ] Tops are not valid. Tops have been disabled.");
	
	return PLUGIN_HANDLED;
}

public display_full_top_stats_menu(id, toptype, page)
{
	full_top_stats_selected_type[id] = toptype;
	full_top_stats_selected_page[id] = page;

	new i, MenuBody[512], len, keys;
	
	if( toptype == 2 )
	{
		if( page == 2 )
		{
			len = format(MenuBody, 511, "\yFull cj top stats \r2/2^n");
			for( i = INFO_ZERO; i < 10; i++ )
			{
				format( view_names[id][i], 32, cj_names[i] );
				view_distance[id][i] = cj_distance[i];
				view_maxspeed[id][i] = cj_maxspeed[i];
				view_prestrafe[id][i] = cj_prestrafe[i];
				view_strafes[id][i] = cj_strafes[i];
				view_sync[id][i] = cj_sync[i];
				view_type[id][i] = "";
				format( view_pretype[id][i], 31, cj_pretype[i] );
				if( i > 4 )
				{
					len += format(MenuBody[len], 511-len, "^n\r%d. \y%d. \w%s \r%d", (i-4), (i+1), view_names[id][i], (view_distance[id][i]/1000000));
					if( (i-5) )
						keys |= (1<<(i-5));
					else
						keys = (1<<0);
				}
			}
			len += format(MenuBody[len], 511-len, "^n^n\r9. \wBack");
			keys |= (1<<8);
		}
		else if( page )
		{
			len = format(MenuBody, 511, "\yFull cj top stats \r1/2^n");
			for( i = INFO_ZERO; i < 5; i++ )
			{
				format( view_names[id][i], 32, cj_names[i] );
				view_distance[id][i] = cj_distance[i];
				view_maxspeed[id][i] = cj_maxspeed[i];
				view_prestrafe[id][i] = cj_prestrafe[i];
				view_strafes[id][i] = cj_strafes[i];
				view_sync[id][i] = cj_sync[i];
				view_type[id][i] = "";
				format( view_pretype[id][i], 31, cj_pretype[i] );
				len += format(MenuBody[len], 511-len, "^n\r%d. \y%d. \w%s \r%d", (i+1), (i+1), view_names[id][i], (view_distance[id][i]/1000000));
				if( i )
					keys |= (1<<i);
				else
					keys = (1<<0);
			}
			len += format(MenuBody[len], 511-len, "^n^n\r9. \wNext");
			keys |= (1<<8);
		}
		else
		{
			len = format(MenuBody, 511, "\yFull cj top stats \r1/1^n");
			if( cj_distance[9] )
			{
				display_full_top_stats_menu(id, toptype, 1);
				return;
			}
			
			new limit;
			for( limit = INFO_ZERO; limit < 10; limit++ )
			{
				if( !cj_distance[limit] )
					break;
			}
			
			if( limit == 1 )
			{
				format( view_names[id][0], 32, cj_names[0] );
				view_distance[id][0] = cj_distance[0];
				view_maxspeed[id][0] = cj_maxspeed[0];
				view_prestrafe[id][0] = cj_prestrafe[0];
				view_strafes[id][0] = cj_strafes[0];
				view_sync[id][0] = cj_sync[0];
				view_type[id][0] = "";
				format( view_pretype[id][0], 31, cj_pretype[0] );
				len += format(MenuBody[len], 511-len, "^n\r1. \y1. \w%s \r%d", view_names[id][0], (view_distance[id][0]/1000000));
				keys = (1<<0);
			}
			else
			{
				for( i = INFO_ZERO; i < limit; i++ )
				{
					format( view_names[id][i], 32, cj_names[i] );
					view_distance[id][i] = cj_distance[i];
					view_maxspeed[id][i] = cj_maxspeed[i];
					view_prestrafe[id][i] = cj_prestrafe[i];
					view_strafes[id][i] = cj_strafes[i];
					view_sync[id][i] = cj_sync[i];
					view_type[id][i] = "";
					format( view_pretype[id][i], 31, cj_pretype[i] );
					len += format(MenuBody[len], 511-len, "^n\r%d. \y%d. \w%s \r%d", (i+1), (i+1), view_names[id][i], (view_distance[id][i]/1000000));
					if( i )
						keys |= (1<<i);
					else
						keys = (1<<0);
				}
			}
		}
	}
	else if( toptype )
	{
		if( page == 2 )
		{
			len = format(MenuBody, 511, "\yFull lj top stats \r2/2^n");
			for( i = INFO_ZERO; i < 10; i++ )
			{
				format( view_names[id][i], 32, lj_names[i] );
				view_distance[id][i] = lj_distance[i];
				view_maxspeed[id][i] = lj_maxspeed[i];
				view_prestrafe[id][i] = lj_prestrafe[i];
				view_strafes[id][i] = lj_strafes[i];
				view_sync[id][i] = lj_sync[i];
				view_type[id][i] = "";
				format( view_pretype[id][i], 31, lj_pretype[i] );
				if( i > 4 )
				{
					len += format(MenuBody[len], 511-len, "^n\r%d. \y%d. \w%s \r%d", (i-4), (i+1), view_names[id][i], (view_distance[id][i]/1000000));
					if( (i-5) )
						keys |= (1<<(i-5));
					else
						keys = (1<<0);
				}
			}
			len += format(MenuBody[len], 511-len, "^n^n\r9. \wBack");
			keys |= (1<<8);
		}
		else if( page )
		{
			len = format(MenuBody, 511, "\yFull lj top stats \r1/2^n");
			for( i = INFO_ZERO; i < 5; i++ )
			{
				format( view_names[id][i], 32, lj_names[i] );
				view_distance[id][i] = lj_distance[i];
				view_maxspeed[id][i] = lj_maxspeed[i];
				view_prestrafe[id][i] = lj_prestrafe[i];
				view_strafes[id][i] = lj_strafes[i];
				view_sync[id][i] = lj_sync[i];
				view_type[id][i] = "";
				format( view_pretype[id][i], 31, lj_pretype[i] );
				len += format(MenuBody[len], 511-len, "^n\r%d. \y%d. \w%s \r%d", (i+1), (i+1), view_names[id][i], (view_distance[id][i]/1000000));
				if( i )
					keys |= (1<<i);
				else
					keys = (1<<0);
			}
			len += format(MenuBody[len], 511-len, "^n^n\r9. \wNext");
			keys |= (1<<8);
		}
		else
		{
			len = format(MenuBody, 511, "\yFull lj top stats \r1/1^n");
			if( lj_distance[9] )
			{
				display_full_top_stats_menu(id, toptype, 1);
				return;
			}
			
			new limit;
			for( limit = INFO_ZERO; limit < 10; limit++ )
			{
				if( !lj_distance[limit] )
					break;
			}
			
			if( limit == 1 )
			{
				format( view_names[id][0], 32, lj_names[0] );
				view_distance[id][0] = lj_distance[0];
				view_maxspeed[id][0] = lj_maxspeed[0];
				view_prestrafe[id][0] = lj_prestrafe[0];
				view_strafes[id][0] = lj_strafes[0];
				view_sync[id][0] = lj_sync[0];
				view_type[id][0] = "";
				format( view_pretype[id][0], 31, lj_pretype[0] );
				len += format(MenuBody[len], 511-len, "^n\r1. \y1. \w%s \r%d", view_names[id][0], (view_distance[id][0]/1000000));
				keys = (1<<0);
			}
			else
			{
				for( i = INFO_ZERO; i < limit; i++ )
				{
					format( view_names[id][i], 32, lj_names[i] );
					view_distance[id][i] = lj_distance[i];
					view_maxspeed[id][i] = lj_maxspeed[i];
					view_prestrafe[id][i] = lj_prestrafe[i];
					view_strafes[id][i] = lj_strafes[i];
					view_sync[id][i] = lj_sync[i];
					view_type[id][i] = "";
					format( view_pretype[id][i], 31, lj_pretype[i] );
					len += format(MenuBody[len], 511-len, "^n\r%d. \y%d. \w%s \r%d", (i+1), (i+1), view_names[id][i], (view_distance[id][i]/1000000));
					if( i )
						keys |= (1<<i);
					else
						keys = (1<<0);
				}
			}
		}
	}
	else
	{
		if( page == 2 )
		{
			len = format(MenuBody, 511, "\yFull total top stats \r2/2^n");
			for( i = INFO_ZERO; i < 10; i++ )
			{
				format( view_names[id][i], 32, top_names[i] );
				view_distance[id][i] = top_distance[i];
				view_maxspeed[id][i] = top_maxspeed[i];
				view_prestrafe[id][i] = top_prestrafe[i];
				view_strafes[id][i] = top_strafes[i];
				view_sync[id][i] = top_sync[i];
				format( view_type[id][i], 4, top_type[i] );
				format( view_pretype[id][i], 31, top_pretype[i] );
				if( i > 4 )
				{
					len += format(MenuBody[len], 511-len, "^n\r%d. \y%d. \w%s \r%d \d%s", (i-4), (i+1), view_names[id][i], (view_distance[id][i]/1000000), view_type[id][i]);
					if( (i-5) )
						keys |= (1<<(i-5));
					else
						keys = (1<<0);
				}
			}
			len += format(MenuBody[len], 511-len, "^n^n\r9. \wBack");
			keys |= (1<<8);
		}
		else if( page )
		{
			len = format(MenuBody, 511, "\yFull total top stats \r1/2^n");
			for( i = INFO_ZERO; i < 5; i++ )
			{
				format( view_names[id][i], 32, top_names[i] );
				view_distance[id][i] = top_distance[i];
				view_maxspeed[id][i] = top_maxspeed[i];
				view_prestrafe[id][i] = top_prestrafe[i];
				view_strafes[id][i] = top_strafes[i];
				view_sync[id][i] = top_sync[i];
				format( view_type[id][i], 4, top_type[i] );
				format( view_pretype[id][i], 31, top_pretype[i] );
				len += format(MenuBody[len], 511-len, "^n\r%d. \y%d. \w%s \r%d \d%s", (i+1), (i+1), view_names[id][i], (view_distance[id][i]/1000000), view_type[id][i]);
				if( i )
					keys |= (1<<i);
				else
					keys = (1<<0);
			}
			len += format(MenuBody[len], 511-len, "^n^n\r9. \wNext");
			keys |= (1<<8);
		}
		else
		{
			len = format(MenuBody, 511, "\yFull total top stats \r1/1^n");
			if( top_distance[9] )
			{
				display_full_top_stats_menu(id, toptype, 1);
				return;
			}
			
			new limit;
			for( limit = INFO_ZERO; limit < 10; limit++ )
			{
				if( !top_distance[limit] )
					break;
			}
			
			if( limit == 1 )
			{
				format( view_names[id][0], 32, top_names[0] );
				view_distance[id][0] = top_distance[0];
				view_maxspeed[id][0] = top_maxspeed[0];
				view_prestrafe[id][0] = top_prestrafe[0];
				view_strafes[id][0] = top_strafes[0];
				view_sync[id][0] = top_sync[0];
				format( view_type[id][0], 4, top_type[0] );
				format( view_pretype[id][0], 31, top_pretype[0] );
				len += format(MenuBody[len], 511-len, "^n\r1. \y1. \w%s \r%d \d%s", view_names[id][0], (view_distance[id][0]/1000000), view_type[id][0]);
				keys = (1<<0);
			}
			else
			{
				for( i = INFO_ZERO; i < limit; i++ )
				{
					format( view_names[id][i], 32, top_names[i] );
					view_distance[id][i] = top_distance[i];
					view_maxspeed[id][i] = top_maxspeed[i];
					view_prestrafe[id][i] = top_prestrafe[i];
					view_strafes[id][i] = top_strafes[i];
					view_sync[id][i] = top_sync[i];
					format( view_type[id][i], 4, top_type[i] );
					format( view_pretype[id][i], 31, top_pretype[i] );
					len += format(MenuBody[len], 511-len, "^n\r%d. \y%d. \w%s \r%d \d%s", (i+1), (i+1), view_names[id][i], (view_distance[id][i]/1000000), view_type[id][i]);
					if( i )
						keys |= (1<<i);
					else
						keys = (1<<0);
				}
			}
		}
	}
	len += format(MenuBody[len], 511-len, "^n^n\r0. \wExit");
	keys |= (1<<9);
	show_menu(id, keys, MenuBody, -1, "Full top stats");
}

public FullTopMenu_Select(id, key)
{
	new target = key, jumpschanged, nofirstjump, i, menu_continue = INFO_ONE, page = full_top_stats_selected_page[id], jumptype = full_top_stats_selected_type[id], ljtops = get_pcvar_num(kz_ljs_tops);
	key += 1;
	
	if( key == 10 )
		return PLUGIN_HANDLED;
	
	if( page == 2 )
		target += 5;
	
	if( !(get_pcvar_num(kz_ljs_enabled) && (ljtops == 2 || ljtops == 3)) )
	{
		if( !(ljtops == 2 || ljtops == 3) )
			client_print(id, print_chat, "[XJ] Tops are not valid. Tops have been disabled.");
		else
			client_print(id, print_chat, "[XJ] Tops are not valid. Plugin has been disabled.");
		return PLUGIN_HANDLED;
	}
	
	for( i = INFO_ZERO; i < 5; i++ )
	{
		if( jumptype == 2 )
		{
			if( !i && !cj_distance[i] )
			{
				nofirstjump = INFO_ONE;
				jumpschanged = INFO_ONE;
				break;
			}
			else if( !equal(view_names[id][i], cj_names[i]) 
			|| view_distance[id][i] != cj_distance[i]
			|| view_maxspeed[id][i] != cj_maxspeed[i]
			|| view_prestrafe[id][i] != cj_prestrafe[i]
			|| view_strafes[id][i] != cj_strafes[i]
			|| view_sync[id][i] != cj_sync[i]
			|| !equal(view_pretype[id][i], cj_pretype[i]) )
			{
				jumpschanged = INFO_ONE;
				break;
			}
		}
		else if( jumptype )
		{
			if( !i && !lj_distance[i] )
			{
				nofirstjump = INFO_ONE;
				jumpschanged = INFO_ONE;
				break;
			}
			else if( !equal(view_names[id][i], lj_names[i]) 
			|| view_distance[id][i] != lj_distance[i]
			|| view_maxspeed[id][i] != lj_maxspeed[i]
			|| view_prestrafe[id][i] != lj_prestrafe[i]
			|| view_strafes[id][i] != lj_strafes[i]
			|| view_sync[id][i] != lj_sync[i]
			|| !equal(view_pretype[id][i], lj_pretype[i]) )
			{
				jumpschanged = INFO_ONE;
				break;
			}
		}
		else
		{
			if( !i && !top_distance[i] )
			{
				nofirstjump = INFO_ONE;
				jumpschanged = INFO_ONE;
				break;
			}
			else if( !equal(view_names[id][i], top_names[i]) 
			|| view_distance[id][i] != top_distance[i]
			|| view_maxspeed[id][i] != top_maxspeed[i]
			|| view_prestrafe[id][i] != top_prestrafe[i]
			|| view_strafes[id][i] != top_strafes[i]
			|| view_sync[id][i] != top_sync[i]
			|| !equal(view_type[id][i], top_type[i])
			|| !equal(view_pretype[id][i], top_pretype[i]) )
			{
				jumpschanged = INFO_ONE;
				break;
			}
		}
	}
	
	if( nofirstjump )
	{
		if( jumptype == 2 )
			client_print(id, print_chat, "[XJ] Cj top is not valid. Jumps have been reseted (no cjs).");
		else if( jumptype )
			client_print(id, print_chat, "[XJ] Lj top is not valid. Jumps have been reseted (no ljs).");
		else
			client_print(id, print_chat, "[XJ] Tops are not valid. Jumps have been reseted (no jumps).");
		menu_continue = INFO_ZERO;
	}
	else if( page && key == 9 )
	{
		if( page == 2 )
			full_top_stats_selected_page[id] = 0;
		else if( jumpschanged )
		{
			if( jumptype == 2 )
				client_print(id, print_chat, "[XJ] First 5 cjs have been changed. You are redirected to menu start.");
			else if( jumptype )
				client_print(id, print_chat, "[XJ] First 5 ljs have been changed. You are redirected to menu start.");
			else
				client_print(id, print_chat, "[XJ] First 5 jumps have been changed. You are redirected to menu start.");
			full_top_stats_selected_page[id] = 0;
		}
		else
		{
			if( jumptype == 2 && cj_distance[9] )
				full_top_stats_selected_page[id] = 2;
			else if( jumptype && lj_distance[9] )
				full_top_stats_selected_page[id] = 2;
			else if( !jumptype && top_distance[9] )
				full_top_stats_selected_page[id] = 2;
			else
			{
				client_print(id, print_chat, "[XJ] All jumps have been changed. You are redirected to menu start.");
				full_top_stats_selected_page[id] = 0;
			}
		}
	}
	else
	{
		if( jumpschanged && page == 2 )
		{
			if( jumptype == 2 )
				client_print(id, print_chat, "[XJ] First 5 cjs have been changed. You are redirected to menu start.");
			else if( jumptype )
				client_print(id, print_chat, "[XJ] First 5 ljs have been changed. You are redirected to menu start.");
			else
				client_print(id, print_chat, "[XJ] First 5 jumps have been changed. You are redirected to menu start.");
			full_top_stats_selected_page[id] = 0;
		}
		else if( page == 2 )
		{
			if( jumptype == 2 && cj_distance[9] )
				full_top_stats_selected_page[id] = 2;
			else if( jumptype && lj_distance[9] )
				full_top_stats_selected_page[id] = 2;
			else if( !jumptype && top_distance[9] )
				full_top_stats_selected_page[id] = 2;
			else
			{
				client_print(id, print_chat, "[XJ] All jumps have been changed. You are redirected to menu start.");
				full_top_stats_selected_page[id] = 0;
			}
		}
		else
			full_top_stats_selected_page[id] = 0;
	}
	
	if( !(page && key == 9) )
		show_player_stats(id, target, jumptype);
	
	if( menu_continue )
		display_full_top_stats_menu(id, jumptype, full_top_stats_selected_page[id]);
	
	return PLUGIN_HANDLED;
}

public show_player_stats(id, target, toptype)
{
	new buffer[2368], name[32], len, motdname[64];
	if( toptype == 2 )
		format(motdname, 63, "%s's cj", view_names[id][target]);
	else if( toptype )
		format(motdname, 63, "%s's lj", view_names[id][target]);
	else
		format(motdname, 63, "%s's jump", view_names[id][target]);
	
	len = format(buffer, 2367, "<body bgcolor=#94AEC6><table width=100%% cellpadding=2 cellspacing=0 border=0>");
	len += format(buffer[len], 2367-len, "<tr  align=left bgcolor=#52697B><th width=50%%> Info name <th width=50%% align=left> Value");
	
	format(name, 31, "%s", view_names[id][target]);
	while( containi(name, "<") != -1 )
		replace(name, 63, "<", "&lt;");
	while( containi(name, ">") != -1 )
		replace(name, 63, ">", "&gt;");
	
	if( toptype == 2 )
		len += format(buffer[len], 2367-len, "<tr align=left bgcolor=#A4BED6><td> Top type: <td align=left> CountJump top");
	else if( toptype == 1 )
		len += format(buffer[len], 2367-len, "<tr align=left bgcolor=#A4BED6><td> Top type: <td align=left> LongJump top");
	else
		len += format(buffer[len], 2367-len, "<tr align=left bgcolor=#A4BED6><td> Top type: <td align=left> Total top");
	
	len += format(buffer[len], 2367-len, "<tr align=left><td> Position: <td align=left> #%d", (target+1));
	len += format(buffer[len], 2367-len, "<tr align=left bgcolor=#A4BED6><td> Name: <td align=left> %s", name);
	len += format(buffer[len], 2367-len, "<tr align=left><td> Distance: <td align=left> %d.%06d", (view_distance[id][target]/1000000), (view_distance[id][target]%1000000));
	len += format(buffer[len], 2367-len, "<tr align=left bgcolor=#A4BED6><td> TopSpeed: <td align=left> %d.%06d", (view_maxspeed[id][target]/1000000), (view_maxspeed[id][target]%1000000));
	len += format(buffer[len], 2367-len, "<tr align=left><td> PreStrafe: <td align=left> %d.%06d", (view_prestrafe[id][target]/1000000), (view_prestrafe[id][target]%1000000));
	len += format(buffer[len], 2367-len, "<tr align=left bgcolor=#A4BED6><td> Strafes: <td align=left> %d", view_strafes[id][target]);
	len += format(buffer[len], 2367-len, "<tr align=left><td> Sync: <td align=left> %d", view_sync[id][target]);
	len += format(buffer[len], 2367-len, "<tr align=left bgcolor=#A4BED6><td> PreType: <td align=left> %s", view_pretype[id][target]);
	
	if( !toptype )
		len += format(buffer[len], 2367-len, "<tr align=left><td> Jump Type: <td align=left> %s", (equal(view_type[id][target], "cj")) ? "CountJump" : "LongJump");
	
	len += format(buffer[len], 2367-len, "</table></body>");
	
	show_motd(id, buffer, motdname);
}

public cmdLjsMenu(id)
{
	new plugin_cvar = get_pcvar_num(kz_ljs_enabled);
	new ljtop_cvar = get_pcvar_num(kz_ljs_tops);
	new MenuBody[512], len, keys;
	len = format(MenuBody, 511, "\yLongJump Stats Menu^n");
	
	if( !plugin_cvar )
	{
		len += format(MenuBody[len], 511-len, "^n\r1. \dSwitch colorchat (plugin off)");
		len += format(MenuBody[len], 511-len, "^n\r2. \dSwitch ljstats (plugin off)");
		len += format(MenuBody[len], 511-len, "^n\r3. \dSwitch speed (plugin off)");
		len += format(MenuBody[len], 511-len, "^n\r4. \dView tops (plugin off)");
	}
	else
	{
		len += format(MenuBody[len], 511-len, "^n\r1. \wSwitch colorchat");
		len += format(MenuBody[len], 511-len, "^n\r2. \wSwitch ljstats");
		len += format(MenuBody[len], 511-len, "^n\r3. \wSwitch speed");
		if( (ljtop_cvar == 2 || ljtop_cvar == 3) && top_distance[0] )
		{
			len += format(MenuBody[len], 511-len, "^n^n\r4. \wView tops");
			keys = (1<<0|1<<1|1<<2|1<<3);
		}
		else
		{
			if( !top_distance[0] )
				len += format(MenuBody[len], 511-len, "^n\r4. \dView tops (no jumps)");
			else
				len += format(MenuBody[len], 511-len, "^n\r4. \dView tops (disabled)");
			keys = (1<<0|1<<1|1<<2);
		}
	}
	
	len += format(MenuBody[len], 511-len, "^n^n\r5. \wPrint plugin info");
	if( !plugin_cvar )
		keys = (1<<4);
	else
		keys |= (1<<4);
	
	new flags = get_user_flags(id);
	if( flags&ADMIN_MENU && (flags&ADMIN_CFG || flags&ADMIN_CVAR) )
		len += format(MenuBody[len], 511-len, "^n^n^n\rAdmin menu^n");
	
	if( flags&ADMIN_MENU )
	{
		if( flags&ADMIN_CFG )
		{
			len += format(MenuBody[len], 511-len, "^n\r6. \yServer configurations");
			keys |= (1<<5);
		}
		
		if( flags&ADMIN_CVAR )
		{
			len += format(MenuBody[len], 511-len, "^n\r7. \yOne map config");
			keys |= (1<<6);
		}
	}
	
	len += format(MenuBody[len], 511-len, "^n^n\r0. \wExit");
	keys |= (1<<9);
	
	show_menu(id, keys, MenuBody, -1, "LongJump Stats Menu");
	
	return ( (get_pcvar_num(kz_ljs_viscmds))?PLUGIN_CONTINUE:PLUGIN_HANDLED );
}

public LjsMenu_Select(id, key)
{
	switch((key+1))
	{
		case 1:
		{
			if( get_pcvar_num(kz_ljs_enabled) )
					cmdColorChat(id);
			cmdLjsMenu(id);
		}
		case 2:
		{
			if( get_pcvar_num(kz_ljs_enabled) )
				cmdLjStats(id);
			cmdLjsMenu(id);
		}
		case 3:
		{
			if( get_pcvar_num(kz_ljs_enabled) )
				cmdSpeed(id);
			cmdLjsMenu(id);
		}
		case 4:
		{
			if( get_pcvar_num(kz_ljs_enabled) )
				cmdTopMenu(id);
			else
				cmdLjsMenu(id);
		}
		case 5: cmdVersion(id);
		case 6:
		{
			if( get_user_flags(id)&ADMIN_CFG && get_user_flags(id)&ADMIN_MENU )
				ColorChat(id, RED, "[XJ] Comming soon!");
			else
				cmdLjsMenu(id);
		}
		case 7:
		{
			if( get_user_flags(id)&ADMIN_CVAR && get_user_flags(id)&ADMIN_MENU )
				ColorChat(id, BLUE, "[XJ] Comming soon!");
			else
				cmdLjsMenu(id);
		}
	}
	return PLUGIN_HANDLED;
}

public read_tops()
{
	static main_filename[128], lj_filename[128], cj_filename[128];
	format(main_filename, 127, "%s/Top10_main.dat", ljsDir);
	format(lj_filename, 127, "%s/Top10_lj.dat", ljsDir);
	format(cj_filename, 127, "%s/Top10_cj.dat", ljsDir);
	
	static distance[12], maxspeed[12], prestrafe[12], strafes[6], sync[6], line = 0, txtsize = 0, i;
	if( file_exists(main_filename) )
	{
		for( i = INFO_ZERO ; i < 10; i++ )
		{
			if( (line=read_file(main_filename,line,top_names[i],32,txtsize))!=0 )
			{
				if( (line=read_file(main_filename,line,top_authid[i],32,txtsize))!=0 )
				{
					if( (line=read_file(main_filename,line,distance,11,txtsize))!=0 )
					{
						if( (line=read_file(main_filename,line,maxspeed,11,txtsize))!=0 )
						{
							if( (line=read_file(main_filename,line,prestrafe,11,txtsize))!=0 )
							{
								if( (line=read_file(main_filename,line,strafes,5,txtsize))!=0 )
								{
									if( (line=read_file(main_filename,line,sync,5,txtsize))!=0 )
									{
										if( (line=read_file(main_filename,line,top_type[i],4,txtsize))!=0 )
										{
											if( (line=read_file(main_filename,line,top_pretype[i],31,txtsize))!=0 )
											{
												top_distance[i] = str_to_num( distance );
												top_maxspeed[i] = str_to_num( maxspeed );
												top_prestrafe[i] = str_to_num( prestrafe );
												top_strafes[i] = str_to_num( strafes );
												top_sync[i] = str_to_num( sync );
											}
										}
									}
								}
							}
						}
					}
				}
			}
			else
				break;
		}
	}
	
	line = 0;
	if( file_exists(lj_filename) )
	{
		for( i = INFO_ZERO ; i < 10; i++ )
		{
			if( (line=read_file(lj_filename,line,lj_names[i],32,txtsize))!=0 )
			{
				if( (line=read_file(lj_filename,line,lj_authid[i],32,txtsize))!=0 )
				{
					if( (line=read_file(lj_filename,line,distance,11,txtsize))!=0 )
					{
						if( (line=read_file(lj_filename,line,maxspeed,11,txtsize))!=0 )
						{
							if( (line=read_file(lj_filename,line,prestrafe,11,txtsize))!=0 )
							{
								if( (line=read_file(lj_filename,line,strafes,5,txtsize))!=0 )
								{
									if( (line=read_file(lj_filename,line,sync,5,txtsize))!=0 )
									{
										if( (line=read_file(lj_filename,line,lj_pretype[i],31,txtsize))!=0 )
										{
											lj_distance[i] = str_to_num( distance );
											lj_maxspeed[i] = str_to_num( maxspeed );
											lj_prestrafe[i] = str_to_num( prestrafe );
											lj_strafes[i] = str_to_num( strafes );
											lj_sync[i] = str_to_num( sync );
										}
									}
								}
							}
						}
					}
				}
			}
			else
				break;
		}
	}
	
	line = 0;
	if( file_exists(cj_filename) )
	{
		for( i = INFO_ZERO ; i < 10; i++ )
		{
			if( (line=read_file(cj_filename,line,cj_names[i],32,txtsize))!=0 )
			{
				if( (line=read_file(cj_filename,line,cj_authid[i],32,txtsize))!=0 )
				{
					if( (line=read_file(cj_filename,line,distance,11,txtsize))!=0 )
					{
						if( (line=read_file(cj_filename,line,maxspeed,11,txtsize))!=0 )
						{
							if( (line=read_file(cj_filename,line,prestrafe,11,txtsize))!=0 )
							{
								if( (line=read_file(cj_filename,line,strafes,5,txtsize))!=0 )
								{
									if( (line=read_file(cj_filename,line,sync,5,txtsize))!=0 )
									{
										if( (line=read_file(cj_filename,line,cj_pretype[i],31,txtsize))!=0 )
										{
											cj_distance[i] = str_to_num( distance );
											cj_maxspeed[i] = str_to_num( maxspeed );
											cj_prestrafe[i] = str_to_num( prestrafe );
											cj_strafes[i] = str_to_num( strafes );
											cj_sync[i] = str_to_num( sync );
										}
									}
								}
							}
						}
					}
				}
			}
			else
				break;
		}
	}
	return PLUGIN_HANDLED;
}

public topreset(id)
{
	if( id == (is_dedicated_server()?0:1) || (get_user_flags(id)&ADMIN_RCON && tops_save) || (get_user_flags(id)&ADMIN_MAP && !tops_save) )
	{
		static main_filename[128], lj_filename[128], cj_filename[128];
		format(main_filename, 127, "%s/Top10_main.dat", ljsDir);
		format(lj_filename, 127, "%s/Top10_lj.dat", ljsDir);
		format(cj_filename, 127, "%s/Top10_cj.dat", ljsDir);
		
		if( file_exists(main_filename) && tops_save )
			delete_file(main_filename);
		if( file_exists(lj_filename) && tops_save )
			delete_file(lj_filename);
		if( file_exists(cj_filename) && tops_save )
			delete_file(cj_filename);
		
		static info_none[33], i;
		info_none = "";
		for( i = INFO_ZERO; i < 10; i++ )
		{
			format( top_names[i], 32, info_none );
			format( top_authid[i], 32, info_none );
			top_distance[i] = INFO_ZERO;
			top_maxspeed[i] = INFO_ZERO;
			top_prestrafe[i] = INFO_ZERO;
			top_strafes[i] = INFO_ZERO;
			top_sync[i] = INFO_ZERO;
			format( top_type[i], 32, info_none );
			
			format( lj_names[i], 32, info_none );
			format( lj_authid[i], 32, info_none );
			lj_distance[i] = INFO_ZERO;
			lj_maxspeed[i] = INFO_ZERO;
			lj_prestrafe[i] = INFO_ZERO;
			lj_strafes[i] = INFO_ZERO;
			lj_sync[i] = INFO_ZERO;
			
			format( cj_names[i], 32, info_none );
			format( cj_authid[i], 32, info_none );
			cj_distance[i] = INFO_ZERO;
			cj_maxspeed[i] = INFO_ZERO;
			cj_prestrafe[i] = INFO_ZERO;
			cj_strafes[i] = INFO_ZERO;
			cj_sync[i] = INFO_ZERO;
		}
		
		static name[32], authid[32];
		name = "";
		authid = "";
		get_user_name( id, name, 31 );
		if( get_pcvar_num(kz_ljs_rank_by) == 1 )
			get_user_authid( id, authid ,31 );
		else
			get_user_ip( id, authid, 31, 1);
		
		log_amx("LjS: ^"%s<%d><%s>^" reseted ljtop", name, get_user_userid(id), authid);
		
		console_print(id, "[XJ] LongJump top and rec reseted!");
		client_print(0, print_chat, "[XJ] LongJump top and rec reseted!");
	}
	else
		console_print(id, "%L", id, "NO_ACC_COM");
	
	return PLUGIN_HANDLED;
}

public check_maintop(id, Distance, MaxAirSpeed, MaxGroundSpeed, strafes, sync, type)
{
	static jumptype[5], editional_top_n, top_num, rankby;
	top_num = 0;
	rankby = get_pcvar_num(kz_ljs_rank_by);
	
	static name[32], authid[32];
	get_user_name( id, name, 31 );
	if( rankby == 1 )
		get_user_authid(id, authid ,31);
	else if( rankby == 2 )
		get_user_ip(id, authid, 31, 1);
	else
		get_user_name(id, authid, 31);
	
	if( type )
	{
		editional_top_n = check_cjtop(id, Distance, MaxAirSpeed, MaxGroundSpeed, strafes, sync, rankby);
		jumptype = "cj";
	}
	else
	{
		editional_top_n = check_ljtop(id, Distance, MaxAirSpeed, MaxGroundSpeed, strafes, sync, rankby);
		jumptype = "lj";
	}
	
	if( Distance > top_distance[9] || (Distance == top_distance[9] && equal(top_type[9], "cj") && equal(jumptype, "lj")) )
	{
		static i;
		for( i = INFO_ZERO; i < 10; i++ )
		{
			if( Distance > top_distance[i] || (Distance == top_distance[i] && equal(top_type[i], "cj") && equal(jumptype, "lj")) )
			{
				static pos, j;
				pos = i;
				j = 0;
				while( !equal( top_authid[pos], authid ) && pos < 9 )
					pos++ ;
				for( j = pos; j > i; j-- )
				{
					format( top_names[j], 32, top_names[j-1] );
					format( top_authid[j], 32, top_authid[j-1] );
					top_distance[j] = top_distance[j-1];
					top_maxspeed[j] = top_maxspeed[j-1];
					top_prestrafe[j] = top_prestrafe[j-1];
					top_strafes[j] = top_strafes[j-1];
					top_sync[j] = top_sync[j-1];
					format( top_type[j], 4, top_type[j-1] );
					format( top_pretype[j], 31, top_pretype[j-1] );
				}
				
				format( top_names[i], 32, name );
				format( top_authid[i], 32, authid );
				top_distance[i] = Distance;
				top_maxspeed[i] = MaxAirSpeed;
				top_prestrafe[i] = MaxGroundSpeed;
				top_strafes[i] = strafes;
				top_sync[i] = sync;
				format( top_type[i], 4, jumptype );
				format( top_pretype[i], 31, pre_type[id] );
				top_num = i+1;
				
				break;
			}
			else if( equal( top_authid[i], authid ) )
				break;
		}
		if( editional_top_n && (get_pcvar_num(kz_ljs_tops) == 2 || get_pcvar_num(kz_ljs_tops) == 3) )
		{
			if( top_num )
			{
				if( top_num == editional_top_n )
					client_print(0, print_chat, "[XJ] %s now is %d in total & %s top with %d.%03d jump!", name, top_num, jumptype, (Distance/1000000), (Distance%1000000/1000), jumptype);
				else
					client_print(0, print_chat, "[XJ] %s now is %d in total top & %d in %s top with %d jump!", name, top_num, editional_top_n, jumptype, (Distance/1000000), jumptype);
			}
			else
				client_print(0, print_chat, "[XJ] %s now is %d in %s top with %d.%06d jump!", name, editional_top_n, jumptype, (Distance/1000000), (Distance%1000000), jumptype);
		}
	
		if( tops_save && editional_top_n)
			save_tops();
	}
}

public check_cjtop(id, Distance, MaxAirSpeed, MaxGroundSpeed, strafes, sync, rankby)
{
	static name[32], authid[32];
	get_user_name( id, name, 31 );
	if( rankby == 1 )
		get_user_authid(id, authid ,31);
	else if( rankby == 2 )
		get_user_ip(id, authid, 31, 1);
	else
		get_user_name(id, authid, 31);
	
	if( Distance > cj_distance[9] )
	{
		static i;
		for( i = INFO_ZERO; i < 10; i++ )
		{
			if( Distance > cj_distance[i] )
			{
				static pos, j;
				pos = i;
				j = 0;
				while( !equal( cj_authid[pos], authid ) && pos < 9 )
					pos++ ;
				for( j = pos; j > i; j-- )
				{
					format( cj_names[j], 32, cj_names[j-1] );
					format( cj_authid[j], 32, cj_authid[j-1] );
					cj_distance[j] = cj_distance[j-1];
					cj_maxspeed[j] = cj_maxspeed[j-1];
					cj_prestrafe[j] = cj_prestrafe[j-1];
					cj_strafes[j] = cj_strafes[j-1];
					cj_sync[j] = cj_sync[j-1];
					format( cj_pretype[j], 31, cj_pretype[j-1] );
				}
				
				format( cj_names[i], 32, name );
				format( cj_authid[i], 32, authid );
				cj_distance[i] = Distance;
				cj_maxspeed[i] = MaxAirSpeed;
				cj_prestrafe[i] = MaxGroundSpeed;
				cj_strafes[i] = strafes;
				cj_sync[i] = sync;
				format( cj_pretype[i], 31, pre_type[id] );
				return (i+1);
				
			}
			else if( equal( cj_authid[i], authid ) )
				return 0;
		}
	}
	return 0;
}

public check_ljtop(id, Distance, MaxAirSpeed, MaxGroundSpeed, strafes, sync, rankby)
{
	static name[32], authid[32];
	get_user_name( id, name, 31 );
	if( rankby == 1 )
		get_user_authid(id, authid ,31);
	else if( rankby == 2 )
		get_user_ip(id, authid, 31, 1);
	else
		get_user_name(id, authid, 31);
	
	if( Distance > lj_distance[9] )
	{
		static i;
		for( i = INFO_ZERO; i < 10; i++ )
		{
			if( Distance > lj_distance[i] )
			{
				static pos, j;
				pos = i;
				j = 0;
				while( !equal( lj_authid[pos], authid ) && pos < 9 )
					pos++ ;
				for( j = pos; j > i; j-- )
				{
					format( lj_names[j], 32, lj_names[j-1] );
					format( lj_authid[j], 32, lj_authid[j-1] );
					lj_distance[j] = lj_distance[j-1];
					lj_maxspeed[j] = lj_maxspeed[j-1];
					lj_prestrafe[j] = lj_prestrafe[j-1];
					lj_strafes[j] = lj_strafes[j-1];
					lj_sync[j] = lj_sync[j-1];
					format( lj_pretype[j], 31, lj_pretype[j-1] );
				}
				
				format( lj_names[i], 32, name );
				format( lj_authid[i], 32, authid );
				lj_distance[i] = Distance;
				lj_maxspeed[i] = MaxAirSpeed;
				lj_prestrafe[i] = MaxGroundSpeed;
				lj_strafes[i] = strafes;
				lj_sync[i] = sync;
				format( lj_pretype[i], 31, pre_type[id] );
				return (i+1);
				
			}
			else if( equal( lj_authid[i], authid ) )
				return 0;
		}
	}
	return 0;
}

public save_tops()
{
	static main_filename[128], lj_filename[128], cj_filename[128];
	format(main_filename, 127, "%s/Top10_main.dat", ljsDir);
	format(lj_filename, 127, "%s/Top10_lj.dat", ljsDir);
	format(cj_filename, 127, "%s/Top10_cj.dat", ljsDir);
	
	if( file_exists(main_filename) )  
		delete_file(main_filename);
	if( file_exists(lj_filename) )  
		delete_file(lj_filename);
	if( file_exists(cj_filename) )  
		delete_file(cj_filename);
	
	static i, distance[12], maxspeed[12], prestrafe[12], strafes[6], sync[6];
	for( i = INFO_ZERO; i < 10; i++ )
	{
		if( top_distance[i] )
		{
			num_to_str(top_distance[i], distance, 11);
			num_to_str(top_maxspeed[i], maxspeed, 11);
			num_to_str(top_prestrafe[i], prestrafe, 11);
			num_to_str(top_strafes[i], strafes, 5);
			num_to_str(top_sync[i], sync, 5);
			write_file(main_filename, top_names[i]);
			write_file(main_filename, top_authid[i]);
			write_file(main_filename, distance);
			write_file(main_filename, maxspeed);
			write_file(main_filename, prestrafe);
			write_file(main_filename, strafes);
			write_file(main_filename, sync);
			write_file(main_filename, top_type[i]);
			write_file(main_filename, top_pretype[i]);
		}
		if( lj_distance[i] )
		{
			num_to_str(lj_distance[i], distance, 11);
			num_to_str(lj_maxspeed[i], maxspeed, 11);
			num_to_str(lj_prestrafe[i], prestrafe, 11);
			num_to_str(lj_strafes[i], strafes, 5);
			num_to_str(lj_sync[i], sync, 5);
			write_file(lj_filename, lj_names[i]);
			write_file(lj_filename, lj_authid[i]);
			write_file(lj_filename, distance);
			write_file(lj_filename, maxspeed);
			write_file(lj_filename, prestrafe);
			write_file(lj_filename, strafes);
			write_file(lj_filename, sync);
			write_file(lj_filename, lj_pretype[i]);
		}
		if( cj_distance[i] )
		{
			num_to_str(cj_distance[i], distance, 11);
			num_to_str(cj_maxspeed[i], maxspeed, 11);
			num_to_str(cj_prestrafe[i], prestrafe, 11);
			num_to_str(cj_strafes[i], strafes, 5);
			num_to_str(cj_sync[i], sync, 5);
			write_file(cj_filename, cj_names[i]);
			write_file(cj_filename, cj_authid[i]);
			write_file(cj_filename, distance);
			write_file(cj_filename, maxspeed);
			write_file(cj_filename, prestrafe);
			write_file(cj_filename, strafes);
			write_file(cj_filename, sync);
			write_file(cj_filename, cj_pretype[i]);
		}
	}
}

public show_leet_ljumper(id)
{
	new plugin_cvar = get_pcvar_num(kz_ljs_enabled);
	new ljtop_cvar = get_pcvar_num(kz_ljs_tops);
	if( plugin_cvar && (ljtop_cvar == 2 || ljtop_cvar == 3) )
	{
		if( top_distance[0] )
		{
			new MenuBody[512], len, keys;
			len = format(MenuBody, 511, "\yShow best longjumper^n");
			len += format(MenuBody[len], 511-len, "^n\r1. \wTotal jump record");
			keys = (1<<0);
			
			if( lj_distance[0] )
			{
				len += format(MenuBody[len], 511-len, "^n\r2. \wLongJump record");
				keys |= (1<<1);
			}
			else
				len += format(MenuBody[len], 511-len, "^n\r2. \dLongJump record (no ljs)");
			
			if( cj_distance[0] )
			{
				len += format(MenuBody[len], 511-len, "^n\r3. \wContJump record");
				keys |= (1<<2);
			}
			else
				len += format(MenuBody[len], 511-len, "^n\r3. \dContJump record (no cjs)");
			
			len += format(MenuBody[len], 511-len, "^n^n\r0. \wExit");
			keys |= (1<<9);
			
			show_menu(id, keys, MenuBody, -1, "Show best longjumper");
		}
		else
			client_print(id, print_chat, "[XJ] No jump records are setted!");
	}
	else if( !plugin_cvar )
		client_print(id, print_chat, "[XJ] Records are not valid. Plugin is disabled.");
	else
		client_print(id, print_chat, "[XJ] Records are not valid. Tops are disabled.");
	
	return ( (get_pcvar_num(kz_ljs_viscmds))?PLUGIN_CONTINUE:PLUGIN_HANDLED );
}

public LeetJumpMenu_Select(id, key)
{
	new plugin_cvar = get_pcvar_num(kz_ljs_enabled);
	new ljtops = get_pcvar_num(kz_ljs_tops);
	if( ljtops == 2 || ljtops == 3 )
		ljtops = 1;
	else
		ljtops = 0;
	switch((key+1))
	{
		case 1:
		{
			if( top_distance[0] && ljtops && plugin_cvar )
				client_print(id, print_chat, "[XJ] %s has the total %d.%06d %s record!", top_names[0], top_distance[0]/1000000, top_distance[0]%1000000, top_type[0]);
			else if( !plugin_cvar )
				client_print(id, print_chat, "[XJ] Records are not valid. Plugin has been disabled.");
			else if( !ljtops )
				client_print(id, print_chat, "[XJ] Records are not valid. Tops have been disabled.");
			else
				client_print(id, print_chat, "[XJ] Records are not valid. Tops have been reseted.");
		}
		case 2:
		{
			if( lj_distance[0] && ljtops && plugin_cvar )
				client_print(id, print_chat, "[XJ] %s has the %d.%06d lj record!", lj_names[0], lj_distance[0]/1000000, lj_distance[0]%1000000);
			else if( !plugin_cvar )
				client_print(id, print_chat, "[XJ] Records are not valid. Plugin has been disabled.");
			else if( !ljtops )
				client_print(id, print_chat, "[XJ] Records are not valid. Tops have been disabled.");
			else
				client_print(id, print_chat, "[XJ] Lj records are not valid. Tops have been reseted.");
		}
		case 3:
		{
			if( cj_distance[0] && ljtops && plugin_cvar )
				client_print(id, print_chat, "[XJ] %s has the %d.%06d cj record!", cj_names[0], cj_distance[0]/1000000, cj_distance[0]%1000000);
			else if( !plugin_cvar )
				client_print(id, print_chat, "[XJ] Records are not valid. Plugin has been disabled.");
			else if( !ljtops )
				client_print(id, print_chat, "[XJ] Records are not valid. Tops have been disabled.");
			else
				client_print(id, print_chat, "[XJ] Cj records are not valid. Tops have been reseted.");
		}
	}
	return PLUGIN_HANDLED;
}

public show_top(id, toptype)
{
	static buffer[2368], name[64], len, i;
	
	len = format(buffer, 2367, "<body bgcolor=#94AEC6><table width=100%% cellpadding=2 cellspacing=0 border=0>");
	if( !toptype )
		len += format(buffer[len], 2367-len, "<tr  align=center bgcolor=#52697B><th width=5%%> # <th width=34%% align=left> Name <th width=10%%> Distance <th  width=10%%> MaxSpeed <th  width=11%%> PreStrafe <th  width=9%%> Strafes <th  width=6%%> Sync <th  width=10%%> Type");
	else
		len += format(buffer[len], 2367-len, "<tr  align=center bgcolor=#52697B><th width=5%%> # <th width=34%% align=left> Name <th width=10%%> Distance <th  width=10%%> MaxSpeed <th  width=11%%> PreStrafe <th  width=9%%> Strafes <th  width=6%%> Sync");
	
	if( toptype == 2)
	{
		for( i = INFO_ZERO; i < 10; i++ )
		{		
			if( cj_distance[i] == 0 )
			{
				len += format(buffer[len], 2367-len, "<tr align=center%s><td> %d <td align=left> %s <td> %s <td> %s <td> %s <td> %s <td> %s", ((i%2)==0) ? "" : " bgcolor=#A4BED6", (i+1), "-", "-", "-", "-", "-", "-");
				i=10;
			}
			else
			{
				name = cj_names[i];
				while( containi(name, "<") != -1 )
					replace(name, 63, "<", "&lt;");
				while( containi(name, ">") != -1 )
					replace(name, 63, ">", "&gt;");
				len += format(buffer[len], 2367-len, "<tr align=center%s><td> %d <td align=left> %s <td> %d.%01d <td> %d.%01d <td> %d.%01d <td> %d <td> %d", ((i%2)==0) ? "" : " bgcolor=#A4BED6", (i+1), name, (cj_distance[i]/1000000), (cj_distance[i]%1000000/100000), (cj_maxspeed[i]/1000000), (cj_maxspeed[i]%1000000/100000), (cj_prestrafe[i]/1000000), (cj_prestrafe[i]%1000000/100000), cj_strafes[i], cj_sync[i]);
			}
		}
	}
	else if( toptype )
	{
		for( i = INFO_ZERO; i < 10; i++ )
		{		
			if( lj_distance[i] == 0 )
			{
				len += format(buffer[len], 2367-len, "<tr align=center%s><td> %d <td align=left> %s <td> %s <td> %s <td> %s <td> %s <td> %s", ((i%2)==0) ? "" : " bgcolor=#A4BED6", (i+1), "-", "-", "-", "-", "-", "-");
				i=10;
			}
			else
			{
				name = lj_names[i];
				while( containi(name, "<") != -1 )
					replace(name, 63, "<", "&lt;");
				while( containi(name, ">") != -1 )
					replace(name, 63, ">", "&gt;");
				len += format(buffer[len], 2367-len, "<tr align=center%s><td> %d <td align=left> %s <td> %d.%01d <td> %d.%01d <td> %d.%01d <td> %d <td> %d", ((i%2)==0) ? "" : " bgcolor=#A4BED6", (i+1), name, (lj_distance[i]/1000000), (lj_distance[i]%1000000/100000), (lj_maxspeed[i]/1000000), (lj_maxspeed[i]%1000000/100000), (lj_prestrafe[i]/1000000), (lj_prestrafe[i]%1000000/100000), lj_strafes[i], lj_sync[i]);
			}
		}
	}
	else
	{
		for( i = INFO_ZERO; i < 10; i++ )
		{		
			if( top_distance[i] == 0 )
			{
				len += format(buffer[len], 2367-len, "<tr align=center%s><td> %d <td align=left> %s <td> %s <td> %s <td> %s <td> %s <td> %s <td> %s", ((i%2)==0) ? "" : " bgcolor=#A4BED6", (i+1), "-", "-", "-", "-", "-", "-", "-");
				i=10;
			}
			else
			{
				name = top_names[i];
				while( containi(name, "<") != -1 )
					replace(name, 63, "<", "&lt;");
				while( containi(name, ">") != -1 )
					replace(name, 63, ">", "&gt;");
				len += format(buffer[len], 2367-len, "<tr align=center%s><td> %d <td align=left> %s <td> %d <td> %d <td> %d <td> %d <td> %d <td> %s", ((i%2)==0) ? "" : " bgcolor=#A4BED6", (i+1), name, (top_distance[i]/1000000), (top_maxspeed[i]/1000000), (top_prestrafe[i]/1000000), top_strafes[i], top_sync[i], top_type[i]);
			}
		}
	}
		
	len += format(buffer[len], 2367-len, "</table></body>");
	
	if( toptype == 2)
		show_motd(id, buffer, "Top 10 CountJumps");
	else if( toptype )
		show_motd(id, buffer, "Top 10 LongJumps");
	else
		show_motd(id, buffer, "Top 10 Best Jumps");
}

public gocheck(id)
{
	gInAir[id] = false;
	cjumped[id] = false;
	doubleducked[id] = false;
}

public ddend(id)
	doubleducked[id] = false;

public testcjstart(id)
	cducked[id] = false;

public client_putinserver(id)
{
	if( task_exists(id+234490, 0) )
		remove_task(id+234490, 0);
	
	set_task(0.1, "check_prestrafe_type", id+234490, "", 0, "b", 0);
	
	static connectenabler[6], fastserver;
	fastserver = get_pcvar_num(kz_ljs_fastserver);
	get_pcvar_string(kz_ljs_connectenabler, connectenabler, 5);
	format(connectenabler, 5, "_%s", connectenabler);
	if( contain(connectenabler, "a") > 0 )
		gHasColorChat[id] = true;
	else
		gHasColorChat[id] = false;
	if( contain(connectenabler, "b") > 0 )
		gHasLjStats[id] = true;
	else
		gHasLjStats[id] = false;
	if( contain(connectenabler, "c") > 0 )
	{
		gHasSpeed[id] = true;
		if( fastserver == 1 )
			set_task(0.1, "tskSpeed", id+334490, "", 0, "b", 0);
		else if( fastserver != 2 )
			set_task(0.5, "tskSpeed", id+334490, "", 0, "b", 0);
	}
	else
		gHasSpeed[id] = false;
	
	if( fastserver == 2 )
		set_task(0.5, "tskFps", id+434490, "", 0, "b", 0);
	else
		set_task(1.0, "tskFps", id+434490, "", 0, "b", 0);
	
	turning_right[id] = false;
	turning_left[id] = false;
	strafing_aw[id] = false;
	strafing_sd[id] = false;
	cducked[id] = false;
	cjumped[id] = false;
	doubleducked[id]=false;
	induck[id] = false;
	OnGround[id] = false;
	possible_lj_script[id][0] = false;
	possible_lj_script[id][1] = false;
}

public client_disconnect(id)
{
	if( task_exists(id+234490, 0) )
		remove_task(id+234490, 0);
	
	gHasColorChat[id] = false;
	gHasLjStats[id] = false;
	gHasSpeed[id] = false;
	turning_right[id] = false;
	turning_left[id] = false;
	strafing_aw[id] = false;
	strafing_sd[id] = false;
	OnGround[id] = false;
	cducked[id] = false;
	doubleducked[id] = false;
	cjumped[id] = false;
	induck[id] = false;
	possible_lj_script[id][0] = false;
	possible_lj_script[id][1] = false;
	
	if( task_exists(id+334490, 0) )
		remove_task(id+334490, 0);
	
	if( task_exists(id+434490, 0) )
		remove_task(id+434490, 0);
}

public check_prestrafe_type(id)
{
	id -= 234490;
	if( is_user_alive(id) )
	{
		static flags, buttons, moving;
		flags = pev(id, pev_flags);
		buttons = pev(id, pev_button);
		
		if( flags&FL_ONGROUND && gInAir[id] && get_gametime() > (jumptime[id]+0.1) )
			fwdPlayerPreThink(id);
		
		if( (buttons&IN_FORWARD || buttons&IN_BACK || buttons&IN_MOVERIGHT || buttons&IN_MOVELEFT) && !(buttons&IN_DUCK) )
			moving = INFO_ONE;
		else
			moving = INFO_ZERO;
		
		if( moving && !doubleducked[id] && !cjumped[id] && flags&FL_ONGROUND && (turning_right[id] || turning_left[id]) )
		{
			if( buttons&IN_FORWARD && buttons&IN_BACK )
				moving = INFO_ZERO;
			
			if( buttons&IN_MOVELEFT && buttons&IN_MOVERIGHT )
				moving = INFO_ZERO;
			
			if( !moving )
				pre_type[id] = "key error";
		}
		else
			moving = 0;
		
		if( moving )
		{
			if( buttons&IN_FORWARD )
			{
				if( buttons&IN_MOVERIGHT )
				{
					if( turning_right[id] )
						pre_type[id] = "right";
					else
						pre_type[id] = "right sw";
				}
				else if( buttons&IN_MOVELEFT )
				{
					if( turning_left[id] )
						pre_type[id] = "left";
					else
						pre_type[id] = "left sw";
				}
				else
				{
					if( turning_right[id] )
						pre_type[id] = "right (1 key)";
					else
						pre_type[id] = "left (1 key)";
				}
			}
			else if( buttons&IN_BACK )
			{
				if( buttons&IN_MOVERIGHT )
				{
					if( turning_left[id] )
						pre_type[id] = "bw right";
					else
						pre_type[id] = "bw right sw";
				}
				else if( buttons&IN_MOVELEFT )
				{
					if( turning_right[id] )
						pre_type[id] = "bw left";
					else
						pre_type[id] = "bw left sw";
				}
				else
				{
					if( turning_left[id] )
						pre_type[id] = "bw right (1 key)";
					else
						pre_type[id] = "bw left (1 key)";
				}
			}
			else if( buttons&IN_MOVERIGHT )
			{
				if( turning_right[id] )
					pre_type[id] = "bw right sw (1 key)";
				else
					pre_type[id] = "left sw (1 key)";
			}
			else if( buttons&IN_MOVELEFT )
			{
				if( turning_left[id] )
					pre_type[id] = "bw left sw (1 key)";
				else
					pre_type[id] = "right sw (1 key)";
			}
			else
				pre_type[id] = "unknown error";
		}
	}				
}

public tskFps(id)
{
	if( get_pcvar_num(kz_legal_settings) && get_pcvar_num(kz_ljs_enabled) )
	{
		id-=434490;
		client_cmd(id, "developer 0;fps_max 101");
	}
}

public cmdColorChat(id)
{
	if( get_pcvar_num(kz_ljs_enabled) && !gHasColorChat[id] )
	{
		gHasColorChat[id] = true;
		client_print(id, print_chat, "[XJ] ColorChat enabled. To disable, type /colorchat.");
	}
	else if( get_pcvar_num(kz_ljs_enabled) )
	{
		gHasColorChat[id] = false;
		client_print(id, print_chat, "[XJ] ColorChat disabled. To enable, type /colorchat.");
	}
	
	return ( (get_pcvar_num(kz_ljs_viscmds))?PLUGIN_CONTINUE:PLUGIN_HANDLED );
}

public cmdLjStats(id)
{
	if( get_pcvar_num(kz_ljs_enabled) && !gHasLjStats[id] )
	{
		gHasLjStats[id] = true;
		
		client_print(id, print_chat, "[XJ] LongJump Stats enabled. To disable, type /ljstats.");
	}
	else if( get_pcvar_num(kz_ljs_enabled) )
	{
		gHasLjStats[id] = false;
		
		client_print(id, print_chat, "[XJ] LongJump Stats disabled. To enable, type /ljstats.");
	}
	
	return ( (get_pcvar_num(kz_ljs_viscmds))?PLUGIN_CONTINUE:PLUGIN_HANDLED );
}

public cmdSpeed(id)
{
	if( get_pcvar_num(kz_ljs_enabled) && !gHasSpeed[id] )
	{
		gHasSpeed[id] = true;
		if( get_pcvar_num(kz_ljs_fastserver) == 1 )
			set_task(0.1, "tskSpeed", id+334490, "", 0, "b", 0);
		else if( get_pcvar_num(kz_ljs_fastserver) != 2 )
			set_task(0.5, "tskSpeed", id+334490, "", 0, "b", 0);
		client_print(id, print_chat, "[XJ] Speedometer enabled. To disable, type /speed.");
	}
	else if( get_pcvar_num(kz_ljs_enabled) )
	{
		gHasSpeed[id] = false;
		if( task_exists(id+334490, 0) )
			remove_task(id+334490, 0);
		client_print(id, print_chat, "[XJ] Speedometer disabled. To enable, type /speed.");
	}
	
	return ( (get_pcvar_num(kz_ljs_viscmds))?PLUGIN_CONTINUE:PLUGIN_HANDLED );
}

public tskSpeed(taskid)
{
	taskid-=334490;
	static alive, aliveflags, spectatedplayer, specflags;
	alive = is_user_alive(taskid);
	aliveflags = pev(taskid, pev_flags);
	spectatedplayer = get_spectated_player(taskid);
	if( spectatedplayer )
		specflags = pev(spectatedplayer, pev_flags);
	else
		specflags = INFO_ZERO;
	
	if( (alive || spectatedplayer > 0) && get_pcvar_num(kz_ljs_enabled) )
	{
		if( alive )
		{
			pev(taskid, pev_velocity, vVelocity);
			if( aliveflags&FL_ONGROUND && aliveflags&FL_INWATER )
				vVelocity[2]-=vVelocity[2];
		}
		else
		{
			pev(spectatedplayer, pev_velocity, vVelocity);
			if( specflags&FL_ONGROUND && specflags&FL_INWATER )
				vVelocity[2]-=vVelocity[2];
		}
				
		if( get_pcvar_num(kz_ljs_fastserver) == 1 )
			set_hudmessage(255, 255, 255, -1.0, 0.65, 0, 0.0, 0.2, 0.0, 0.0, 2);
		else if( !(get_pcvar_num(kz_ljs_fastserver) == 1 || get_pcvar_num(kz_ljs_fastserver) == 2) )
			set_hudmessage(255, 255, 255, -1.0, 0.65, 0, 0.0, 0.6, 0.0, 0.0, 2);
		
		if( get_pcvar_num(kz_ljs_speedtype) == 1 )
			show_hudmessage(taskid, "%d units/second", floatround(vector_length(vVelocity), floatround_floor));
		else if( get_pcvar_num(kz_ljs_speedtype) == 2 )
		{
			if( vVelocity[2] != 0 )
				vVelocity[2]-=vVelocity[2];
			gSpeed = vector_length(vVelocity);
			show_hudmessage(taskid, "%d velocity", floatround(gSpeed, floatround_floor));
		}
		else
		{
			if( vVelocity[2] != 0 )
				vVelocity[2]-=vVelocity[2];
			gSpeed = vector_length(vVelocity);
			if( alive )
			{
				pev(taskid, pev_velocity, vVelocity);
				if( aliveflags&FL_ONGROUND && aliveflags&FL_INWATER )
					vVelocity[2]-=vVelocity[2];
			}
			else
			{
				pev(spectatedplayer, pev_velocity, vVelocity);
				if( specflags&FL_ONGROUND && specflags&FL_INWATER )
					vVelocity[2]-=vVelocity[2];
			}
			show_hudmessage(taskid, "%d units/second^n%d velocity", floatround(vector_length(vVelocity), floatround_floor), floatround(gSpeed, floatround_floor));
		}
	}
}

public cmdVersion(id)
{
	ColorChat(id, GREY, "^x04[XJ] Plugin: ^x01%s^x04 by: ^x03%s", gPLUGIN, gAUTHOR);
	if( get_pcvar_num(kz_ljs_enabled) )
		ColorChat(id, BLUE, "^x04[XJ] Version: ^x01%s^x04, Status:^x03 enabled", gVERSION);
	else
		ColorChat(id, RED, "^x04[XJ] Version: ^x01%s^x04, Status:^x03 disabled", gVERSION);
	
	return ( (get_pcvar_num(kz_ljs_viscmds))?PLUGIN_CONTINUE:PLUGIN_HANDLED );
}

public fwdStartFrame()
{
	if( get_pcvar_num(kz_legal_settings) && get_pcvar_num(kz_ljs_enabled) )
	{
		if( get_pcvar_num(edgefriction) != 2 )
			set_pcvar_num(edgefriction, 2);
		
		if( get_pcvar_num(mp_footsteps) != 1 )
			set_pcvar_num(mp_footsteps, 1);
		
		if( get_pcvar_num(sv_cheats) != 0 )
			set_pcvar_num(sv_cheats, 0);
		
		if( get_pcvar_num(sv_gravity) != 800 )
			set_pcvar_num(sv_gravity, 800);
		
		if( get_pcvar_num(sv_airaccelerate) != 10 )
			set_pcvar_num(sv_airaccelerate, 10);
		
		if( get_pcvar_num(sv_maxspeed) != 320 )
			set_pcvar_num(sv_maxspeed, 320);
		
		if( get_pcvar_num(sv_stepsize) != 18 )
			set_pcvar_num(sv_stepsize, 18);
		
		if( get_pcvar_num(sv_maxvelocity) != 2000 )
			set_pcvar_num(sv_maxvelocity, 2000);
	}
	
	if( FindPlayer() > -1)
	{
		if( get_pcvar_num(kz_ljs_enabled) )
		{
			set_hudmessage(255, 255, 255, -1.0, 0.65, 0, 0.0, 0.1, 0.0, 0.0, 2);
			if( !pluginstatus )
			{
				ColorChat(0, BLUE, "^x04[XJ] ^x01%s ^x04plugin^x03 enabled ^x04!", gPLUGIN);
				pluginstatus = INFO_ONE;
			}
		}
		else
		{
			if( pluginstatus )
			{
				ColorChat(0, RED, "^x04[XJ] ^x01%s ^x04plugin^x03 disabled ^x04!", gPLUGIN);
				pluginstatus = INFO_ZERO;
			}
		}
	}
	static id, fastserver, speedtype, spectatedplayer, alive, aliveflags, specflags;
	fastserver = get_pcvar_num(kz_ljs_fastserver);
	speedtype = get_pcvar_num(kz_ljs_speedtype);
	for( id = INFO_ONE; id < 33; id++ )
	{
		if( pev_valid(id) && pluginstatus )
		{
			alive = is_user_alive(id);
			aliveflags = pev(id, pev_flags);
			spectatedplayer = get_spectated_player(id);
			if( spectatedplayer )
				specflags = pev(spectatedplayer, pev_flags);
			else
				specflags = INFO_ZERO;
			if( alive || spectatedplayer )
			{
				if( alive )
				{
					pev(id, pev_velocity, vVelocity);
					if( aliveflags&FL_ONGROUND && aliveflags&FL_INWATER )
						vVelocity[2]-=vVelocity[2];
				}
				else
				{
					pev(spectatedplayer, pev_velocity, vVelocity);
					if( specflags&FL_ONGROUND && specflags&FL_INWATER )
						vVelocity[2]-=vVelocity[2];
				}
				
				if( fastserver == 2 && gHasSpeed[id] )
				{
					if( task_exists(id+334490, 0) )
						remove_task(id+334490, 0);
					
					if( speedtype == 1 )
						show_hudmessage(id, "%d units/second", floatround(vector_length(vVelocity), floatround_floor));
					else if( speedtype == 2 )
					{
						if( vVelocity[2] != 0 )
							vVelocity[2]-=vVelocity[2];
						gSpeed = vector_length(vVelocity);
						show_hudmessage(id, "%d velocity", floatround(gSpeed, floatround_floor));
					}
					else
					{
						if( vVelocity[2] != 0 )
							vVelocity[2]-=vVelocity[2];
						gSpeed = vector_length(vVelocity);
						if( alive )
						{
							pev(id, pev_velocity, vVelocity);
							if( aliveflags&FL_ONGROUND && aliveflags&FL_INWATER )
								vVelocity[2]-=vVelocity[2];
						}
						else
						{
							pev(spectatedplayer, pev_velocity, vVelocity);
							if( specflags&FL_ONGROUND && specflags&FL_INWATER )
								vVelocity[2]-=vVelocity[2];
						}
						show_hudmessage(id, "%d units/second^n%d velocity", floatround(vector_length(vVelocity), floatround_floor), floatround(gSpeed, floatround_floor));
					}			
				}
				else if( gHasSpeed[id]
				&& fastserver != 2
				&& !task_exists(id+334490, 0) )
				{
					if( fastserver )
						set_task(0.1, "tskSpeed", id+334490, "", 0, "b", 0);
					else
						set_task(0.5, "tskSpeed", id+334490, "", 0, "b", 0);
				}
			}
		}
	}
	
	return FMRES_IGNORED;
}

public fwdPlayerPreThink(id)
{
	if( is_user_alive(id) && get_pcvar_num(kz_ljs_enabled) )
	{
		static flags, buttons, oldbuttons;
		flags = pev(id, pev_flags);
		buttons = pev(id, pev_button);
		oldbuttons = pev(id, pev_oldbuttons);
		
		static Float:fGravity;
		pev(id, pev_gravity, fGravity);
		
		pev(id, pev_angles, angle);
		old_angle1[id] = angle[1];
		
		if( gInAir[id] == true && !(flags&FL_ONGROUND) )
		{
			static i;
			for( i = INFO_ZERO; i < 2; i++ )
			{
				if( (vFramePos[id][i][0] == 0
				&& vFramePos[id][i][1] == 0
				&& vFramePos[id][i][2] == 0
				&& vFrameSpeed[id][i][0] == 0
				&& vFrameSpeed[id][i][1] == 0
				&& vFrameSpeed[id][i][2] == 0)
				|| (i == 1) )
				{
					pev(id, pev_origin, vOrigin);
					vFramePos[id][i][0] = vOrigin[0];
					vFramePos[id][i][1] = vOrigin[1];
					vFramePos[id][i][2] = vOrigin[2];
					
					pev(id, pev_velocity, vVelocity);
					vFrameSpeed[id][i][0] = vVelocity[0];
					vFrameSpeed[id][i][1] = vVelocity[1];
					vFrameSpeed[id][i][2] = vVelocity[2];
					
					i=2;
				}
			}
		}
		
		pev(id, pev_velocity, vVelocity);
		if( flags&FL_ONGROUND && flags&FL_INWATER )
			vVelocity[2] = 0.0;
		fSpeed = vector_length(vVelocity);
		
		pev(id, pev_origin, vOrigin);
		fDistance = get_distance_f(vOldOrigin[id], vOrigin);
		pev(id, pev_origin, vOldOrigin[id]);
		pev(id, pev_velocity, vVelocity);
		if( vVelocity[2] != 0 )
			vVelocity[2]-=vVelocity[2];
		
		if( (cjumped[id] == false
		&& vector_length(vVelocity) > 350.0)
		|| (cjumped[id] == true
		&& vector_length(vVelocity) > 375.0)
		|| pev(id, pev_maxspeed) != 250.0
		|| pev(id, pev_movetype) != MOVETYPE_WALK
		|| fGravity != 1.0
		|| get_pcvar_num(edgefriction) != 2
		|| get_pcvar_num(mp_footsteps) != 1
		|| get_pcvar_num(sv_cheats) != 0
		|| get_pcvar_num(sv_gravity) != 800
		|| get_pcvar_num(sv_airaccelerate) != 10
		|| get_pcvar_num(sv_maxspeed) != 320
		|| get_pcvar_num(sv_stepsize) != 18
		|| get_pcvar_num(sv_maxvelocity) != 2000
		|| pev(id, pev_waterlevel) >= 2
		|| fDistance > 20 )
		{
			gocheck(id);
			return FMRES_IGNORED;
		}
		
		if( !(flags&FL_ONGROUND) )
			lasttime[id] = get_gametime();
		
		if( gInAir[id] )
		{
			pev(id, pev_velocity, vVelocity);
			if( vVelocity[2] != 0 )
				vVelocity[2]-=vVelocity[2];
			gSpeed = vector_length(vVelocity);
			if( gSpeed > fMaxAirSpeed[id] )
			{
				fMaxAirSpeed[id] = gSpeed;
			}
		}
		
		if( buttons&IN_JUMP
		&& !(oldbuttons&IN_JUMP)
		&& flags&FL_ONGROUND
		&& gInAir[id] == false )
		{
			set_task(0.8,"gocheck", id);
			
			jumptime[id] = get_gametime();
			gInAir[id] = true;
			fMaxGroundSpeed[id] = fSpeed;
			OldSpeed[id] = fSpeed;
			fMaxAirSpeed[id] = fSpeed;
			
			pev(id, pev_origin, vOrigin);
			
			vJumpedAt[id][0] = vOrigin[0];
			vJumpedAt[id][1] = vOrigin[1];
			vJumpedAt[id][2] = vOrigin[2];
			
			if( doubleducked[id] && vOrigin[2] == vDuckedAt[id][2] )
				cjumped[id] = true;
			else
				cjumped[id] = false;
			
			doubleducked[id] = false;
			
			strafes[id] = INFO_ZERO;
			
			goodsync[id] = INFO_ZERO;
			badsync[id] = INFO_ZERO;
			
			turning_right[id] = false;
			turning_left[id] = false;
			strafing_aw[id] = false;
			strafing_sd[id] = false;
			if( cjumped[id] == false )
			{
				beam_jump_off_time[id] = jumptime[id];
				static i;
				for( i = INFO_ZERO; i < 127; i++ )
				{
					vBeamPos[id][i][0] = 0.0;
					vBeamPos[id][i][1] = 0.0;
					vBeamPos[id][i][2] = 0.0;
					vBeamTime[id][i] = 0.0;
				}
			}
			static i;
			for( i = INFO_ZERO; i < 2; i++ )
			{
				vFramePos[id][i][0] = 0.0;
				vFramePos[id][i][1] = 0.0;
				vFramePos[id][i][2] = 0.0;
				
				vFrameSpeed[id][i][0] = 0.0;
				vFrameSpeed[id][i][1] = 0.0;
				vFrameSpeed[id][i][2] = 0.0;
			}
		}
		else if( flags&FL_ONGROUND
		&& gInAir[id] == true )
		{
			set_task(0.5,"gocheck", id);
			gInAir[id] = false;
			
			pev(id, pev_origin, vOrigin);
			
			fDistance1 = get_distance_f(vJumpedAt[id], vOrigin)+32.0625;
			
			if( !(vFramePos[id][0][2] > vOrigin[2]) )
				return FMRES_IGNORED;
			
			rLandPos[2] = vFrameSpeed[id][0][2] * vFrameSpeed[id][0][2] + (2 * get_pcvar_float(sv_gravity) * (vFramePos[id][0][2] - vOrigin[2]));
			rDistance[0] = (floatsqroot(rLandPos[2]) * -1) - vFrameSpeed[id][1][2];
			rDistance[1] = get_pcvar_float(sv_gravity)*-1;
			frame2time = floatdiv(rDistance[0], rDistance[1]);
			
			if( vFrameSpeed[id][1][0] < 0 )
				vFrameSpeed[id][1][0] = vFrameSpeed[id][1][0]*-1;
			rDistance[0] = frame2time*vFrameSpeed[id][1][0];
			
			if( vFrameSpeed[id][1][1] < 0 )
				vFrameSpeed[id][1][1] = vFrameSpeed[id][1][1]*-1;
			rDistance[1] = frame2time*vFrameSpeed[id][1][1];
			
			if( vFramePos[id][1][0] < vOrigin[0] )
				rLandPos[0] = vFramePos[id][1][0] + rDistance[0];
			else
				rLandPos[0] = vFramePos[id][1][0] - rDistance[0];
			
			if( vFramePos[id][1][1] < vOrigin[1] )
				rLandPos[1] = vFramePos[id][1][1] + rDistance[1];
			else
				rLandPos[1] = vFramePos[id][1][1] - rDistance[1];
			
			if( is_in_duck(id) )
				vOrigin[2]+=18.0;
			rLandPos[2] = vOrigin[2];
			
			frame2time += (lasttime[id]-jumptime[id]);
			if( vOrigin[2] == vJumpedAt[id][2] )
			{
				if( is_in_duck(id) && !(frame2time > 0.71 && frame2time < 0.77) )
					vOrigin[2] = vOrigin[2]*-1;
				else if( !(is_in_duck(id)) && !(frame2time > 0.65 && frame2time < 0.70) )
					vOrigin[2] = vOrigin[2]*-1;
			}
			
			fDistance2 = get_distance_f(vJumpedAt[id], rLandPos)+32.0625;
			if( fDistance1 > fDistance2 )
			{
				fDistance = fDistance2;
				vOrigin[0] = rLandPos[0];
				vOrigin[1] = rLandPos[1];
			}
			else
				fDistance = fDistance1;
			
			vJumpedAt2[2] = vJumpedAt[id][2]-34.0;
			vTraceEnd[2] = vOrigin[2]-34.0;
			
			vJumpedAt2[0] = vJumpedAt[id][0];
			vTraceEnd[0] = vOrigin[0];
			vJumpedAt2[1] = vJumpedAt[id][1]-vJumpedAt[id][1];
			vTraceEnd[1] = vOrigin[1]-vOrigin[1];
			xDistance = get_distance_f(vJumpedAt2, vTraceEnd);
			
			vJumpedAt2[0] = vJumpedAt[id][0]-vJumpedAt[id][0];
			vTraceEnd[0] = vOrigin[0]-vOrigin[0];
			vJumpedAt2[1] = vJumpedAt[id][1];
			vTraceEnd[1] = vOrigin[1];
			yDistance = get_distance_f(vJumpedAt2, vTraceEnd);
			
			if( vJumpedAt[id][0] > vOrigin[0] )
			{
				vJumpedAt2[0] = vJumpedAt[id][0]+(xDistance*16.03125/fDistance);
				vTraceEnd[0] = vOrigin[0]-(xDistance*16.03125/fDistance);
			}
			else if( vJumpedAt[id][0] < vOrigin[0] )
			{
				vJumpedAt2[0] = vJumpedAt[id][0]-(xDistance*16.03125/fDistance);
				vTraceEnd[0] = vOrigin[0]+(xDistance*16.03125/fDistance);
			}
			else
			{
				vJumpedAt2[0] = vJumpedAt[id][0];
				vTraceEnd[0] = vOrigin[0];
			}
			
			if( vJumpedAt[id][1] > vOrigin[1] )
			{
				vJumpedAt2[1] = vJumpedAt[id][1]+(yDistance*16.03125/fDistance);
				vTraceEnd[1] = vOrigin[1]-(yDistance*16.03125/fDistance);
			}
			else if( vJumpedAt[id][1] < vOrigin[1] )
			{
				vJumpedAt2[1] = vJumpedAt[id][1]-(yDistance*16.03125/fDistance);
				vTraceEnd[1] = vOrigin[1]+(yDistance*16.03125/fDistance);
			}
			else
			{
				vJumpedAt2[1] = vJumpedAt[id][1];
				vTraceEnd[1] = vOrigin[1];
			}
			
			static type;
			
			if( vJumpedAt[id][2] == vOrigin[2]
			&& fDistance > get_pcvar_float(kz_min_lj)
			&& fMaxGroundSpeed[id] < 279
			&& cjumped[id] == false
			&& !(fDistance > get_pcvar_float(kz_max_lj)) )
			{
				type = INFO_ZERO;
				static Distance, MaxAirSpeed, MaxGroundSpeed, sync;
				if( goodsync[id] > 0 )
					sync = (goodsync[id]*100/(goodsync[id]+badsync[id]));
				else
					sync = INFO_ZERO;
				Distance = floatround((fDistance*1000000), floatround_floor);
				MaxAirSpeed = floatround((fMaxAirSpeed[id]*1000000), floatround_floor);
				MaxGroundSpeed = floatround((fMaxGroundSpeed[id]*1000000), floatround_floor);
				if( !(possible_lj_script[id][0] || possible_lj_script[id][1]) )
					check_maintop(id, Distance, MaxAirSpeed, MaxGroundSpeed, strafes[id], sync, type);
				
				static ljStatsRed, ljStatsGreen, ljStatsBlue, i, ljs_beam, sound;
				ljStatsRed = get_pcvar_num(kz_ljstats_red);
				ljStatsGreen = get_pcvar_num(kz_ljstats_green);
				ljStatsBlue = get_pcvar_num(kz_ljstats_blue);
				ljs_beam = get_pcvar_num(kz_ljs_beam);
				sound = get_pcvar_num(kz_lj_sounds);
				if( gHasLjStats[id] )
				{
					if( ljs_beam == 1)
					{
						message_begin(MSG_ONE_UNRELIABLE, SVC_TEMPENTITY, {0, 0, 0}, id);
						write_byte (0);
						write_coord(floatround(vJumpedAt2[0]));
						write_coord(floatround(vJumpedAt2[1]));
						write_coord(floatround(vJumpedAt2[2]));
						write_coord(floatround(vTraceEnd[0]));
						write_coord(floatround(vTraceEnd[1]));
						write_coord(floatround(vTraceEnd[2]));
						write_short(gBeam);
						write_byte(1);
						write_byte(5);
						write_byte(30);
						write_byte(20);
						write_byte(0);
						write_byte(random_num(32, 255));
						write_byte(random_num(32, 255));
						write_byte(random_num(32, 255));
						write_byte(200);
						write_byte(200);
						message_end();
					}
					else if( ljs_beam == 2)
					{
						set_task(0.4, "gocheck", id);
						set_task(0.8, "gocheck", id);
						set_task(1.2, "gocheck", id);
						for( i = INFO_ZERO; i < 127; i++ )
						{
							if( i == 0 )
							{
								message_begin(MSG_ONE_UNRELIABLE, SVC_TEMPENTITY, {0, 0, 0}, id);
								write_byte (0);
								write_coord(floatround(vJumpedAt2[0]));
								write_coord(floatround(vJumpedAt2[1]));
								write_coord(floatround(vTraceEnd[2]));
								write_coord(floatround(vBeamPos[id][0][0]));
								write_coord(floatround(vBeamPos[id][0][1]));
								write_coord(floatround(vTraceEnd[2]));
								write_short(gBeam);
								write_byte(1);
								write_byte(5);
								write_byte(15);
								write_byte(20);
								write_byte(0);
								write_byte(255);
								write_byte(255);
								write_byte(0);
								write_byte(200);
								write_byte(200);
								message_end();
								
								message_begin(MSG_ONE_UNRELIABLE, SVC_TEMPENTITY, {0, 0, 0}, id);
								write_byte (0);
								write_coord(floatround(vBeamPos[id][0][0]));
								write_coord(floatround(vBeamPos[id][0][1]));
								write_coord(floatround(vTraceEnd[2]));
								write_coord(floatround(vBeamPos[id][1][0]));
								write_coord(floatround(vBeamPos[id][1][1]));
								write_coord(floatround(vTraceEnd[2]));
								write_short(gBeam);
								write_byte(1);
								write_byte(5);
								write_byte(15);
								write_byte(20);
								write_byte(0);
								write_byte(255);
								write_byte(255);
								write_byte(0);
								write_byte(200);
								write_byte(200);
								message_end();
							}
							else if( i == 126 || (vBeamPos[id][i+1][0] == 0
							&& vBeamPos[id][i+1][1] == 0
							&& vBeamPos[id][i+1][2] == 0) )
							{
								message_begin(MSG_ONE_UNRELIABLE, SVC_TEMPENTITY, {0, 0, 0}, id);
								write_byte (0);
								write_coord(floatround(vBeamPos[id][i][0]));
								write_coord(floatround(vBeamPos[id][i][1]));
								write_coord(floatround(vTraceEnd[2]));
								write_coord(floatround(vOrigin[0]));
								write_coord(floatround(vOrigin[1]));
								write_coord(floatround(vTraceEnd[2]));
								write_short(gBeam);
								write_byte(1);
								write_byte(5);
								write_byte(floatround(vBeamTime[id][i]));
								write_byte(20);
								write_byte(0);
								if( vBeamPosStatus[id][i] == 1 )
								{
									write_byte(255);
									write_byte(0);
									write_byte(0);
								}
								else
								{
									write_byte(255);
									write_byte(255);
									write_byte(0);
								}
								write_byte(200);
								write_byte(200);
								message_end();
								
								message_begin(MSG_ONE_UNRELIABLE, SVC_TEMPENTITY, {0, 0, 0}, id);
								write_byte (0);
								write_coord(floatround(vOrigin[0]));
								write_coord(floatround(vOrigin[1]));
								write_coord(floatround(vTraceEnd[2]));
								write_coord(floatround(vTraceEnd[0]));
								write_coord(floatround(vTraceEnd[1]));
								write_coord(floatround(vTraceEnd[2]));
								write_short(gBeam);
								write_byte(1);
								write_byte(5);
								write_byte(floatround(vBeamTime[id][i]));
								write_byte(20);
								write_byte(0);
								if( vBeamPosStatus[id][i] == 1 )
								{
									write_byte(255);
									write_byte(0);
									write_byte(0);
								}
								else
								{
									write_byte(255);
									write_byte(255);
									write_byte(0);
								}
								write_byte(200);
								write_byte(200);
								message_end();
								break;
							}
							else
							{
								message_begin(MSG_ONE_UNRELIABLE, SVC_TEMPENTITY, {0, 0, 0}, id);
								write_byte (0);
								write_coord(floatround(vBeamPos[id][i][0]));
								write_coord(floatround(vBeamPos[id][i][1]));
								write_coord(floatround(vTraceEnd[2]));
								write_coord(floatround(vBeamPos[id][i+1][0]));
								write_coord(floatround(vBeamPos[id][i+1][1]));
								write_coord(floatround(vTraceEnd[2]));
								write_short(gBeam);
								write_byte(1);
								write_byte(5);
								write_byte(floatround(vBeamTime[id][i]));
								write_byte(20);
								write_byte(0);
								if( vBeamPosStatus[id][i] == 1 )
								{
									write_byte(255);
									write_byte(0);
									write_byte(0);
								}
								else
								{
									write_byte(255);
									write_byte(255);
									write_byte(0);
								}
								write_byte(200);
								write_byte(200);
								message_end();
							}
						}
					}
				}
				set_hudmessage(ljStatsRed, ljStatsGreen, ljStatsBlue, -1.0, 0.70, 0, 0.0, ((vBeamTime[id][i]*0.1)-0.1), 0.1, 0.1, 3);
				static strdist[128];
				num_to_word(floatround(fDistance, floatround_floor), strdist, 127);
				for( i = INFO_ONE; i < 33; i++ )
				{
					if( (i == id || is_user_spectating_player(i, id)) && gHasLjStats[i] )
					{
						show_hudmessage(i, "Distance: %f^nMaxSpeed: %f^nPreStrafe: %f^nStrafes: %d^nSync: %d", fDistance, fMaxAirSpeed[id], fMaxGroundSpeed[id], strafes[id], sync );
						
						client_print(i, print_console, "Distance: %f MaxSpeed: %f PreStrafe: %f Strafes: %d Sync: %d", fDistance, fMaxAirSpeed[id], fMaxGroundSpeed[id], strafes[id], sync );
						
						if( possible_lj_script[id][0] || possible_lj_script[id][1] )
						{
							if( possible_lj_script[id][0] && possible_lj_script[id][1] )
								client_print(i, print_center, "No ljtop access (possible lj script)");
							else
								client_print(i, print_center, "No ljtop access (possible %s script)", (possible_lj_script[id][0])?"prestrafe":"strafe");
						}
						
						if( sound == 2 && gHasColorChat[i] )
							client_cmd(i, "speak ^"vox/%s uniform(e30) it south(e15)^"", strdist);
						
						if( i != id && (ljs_beam == 1 || ljs_beam == 2) )
						{
							message_begin(MSG_ONE_UNRELIABLE, SVC_TEMPENTITY, {0, 0, 0}, i);
							write_byte (0);
							write_coord(floatround(vJumpedAt2[0]));
							write_coord(floatround(vJumpedAt2[1]));
							write_coord(floatround(vJumpedAt2[2]));
							write_coord(floatround(vTraceEnd[0]));
							write_coord(floatround(vTraceEnd[1]));
							write_coord(floatround(vTraceEnd[2]));
							write_short(gBeam);
							write_byte(1);
							write_byte(5);
							write_byte(30);
							write_byte(20);
							write_byte(0);
							write_byte(random_num(32, 255));
							write_byte(random_num(32, 255));
							write_byte(random_num(32, 255));
							write_byte(200);
							write_byte(200);
							message_end();
						}
					}
				}
				
				static Float:max_lj, Float:leet_lj, Float:pro_lj, Float:good_lj, ljtop;
				max_lj = get_pcvar_float(kz_max_lj);
				leet_lj = get_pcvar_float(kz_leet_lj);
				pro_lj = get_pcvar_float(kz_pro_lj);
				good_lj = get_pcvar_float(kz_good_lj);
				ljtop = get_pcvar_num(kz_ljs_tops);
				if( fDistance < max_lj
				&& !(fDistance < leet_lj)
				&& !(0 > leet_lj)
				&& (ljtop == 1
				|| ljtop == 3) )
				{
					static color, name[33];
					color = get_pcvar_num(kz_leet_lj_clr);
					get_user_name(id, name, 31);
					for( i = INFO_ONE; i < 33; i++ )
					{
						if( possible_lj_script[id][0] || possible_lj_script[id][1] )
							break;
						
						if( i == id || is_user_spectating_player(i, id) || (pev_valid(i) && is_user_connected(i) && gHasColorChat[i]) )
						{
							if( color < 6 && color > 0 )
							{
								switch(color)
								{
									case 1: ColorChat(i, RED, "[XJ] %s jumped %.3f units!", name, fDistance);
									case 2: ColorChat(i, GREEN, "[XJ] %s jumped %.3f units!", name, fDistance);
									case 3: ColorChat(i, BLUE, "[XJ] %s jumped %.3f units!", name, fDistance);
									case 4: ColorChat(i, GREY, "[XJ] %s jumped %.3f units!", name, fDistance);
									case 5: ColorChat(i, TEAM_COLOR, "[XJ] %s jumped %.3f units!", name, fDistance);
								}
							}
							else
								client_print(i, print_chat, "[XJ] %s jumped %.3f units!", name, fDistance);
							
							if( sound == 1 )
							{
								if( i == id || is_user_spectating_player(i, id) )
									client_cmd(i, "speak misc/mod_wickedsick");
								else
									client_cmd(i, "speak misc/mod_godlike");
							}
						}
					}
				}
				
				else if( fDistance < max_lj
				&& !(fDistance < pro_lj)
				&& !(0 > pro_lj)
				&& (ljtop == 1
				|| ljtop == 3) )
				{
					static color, name[33];
					color = get_pcvar_num(kz_pro_lj_clr);
					get_user_name(id, name, 31);
					for( i = INFO_ONE; i < 33; i++ )
					{
						if( possible_lj_script[id][0] || possible_lj_script[id][1] )
							break;
						
						if( i == id || is_user_spectating_player(i, id) || (pev_valid(i) && is_user_connected(i) && gHasColorChat[i]) )
						{
							if( color < 6 && color > 0 )
							{
								switch(color)
								{
									case 1: ColorChat(i, RED, "[XJ] %s jumped %.3f units!", name, fDistance);
									case 2: ColorChat(i, GREEN, "[XJ] %s jumped %.3f units!", name, fDistance);
									case 3: ColorChat(i, BLUE, "[XJ] %s jumped %.3f units!", name, fDistance);
									case 4: ColorChat(i, GREY, "[XJ] %s jumped %.3f units!", name, fDistance);
									case 5: ColorChat(i, TEAM_COLOR, "[XJ] %s jumped %.3f units!", name, fDistance);
								}
							}
							else
								client_print(i, print_chat, "[XJ] %s jumped %.3f units!", name, fDistance);
						}
						if( (i == id || is_user_spectating_player(i, id)) && sound == 1 )
							client_cmd(i, "speak misc/perfect");
					}
				}
				
				else if( fDistance < max_lj
				&& !(fDistance < good_lj)
				&& !(0 > good_lj)
				&& (ljtop == 1
				|| ljtop == 3) )
				{
					static color, name[33];
					color = get_pcvar_num(kz_good_lj_clr);
					get_user_name(id, name, 31);
					for( i = INFO_ONE; i < 33; i++ )
					{
						if( possible_lj_script[id][0] || possible_lj_script[id][1] )
							break;
						
						if( i == id || is_user_spectating_player(i, id) || (pev_valid(i) && is_user_connected(i) && gHasColorChat[i]) )
						{
							if( color < 6 && color > 0 )
							{
								switch(color)
								{
									case 1: ColorChat(i, RED, "[XJ] %s jumped %.3f units!", name, fDistance);
									case 2: ColorChat(i, GREEN, "[XJ] %s jumped %.3f units!", name, fDistance);
									case 3: ColorChat(i, BLUE, "[XJ] %s jumped %.3f units!", name, fDistance);
									case 4: ColorChat(i, GREY, "[XJ] %s jumped %.3f units!", name, fDistance);
									case 5: ColorChat(i, TEAM_COLOR, "[XJ] %s jumped %.3f units!", name, fDistance);
								}
							}
							else
								client_print(i, print_chat, "[XJ] %s jumped %.3f units!", name, fDistance);
						}
						if( (i == id || is_user_spectating_player(i, id)) && sound == 1 )
							client_cmd(i, "speak misc/impressive");
					}
				}
			}
			else if( vJumpedAt[id][2] == vOrigin[2]
			&& fDistance > get_pcvar_float(kz_min_lj)
			&& fMaxGroundSpeed[id] < 300
			&& cjumped[id] == true
			&& !(fDistance > (get_pcvar_float(kz_max_lj) + get_pcvar_float(kz_cj_dif))) )
			{
				type = INFO_ONE;
				static Distance, MaxAirSpeed, MaxGroundSpeed, sync;
				if( goodsync[id] > 0 )
					sync = (goodsync[id]*100/(goodsync[id]+badsync[id]));
				else
					sync = INFO_ZERO;
				Distance = floatround((fDistance*1000000), floatround_floor);
				MaxAirSpeed = floatround((fMaxAirSpeed[id]*1000000), floatround_floor);
				MaxGroundSpeed = floatround((fMaxGroundSpeed[id]*1000000), floatround_floor);
				if( !(possible_lj_script[id][0] || possible_lj_script[id][1]) )
					check_maintop(id, Distance, MaxAirSpeed, MaxGroundSpeed, strafes[id], sync, type);
				
				static ljStatsRed, ljStatsGreen, ljStatsBlue, i, ljs_beam, sound;
				ljStatsRed = get_pcvar_num(kz_ljstats_red);
				ljStatsGreen = get_pcvar_num(kz_ljstats_green);
				ljStatsBlue = get_pcvar_num(kz_ljstats_blue);
				ljs_beam = get_pcvar_num(kz_ljs_beam);
				sound = get_pcvar_num(kz_lj_sounds);
				if( gHasLjStats[id] )
				{
					if( ljs_beam == 1)
					{
						message_begin(MSG_ONE_UNRELIABLE, SVC_TEMPENTITY, {0, 0, 0}, id);
						write_byte (0);
						write_coord(floatround(vJumpedAt2[0]));
						write_coord(floatround(vJumpedAt2[1]));
						write_coord(floatround(vJumpedAt2[2]));
						write_coord(floatround(vTraceEnd[0]));
						write_coord(floatround(vTraceEnd[1]));
						write_coord(floatround(vTraceEnd[2]));
						write_short(gBeam);
						write_byte(1);
						write_byte(5);
						write_byte(30);
						write_byte(20);
						write_byte(0);
						write_byte(random_num(32, 255));
						write_byte(random_num(32, 255));
						write_byte(random_num(32, 255));
						write_byte(200);
						write_byte(200);
						message_end();
					}
					else if( ljs_beam == 2)
					{
						set_task(0.4, "gocheck", id);
						set_task(0.8, "gocheck", id);
						set_task(1.2, "gocheck", id);
						for( i = INFO_ZERO; i < 127; i++ )
						{
							if( i == 0 )
							{
								message_begin(MSG_ONE_UNRELIABLE, SVC_TEMPENTITY, {0, 0, 0}, id);
								write_byte (0);
								write_coord(floatround(vDuckedAt[id][0]));
								write_coord(floatround(vDuckedAt[id][1]));
								write_coord(floatround(vTraceEnd[2]));
								write_coord(floatround(vBeamPos[id][0][0]));
								write_coord(floatround(vBeamPos[id][0][1]));
								write_coord(floatround(vTraceEnd[2]));
								write_short(gBeam);
								write_byte(1);
								write_byte(5);
								write_byte(15);
								write_byte(20);
								write_byte(0);
								write_byte(0);
								write_byte(255);
								write_byte(0);
								write_byte(200);
								write_byte(200);
								message_end();
								
								message_begin(MSG_ONE_UNRELIABLE, SVC_TEMPENTITY, {0, 0, 0}, id);
								write_byte (0);
								write_coord(floatround(vBeamPos[id][0][0]));
								write_coord(floatround(vBeamPos[id][0][1]));
								write_coord(floatround(vTraceEnd[2]));
								write_coord(floatround(vBeamPos[id][1][0]));
								write_coord(floatround(vBeamPos[id][1][1]));
								write_coord(floatround(vTraceEnd[2]));
								write_short(gBeam);
								write_byte(1);
								write_byte(5);
								write_byte(15);
								write_byte(20);
								write_byte(0);
								write_byte(0);
								write_byte(255);
								write_byte(0);
								write_byte(200);
								write_byte(200);
								message_end();
							}
							else if( i == 126 || (vBeamPos[id][i+1][0] == 0
							&& vBeamPos[id][i+1][1] == 0
							&& vBeamPos[id][i+1][2] == 0) )
							{
								message_begin(MSG_ONE_UNRELIABLE, SVC_TEMPENTITY, {0, 0, 0}, id);
								write_byte (0);
								write_coord(floatround(vBeamPos[id][i][0]));
								write_coord(floatround(vBeamPos[id][i][1]));
								write_coord(floatround(vTraceEnd[2]));
								write_coord(floatround(vOrigin[0]));
								write_coord(floatround(vOrigin[1]));
								write_coord(floatround(vTraceEnd[2]));
								write_short(gBeam);
								write_byte(1);
								write_byte(5);
								write_byte(floatround(vBeamTime[id][i]));
								write_byte(20);
								write_byte(0);
								if( vBeamPosStatus[id][i] == 1 )
								{
									write_byte(255);
									write_byte(0);
									write_byte(0);
								}
								else
								{
									write_byte(255);
									write_byte(255);
									write_byte(0);
								}
								write_byte(200);
								write_byte(200);
								message_end();
								
								message_begin(MSG_ONE_UNRELIABLE, SVC_TEMPENTITY, {0, 0, 0}, id);
								write_byte (0);
								write_coord(floatround(vOrigin[0]));
								write_coord(floatround(vOrigin[1]));
								write_coord(floatround(vTraceEnd[2]));
								write_coord(floatround(vTraceEnd[0]));
								write_coord(floatround(vTraceEnd[1]));
								write_coord(floatround(vTraceEnd[2]));
								write_short(gBeam);
								write_byte(1);
								write_byte(5);
								write_byte(floatround(vBeamTime[id][i]));
								write_byte(20);
								write_byte(0);
								if( vBeamPosStatus[id][i] == 1 )
								{
									write_byte(255);
									write_byte(0);
									write_byte(0);
								}
								else
								{
									write_byte(255);
									write_byte(255);
									write_byte(0);
								}
								write_byte(200);
								write_byte(200);
								message_end();
								break;
							}
							else
							{
								message_begin(MSG_ONE_UNRELIABLE, SVC_TEMPENTITY, {0, 0, 0}, id);
								write_byte (0);
								write_coord(floatround(vBeamPos[id][i][0]));
								write_coord(floatround(vBeamPos[id][i][1]));
								write_coord(floatround(vTraceEnd[2]));
								write_coord(floatround(vBeamPos[id][i+1][0]));
								write_coord(floatround(vBeamPos[id][i+1][1]));
								write_coord(floatround(vTraceEnd[2]));
								write_short(gBeam);
								write_byte(1);
								write_byte(5);
								write_byte(floatround(vBeamTime[id][i]));
								write_byte(20);
								write_byte(0);
								if( vBeamPosStatus[id][i] == 1 )
								{
									write_byte(255);
									write_byte(0);
									write_byte(0);
								}
								else if( vBeamPosStatus[id][i] == -1 )
								{
									write_byte(0);
									write_byte(255);
									write_byte(0);
								}
								else
								{
									write_byte(255);
									write_byte(255);
									write_byte(0);
								}
								write_byte(200);
								write_byte(200);
								message_end();
							}
						}
					}
				}
				set_hudmessage(ljStatsRed, ljStatsGreen, ljStatsBlue, -1.0, 0.70, 0, 0.0, ((vBeamTime[id][i]*0.1)-0.1), 0.1, 0.1, 3);
				static strdist[128];
				num_to_word(floatround(fDistance, floatround_floor), strdist, 127);
				for( i = INFO_ONE; i < 33; i++ )
				{
					if( (i == id || is_user_spectating_player(i, id)) && gHasLjStats[i] )
					{
						show_hudmessage(i, "Distance: %f^nMaxSpeed: %f^nPreStrafe: %f^nStrafes: %d^nSync: %d", fDistance, fMaxAirSpeed[id], fMaxGroundSpeed[id], strafes[id], sync );
						
						client_print(i, print_console, "Distance: %f MaxSpeed: %f PreStrafe: %f Strafes: %d Sync: %d", fDistance, fMaxAirSpeed[id], fMaxGroundSpeed[id], strafes[id], sync );
						
						if( possible_lj_script[id][0] || possible_lj_script[id][1] )
						{
							if( possible_lj_script[id][0] && possible_lj_script[id][1] )
								client_print(i, print_center, "No ljtop access (possible cj script)");
							else
								client_print(i, print_center, "No ljtop access (possible %s script)", (possible_lj_script[id][0])?"prestrafe":"strafe");
						}
						
						if( sound == 2 && gHasColorChat[i] )
							client_cmd(i, "speak ^"vox/%s uniform(e30) it south(e15)^"", strdist);
						
						if( i != id && (ljs_beam == 1 || ljs_beam == 2) )
						{
							message_begin(MSG_ONE_UNRELIABLE, SVC_TEMPENTITY, {0, 0, 0}, i);
							write_byte (0);
							write_coord(floatround(vJumpedAt2[0]));
							write_coord(floatround(vJumpedAt2[1]));
							write_coord(floatround(vJumpedAt2[2]));
							write_coord(floatround(vTraceEnd[0]));
							write_coord(floatround(vTraceEnd[1]));
							write_coord(floatround(vTraceEnd[2]));
							write_short(gBeam);
							write_byte(1);
							write_byte(5);
							write_byte(30);
							write_byte(20);
							write_byte(0);
							write_byte(random_num(32, 255));
							write_byte(random_num(32, 255));
							write_byte(random_num(32, 255));
							write_byte(200);
							write_byte(200);
							message_end();
						}
					}
				}
				
				static Float:cj_dif, Float:max_cj, Float:leet_cj, Float:pro_cj, Float:good_cj, ljtop;
				cj_dif = get_pcvar_float(kz_cj_dif);
				max_cj = get_pcvar_float(kz_max_lj) + cj_dif;
				leet_cj = get_pcvar_float(kz_leet_lj) + cj_dif;
				pro_cj = get_pcvar_float(kz_pro_lj) + cj_dif;
				good_cj = get_pcvar_float(kz_good_lj) + cj_dif;
				ljtop = get_pcvar_num(kz_ljs_tops);
				if( fDistance < max_cj
				&& !(fDistance < leet_cj)
				&& !(cj_dif > leet_cj)
				&& (ljtop == 1
				|| ljtop == 3) )
				{
					static color, name[33];
					color = get_pcvar_num(kz_leet_cj_clr);
					get_user_name(id, name, 31);
					for( i = INFO_ONE; i < 33; i++ )
					{
						if( possible_lj_script[id][0] || possible_lj_script[id][1] )
							break;
						
						if( i == id || is_user_spectating_player(i, id) || (pev_valid(i) && is_user_connected(i) && gHasColorChat[i]) )
						{
							if( color < 6 && color > 0 )
							{
								switch(color)
								{
									case 1: ColorChat(i, RED, "[XJ] %s jumped %.3f units with cj!", name, fDistance);
									case 2: ColorChat(i, GREEN, "[XJ] %s jumped %.3f units with cj!", name, fDistance);
									case 3: ColorChat(i, BLUE, "[XJ] %s jumped %.3f units with cj!", name, fDistance);
									case 4: ColorChat(i, GREY, "[XJ] %s jumped %.3f units with cj!", name, fDistance);
									case 5: ColorChat(i, TEAM_COLOR, "[XJ] %s jumped %.3f units with cj!", name, fDistance);
								}
							}
							else
								client_print(i, print_chat, "[XJ] %s jumped %.3f units with cj!", name, fDistance);
							
							if( sound == 1 )
							{
								if( i == id || is_user_spectating_player(i, id) )
									client_cmd(i, "speak misc/mod_wickedsick");
								else
									client_cmd(i, "speak misc/mod_godlike");
							}
						}
					}
				}
				
				else if( fDistance < max_cj
				&& !(fDistance < pro_cj)
				&& !(cj_dif > pro_cj)
				&& (ljtop == 1
				|| ljtop == 3) )
				{
					static color, name[33];
					color = get_pcvar_num(kz_pro_cj_clr);
					get_user_name(id, name, 31);
					for( i = INFO_ONE; i < 33; i++ )
					{
						if( possible_lj_script[id][0] || possible_lj_script[id][1] )
							break;
						
						if( i == id || is_user_spectating_player(i, id) || (pev_valid(i) && is_user_connected(i) && gHasColorChat[i]) )
						{
							if( color < 6 && color > 0 )
							{
								switch(color)
								{
									case 1: ColorChat(i, RED, "[XJ] %s jumped %.3f units with cj!", name, fDistance);
									case 2: ColorChat(i, GREEN, "[XJ] %s jumped %.3f units with cj!", name, fDistance);
									case 3: ColorChat(i, BLUE, "[XJ] %s jumped %.3f units with cj!", name, fDistance);
									case 4: ColorChat(i, GREY, "[XJ] %s jumped %.3f units with cj!", name, fDistance);
									case 5: ColorChat(i, TEAM_COLOR, "[XJ] %s jumped %.3f units with cj!", name, fDistance);
								}
							}
							else
								client_print(i, print_chat, "[XJ] %s jumped %.3f units with cj!", name, fDistance);
						}
						if( (i == id || is_user_spectating_player(i, id)) && sound == 1 )
							client_cmd(i, "speak misc/perfect");
					}
				}
				
				else if( fDistance < max_cj
				&& !(fDistance < good_cj)
				&& !(cj_dif > good_cj)
				&& (ljtop == 1
				|| ljtop == 3) )
				{
					static color, name[33];
					color = get_pcvar_num(kz_good_cj_clr);
					get_user_name(id, name, 31);
					for( i = INFO_ONE; i < 33; i++ )
					{
						if( possible_lj_script[id][0] || possible_lj_script[id][1] )
							break;
						
						if( i == id || is_user_spectating_player(i, id) || (pev_valid(i) && is_user_connected(i) && gHasColorChat[i]) )
						{
							if( color < 6 && color > 0 )
							{
								switch(color)
								{
									case 1: ColorChat(i, RED, "[XJ] %s jumped %.3f units with cj!", name, fDistance);
									case 2: ColorChat(i, GREEN, "[XJ] %s jumped %.3f units with cj!", name, fDistance);
									case 3: ColorChat(i, BLUE, "[XJ] %s jumped %.3f units with cj!", name, fDistance);
									case 4: ColorChat(i, GREY, "[XJ] %s jumped %.3f units with cj!", name, fDistance);
									case 5: ColorChat(i, TEAM_COLOR, "[XJ] %s jumped %.3f units with cj!", name, fDistance);
								}
							}
							else
								client_print(i, print_chat, "[XJ] %s jumped %.3f units with cj!", name, fDistance);
						}
						if( (i == id || is_user_spectating_player(i, id)) && sound == 1 )
							client_cmd(i, "speak misc/impressive");
					}
				}
			}
			fMaxAirSpeed[id] = 0.0;
			fMaxGroundSpeed[id] = 0.0;
			cjumped[id] = false;
			gInAir[id] = false;
		}
		else if( flags&FL_ONGROUND
		&& gInAir[id] == false )
		{
			pev(id, pev_velocity, vVelocity);
			vVelocity[2]-=vVelocity[2];
			if( vector_length(vVelocity) >= 279
			&& doubleducked[id] == false )
				set_task(0.5,"gocheck", id);
			gInAir[id] = false;
			fMaxAirSpeed[id] = 0.0;
			fMaxGroundSpeed[id] = 0.0;
			cjumped[id] = false;
		}
		
		static i;
		for( i = INFO_ZERO; i < 127; i++ )
		{
			if( i == 126 || (vBeamPos[id][i][0] == 0
			&& vBeamPos[id][i][1] == 0
			&& vBeamPos[id][i][2] == 0
			&& vBeamTime[id][i] == 0) )
			{
				pev(id, pev_origin, vBeamPos[id][i]);
				if( i == 0 )
					vBeamTime[id][i] = 15.0;
				else
					vBeamTime[id][i] = (get_gametime()-beam_jump_off_time[id])*10+15;
				if( doubleducked[id] == true || induck[id] == true )
					vBeamPosStatus[id][i] = -1.0;
				else if( is_in_duck(id) )
					vBeamPosStatus[id][i] = 1.0;
				else
					vBeamPosStatus[id][i] = 0.0;
				i=127;
			}
		}
		
		if( flags&FL_ONGROUND )
		{
			static ClassName[32];
			pev(pev(id, pev_groundentity), pev_classname, ClassName, 32);
			if( equal(ClassName, "func_train") || equal(ClassName, "func_door") || equal(ClassName, "func_door_rotating") || equal(ClassName, "func_conveyor") )
			{
				gocheck(id);
				set_task(0.4,"gocheck", id);
			}
			if( OnGround[id] == false )
			{
				pev(id, pev_origin, vOrigin);
				if( doubleducked[id] == false
				&& !(cjumped[id] == true
				&& buttons&IN_JUMP
				&& !(oldbuttons&IN_JUMP)) )
					set_task(0.4,"gocheck", id);
				else if( doubleducked[id] == true
				&& vOrigin[2] != vDuckedAt[id][2] )
					set_task(0.5,"gocheck", id);
				OnGround[id] = true;
			}
		}
		if( buttons&IN_DUCK
		&& flags&FL_ONGROUND
		&& gInAir[id] == false )
		{
			if( induck[id] == false )
			{
				cducked[id] = true;
				induck[id] = true;
				set_task(0.1,"testcjstart", id);
				
				pev(id, pev_origin, vOrigin);
				vDuckedAt[id][0] = vOrigin[0];
				vDuckedAt[id][1] = vOrigin[1];
				vDuckedAt[id][2] = vOrigin[2];
				beam_jump_off_time[id] = get_gametime();
				
				static i;
				for( i = INFO_ZERO; i < 128; i++ )
				{
					vBeamPos[id][i][0] = 0.0;
					vBeamPos[id][i][1] = 0.0;
					vBeamPos[id][i][2] = 0.0;
					vBeamTime[id][i] = 0.0;
				}
			}
		}
		else if( oldbuttons&IN_DUCK )
		{
			induck[id] = false;
			if( cducked[id] == true && !is_in_duck(id) )
			{
				set_task(0.3,"ddend", id);
				doubleducked[id] = true;
				cducked[id] = false;
			}
		}
		if( !(flags&FL_ONGROUND) )
			OnGround[id] = false;
	}
	return FMRES_IGNORED;
}

public fwdPlayerPostThink(id)
{
	if( is_user_alive(id) && get_pcvar_num(kz_ljs_enabled) )
	{
		static buttons, flags;
		buttons = pev(id, pev_button);
		flags = pev(id, pev_flags);
		
		if( flags&FL_ONGROUND
		&& (gInAir[id] == true
		|| OnGround[id] == false) )
			fwdPlayerPreThink(id);
		
		pev(id, pev_angles, angle);
		if( old_angle1[id] > angle[1] )
		{
			turning_left[id] = false;
			turning_right[id] = true;
		}
		else if( old_angle1[id] < angle[1] )
		{
			turning_left[id] = true;
			turning_right[id] = false;
		}
		else
		{
			turning_left[id] = false;
			turning_right[id] = false;
		}
		if( strafing_aw[id] == false
		&& (buttons&IN_MOVELEFT
		|| buttons&IN_FORWARD)
		&& (turning_left[id] == true
		|| turning_right[id] == true )
		&& !(buttons&IN_MOVERIGHT
		|| buttons&IN_BACK) )
		{
			strafing_aw[id] = true;
			strafing_sd[id] = false;
			strafes[id] += INFO_ONE;
		}
		else if( strafing_sd[id] == false
		&& (buttons&IN_MOVERIGHT
		|| buttons&IN_BACK)
		&& (turning_left[id] == true
		|| turning_right[id] == true )
		&& !(buttons&IN_MOVELEFT
		|| buttons&IN_FORWARD) )
		{
			strafing_aw[id] = false;
			strafing_sd[id] = true;
			strafes[id] += INFO_ONE;
		}
		
		pev(id, pev_velocity, vVelocity);
		vVelocity[2] = 0.0;
		fSpeed = vector_length(vVelocity);
		
		if( buttons&IN_MOVERIGHT
		|| buttons&IN_MOVELEFT
		|| buttons&IN_FORWARD
		|| buttons&IN_BACK )
		{
			if( fSpeed > OldSpeed[id] )
				goodsync[id] += INFO_ONE;
			else
				badsync[id] += INFO_ONE;
		}
		
		OldSpeed[id] = fSpeed;
		
		if( buttons&IN_RIGHT
		|| buttons&IN_LEFT )
		{
			if( flags&FL_ONGROUND )
			{
				possible_lj_script[id][1] = false;
				
				if( fSpeed > 250 )
				{
					if( task_exists(id+534490) )
						remove_task(id+534490);
					
					possible_lj_script[id][0] = true;
				}
			}
			else if( gInAir[id] )
				possible_lj_script[id][1] = true;
		}
		else if( flags&FL_ONGROUND )
		{
			possible_lj_script[id][1] = false;
			
			if( !task_exists(id+534490) && possible_lj_script[id][0] )
				set_task(1.5, "isnt_prestrafe_cheating", id+534490);
		}
	}
}

public isnt_prestrafe_cheating(id)
	possible_lj_script[id-534490][0] = false;

public fwdTouch(ent, id)
{ 
	static ClassName[32];
	if( pev_valid(ent) )
	{
		pev(ent, pev_classname, ClassName, 31);
	}
	static ClassName2[32];
	if( pev_valid(id) )
	{
		pev(id, pev_classname, ClassName2, 31);
	}
	if( equal(ClassName2, "player") )
	{
		if( pev(id, pev_groundentity) == ent && (gInAir[id] || !OnGround[id]) )
		{
			if( pev(id, pev_flags)&FL_ONGROUND )
			{
				if( get_gametime() > (jumptime[id]+0.1) )
					fwdPlayerPreThink(id);
			}
		}
		
		if( equal(ClassName, "func_train") || equal(ClassName, "func_door") || equal(ClassName, "func_door_rotating") || equal(ClassName, "func_conveyor") )
		{
			gocheck(id);
			set_task(0.4,"gocheck", id);
		}
	}
}

stock get_spectated_player(spectator)
{
	if( !pev_valid(spectator) )
		return 0;
	if( !is_user_connected(spectator) )
		return 0;
	if( is_user_alive(spectator) )
		return 0;
	if( pev(spectator, pev_deadflag) != 2 )
		return 0;
	
	static player, specmode;
	specmode = pev(spectator, pev_iuser1);
	if( !(specmode == 1 || specmode == 2 || specmode == 4) )
		return 0;
	
	player = pev(spectator, pev_iuser2);
	
	if( !pev_valid(player) )
		return 0;
	if( !is_user_connected(player) )
		return 0;
	if( !is_user_alive(player) )
		return 0;
	
	return player;
}

stock is_user_spectating_player(spectator, player)
{
	if( !pev_valid(spectator) || !pev_valid(player) )
		return 0;
	if( !is_user_connected(spectator) || !is_user_connected(player) )
		return 0;
	if( is_user_alive(spectator) || !is_user_alive(player) )
		return 0;
	if( pev(spectator, pev_deadflag) != 2 )
		return 0;
	
	static specmode;
	specmode = pev(spectator, pev_iuser1);
	if( !(specmode == 1 || specmode == 2 || specmode == 4) )
		return 0;
	
	if( pev(spectator, pev_iuser2) == player )
		return 1;
	
	return 0;
}

stock is_in_duck(player)
{
	// supplied with invalid entities
	if( !pev_valid(player)  )
		return 0;
	
	// retrieve absolutes
	static Float:absmin[3], Float:absmax[3];
	
	pev(player, pev_absmin, absmin);
	pev(player, pev_absmax, absmax);
	
	absmin[2]+=64.0;
	
	if( absmin[2] < absmax[2] )
		return 0;
	
	return 1;
}
