#include <amxmodx>
#include <amxmisc>
#include <bfmod>

#define g_szPrefixName "Battlefield"

public plugin_init()
{
	register_plugin("BF Admin Commands", "0.0.1", "SavSin");
	
	register_concmd("amx_rem_exp", "cmd_take_exp", ADMIN_RCON, "<target> <amount>");
	register_concmd("amx_add_exp", "cmd_give_exp", ADMIN_RCON, "<target> <amount>");
	register_concmd("amx_set_exp", "cmd_set_exp", ADMIN_RCON, "<target> <amount>");
	
	//register_concmd("amx_reset_ranks", "cmd_reset_ranks", ADMIN_RCON, "<value>");
}
//Give/Take/Set XP addaon by [X]-RayCat
public cmd_take_exp(id, level,cid) 
{
	if(!cmd_access (id, level, cid, 3))
		return PLUGIN_HANDLED;
	
	new target[32], amount[21], reason[21];
	
	read_argv(1, target, 31);
	read_argv(2, amount, 20);
	read_argv(3, reason, 20);
	
	new player = cmd_target(id, target, 8);
	
	if( ! player )
		return PLUGIN_HANDLED;
	
	new admin_name[32], player_name[32];
	get_user_name(id, admin_name, charsmax(admin_name));
	get_user_name(player, player_name, charsmax(player_name));
	
	new expnum = str_to_num(amount);
	rem_user_xp(player, expnum);
	
	switch(get_cvar_num("amx_show_activity"))
	{
		case 1: client_print( 0, print_chat, "ADMIN: took %i points from %s.", expnum, player_name );
		case 2: client_print( 0, print_chat, "ADMIN %s: took %i points from %s.", admin_name, expnum, player_name );
	}
	
	client_print( player, print_chat,  "[%s] You lost %i points.", g_szPrefixName, expnum);
	return PLUGIN_HANDLED;
}

public cmd_give_exp(id, level,cid) 
{
	if(!cmd_access(id, level, cid, 3))
		return PLUGIN_HANDLED;
	
	new target[32], amount[21], reason[21];
	
	read_argv(1, target, 31);
	read_argv(2, amount, 20);
	read_argv(3, reason, 20);
	
	new player = cmd_target(id, target, 8);
	
	if( ! player )
		return PLUGIN_HANDLED;
	
	new admin_name[32], player_name[32];
	get_user_name(id, admin_name, charsmax(admin_name));
	get_user_name(player, player_name, charsmax(player_name));
	
	new expnum = str_to_num(amount);
	add_user_xp(player, expnum);
	
	switch(get_cvar_num("amx_show_activity"))
	{
		case 1: client_print(0, print_chat, "ADMIN: gave %i points to %s.", expnum, player_name );
		case 2: client_print(0, print_chat, "ADMIN %s: gave %i points to %s.", admin_name, expnum, player_name );
	}
	
	client_print(player, print_chat,  "[%s] You gained %i points.", g_szPrefixName, expnum);
	return PLUGIN_HANDLED;
}

public cmd_set_exp(id, level,cid) 
{
	if(!cmd_access(id, level, cid, 3))
		return PLUGIN_HANDLED;
	
	new target[32], amount[21], reason[21];
	
	read_argv(1, target, 31);
	read_argv(2, amount, 20);
	read_argv(3, reason, 20);
	
	new player = cmd_target(id, target, 8);
	
	if(!player)
		return PLUGIN_HANDLED;
	
	new admin_name[32];
	get_user_name(id, admin_name, charsmax(admin_name));
	
	new expnum = str_to_num( amount );
	set_user_xp(player, expnum);
	
	switch(get_cvar_num("amx_show_activity"))
	{
		case 1: client_print(0, print_chat, "ADMIN: set your xp  to %i points.", expnum);
		case 2: client_print(0, print_chat, "ADMIN %s: set your xp to %i points.", admin_name, expnum);
	}
	
	client_print(player, print_chat,  "[%s] You lost %i points.", g_szPrefixName, expnum);
	return PLUGIN_HANDLED;
}