#pragma semicolon 1

#include <amxmodx>
#include <amxmisc>
#include <hamsandwich>
#include <fakemeta>
#include <cstrike>
#include <bfmod>
#include <fun>

#define PLUGIN_VERSION "2.0.1"
#define g_szPrefixName "Battlefield"

//#define GLOBAL_DATABASE
//#define USE_NVAULT

#if defined USE_NVAULT
	#include <nvault>
#else
	#include <sqlvault>
#endif


#define PRIMARY_WEAPON ((1 << CSW_SCOUT) | (1 << CSW_XM1014) | (1 << CSW_MAC10) | (1 << CSW_AUG) | (1 << CSW_UMP45) | (1 << CSW_SG550) | (1 << CSW_GALIL) | (1 << CSW_FAMAS) | (1 << CSW_AWP) | (1 << CSW_MP5NAVY) | (1 << CSW_M249) | (1 << CSW_M3) | (1 << CSW_M4A1) | (1 << CSW_TMP) | (1 << CSW_G3SG1) | (1 << CSW_SG552) | (1 << CSW_AK47) | (1 << CSW_P90))
#define SECONDARY_WEAPON ((1 << CSW_P228) | (1 << CSW_ELITE) | (1 << CSW_FIVESEVEN) | (1 << CSW_USP) | (1 << CSW_GLOCK18) | (1 << CSW_DEAGLE))
#define NO_BPAMMO ((1<<CSW_HEGRENADE)|(1<<CSW_SMOKEGRENADE)|(1<<CSW_FLASHBANG)|(1<<CSW_KNIFE)|(1<<CSW_C4))
#define NO_RELOAD ((1 << 2) | (1 << CSW_KNIFE) | (1 << CSW_C4) | (1 << CSW_M3) | (1 << CSW_XM1014) | (1 << CSW_HEGRENADE) | (1 << CSW_FLASHBANG) | (1 << CSW_SMOKEGRENADE))
#define fm_cs_set_user_nobuy(%1)	set_pdata_int(%1, 235, get_pdata_int(%1, 235) & ~(1<<0))
#define fm_find_ent_by_class(%1,%2) engfunc(EngFunc_FindEntityByString, %1, "classname", %2)
#define Ham_Player_ResetMaxSpeed Ham_Item_PreFrame

#define IsPlayer(%1) (1 <= %1 <= g_iMaxPlayers)

const TASK_HEAL = 12345;
const TASK_DISTANCE = 12346;
const TASK_GIVE = 12347;
const TASK_DISTGIVE = 12348;
const BLEED_ENT = 25;

const OFFSET_PRIMARYWEAPON = 116;
const OFFSET_C4_SLOT = 372;
const m_afButtonPressed = 246;
const m_afButtonReleased = 247;
const m_pActiveItem = 373;
const m_iID = 43;
const m_pPlayer = 41;
const m_fInReload = 54;
const m_iClip = 51;
const m_LastHitGroup = 75;

enum _:CVARS
{
	CVAR_ENABLED, CVAR_KNIFEBONUS, CVAR_HSSTREAKBONUS, CVAR_HSSTREAK, CVAR_KILLSTREAK,
	CVAR_KILLSTREAKBONUS, CVAR_HSBONUS, CVAR_KILLXP, CVAR_BOMBBONUS, CVAR_PLANTBONUS,
	CVAR_EXPBONUS, CVAR_DEFUSEBONUS, CVAR_TARGSAVBONUS, CVAR_HOSTRESBONUS, CVAR_HOSTNRESBONUS,CVAR_TK, CVAR_TKXP, CVAR_KNIFE,
	CVAR_HEALAMOUNT, CVAR_HEALWAIT, CVAR_HEALMIN, CVAR_HEALTIME, CVAR_CALLWAIT, 
	CVAR_HEALBONUS, CVAR_GIVEWAIT, CVAR_MINAMMO, CVAR_GIVETIME, CVAR_AMMOBONUS,
	CVAR_DEATHMATCH, CVAR_RESPAWNTIME, CVAR_SPTIME, CVAR_SPHUD, CVAR_SPGLOW,
	CVAR_BLEEDTOGGLE, CVAR_STARTBLEED, CVAR_STOPBLEED, CVAR_BLEEDTIME,
	CVAR_VFFMIRRORHURT, CVAR_VFFNADES, CVAR_SQLHOST, CVAR_SQLUSER, CVAR_SQLPASS, CVAR_SQLDB,
	CVAR_SOUNDTOGGLE
}

enum _:CLASSRANKCVAR
{
	CVAR_PWEP, CVAR_SWEP, CVAR_HEALTH, CVAR_ARMOR, CVAR_SPEED, CVAR_GRAVITY
}

enum _:XPDATA 
{ 
	XPTotal, XP[CLASSES], Class, Rank
}

new const g_ClassDesc[CLASSES][] = 
{
	"None", "Assault", "Special Ops", "Sniper", "Engineer", "Medic", "Support"
};

new const g_RankDesc[RANKS][] = 
{
	"Private", "Private First Class", "Specialist", "Corporal", "Sergeant",
	"Staff Sergeant", "Sergeant Firs Class", "Master Sergeant", "First Sergeant",
	"Sergeant Major", "Warrant Officer", "Chief Warrant Officer", "Second Lieutenant",
	"First Lieutenant", "Captain", "Major", "Lieutenant Colonel", "Colonel", 
	"Brigadier General", "Major General", "Lieutenant General", "General"
}; 

new const g_RankXP[RANKS][2] = 
{
	{0, 6499},
	{6500, 10999},
	{11000, 18499},
	{18500, 27999},
	{28000, 39999},
	{40000, 52999},
	{53000, 67999},
	{68000, 83999},
	{84000, 99999},
	{100000, 119999},
	{120000, 137999},
	{138000, 157999},
	{158000, 178999},
	{179000, 199999},
	{200000, 223999},
	{224000, 246999},
	{247000, 271999}, 
	{272000, 296999},
	{297000, 322999},
	{323000, 471999},
	{472000, 999999},
	{1000000, 5000000}
};

new const g_SettingsCvarDesc[CVARS][] =
{
	"toggle", "knifebonus", "hsmultixp", "hskills", "killstreak", "killstreakbonus", "hsxp", "killxp", "bomb_bonus", "plantxp", "expxp",
	"defxp", "targxp", "hostrescxp", "hostnrescxp", "tk_punish", "tk_punishxp", "knifebonus", "healamount", "healwait", "healmin", "healtime", "callwait", "healbonus",
	"giveammowait", "ammomin", "ammogivetime", "ammogivebonus", "deathmatch", "respawntime", "sptime", "sphud", "spglow", "bleedtoggle", 
	"startbleed", "stopbleed", "bleedtime", "vff_mirrorhurt", "vff_nades", "sql_host", "sql_user", "sql_pass", "sql_db",
	"sound_toggle"
};

new const g_ClassCvarDesc[CLASSES][] = 
{
	"", "Assault", "Special", "Sniper", "Engineer", "Medic", "Support"
};	

new const classLimitDesc[CLASSES][] = 
{
	"", "assault", "specop", "sniper", "engineer", "medic", "support"
};
new const classLimitDefault[CLASSES][] = 
{
	"", "2", "2", "1", "1", "1", "3"
};

new const g_RankCvarDesc[RANKS][] = 
{
	"pvt", "pfc", "spe", "cor", "ser", "sser", "sfc","ms", "fs", "sm", "wo", "cwo", "slt", "flt", "cpt", "maj", "ltcol", "col", "bg", "mg", "ltg", "g"
};

new const g_CvarDesc[CLASSRANKCVAR][] =
{
	"pwep", "swep", "Health", "Armor", "Speed", "Gravity"
};

new g_WeaponBPAmmo[] =
{
    0, 52, 0, 90, 1, 32, 1, 100, 90, 1, 120, 100, 100, 90, 90, 90, 100, 120, 30,
    120, 200, 32, 90, 120, 90, 2, 35, 90, 90, 0, 100
};

//Class information
new g_XP[33][XPDATA];
new g_ClassCounter[CsTeams][CLASSES];
new CsTeams:g_iPlayerTeam[33];

new g_iMaxPlayers;

//Bomb Map stff
new bool:is_alive[33];
new g_bomb_targ;

//Kill Streaks
new g_kills[33];
new g_HS[33];

//XP Stuff
new gHudSync;
new gHudSyncXp;
new g_szAuthID[33][35];
#if defined USE_NVAULT
	new g_hVault;
#else
	new SQLVault:g_hVault;
#endif

//Menu Stuff
new g_ClassMenu;
new bool:g_NewClass[33];

//Respawn Stuff
new bool:bBombPlanted;
new iTeamInfoCounter[33];

//Virtual Reality
new bool:Is_Bleeding[33];
new g_ent[33];

//Cvars
new g_iFriendlyFirePointer;
new g_iMirrorDamagePointer;
new g_Cvar[CLASSRANKCVAR][CLASSES][RANKS];
new g_Cvar2[CVARS];
new g_Cvar3[CsTeams][CLASSES];

//Medic And Support
new gmsgBarTime;
new g_iTarget[33];

//Medic
new bool:g_bCompetedHeal[33];
new bool:IsHealing[33];
new bool:IsBeingHealed[33];
new g_iMedicCount[CsTeams];
new g_iMedicID[CsTeams][33];
new Float:g_flLastHeal[33];
new Float:g_flLastMedicCall[33];

//Support
new g_iSupportID[CsTeams][33];
new g_iSupportCount[CsTeams];
new g_iTargetSecondaryWeapon[33];
new g_iTargetPrimaryWeapon[33];
new bool:g_bCompetedGive[33];
new bool:IsGiving[33];
new bool:IsGetting[33];
new Float:g_flLastAmmoCall[33];
new Float:g_flLastGive[33];


new const g_medic_calls[][] =
{
	"bf/bf_medic_call1.wav",
	"bf/bf_medic_call2.wav",
	"bf/bf_medic_call3.wav",
	"bf/bf_medic_call4.wav"
};

new const g_medic_done[] = "bf/bf_medic_done.wav";
new const g_medic_heal[] = "bf/bf_medic_healing.wav";

new const g_Death_Sounds[][] =
{
	"bf/bf_death1.wav",
	"bf/bf_death2.wav",
	"bf/bf_death3.wav",
	"bf/bf_death4.wav"
};

new const g_Ammo_Calls[][] =
{
	"bf/bf_needammo1.wav",
	"bf/bf_needammo2.wav",
	"bf/bf_needammo3.wav",
	"bf/bf_needammo4.wav"
};

new const g_Reload_Sounds[][]=
{
	"bf/bf_reload1.wav",
	"bf/bf_reload2.wav"
};

new const g_Take_Ammo[][] = 
{
	"bf/bf_takeammo1.wav",
	"bf/bf_takeammo2.wav"
};

new const g_level_up[] = "bf/bf_levelup.wav";

public plugin_init() 
{
	register_plugin( "Battlefield Mod XP" , PLUGIN_VERSION , "SavSin" );
	register_cvar("bfm_version", PLUGIN_VERSION, FCVAR_SERVER|FCVAR_UNLOGGED); //Public var for seeing all servers and what version
	
	RegisterHam(Ham_Spawn, "player", "fwdPlayerSpawn", 1); //Player Spawn
	RegisterHam(Ham_TakeDamage, "player", "fwdPlayerHurt"); //Player Hurt Pre (True Armor)
	RegisterHam(Ham_TakeDamage, "player", "fwdPlayerHurtPost", 1); //Player Hurt Post
	RegisterHam(Ham_Killed, "player", "fwdPlayerDeath", 1); //Player Death
	RegisterHam(Ham_Player_ResetMaxSpeed, "player", "fwdPlayerResetMaxSpeedPost", 1); // Player Speed change
	RegisterHam(Ham_ObjectCaps, "player", "fwdObjectCaps"); // Player Presses Use
	RegisterHam(Ham_Touch, "item_thighpack", "RemoveWeapons", 1);//Rmoves Thighpack
	RegisterHam(Ham_Touch, "weaponbox", "RemoveWeapons", 1); //Weapon box spawn
	RegisterHam(Ham_Touch, "armoury_entity", "RemoveWeapons", 1); //Armor entity Spawn
	
	//Reload weapon Hook
	new szWeaponName[20];
	for(new i = CSW_P228; i <= CSW_P90; i++) 
	{
		if(NO_RELOAD & (1 << i))
			continue;
		
		get_weaponname(i, szWeaponName, charsmax(szWeaponName));
		RegisterHam(Ham_Weapon_Reload, szWeaponName, "fwdHamWeaponReload", 1);
	}
	
	//Checks team information (Switching teams)
	register_event("TeamInfo", "eTeamInfo", "a");
	
	//Events for various XP
	register_logevent("ePlanted", 3, "2=Planted_The_Bomb");
	register_logevent("eDefused", 3, "2=Defused_The_Bomb");
	register_logevent("eExplosion", 6, "3=Target_Bombed");
	register_logevent("eTargetSaved", 6, "3=Target_Saved");
	register_logevent("eHostages", 6, "2=triggered");
	
	//Calling for medic
	register_clcmd("medic_call", "cmdMedicCall");
	register_clcmd("say /medic", "cmdMedicCall");
	register_clcmd("say_team /medic", "cmdMedicCall");
	
	//Calling for Ammo
	register_clcmd("ammo_call", "cmdAmmoCall");
	register_clcmd("say /ammo", "cmdAmmoCall");
	register_clcmd("say_team /ammo", "cmdAmmoCall");
	
	//class CMDs and Blocking Drop and Suicide and Corpse
	register_clcmd("say /class" , "cmdSayClass");
	register_clcmd("say_team /class", "cmdSayClass");
	register_clcmd("drop", "hookDrop");
	register_forward(FM_ClientKill, "BlockSuicide");
	set_msg_block(get_user_msgid("ClCorpse"), BLOCK_SET);
	register_forward(FM_EmitSound, "FwdEmitSound"); //When sound is emited (blocks use sound)
	
	//FF commands
	register_clcmd("say /ff", "sayFFStatus");
	register_clcmd("say ff", "sayFFStatus");
	register_clcmd("say_team /ff", "sayFFStatus");
	register_clcmd("say_team ff", "sayFFStatus");
	
	//MD Commands
	register_clcmd("say /md", "sayMDStatus");
	register_clcmd("say md", "sayMDStatus");
	register_clcmd("say_team /md", "sayMDStatus");
	register_clcmd("say_team md", "sayMDStatus");
	
	g_iFriendlyFirePointer = get_cvar_pointer("mp_friendlyfire");
	g_iMirrorDamagePointer = get_cvar_pointer("mp_mirrordamage");
	
	gHudSync = CreateHudSyncObj();
	gHudSyncXp = CreateHudSyncObj();
	
	g_iMaxPlayers = get_maxplayers();
	
	gmsgBarTime = get_user_msgid("BarTime");
	
	if (fm_find_ent_by_class(-1, "func_bomb_target") || fm_find_ent_by_class(-1, "info_bomb_target"))
	{
		g_bomb_targ = true;
	}
	
	g_ClassMenu = menu_create("Battlefield" , "HandleClassMenu");
	new szNum[3];
	
	for (new i = 1 ; i < sizeof(g_ClassDesc); i++)
	{
		num_to_str(i , szNum , charsmax(szNum));
		menu_additem(g_ClassMenu , g_ClassDesc[ i ] , szNum , 0);
	}

	menu_setprop(g_ClassMenu , MPROP_EXIT , MEXIT_NEVER);
	
	RegisterSettingsCvars();
	RegisterClassRankCvars();
	
	#if defined USE_NVAULT
	
		g_hVault = nvault_open("bf_xp_data");
	
	#else

		#if defined GLOBAL_DATABASE

			new szHost[32], szUserName[32], szPassword[32], szDataBase[32];
			get_pcvar_string(g_Cvar2[CVAR_SQLHOST], szHost, charsmax(szHost));
			get_pcvar_string(g_Cvar2[CVAR_SQLUSER], szUserName, charsmax(szUserName));
			get_pcvar_string(g_Cvar2[CVAR_SQLPASS], szPassword, charsmax(szPassword));
			get_pcvar_string(g_Cvar2[CVAR_SQLDB], szDataBase, charsmax(szDataBase));

			g_hVault = sqlv_open(szHost, szUserName, szPassword, szDataBase, "bf_xp_data", true);

		#else
		
			g_hVault = sqlv_open_local("bf_xp_data", true);
		
		#endif
		
		if(g_hVault == Invalid_SQLVault)
			set_fail_state("Error Creating SQLVault");
	#endif
	
	static iEnt;
	iEnt = engfunc(EngFunc_CreateNamedEntity,engfunc(EngFunc_AllocString,"info_target"));
	
	set_pev(iEnt, pev_classname, "HudSyncEnt");
	set_pev(iEnt, pev_nextthink, get_gametime());
	RegisterHamFromEntity(Ham_Think, iEnt, "HudShow");
}

public plugin_natives()
{
	register_native("rem_user_xp", "_rem_user_xp");
	register_native("add_user_xp", "_add_user_xp");
	register_native("set_user_xp", "_set_user_xp");
	register_native("get_user_xp", "_get_user_xp");
	register_native("get_user_totalxp", "_get_user_totalxp");
	register_native("get_user_class", "_get_user_class");
	register_native("get_user_rank", "_get_user_rank");
}

public cz_bot_ham_registerable(id)
{
	RegisterHamFromEntity(Ham_Killed, id, "fwdPlayerDeath", 1);
	RegisterHamFromEntity(Ham_Spawn, id, "fwdPlayerSpawn", 1);
}

public plugin_precache()
{
	for(new i = 0; i < sizeof(g_medic_calls); i++)
	{
		precache_sound(g_medic_calls[i]);
	}
	
	for(new i = 0; i < sizeof(g_Death_Sounds); i++)
	{
		precache_sound(g_Death_Sounds[i]);
	}
	
	for(new i = 0; i < sizeof(g_Ammo_Calls); i++)
	{
		precache_sound(g_Ammo_Calls[i]);
	}
	
	for(new i = 0; i < sizeof(g_Take_Ammo); i++)
	{
		precache_sound(g_Take_Ammo[i]);
	}
	
	for(new i = 0; i < sizeof(g_Reload_Sounds); i++)
	{
		precache_sound(g_Reload_Sounds[i]);
	}
	
	precache_sound(g_level_up);
	precache_sound(g_medic_done);
	precache_sound(g_medic_heal);
}

public plugin_cfg()
{
	new szConfigDir[64];

	get_configsdir(szConfigDir , charsmax(szConfigDir));
	format(szConfigDir, charsmax(szConfigDir), "%s/battlefield.cfg", szConfigDir);
	if(file_exists(szConfigDir))
	{
		server_cmd("exec %s" , szConfigDir);
		server_exec();
	}
	else
	{
		set_fail_state("Error: CFG Not Found.");
	}
	
	register_message(get_user_msgid("StatusIcon") , "Message_StatusIcon");
}

public Message_StatusIcon(iMsgId, MSG_DEST, id)
{
	if(!get_pcvar_num(g_Cvar2[CVAR_ENABLED]))
		return PLUGIN_HANDLED;
	static szIcon[5];
	get_msg_arg_string(2, szIcon, 4);
	if(szIcon[0] == 'b' && szIcon[2] == 'y' && szIcon[3] == 'z')
	{
		if(get_msg_arg_int(1))
		{
			fm_cs_set_user_nobuy(id);
			return PLUGIN_HANDLED;
		}
	}
	return PLUGIN_CONTINUE;
}


public plugin_end()
{
	#if defined USE_NVAULT
		nvault_close(g_hVault);
	#else
		sqlv_close(g_hVault);
	#endif
}

public client_authorized(id)
{
	if(get_pcvar_num(g_Cvar2[CVAR_ENABLED]))
	{
		get_user_authid(id , g_szAuthID[id] , charsmax(g_szAuthID[]));
		LoadData(id);
	}
}

public client_disconnect(id)
{
	if(get_pcvar_num(g_Cvar2[CVAR_ENABLED]))
	{
		if(g_XP[id][Class] == CLASS_MEDIC)
		{
			--g_iMedicCount[g_iPlayerTeam[id]];
			g_iMedicID[g_iPlayerTeam[id]][id] = 0;
		}
		else if(g_XP[id][Class] == CLASS_SUPPORT)
		{
			--g_iSupportCount[g_iPlayerTeam[id]];
			g_iSupportID[g_iPlayerTeam[id]][id] = 0;
		}
		iTeamInfoCounter[id] = 0;
		--g_ClassCounter[g_iPlayerTeam[id]][g_XP[id][Class]];
		g_iPlayerTeam[id] = CS_TEAM_UNASSIGNED;
		
		for (new i = 0 ; i < XPDATA ; i++)
		{
			g_XP[id][i] = 0;
		}
	}
}

public hookDrop(id)
{
	new weapon = get_user_weapon(id);
	
	if(weapon != CSW_C4)
	{
		client_print(id, print_center,  "You are not allowed to drop your weapon.");
		return PLUGIN_HANDLED;
	}
	return PLUGIN_CONTINUE;
}

public RemoveWeapons(iEnt)
{
	if(pev_valid(iEnt))
	{
		new szModelName[32];
		pev(iEnt, pev_model, szModelName, charsmax(szModelName));
		
		if(containi(szModelName, "backpack") == -1)
		{
			set_pev(iEnt, pev_flags, FL_KILLME);
			ExecuteHam(Ham_Think, iEnt);
		}
	}
}

public FwdEmitSound(id, iChannel, szSound[])
{		
	return equal(szSound, "common/wpn_denyselect.wav") ? FMRES_SUPERCEDE:FMRES_IGNORED;
}

public sayFFStatus(id)
{
	client_print(0, print_chat, "Friendly fire: %s", get_cvar_float("mp_friendlyfire") ? "ON" : "OFF");
	return PLUGIN_HANDLED;
}

public sayMDStatus(id)
{
	client_print(0, print_chat, "Mirror damage: %s", get_cvar_float("mp_mirrordamage") ? "ON" : "OFF");
	return PLUGIN_HANDLED_MAIN;
}

public BlockSuicide(id)
{
	client_print(id, print_center,  "Suicide is not an option");
	return FMRES_SUPERCEDE;
}

public fwdPlayerDeath(iVictim, iAttacker, iShouldGib)
{
	if(!get_pcvar_num(g_Cvar2[CVAR_ENABLED]))
		return HAM_IGNORED;
		
	new HitGroup = get_pdata_int(iVictim, m_LastHitGroup, 5);
	if(get_pcvar_num(g_Cvar2[CVAR_DEATHMATCH]) && !bBombPlanted)
	{
		set_task(get_pcvar_float(g_Cvar2[CVAR_RESPAWNTIME]), "RespawnPlayer", iVictim);
		set_task(0.01, "RespawnHud", iVictim);
	}
	
	if(is_user_bleeding(iVictim))
	{
		StopBleeding(iVictim);
	}
	
	set_pev(iVictim, pev_iuser1, 0);
	
	if(get_pcvar_num(g_Cvar2[CVAR_SOUNDTOGGLE]))
	{
		emit_sound(iVictim, CHAN_VOICE, g_Death_Sounds[random(sizeof(g_Death_Sounds))], VOL_NORM, ATTN_NORM, 0, PITCH_NORM);
	}
	
	g_kills[iVictim] = 0;
	g_HS[iVictim] = 0;
	
	if(!IsPlayer(iAttacker))
		return HAM_IGNORED;
		
	new weapon = get_user_weapon(iAttacker);
	new iClass = g_XP[iAttacker][Class];
	
	if(get_pcvar_num(g_Cvar2[ CVAR_TK ]))
	{
		if(get_user_team(iAttacker) == get_user_team(iVictim))
		{
			g_XP[iAttacker][XP][iClass] -= get_pcvar_num(g_Cvar2[ CVAR_TKXP ]);
		}
	}
	else
	{
		if(get_user_team(iAttacker) != get_user_team(iVictim))
		{
			if(g_kills[iAttacker] != get_pcvar_num(g_Cvar2[ CVAR_KILLSTREAK ])  && g_HS[iAttacker] != get_pcvar_num(g_Cvar2[ CVAR_HSSTREAK ]))
			{
				if(weapon == CSW_KNIFE)
				{
					if(HitGroup != HIT_HEAD)
					{
						g_XP[iAttacker][XP][iClass] += (get_pcvar_num(g_Cvar2[ CVAR_KILLXP ]) + get_pcvar_num(g_Cvar2[ CVAR_KNIFEBONUS ]));
						set_hudmessage(0, 255, 50, 0.50, 0.33, 1, 2.0, 2.0);
						ShowSyncHudMsg(iAttacker, gHudSyncXp, "+ %d", get_pcvar_num(g_Cvar2[ CVAR_KILLXP ]) + get_pcvar_num(g_Cvar2[ CVAR_KNIFEBONUS ]));
						++g_kills[iAttacker];
					}
					else
					{
						g_XP[iAttacker][XP][iClass] += (get_pcvar_num(g_Cvar2[ CVAR_KILLXP ]) +  get_pcvar_num(g_Cvar2[ CVAR_HSBONUS ]) + get_pcvar_num(g_Cvar2[ CVAR_KNIFEBONUS ]));
						set_hudmessage(0, 255, 50, 0.50, 0.33, 1, 2.0, 2.0);
						ShowSyncHudMsg(iAttacker, gHudSyncXp, "+ %d", get_pcvar_num(g_Cvar2[ CVAR_KILLXP ]) + get_pcvar_num(g_Cvar2[ CVAR_HSBONUS ]) + get_pcvar_num(g_Cvar2[ CVAR_KNIFEBONUS ]));
						++g_kills[iAttacker];
						++g_HS[iAttacker];
					}
				}
				else
				{
					if(HitGroup != HIT_HEAD)
					{
						g_XP[iAttacker][XP][iClass] += get_pcvar_num(g_Cvar2[ CVAR_KILLXP ]);
						set_hudmessage(0, 255, 50, 0.50, 0.33, 1, 2.0, 2.0);
						ShowSyncHudMsg(iAttacker, gHudSyncXp, "+ %d", get_pcvar_num(g_Cvar2[ CVAR_KILLXP ]));
						++g_kills[iAttacker];
					}
					else
					{
						g_XP[iAttacker][XP][iClass] += (get_pcvar_num(g_Cvar2[ CVAR_KILLXP ]) +  get_pcvar_num(g_Cvar2[ CVAR_HSBONUS ]));
						set_hudmessage(0, 255, 50, 0.50, 0.33, 1, 2.0, 2.0);
						ShowSyncHudMsg(iAttacker, gHudSyncXp, "+ %d", get_pcvar_num(g_Cvar2[ CVAR_KILLXP ]) + get_pcvar_num(g_Cvar2[ CVAR_HSBONUS ]));
						++g_kills[iAttacker];
						++g_HS[iAttacker];
					}
				}
			}
			
			if(g_kills[iAttacker] == get_pcvar_num(g_Cvar2[ CVAR_KILLSTREAK ]) && g_HS[iAttacker] == get_pcvar_num(g_Cvar2[ CVAR_HSSTREAK ]))
			{
				if(weapon == CSW_KNIFE)
				{
					g_XP[iAttacker][XP][iClass] += (get_pcvar_num(g_Cvar2[ CVAR_KILLXP ]) + get_pcvar_num(g_Cvar2[ CVAR_KNIFEBONUS ]) + get_pcvar_num(g_Cvar2[ CVAR_HSSTREAKBONUS ]) + get_pcvar_num(g_Cvar2[ CVAR_KILLSTREAKBONUS ]));
					set_hudmessage(0, 255, 50, 0.50, 0.33, 1, 2.0, 2.0);
					ShowSyncHudMsg(iAttacker, gHudSyncXp, "+ %d", get_pcvar_num(g_Cvar2[ CVAR_KILLXP ]) + get_pcvar_num(g_Cvar2[ CVAR_KNIFEBONUS ]) + get_pcvar_num(g_Cvar2[ CVAR_HSSTREAKBONUS ]) + get_pcvar_num(g_Cvar2[ CVAR_KILLSTREAKBONUS ]));
					g_kills[iAttacker] = 0;
					g_HS[iAttacker] = 0;
				}
				else
				{
					g_XP[iAttacker][XP][iClass] += (get_pcvar_num(g_Cvar2[ CVAR_KILLXP ]) + get_pcvar_num(g_Cvar2[ CVAR_HSSTREAKBONUS ]) + get_pcvar_num(g_Cvar2[ CVAR_KILLSTREAKBONUS ]));
					set_hudmessage(0, 255, 50, 0.50, 0.33, 1, 2.0, 2.0);
					ShowSyncHudMsg(iAttacker, gHudSyncXp, "+ %d", get_pcvar_num(g_Cvar2[ CVAR_KILLXP ]) + get_pcvar_num(g_Cvar2[ CVAR_HSSTREAKBONUS ]) + get_pcvar_num(g_Cvar2[ CVAR_KILLSTREAKBONUS ]));
					g_kills[iAttacker] = 0;
					g_HS[iAttacker] = 0;
				}
			}
			
			if(g_kills[iAttacker] == get_pcvar_num(g_Cvar2[ CVAR_KILLSTREAK ]) && g_HS[iAttacker] != get_pcvar_num(g_Cvar2[ CVAR_HSSTREAK ]))
			{
				if(weapon == CSW_KNIFE)
				{
					if(HitGroup != HIT_HEAD)
					{
						g_XP[iAttacker][XP][iClass] += (get_pcvar_num(g_Cvar2[ CVAR_KILLXP ]) + get_pcvar_num(g_Cvar2[ CVAR_KILLSTREAKBONUS ])  + get_pcvar_num(g_Cvar2[ CVAR_KNIFEBONUS ]));
						set_hudmessage(0, 255, 50, 0.50, 0.33, 1, 2.0, 2.0);
						ShowSyncHudMsg(iAttacker, gHudSyncXp, "+ %d Kill Streak", get_pcvar_num(g_Cvar2[ CVAR_KILLXP ]) + get_pcvar_num(g_Cvar2[ CVAR_KILLSTREAKBONUS ])  + get_pcvar_num(g_Cvar2[ CVAR_KNIFEBONUS ]));
					}
					else
					{
						g_XP[iAttacker][XP][iClass] += (get_pcvar_num(g_Cvar2[ CVAR_KILLXP ]) + get_pcvar_num(g_Cvar2[ CVAR_HSBONUS ]) + get_pcvar_num(g_Cvar2[ CVAR_KILLSTREAKBONUS ]));
						set_hudmessage(0, 255, 50, 0.50, 0.33, 1, 2.0, 2.0);
						ShowSyncHudMsg(iAttacker, gHudSyncXp, "+ %d Kill Streak + Headshot", get_pcvar_num(g_Cvar2[ CVAR_KILLXP ]) + get_pcvar_num(g_Cvar2[ CVAR_HSBONUS ]) + get_pcvar_num(g_Cvar2[ CVAR_KILLSTREAKBONUS ]));
						++g_HS[iAttacker];
					}
				}
				else
				{
					if(HitGroup != HIT_HEAD)
					{
						g_XP[iAttacker][XP][iClass] += (get_pcvar_num(g_Cvar2[ CVAR_KILLXP ]) + get_pcvar_num(g_Cvar2[ CVAR_KILLSTREAKBONUS ]));
						set_hudmessage(0, 255, 50, 0.50, 0.33, 1, 2.0, 2.0);
						ShowSyncHudMsg(iAttacker, gHudSyncXp, "+ %d Kill Streak", get_pcvar_num(g_Cvar2[ CVAR_KILLXP ]) + get_pcvar_num(g_Cvar2[ CVAR_KILLSTREAKBONUS ]));
					}
					else
					{
						g_XP[iAttacker][XP][iClass] += (get_pcvar_num(g_Cvar2[ CVAR_KILLXP ]) + get_pcvar_num(g_Cvar2[ CVAR_HSBONUS ]) + get_pcvar_num(g_Cvar2[ CVAR_KILLSTREAKBONUS ]));
						set_hudmessage(0, 255, 50, 0.50, 0.33, 1, 2.0, 2.0);
						ShowSyncHudMsg(iAttacker, gHudSyncXp, "+ %d Kill Streak + Headshot", get_pcvar_num(g_Cvar2[ CVAR_KILLXP ]) + get_pcvar_num(g_Cvar2[ CVAR_HSBONUS ]) + get_pcvar_num(g_Cvar2[ CVAR_KILLSTREAKBONUS ]));
						++g_HS[iAttacker];
					}
				}
				g_kills[iAttacker] = 0;	
			}
			
			if(g_HS[iAttacker] == get_pcvar_num(g_Cvar2[ CVAR_HSSTREAK ]) && g_kills[iAttacker] != get_pcvar_num(g_Cvar2[ CVAR_KILLSTREAK ]))
			{
				if(weapon == CSW_KNIFE)
				{
					g_XP[iAttacker][XP][iClass] += (get_pcvar_num(g_Cvar2[ CVAR_KILLXP ]) + get_pcvar_num(g_Cvar2[ CVAR_HSSTREAKBONUS ]) + get_pcvar_num(g_Cvar2[ CVAR_KILLSTREAKBONUS ]));
					set_hudmessage(0, 255, 50, 0.50, 0.33, 1, 2.0, 2.0);
					ShowSyncHudMsg(iAttacker, gHudSyncXp, "+ %d Headshot Streak", get_pcvar_num(g_Cvar2[ CVAR_KILLXP ]) + get_pcvar_num(g_Cvar2[ CVAR_HSSTREAKBONUS ]) + get_pcvar_num(g_Cvar2[ CVAR_KILLSTREAKBONUS ]));
					g_HS[iAttacker] = 0;
				}
				else
				{
					g_XP[iAttacker][XP][iClass] += (get_pcvar_num(g_Cvar2[ CVAR_KILLXP ]) + get_pcvar_num(g_Cvar2[ CVAR_HSSTREAKBONUS ]));
					set_hudmessage(0, 255, 50, 0.50, 0.33, 1, 2.0, 2.0);
					ShowSyncHudMsg(iAttacker, gHudSyncXp, "+ %d Headshot Streak", get_pcvar_num(g_Cvar2[ CVAR_KILLXP ]) + get_pcvar_num(g_Cvar2[ CVAR_HSSTREAKBONUS ]));
					g_HS[iAttacker] = 0;
				}
			}
		}
	}
	CheckLevel(iAttacker);
	return HAM_IGNORED;
}

public CheckLevel(id)
{
	for (new i = 0 ; i < sizeof(g_RankXP) ; i++ ) 
	{ 
		if (g_RankXP[i][0] <= g_XP[id][XP][g_XP[id][Class]] <= g_RankXP[i][1] ) 
		{
			if(g_XP[id][Rank] != i)
			{
				g_XP[id][Rank] = i;
				if(get_pcvar_num(g_Cvar2[CVAR_SOUNDTOGGLE]))
				{
					new szSoundFile[32];
					format(szSoundFile, charsmax(szSoundFile), "spk sound/%s", g_level_up);
					client_cmd(id, szSoundFile);
				}
				break; 
			}
			break;
		} 
	}
	SaveData(id);
}

public ePlanted()
{
	if(!g_Cvar2[CVAR_ENABLED])
		return PLUGIN_HANDLED;
		
	for(new i = 1; i <= g_iMaxPlayers; ++i)
	{
		if(!IsPlayer(i))
			return PLUGIN_HANDLED;
		
		if(is_user_alive(i) && get_user_team(i) == 1)
		{
			is_alive[i] = true;
			g_XP[i][XP][g_XP[i][Class]] += get_pcvar_num(g_Cvar2[CVAR_PLANTBONUS]);
			set_hudmessage(0, 255, 50, 0.50, 0.33, 1, 2.0, 2.0);
			ShowSyncHudMsg(i, gHudSyncXp, "+ %d", get_pcvar_num(g_Cvar2[CVAR_PLANTBONUS]));
		}
		bBombPlanted = true;
		CheckLevel(i);
	}
	return PLUGIN_CONTINUE;
}

public eDefused()
{
	if(!g_Cvar2[CVAR_ENABLED])
		return PLUGIN_HANDLED;
		
	for(new i = 1; i <= g_iMaxPlayers; ++i)
	{
		if(!IsPlayer(i))
			return PLUGIN_HANDLED;
			
		if(is_user_alive(i) && get_user_team(i) == 2)
		{
			g_XP[i][XP][g_XP[i][Class]] +=  get_pcvar_num(g_Cvar2[CVAR_DEFUSEBONUS]);
			is_alive[i] = false;
			ShowSyncHudMsg(i, gHudSyncXp, "+ %d", get_pcvar_num(g_Cvar2[CVAR_DEFUSEBONUS]));
		}
		CheckLevel(i);
	}
	return PLUGIN_CONTINUE;
}

public eExplosion()
{
	if(!g_Cvar2[CVAR_ENABLED])
		return PLUGIN_HANDLED;
		
	for(new i = 1; i <= g_iMaxPlayers; ++i)
	{
		if(!IsPlayer(i))
			return PLUGIN_HANDLED;
		
		if(is_alive[i] && get_user_team(i) == 1)
		{
			g_XP[i][XP][g_XP[i][Class]] +=  get_pcvar_num(g_Cvar2[CVAR_EXPBONUS]);
			is_alive[i] = false;
			ShowSyncHudMsg(i, gHudSyncXp, "+ %d", get_pcvar_num(g_Cvar2[CVAR_EXPBONUS]));
		}
		CheckLevel(i);
	}
	return PLUGIN_CONTINUE;
}

public eTargetSaved()
{
	if(!g_Cvar2[CVAR_ENABLED])
		return PLUGIN_HANDLED;
		
	for(new i = 1; i <= g_iMaxPlayers; ++i)
	{
		if(!IsPlayer(i))
			return PLUGIN_HANDLED;
			
		if(is_user_alive(i) && get_user_team(i) == 2)
		{
			g_XP[i][XP][g_XP[i][Class]] +=  get_pcvar_num(g_Cvar2[CVAR_TARGSAVBONUS]);
			ShowSyncHudMsg(i, gHudSyncXp, "+ %d", get_pcvar_num(g_Cvar2[CVAR_TARGSAVBONUS]));
		}
		CheckLevel(i);
	}
	return PLUGIN_CONTINUE;
}

public eHostages()
{
	new arg[64];
	read_logargv(3, arg, 63);

	if(equal(arg, "Hostages_Not_Rescued"))
	{
		if(!g_Cvar2[CVAR_ENABLED])
			return PLUGIN_HANDLED;
		
		for(new i = 1; i <= g_iMaxPlayers; ++i)
		{
			if(!IsPlayer(i))
				return PLUGIN_HANDLED;
				
			if(is_user_alive(i) && get_user_team(i) == 1)
			{
				g_XP[i][XP][g_XP[i][Class]] +=  get_pcvar_num(g_Cvar2[CVAR_HOSTNRESBONUS]);
				ShowSyncHudMsg(i, gHudSyncXp, "+ %d", get_pcvar_num(g_Cvar2[CVAR_HOSTNRESBONUS]));
			}
			CheckLevel(i);
		}
	}
	else if(equal(arg, "All_Hostages_Rescued"))
	{
		if(!g_Cvar2[CVAR_ENABLED])
			return PLUGIN_HANDLED;
		
		for(new i = 1; i <= g_iMaxPlayers; ++i)
		{
			if(!IsPlayer(i))
				return PLUGIN_HANDLED;
				
			if(is_user_alive(i) && get_user_team(i) == 2)
			{
				g_XP[i][XP][g_XP[i][Class]] +=  get_pcvar_num(g_Cvar2[CVAR_HOSTRESBONUS]);
				ShowSyncHudMsg(i, gHudSyncXp, "+ %d", get_pcvar_num(g_Cvar2[CVAR_HOSTRESBONUS]));
			}
			CheckLevel(i);
		}
	}

	return PLUGIN_CONTINUE;
}

public eTeamInfo() 
{ 
	new id = read_data(1);
	new szTeam[2];
	read_data(2, szTeam, charsmax(szTeam));
	switch(szTeam[0])
	{
		case 'T': 
		{
			if(++iTeamInfoCounter[id] == 2)
			{
				if(get_pcvar_num(g_Cvar2[CVAR_DEATHMATCH]) && !is_user_alive(id))
				{
					set_task(get_pcvar_float(g_Cvar2[CVAR_RESPAWNTIME]), "RespawnPlayer", id);
					set_task(0.01, "RespawnHud", id);
				}
			}
			
			if(g_iPlayerTeam[id] == CS_TEAM_SPECTATOR)
			{
				if(get_pcvar_num(g_Cvar2[CVAR_DEATHMATCH]) && !bBombPlanted)
				{
					set_task(get_pcvar_float(g_Cvar2[CVAR_RESPAWNTIME]), "RespawnPlayer", id);
					set_task(0.01, "RespawnHud", id);
				}
			}
			else if(g_iPlayerTeam[id] == CS_TEAM_CT)
			{
				--g_ClassCounter[g_iPlayerTeam[id]][g_XP[id][Class]];
				if(g_XP[id][Class] == CLASS_MEDIC)
				{
					--g_iMedicCount[g_iPlayerTeam[id]];
					g_iMedicID[g_iPlayerTeam[id]][id] = 0;
				}
				else if(g_XP[id][Class] == CLASS_SUPPORT)
				{
					--g_iSupportCount[g_iPlayerTeam[id]];
					g_iSupportID[g_iPlayerTeam[id]][id] = 0;
				}
				
				g_iPlayerTeam[id] = CS_TEAM_T;
				
				if(g_ClassCounter[g_iPlayerTeam[id]][g_XP[id][Class]] >= get_pcvar_num(g_Cvar3[g_iPlayerTeam[id]][g_XP[id][Class]]))
				{
					g_XP[id][Class] = CLASS_NONE;
				}
				else
				{
					++g_ClassCounter[g_iPlayerTeam[id]][g_XP[id][Class]];
					if(g_XP[id][Class] == CLASS_MEDIC)
					{
						++g_iMedicCount[g_iPlayerTeam[id]];
						g_iMedicID[g_iPlayerTeam[id]][id] = id;
					}
					else if(g_XP[id][Class] == CLASS_SUPPORT)
					{
						++g_iSupportCount[g_iPlayerTeam[id]];
						g_iSupportID[g_iPlayerTeam[id]][id] = 0;
					}
				}
			}
			g_iPlayerTeam[id] = CS_TEAM_T;
		}
		case 'C': 
		{
			if(++iTeamInfoCounter[id] == 2)
			{
				if(get_pcvar_num(g_Cvar2[CVAR_DEATHMATCH]) && !is_user_alive(id))
				{
					set_task(get_pcvar_float(g_Cvar2[CVAR_RESPAWNTIME]), "RespawnPlayer", id);
					set_task(0.01, "RespawnHud", id);
				}
			}
			
			if(g_iPlayerTeam[id] == CS_TEAM_SPECTATOR)
			{
				if(get_pcvar_num(g_Cvar2[CVAR_DEATHMATCH]) && !bBombPlanted)
				{
					set_task(get_pcvar_float(g_Cvar2[CVAR_RESPAWNTIME]), "RespawnPlayer", id);
					set_task(0.01, "RespawnHud", id);
				}
			}			
			else if(g_iPlayerTeam[id] == CS_TEAM_T)
			{
				--g_ClassCounter[g_iPlayerTeam[id]][g_XP[id][Class]];
				if(g_XP[id][Class] == CLASS_MEDIC)
				{
					--g_iMedicCount[g_iPlayerTeam[id]];
					g_iMedicID[g_iPlayerTeam[id]][id] = 0;
				}
				else if(g_XP[id][Class] == CLASS_SUPPORT)
				{
					--g_iSupportCount[g_iPlayerTeam[id]];
					g_iSupportID[g_iPlayerTeam[id]][id] = 0;
				}
				g_iPlayerTeam[id] = CS_TEAM_CT;
				
				if(g_ClassCounter[g_iPlayerTeam[id]][g_XP[id][Class]] >= get_pcvar_num(g_Cvar3[g_iPlayerTeam[id]][g_XP[id][Class]]))
				{
					g_XP[id][Class] = CLASS_NONE;
				}
				else
				{
					++g_ClassCounter[g_iPlayerTeam[id]][g_XP[id][Class]];
					if(g_XP[id][Class] == CLASS_MEDIC)
					{
						++g_iMedicCount[g_iPlayerTeam[id]];
						g_iMedicID[g_iPlayerTeam[id]][id] = id;
					}
					else if(g_XP[id][Class] == CLASS_SUPPORT)
					{
						++g_iMedicCount[g_iPlayerTeam[id]];
						g_iSupportID[g_iPlayerTeam[id]][id] = 0;
					}
				}				
			}
			g_iPlayerTeam[id] = CS_TEAM_CT;
		}
		case 'S':
		{
			if(g_iPlayerTeam[id] == CS_TEAM_T || g_iPlayerTeam[id] == CS_TEAM_CT)
			{
				--g_ClassCounter[g_iPlayerTeam[id]][g_XP[id][Class]];
				if(g_XP[id][Class] == CLASS_MEDIC)
				{
					--g_iMedicCount[g_iPlayerTeam[id]];
					g_iMedicID[g_iPlayerTeam[id]][id] = 0;
				}
				else if(g_XP[id][Class] == CLASS_SUPPORT)
				{
					--g_iSupportCount[g_iPlayerTeam[id]];
					g_iSupportID[g_iPlayerTeam[id]][id] = 0;
				}
				remove_task(id);
			}
			g_iPlayerTeam[id] = CS_TEAM_SPECTATOR;
		}
	}
}

public fwdHamWeaponReload(const iWeapon)
{
	new id = get_pdata_cbase(iWeapon, m_pPlayer, 4);
	
	if(!is_user_connected(id))
		return HAM_IGNORED;
		
	if(get_pdata_int(iWeapon, m_fInReload, 4))
	{
		if(pev(id, pev_button) & IN_RELOAD)
		{
			if(get_pcvar_num(g_Cvar2[CVAR_SOUNDTOGGLE]))
			{
				switch(random(10))
				{
					case 1, 3, 5, 7, 9: emit_sound(id, CHAN_VOICE, g_Reload_Sounds[random(sizeof(g_Reload_Sounds))], VOL_NORM, ATTN_NORM, 0, PITCH_NORM);
				}
			}
			set_pdata_int(iWeapon, m_iClip, 0, 4);
		}
	}
	return HAM_IGNORED;
}

public fwdObjectCaps(id)
{
	if(!is_user_alive(id))
    {
        return HAM_IGNORED;
    }
	
	if(g_XP[id][Class] == CLASS_MEDIC)
	{
		if(get_pdata_int(id, m_afButtonPressed, 5) & IN_USE)
		{
			static target, body;
			new Float:Distance = get_user_aiming(id, target, body);
			
			new szClassname[32];
			pev(target, pev_classname, szClassname, charsmax(szClassname));
			if(!equal(szClassname, "player") && !equal(szClassname, "grenade"))
			{
				new Float:Time = get_gametime();
				
				if(Time - get_pcvar_float(g_Cvar2[CVAR_HEALWAIT]) > g_flLastHeal[id])
				{
					new minHealth = floatround(get_pcvar_num(g_Cvar[CVAR_HEALTH][g_XP[id][Class]][g_XP[id][Rank]]) * get_pcvar_float(g_Cvar2[CVAR_HEALMIN]));
					
					if(get_user_health(id) <= minHealth)
					{
						new healTime = get_pcvar_num(g_Cvar2[CVAR_HEALTIME]);
						
						IsHealing[id] = true;
						set_pev(id, pev_maxspeed, 1.0);
						g_bCompetedHeal[id] = false;
						Create_BarTime(id, healTime, 0);
						set_task(float(healTime), "HealPlayer", id+TASK_HEAL);
						if(get_pcvar_num(g_Cvar2[CVAR_SOUNDTOGGLE]))
						{
							emit_sound(id, CHAN_VOICE, g_medic_heal, VOL_NORM, ATTN_NORM, 0, PITCH_NORM);
						}
						
						if(is_user_bleeding(id))
						{
							StopBleeding(id);
						}
							
						g_iTarget[id] = id;
						g_flLastHeal[id] = Time;
					}
					else
					{
						client_print(id, print_center, "You can't heal yourself untill your are below %d health", minHealth);
					}
				}
			}
		
			else if(!equal(szClassname, "grenade") && get_user_team(id) == get_user_team(target) && !is_user_bot(target))
			{
				new Float:Time = get_gametime();
				
				if(Time - get_pcvar_float(g_Cvar2[CVAR_HEALWAIT]) > g_flLastHeal[id])
				{
					new iTargetClass = g_XP[target][Class];
					new iTargetRank = g_XP[target][Rank];
					new minHealth = floatround(get_pcvar_num(g_Cvar[CVAR_HEALTH][iTargetClass][iTargetRank]) * get_pcvar_float(g_Cvar2[CVAR_HEALMIN]));
					
					if(Distance <= 50.0)
					{
						if(get_user_health(target) <= minHealth)
						{
						
							new healTime = get_pcvar_num(g_Cvar2[CVAR_HEALTIME]);
							
							IsBeingHealed[target] = true;
							IsHealing[id] = true;
							set_pev(target, pev_maxspeed, 1.0);
							set_pev(id, pev_maxspeed, 1.0);
							Create_BarTime(id, healTime, 0);
							Create_BarTime(target, healTime, 0);
							if(get_pcvar_num(g_Cvar2[CVAR_SOUNDTOGGLE]))
							{
								emit_sound(id, CHAN_VOICE, g_medic_heal, VOL_NORM, ATTN_NORM, 0, PITCH_NORM);
							}
							g_bCompetedHeal[id] = false;
							
							set_task(float(healTime), "HealPlayer", id+TASK_HEAL);
							
							if(is_user_bleeding(target))
							{
								StopBleeding(target);
							}
							
							g_iTarget[id] = target;
							g_flLastHeal[id] = Time;
						}
						else
						{
							client_print(id, print_center, "Player doesn't need health");
						}
					}
					else
					{
						if(get_user_health(target) <= minHealth)
						{
							client_print(id, print_center, "Player needs health");
						}
						else
						{
							client_print(id, print_center, "Player doesn't need health");
						}
					}
				}
				else
				{
					new Result = floatround(g_flLastHeal[id] - (Time - get_pcvar_float(g_Cvar2[CVAR_HEALWAIT])));
					
					client_print(id, print_center, "You must wait %d seconds before you can heal again.", Result);
				}
			}
		}
		else if(get_pdata_int(id, m_afButtonReleased, 5) & IN_USE)
		{
			if(!g_bCompetedHeal[id])
			{
				g_flLastHeal[id] = 0.0;
			}
			StopHealing(id);
			return HAM_IGNORED;
		}
	}
	
	if(g_XP[id][Class] == CLASS_SUPPORT)
	{
		if(get_pdata_int(id, m_afButtonPressed, 5) & IN_USE)
		{
			static target, body;
			new Float:Distance = get_user_aiming(id, target, body);
			
			//Give Your self ammo
			new szClassname[32];
			pev(target, pev_classname, szClassname, charsmax(szClassname));
			
			if(!equal(szClassname, "player") && !equal(szClassname, "grenade"))
			{
				new Float:Time = get_gametime();
				
				if(Time - get_pcvar_float(g_Cvar2[CVAR_GIVEWAIT]) > g_flLastGive[id])
				{
					new currentPrimaryAmmo;
					new currentSecondaryAmmo;
					new maxPrimaryAmmo;
					new maxSecondaryAmmo;
					new szWeapon[32], iWeapons[32], iWeaponNum;
		
					get_user_weapons(id, iWeapons, iWeaponNum);
					
					for(new i = 0; i < iWeaponNum; i++)
					{
						get_weaponname(iWeapons[i], szWeapon, charsmax(szWeapon));
						
						if(NO_BPAMMO & (1 << iWeapons[i]))
							continue;
						
						if(PRIMARY_WEAPON & (1 << iWeapons[i]))
						{
							g_iTargetPrimaryWeapon[id] = iWeapons[i];
							currentPrimaryAmmo = cs_get_user_bpammo(id, iWeapons[i]);
							maxPrimaryAmmo = g_WeaponBPAmmo[iWeapons[i]];
						}
						if(SECONDARY_WEAPON & (1 << iWeapons[i]))
						{
							g_iTargetSecondaryWeapon[id] = iWeapons[i];
							currentSecondaryAmmo = cs_get_user_bpammo(id, iWeapons[i]);
							maxSecondaryAmmo = g_WeaponBPAmmo[iWeapons[i]];
						}
					}
					
					new minPrimaryAmmo = floatround(maxPrimaryAmmo * get_pcvar_float(g_Cvar2[CVAR_MINAMMO]));
					new minSecondaryAmmo = floatround(maxSecondaryAmmo * get_pcvar_float(g_Cvar2[CVAR_MINAMMO]));
					
					if(currentPrimaryAmmo <= minPrimaryAmmo || currentSecondaryAmmo <= minSecondaryAmmo)
					{
						new giveTime = get_pcvar_num(g_Cvar2[CVAR_GIVETIME]);
						
						IsGiving[id] = true;
						set_pev(id, pev_maxspeed, 1.0);
						Create_BarTime(id, giveTime, 0);
						g_bCompetedGive[id] = false;
						
						set_task(float(giveTime), "GivePlayerAmmo", id+TASK_GIVE);
							
						g_iTarget[id] = id;
						g_flLastGive[id] = Time;
					}
					else
					{
						client_print(id, print_center, "You don't need any more ammo");
					}
				}
				else
				{
					new Result = floatround(g_flLastGive[id] - (Time - get_pcvar_float(g_Cvar2[CVAR_GIVEWAIT])));
					
					client_print(id, print_center, " You must wait %d seconds before you can give yourself ammo again.", Result);
				}
			}
			else if(!equal(szClassname, "grenade") && get_user_team(id) == get_user_team(target) && !is_user_bot(target))
			{
				new Float:Time = get_gametime();
				
				if(Time - get_pcvar_float(g_Cvar2[CVAR_GIVEWAIT]) > g_flLastGive[id])
				{
					new currentPrimaryAmmo;
					new currentSecondaryAmmo;
					new maxPrimaryAmmo;
					new maxSecondaryAmmo;
					new szWeapon[32], iWeapons[32], iWeaponNum;
		
					get_user_weapons(target, iWeapons, iWeaponNum);
					
					for(new i = 0; i < iWeaponNum; i++)
					{
						get_weaponname(iWeapons[i], szWeapon, charsmax(szWeapon));
						
						if(NO_BPAMMO & (1 << iWeapons[i]))
							continue;
						
						if(PRIMARY_WEAPON & (1 << iWeapons[i]))
						{
							g_iTargetPrimaryWeapon[target] = iWeapons[i];
							currentPrimaryAmmo = cs_get_user_bpammo(target, iWeapons[i]);
							maxPrimaryAmmo = g_WeaponBPAmmo[iWeapons[i]];
						}
						if(SECONDARY_WEAPON & (1 << iWeapons[i]))
						{
							g_iTargetSecondaryWeapon[target] = iWeapons[i];
							currentSecondaryAmmo = cs_get_user_bpammo(target, iWeapons[i]);
							maxSecondaryAmmo = g_WeaponBPAmmo[iWeapons[i]];
						}
					}
					
					new minPrimaryAmmo = floatround(maxPrimaryAmmo * get_pcvar_float(g_Cvar2[CVAR_MINAMMO]));
					new minSecondaryAmmo = floatround(maxSecondaryAmmo * get_pcvar_float(g_Cvar2[CVAR_MINAMMO]));
					
					if(currentPrimaryAmmo <= minPrimaryAmmo || currentSecondaryAmmo <= minSecondaryAmmo)
					{
						if(Distance <= 50.0)
						{
							new giveTime = get_pcvar_num(g_Cvar2[CVAR_GIVETIME]);
							
							IsGiving[id] = true;
							IsGetting[target] = true;
							set_pev(id, pev_maxspeed, 1.0);
							set_pev(target, pev_maxspeed, 1.0);
							Create_BarTime(id, giveTime, 0);
							Create_BarTime(target, giveTime, 0);
							emit_sound(id, CHAN_VOICE, g_Take_Ammo[random(sizeof(g_Take_Ammo))], VOL_NORM, ATTN_NORM, 0, PITCH_NORM);
							g_bCompetedGive[id] = false;
							set_task(float(giveTime), "GivePlayerAmmo", id+TASK_GIVE);
							
							g_iTarget[id] = target;
							g_flLastGive[id] = Time;
						}
						else
						{
							client_print(id, print_center, "Player needs ammo.");
						}
					}
					else
					{
						client_print(id, print_center, "Player doesn't need ammo.");
					}
				}
				else
				{
					new Result = floatround(g_flLastGive[id] - (Time - get_pcvar_float(g_Cvar2[CVAR_GIVEWAIT])));
					
					client_print(id, print_center, "You must wait %d seconds until you can give ammo again.", Result);
				}
			}
		}
		else if(get_pdata_int(id, m_afButtonReleased, 5) & IN_USE)
		{
			StopGiving(id);
			if(!g_bCompetedGive[id])
			{
				g_flLastGive[id] = 0.0;
			}
			return HAM_IGNORED;
		}
	}
	return HAM_IGNORED;
}

public GivePlayerAmmo(taskid)
{
	new id = taskid - TASK_GIVE;
	new iClass = g_XP[id][Class];
	
	cs_set_user_bpammo(g_iTarget[id], g_iTargetPrimaryWeapon[g_iTarget[id]], g_WeaponBPAmmo[g_iTargetPrimaryWeapon[g_iTarget[id]]]);
	cs_set_user_bpammo(g_iTarget[id], g_iTargetSecondaryWeapon[g_iTarget[id]], g_WeaponBPAmmo[g_iTargetSecondaryWeapon[g_iTarget[id]]]);
	
	
	if(g_iTarget[id] != id)
	{
		g_XP[id][XP][iClass] += get_pcvar_num(g_Cvar2[CVAR_AMMOBONUS]);
		set_hudmessage(0, 255, 50, 0.50, 0.33, 1, 2.0, 2.0);
		ShowSyncHudMsg(id, gHudSyncXp, "+%d", get_pcvar_num(g_Cvar2[CVAR_AMMOBONUS]));
		if(get_pcvar_num(g_Cvar2[CVAR_SOUNDTOGGLE]))
		{
			emit_sound(id, CHAN_VOICE, g_medic_done, VOL_NORM, ATTN_NORM, 0, PITCH_NORM);
		}
	}
	g_bCompetedGive[id] = true;
	StopGiving(id);
}

public StopGiving(id)
{
	remove_task(id+TASK_DISTGIVE);
	remove_task(id+TASK_GIVE);
	Create_BarTime(id, 0, 0);
	Create_BarTime(g_iTarget[id], 0, 0);
	set_pev(id, pev_maxspeed, get_pcvar_float(g_Cvar[CVAR_SPEED][g_XP[id][Class]][g_XP[id][Rank]]));
	set_pev(g_iTarget[id], pev_maxspeed, get_pcvar_float(g_Cvar[CVAR_SPEED][g_XP[g_iTarget[id]][Class]][g_XP[g_iTarget[id]][Rank]]));
	IsGetting[g_iTarget[id]] = false;
	IsGiving[id] = false;
	g_iTarget[id] = 0;
}

public HealPlayer(taskid)
{
	new id = taskid - TASK_HEAL;
	new iClass = g_XP[id][Class];
	
	new iRankTarget = g_XP[g_iTarget[id]][Rank];
	new iClassTarget = g_XP[g_iTarget[id]][Class];
	
	new health = get_user_health(g_iTarget[id]);
	new healAmount = get_pcvar_num(g_Cvar2[CVAR_HEALAMOUNT]);
	new maxHealth = get_pcvar_num(g_Cvar[CVAR_HEALTH][iClassTarget][iRankTarget]);
	
	if(health + healAmount > maxHealth)
	{
		set_user_health(g_iTarget[id], maxHealth);
	}
	else
	{
		set_user_health(g_iTarget[id], health + healAmount);
	}
	
	if(g_iTarget[id] != id)
	{
		g_XP[id][XP][iClass] += get_pcvar_num(g_Cvar2[ CVAR_HEALBONUS ]);
		set_hudmessage(0, 255, 50, 0.50, 0.33, 1, 2.0, 2.0);
		ShowSyncHudMsg(id, gHudSyncXp, "+ %d", get_pcvar_num(g_Cvar2[ CVAR_HEALBONUS ]));
		if(get_pcvar_num(g_Cvar2[CVAR_SOUNDTOGGLE]))
		{
			emit_sound(id, CHAN_VOICE, g_medic_done, VOL_NORM, ATTN_NORM, 0, PITCH_NORM);
		}
	}
	g_bCompetedHeal[id] = true;
	StopHealing(id);
}

public StopHealing(id)
{
	remove_task(id+TASK_DISTANCE);
	remove_task(id+TASK_HEAL);
	Create_BarTime(id, 0, 0);
	Create_BarTime(g_iTarget[id], 0, 0);
	IsBeingHealed[g_iTarget[id]] = false;
	IsHealing[id] = false;
	set_pev(id, pev_maxspeed, get_pcvar_float(g_Cvar[CVAR_SPEED][g_XP[id][Class]][g_XP[id][Rank]]));
	set_pev(g_iTarget[id], pev_maxspeed, get_pcvar_float(g_Cvar[CVAR_SPEED][g_XP[g_iTarget[id]][Class]][g_XP[g_iTarget[id]][Rank]]));
	g_iTarget[id] = 0;
}

public fwdPlayerResetMaxSpeedPost(id)
{

	if(is_user_connected(id))
	{
		new weapon = get_pdata_cbase(id, m_pActiveItem, 5);
		
		if(!pev_valid(weapon))
			return HAM_IGNORED;
		
		new weaponid = get_pdata_int(weapon, m_iID, 4);
		new iClass = g_XP[id][Class];
		new iRank = g_XP[id][Rank];

		if(iClass == CLASS_NONE)
			return HAM_IGNORED;
			
		if(iClass == CLASS_SNIPER)
		{
			switch(weaponid)
			{
				case CSW_KNIFE:
				{
					set_pev(id, pev_maxspeed, get_pcvar_float(g_Cvar[CVAR_SPEED][iClass][iRank]) + 175.0);
					set_user_rendering(id,kRenderFxNone,0,0,0,kRenderTransAlpha,255);
				}
				case CSW_USP, CSW_DEAGLE:
				{
					set_pev(id, pev_maxspeed, get_pcvar_float(g_Cvar[CVAR_SPEED][iClass][iRank]) + 100.0);
					set_user_rendering(id,kRenderFxNone,0,0,0,kRenderTransAlpha, 150);
				}
				case CSW_AWP, CSW_SCOUT, CSW_G3SG1:
				{
					set_pev(id, pev_maxspeed, get_pcvar_float(g_Cvar[CVAR_SPEED][iClass][iRank]) + 70.0);
					set_user_rendering(id,kRenderFxNone,0,0,0,kRenderTransAlpha, 75);
				}
			}
		}
		else
		{
			set_pev(id, pev_maxspeed, get_pcvar_float(g_Cvar[CVAR_SPEED][iClass][iRank]));
		}
		
		if(IsGiving[id] || IsGetting[id] || IsHealing[id] || IsBeingHealed[id])
		{
			set_pev(id, pev_maxspeed, 1.0);
		}
	}
		
	return HAM_IGNORED;
}

public fwdPlayerHurt(iVictim, iInflictor, iAttacker, Float:flDamage, iDmgBits)
{		
	if(is_user_connected(iAttacker) // Makes sure valid target
	&& get_user_team(iAttacker) == get_user_team(iVictim)) //Checks if the same team
	{
		new iVictimClass = g_XP[iVictim][Class];
		
		if(iVictimClass == CLASS_NONE)
			return HAM_IGNORED;
		if(get_pcvar_float(g_iFriendlyFirePointer))
		{
			new Float:flNewDamage = (flDamage * 2.86 ) * floatclamp(get_pcvar_float(g_iFriendlyFirePointer), 0.0, 1.0);
			new Float:flMirrorDamage = (flDamage * 2.86 ) * floatclamp(get_pcvar_float(g_iMirrorDamagePointer), 0.0, 1.0);
			
			if(!get_pcvar_num(g_Cvar2[CVAR_VFFNADES]))
			{
				if(get_pcvar_float(g_iMirrorDamagePointer))
				{
					if(get_pcvar_num(g_Cvar2[CVAR_VFFMIRRORHURT]))
					{
						if(iVictimClass == CLASS_SUPPORT)
						{
							SetHamParamFloat(4, float(TrueArmor(iVictim, flNewDamage)));
						}
						else
						{
							SetHamParamFloat(4, flNewDamage);
						}
					}
					else
					{
						SetHamParamFloat(4, 0.0);
					}
					ExecuteHam(Ham_TakeDamage, iAttacker, iInflictor, iAttacker, flMirrorDamage, iDmgBits);
					client_print(iVictim, print_center, "You have been hurt for attacking a teammate.");
					return HAM_SUPERCEDE;
				}
				else
				{
					if(iVictimClass == CLASS_SUPPORT)
					{
						SetHamParamFloat(4, float(TrueArmor(iVictim, flNewDamage)));
					}
					else
					{
						SetHamParamFloat(4, flNewDamage);
					}
					return HAM_OVERRIDE;
				}
			}
			else
			{
				if(get_user_weapon(iAttacker) != CSW_HEGRENADE)
				{				
					if(get_pcvar_float(g_iMirrorDamagePointer))
					{
						if(get_pcvar_num(g_Cvar2[CVAR_VFFMIRRORHURT]))
						{
							if(iVictimClass == CLASS_SUPPORT)
							{
								SetHamParamFloat(4, float(TrueArmor(iVictim, flNewDamage)));
							}
							else
							{
								SetHamParamFloat(4, flNewDamage);
							}
						}
						else
						{
							SetHamParamFloat(4, float(TrueArmor(iVictim, flNewDamage)));
						}
						
						ExecuteHam(Ham_TakeDamage, iAttacker, iInflictor, iAttacker, flMirrorDamage, iDmgBits);
						client_print(iVictim, print_center, "You have been hurt for attacking a teammate.");
						return HAM_SUPERCEDE;
					}
					else
					{
						if(iVictimClass == CLASS_SUPPORT)
						{
							SetHamParamFloat(4, float(TrueArmor(iVictim, flNewDamage)));
						}
						else
						{
							SetHamParamFloat(4, flNewDamage);
						}
						return HAM_OVERRIDE;
					}
					return HAM_OVERRIDE;
				}
			}
		}
	}
	return HAM_IGNORED;
}

public TrueArmor(id, Float:flDamage)
{
	new CsArmorType:iPlayerArmorType;
	new Float:armor = float(cs_get_user_armor(id, iPlayerArmorType));
	if(armor > 0)
	{
		new Float:new_armor = armor - flDamage;
		
		if(new_armor < 0)
		{
			cs_set_user_armor(id, 0, CS_ARMOR_NONE);
			return floatround(flDamage - armor);
		}
		else
		{
			cs_set_user_armor(id, floatround(new_armor, floatround_round), CS_ARMOR_VESTHELM);
			return 0;
		}
	}
	else
	{
		return floatround(flDamage);
	}
	return PLUGIN_CONTINUE;
}

public fwdPlayerHurtPost(iVictim, iInflictor, iAttacker, Float:flDamage, iDmgbits)
{
	new iVictimClass = g_XP[iVictim][Class];
	new iVictimRank = g_XP[iVictim][Rank];
	
	if(iVictimClass == CLASS_NONE)
		return HAM_IGNORED;
	
	if(is_user_alive(iVictim) && get_pcvar_num(g_Cvar2[CVAR_BLEEDTOGGLE]) && !is_user_bleeding(iVictim))
	{
		new playerHealth = get_user_health(iVictim);
		new minHealth = floatround(get_pcvar_num(g_Cvar[CVAR_HEALTH][iVictimClass][iVictimRank]) * get_pcvar_float(g_Cvar2[CVAR_STARTBLEED]));
		if(playerHealth <= minHealth)
		{
			CreateFollowEnt(iVictim);
		}
	}
	return HAM_IGNORED;
}

public fwdPlayerSpawn(id)
{
	if(!g_Cvar2[CVAR_ENABLED])
		return PLUGIN_HANDLED;
		
	if(is_user_bot(id))
	{
		set_task(0.1, "protect", id);
	}
	else
	{
		if(bBombPlanted)
		{
			bBombPlanted = false;
		}
			
		if(is_user_connected(id) && is_user_alive(id))
		{
		
			IsBeingHealed[id] = false;
			IsHealing[id] = false;
			StripUserWeapons(id);
			
			set_user_rendering(id,kRenderFxNone,0,0,0,kRenderTransAlpha, 255);
			
			if(is_user_bleeding(id))
			{
				StopBleeding(id);
			}
			
			if(g_NewClass[id])
			{
				--g_ClassCounter[cs_get_user_team(id)][g_XP[id][Class]];
				g_XP[id][Class] = CLASS_NONE;
				g_NewClass[id] = false;
			}
			
			if(g_XP[id][Class] == CLASS_NONE)
			{
				menu_display(id , g_ClassMenu , 0);
			}
			else
			{
				set_task(0.01, "SetSkill", id);
			}
			if (g_bomb_targ && cs_get_user_team(id) == CS_TEAM_CT)
			{
				cs_set_user_defuse(id, 1);
			}
			
			set_task(0.1, "protect", id);
		}
	}
	return PLUGIN_CONTINUE;
}

public HandleClassMenu(id , iMenu , iItem) 
{
	new szKey[3] , iSelectedClass , Dummy;
	menu_item_getinfo(iMenu , iItem , Dummy , szKey , 2 , "" , 0 , Dummy);
	
	iSelectedClass = str_to_num(szKey);
	
	if(iSelectedClass == CLASS_NONE)
		return PLUGIN_HANDLED;
	
	if(g_ClassCounter[g_iPlayerTeam[id]][iSelectedClass] >= get_pcvar_num(g_Cvar3[g_iPlayerTeam[id]][iSelectedClass]))
	{
		menu_display(id, g_ClassMenu, 0);
		client_print(id, print_chat, "[%s] Sorry. The class ^"%s^" is full. Please choose another.", g_szPrefixName, g_ClassDesc[iSelectedClass]);
	}
	else
	{
		++g_ClassCounter[g_iPlayerTeam[id]][iSelectedClass];
		if(g_XP[id][Class] == CLASS_MEDIC)
		{
			g_iMedicID[g_iPlayerTeam[id]][id] = 0;
			--g_iMedicCount[g_iPlayerTeam[id]];
		}
		else if(g_XP[id][Class] == CLASS_SUPPORT)
		{
			--g_iSupportCount[g_iPlayerTeam[id]];
			g_iSupportID[g_iPlayerTeam[id]][id] = 0;
		}
		
		ChangeClass(id, iSelectedClass);
		
		if(iSelectedClass == CLASS_MEDIC)
		{
			g_iMedicID[g_iPlayerTeam[id]][id] = id;
			++g_iMedicCount[g_iPlayerTeam[id]];
		}
		else if(iSelectedClass == CLASS_SUPPORT)
		{
			++g_iSupportCount[g_iPlayerTeam[id]];
			g_iSupportID[g_iPlayerTeam[id]][id] = id;
		}
		client_print(id, print_chat, "[%s]To select a new class write /class in the chat. ", g_szPrefixName);
	}
	
	return PLUGIN_HANDLED;
}

public ChangeClass(id , NewClass) 
{
	new i;
	
	g_XP[id][Class] = NewClass; 
	g_XP[id][Rank] = 0; 
	
	
	for (i = 0 ; i < sizeof(g_RankXP) ; i++) 
	{ 
		if (g_RankXP[i][0] <= g_XP[id][XP][NewClass] <= g_RankXP[i][1]) 
		{ 
			g_XP[id][Rank] = i; 
			break;  
		} 
	}
	
	SetSkill(id);
	
	return PLUGIN_HANDLED;  
}

public cmdSayClass(id) 
{ 
	if(!g_Cvar2[CVAR_ENABLED])
		return PLUGIN_HANDLED;
	
	if(g_XP[id][Class] == CLASS_NONE)
	{
		menu_display(id , g_ClassMenu , 0);
	}
	else
	{
		g_NewClass[id] = true;
		client_print(id, print_chat, "[%s] You may choose a new class when you respawn.", g_szPrefixName);
	}
	return PLUGIN_HANDLED;
}

public HudShow(iEnt)
{
	for(new id = 1; id <= g_iMaxPlayers; id++)
	{
		ShowHud(id);
	}
	set_pev(iEnt, pev_nextthink, get_gametime() + 1.0);
}

public ShowHud(id)
{
	if(IsPlayer(id) && is_user_connected(id))
	{
		if(g_XP[id][Class] != CLASS_NONE)
		{
			set_hudmessage(255, 0, 0, 0.02, 0.26, 0, 0.0, 1.0,_ ,_, -1);
			ShowSyncHudMsg(id, gHudSync, "[Class: %s] ^n[Rank: %s] ^n[XP: %d / %d]", g_ClassDesc[g_XP[id][Class]], g_RankDesc[g_XP[id][Rank]], g_XP[id][XP][g_XP[id][Class]], ( g_XP[ id ][ Rank ] + 1 )== RANKS ?  g_RankXP[ g_XP[ id ][ Rank ] ][ 1 ] : g_RankXP[ g_XP[ id ][ Rank ] + 1 ][ 0 ] );
		}
	}
}

public RespawnHud(id)
{
	set_hudmessage(255, 1, 1, -1.0, 0.3, 0, 6.0, get_pcvar_float(g_Cvar2[CVAR_RESPAWNTIME]), 0.1, 0.2, 4);
	show_hudmessage(id, "** You will respawn in %d seconds **", get_pcvar_num(g_Cvar2[CVAR_RESPAWNTIME]));
}	

stock StripUserWeapons(id)
{
	new iC4Ent = get_pdata_cbase(id, OFFSET_C4_SLOT);
	
	if( iC4Ent > 0 )
	{
		set_pdata_cbase(id, OFFSET_C4_SLOT, FM_NULLENT);
	}

	strip_user_weapons(id);
	give_item(id, "weapon_knife");
	set_pdata_int(id, OFFSET_PRIMARYWEAPON, 0);

	if( iC4Ent > 0 )
	{
		set_pev(id, pev_weapons, pev(id, pev_weapons) | (1<<CSW_C4));
		set_pdata_cbase(id, OFFSET_C4_SLOT, iC4Ent);
		cs_set_user_bpammo(id, CSW_C4, 1);
		cs_set_user_plant(id, 1);
	}
	return PLUGIN_HANDLED;
}

public RespawnPlayer(id)
{
	if(!is_user_connected(id))
		return PLUGIN_HANDLED;
		
	ExecuteHamB(Ham_CS_RoundRespawn, id);
	return PLUGIN_CONTINUE;
}

public protect(id)
{
	set_user_godmode(id, 1);
	
	if(get_pcvar_num(g_Cvar2[CVAR_SPGLOW]))
	{ 
		
		switch(cs_get_user_team(id))
		{
			case CS_TEAM_T: set_user_rendering(id, kRenderFxGlowShell, 255, 0, 0, kRenderNormal, 25);
			case CS_TEAM_CT: set_user_rendering(id, kRenderFxGlowShell, 0, 0, 255, kRenderNormal, 25);
		}
	}
	
	if(get_pcvar_num(g_Cvar2[CVAR_SPHUD]))
	{
		set_hudmessage(255, 1, 1, -1.0, 0.3, 0, 6.0, get_pcvar_float(g_Cvar2[CVAR_SPTIME]), 0.1, 0.2, 4);
		show_hudmessage(id, "** Spawn Protection is Active **");
	}
	
	set_task(get_pcvar_float(g_Cvar2[CVAR_SPTIME]), "sp_off", id);
	return PLUGIN_HANDLED;
}

public sp_off(id) 
{
	if(!is_user_connected(id))
		return PLUGIN_HANDLED;
	
	set_user_godmode(id, 0);
	set_user_rendering(id, kRenderFxGlowShell, 0, 0,0, kRenderNormal, 0);
	return PLUGIN_HANDLED;
}

stock Create_BarTime(id, duration, flag)
{

	if( is_user_connected(id) && !is_user_bot(id))
	{

		message_begin(MSG_ONE, gmsgBarTime, {0,0,0}, id);
		write_byte(duration); // duration 
		write_byte(flag);
		message_end();
	
	}
}

public cmdMedicCall(id)
{
	new Float:Time = get_gametime();
	if(Time - g_flLastMedicCall[id] <= get_pcvar_float(g_Cvar2[CVAR_CALLWAIT]))
	{
		new Result = floatround(g_flLastMedicCall[id] - (Time - get_pcvar_float(g_Cvar2[CVAR_CALLWAIT])));
		client_print(id, print_center, "You must wait %d before you can call again.", Result);
	}
	else
	{
		new iClass = g_XP[id][Class];
		new iRank = g_XP[id][Rank];
		
		if(iClass == CLASS_MEDIC)
			return PLUGIN_HANDLED;
		
		new szPlayerName[32];
		get_user_name(id, szPlayerName, charsmax(szPlayerName));
		
		new minHealth = floatround(get_pcvar_num(g_Cvar[CVAR_HEALTH][iClass][iRank]) * get_pcvar_float(g_Cvar2[CVAR_HEALMIN]));
		
		if(g_iMedicCount[g_iPlayerTeam[id]])
		{
			if(get_user_health(id) <= minHealth)
			{
				for(new i = 0; i < g_iMedicCount[g_iPlayerTeam[id]]; i++)
				{
					client_print(g_iMedicID[g_iPlayerTeam[id]][i], print_center, "%s has called for a medic!!!!", szPlayerName);
				}
				if(get_pcvar_num(g_Cvar2[CVAR_SOUNDTOGGLE]))
				{
					emit_sound(id, CHAN_VOICE, g_medic_calls[random(sizeof(g_medic_calls))], VOL_NORM, ATTN_NORM, 0, PITCH_NORM);
				}
				g_flLastMedicCall[id] = Time;
			}
			else
			{
				client_print(id, print_center, "You must have less then %d health to call for medic", g_szPrefixName, minHealth);
			}
		}
		else
		{
				client_print(id, print_center, "There isn't currently a medic available!!");
		}
	}
	return PLUGIN_CONTINUE;
}

public cmdAmmoCall(id)
{
	new Float:Time = get_gametime();
	if(Time - g_flLastAmmoCall[id] <= get_pcvar_float(g_Cvar2[CVAR_CALLWAIT]))
	{
		new Result = floatround(g_flLastAmmoCall[id] - (Time - get_pcvar_float(g_Cvar2[CVAR_CALLWAIT])));
		client_print(id, print_center, "You must wait %d before you can call again.", Result);
	}
	else
	{
		new iClass = g_XP[id][Class];
		
		if(iClass == CLASS_SUPPORT)
			return PLUGIN_HANDLED;
		
		new szPlayerName[32];
		get_user_name(id, szPlayerName, charsmax(szPlayerName));
		
		new currentPrimaryAmmo;
		new currentSecondaryAmmo;
		new maxPrimaryAmmo;
		new maxSecondaryAmmo;
		new szWeapon[32], iWeapons[32], iWeaponNum;

		get_user_weapons(id, iWeapons, iWeaponNum);
		
		for(new i = 0; i < iWeaponNum; i++)
		{
			get_weaponname(iWeapons[i], szWeapon, charsmax(szWeapon));
			
			if(NO_BPAMMO & (1 << iWeapons[i]))
				continue;
			
			if(PRIMARY_WEAPON & (1 << iWeapons[i]))
			{
				g_iTargetPrimaryWeapon[id] = iWeapons[i];
				currentPrimaryAmmo = cs_get_user_bpammo(id, iWeapons[i]);
				maxPrimaryAmmo = g_WeaponBPAmmo[iWeapons[i]];
			}
			if(SECONDARY_WEAPON & (1 << iWeapons[i]))
			{
				g_iTargetSecondaryWeapon[id] = iWeapons[i];
				currentSecondaryAmmo = cs_get_user_bpammo(id, iWeapons[i]);
				maxSecondaryAmmo = g_WeaponBPAmmo[iWeapons[i]];
			}
		}
		
		new minPrimaryAmmo = floatround(maxPrimaryAmmo * get_pcvar_float(g_Cvar2[CVAR_MINAMMO]));
		new minSecondaryAmmo = floatround(maxSecondaryAmmo * get_pcvar_float(g_Cvar2[CVAR_MINAMMO]));
		
		if(g_iSupportCount[g_iPlayerTeam[id]])
		{
			if(currentPrimaryAmmo <= minPrimaryAmmo || currentSecondaryAmmo <= minSecondaryAmmo)
			{
				for(new i = 0; i < g_iSupportCount[g_iPlayerTeam[id]]; i++)
				{
					client_print(g_iSupportID[g_iPlayerTeam[id]][i], print_center, "%s has called for ammo!!!!", szPlayerName);
				}
				if(get_pcvar_num(g_Cvar2[CVAR_SOUNDTOGGLE]))
				{
					emit_sound(id, CHAN_VOICE, g_Ammo_Calls[random(sizeof(g_Ammo_Calls))], VOL_NORM, ATTN_NORM, 0, PITCH_NORM);
				}
				g_flLastAmmoCall[id] = Time;
			}
			else
			{
				client_print(id, print_center, "You to much ammo to call for medic", g_szPrefixName);
			}
		}
		else
		{
				client_print(id, print_center, "Support gunner not currently available!!");
		}
	}
	return PLUGIN_CONTINUE;
}

public CreateFollowEnt(id)
{
	static ent, HamHook:Think;
	ent = engfunc(EngFunc_CreateNamedEntity,engfunc(EngFunc_AllocString,"info_target"));
	
	if(pev_valid(ent))
	{
		set_pev(ent, pev_aiment, id);
		set_pev(ent, pev_movetype, MOVETYPE_FOLLOW);
		set_pev(ent, pev_owner, id);
		set_pev(ent, pev_iuser1, BLEED_ENT);
		
		set_pev(ent, pev_nextthink, get_gametime() + 1.0);
		
		g_ent[id] = ent;
		Is_Bleeding[id] = true;
		
		if(!Think)
		{
			Think = RegisterHamFromEntity(Ham_Think, ent, "Think_Bleed");
		}
	}
}

//Thinking part of ent
public Think_Bleed(ent)
{
	new id = pev(ent, pev_owner);
		
	if(pev(ent, pev_iuser1) == BLEED_ENT && FakeBleed(id))
	{
		set_pev(ent, pev_nextthink, get_gametime() + random_float(1.0, get_pcvar_float(g_Cvar2[CVAR_BLEEDTIME])));
	}
}

//Preform the bleeding
public FakeBleed(id)
{
	if(!is_user_alive(id) || !is_user_bleeding(id))
		return PLUGIN_HANDLED;
	
	new Float:playerHealth;
	pev(id, pev_health, playerHealth);
	new minHealth = floatround(get_pcvar_num(g_Cvar[CVAR_HEALTH][g_XP[id][Class]][g_XP[id][Rank]]) * get_pcvar_float(g_Cvar2[CVAR_STOPBLEED]));
	
	if(playerHealth <= minHealth)
	{
		StopBleeding(id);
		return PLUGIN_HANDLED;
	}
	
	//Begin Connors Bleeding Fucntion
	new trace_handled;
	new Float:flFraction, Float:fDirection[3];
	new Float:start[3], Float:dest[3];

	trace_handled = create_tr2();
	pev(id, pev_origin, start);
	
	new iOrigin[3];
	
	iOrigin[0] = floatround(start[0]);
	iOrigin[1] = floatround(start[1]);
	iOrigin[2] = floatround(start[2]);

	dest[0] = start[0];
	dest[1] = start[1];
	dest[2] = start[2] - 9999.0;
				
	engfunc(EngFunc_TraceLine, start, dest, IGNORE_MONSTERS, id, trace_handled);
	get_tr2(trace_handled, TR_flFraction, flFraction);
	
	if( flFraction != 1.0 )
	{
		fDirection[0] = random_float(-1.0, 1.0);
		fDirection[1] = random_float(-1.0, 1.0);
		fDirection[2] = random_float(-1.0, 0.0);
		ExecuteHam(Ham_TraceBleed, id, 50.0, fDirection, trace_handled, DMG_BULLET);
		fxBleed(iOrigin);
		set_pev(id, pev_health, playerHealth - random_float(1.0, 3.0));
	}
	
	free_tr2(trace_handled);
	//End Connors Bleeding Function	
	return 1;
}

//Blood Squirt effect
stock fxBleed(origin[3])
{
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
	write_byte(TE_BLOODSTREAM);
	write_coord(origin[0]);
	write_coord(origin[1]);
	write_coord(origin[2]+10);
	write_coord(random_num(-360,360));
	write_coord(random_num(-360,360));
	write_coord(-10);
	write_byte(70);
	write_byte(random_num(50,100));
	message_end();
}

public bool:is_user_bleeding(id)
	return Is_Bleeding[id];

public StopBleeding(id)
{
	if(!pev_valid(g_ent[id]))
		return PLUGIN_HANDLED;
	
	set_pev(g_ent[id], pev_flags, FL_KILLME);
	g_ent[id] = 0;
	Is_Bleeding[id] = false;
	
	return PLUGIN_CONTINUE;
}

public RegisterSettingsCvars()
{	
	new settingsCvar[64];
	for(new iCvar = 0; iCvar < CVARS; iCvar++)
	{
		formatex(settingsCvar, charsmax(settingsCvar), "bf_%s", g_SettingsCvarDesc[iCvar]);
		g_Cvar2[iCvar] = register_cvar(settingsCvar, "");
	}
	
	new limitCvar[64];
	for(new CsTeams:team = CS_TEAM_T, class; team <= CS_TEAM_CT; team++) 
	{
		for(class = 1; class < CLASSES; class++) 
		{
			formatex(limitCvar, charsmax(limitCvar), "bf_%st%slimit", (team == CS_TEAM_T) ? "" : "c", classLimitDesc[class]);
			g_Cvar3[team][class] = register_cvar(limitCvar, classLimitDefault[class]);
		}
	}
}

public RegisterClassRankCvars()
{
	new classRankCvar[64], cvarDesc[8], len, len2;
	for(new class = 1, rank, var; class < CLASSES; class++) 
	{
		len = copy(classRankCvar, charsmax(classRankCvar), g_ClassCvarDesc[class]);
		
		for(rank = 0; rank < RANKS; rank++) 
		{
			len2 = len + formatex(classRankCvar[len], charsmax(classRankCvar) - len, "%s_", g_RankCvarDesc[rank]);
			
			for(var = 0; var < CLASSRANKCVAR; var++)
			{
				copy(cvarDesc, charsmax(cvarDesc), g_CvarDesc[var]);
				copy(classRankCvar[len2], charsmax(classRankCvar) - len2, cvarDesc);
				g_Cvar[var][class][rank] = register_cvar(classRankCvar, "");
			}
		}
	}
}

public SetSkill(id)
{
	new iClass, iRank;
	iClass = g_XP[id][Class];
	iRank = g_XP[id][Rank];
	
	if(iClass == CLASS_NONE)
		return PLUGIN_HANDLED;
	
	new szPwep[32], szSwep[32];
		
	get_pcvar_string(g_Cvar[CVAR_PWEP][iClass][iRank], szPwep, 32);
	get_pcvar_string(g_Cvar[CVAR_SWEP][iClass][iRank], szSwep, 32);
	new iPrimaryWeaponId = get_weaponid(szPwep);
	new iSecondaryWeaponId = get_weaponid(szSwep);
	
	give_item(id, szPwep);
	give_item(id, szSwep);
	
	cs_set_user_bpammo(id , iPrimaryWeaponId, g_WeaponBPAmmo[iPrimaryWeaponId]);
	cs_set_user_bpammo(id , iSecondaryWeaponId, g_WeaponBPAmmo[iSecondaryWeaponId]);
	
	set_user_health(id, get_pcvar_num( g_Cvar[ CVAR_HEALTH ][ iClass ][ iRank ] ));
	
	cs_set_user_armor(id, get_pcvar_num( g_Cvar[ CVAR_ARMOR ][ iClass ][ iRank ] ), CS_ARMOR_VESTHELM);
	
	set_user_maxspeed(id, get_pcvar_float( g_Cvar[ CVAR_SPEED ][ iClass ][ iRank ]));
	
	set_user_gravity(id, get_pcvar_float(g_Cvar[ CVAR_GRAVITY ][ iClass ][ iRank ] ));
	
	give_item(id, "weapon_hegrenade");
	
	give_item(id, "weapon_flashbang");
	cs_set_user_bpammo(id, CSW_FLASHBANG, 2);
	
	give_item(id, "weapon_smokegrenade");
		
	if(iClass == CLASS_SPECOPS || iClass == CLASS_SNIPER || iClass == CLASS_ENGINEER)
	{
		set_user_footsteps(id, 1);
	}
	else
	{
		set_user_footsteps(id, 0);
	}
	return PLUGIN_CONTINUE;
}

#if defined USE_NVAULT
	public SaveData( id )
	{
		new iPos , szSave[(XPDATA * 10) + 1];
		
		for (new i = 0 ; i < XPDATA ; i++)
		{
			iPos += formatex(szSave[iPos] ,charsmax(szSave) , "%10d" , g_XP[id][i]);
		}
		nvault_set(g_hVault, g_szAuthID[ id ], szSave);
	}

	public LoadData(id)
	{
		new iPos , szNum[11] , szLoad[(XPDATA * 10 )+1];
		
		nvault_get(g_hVault, g_szAuthID[ id ], szLoad , charsmax(szLoad));
		
		for (new i = 0 ; i < XPDATA ; i++)
		{    
			iPos += copy(szNum , 10 , szLoad[ iPos ]);
			g_XP[id][i] = str_to_num(szNum); 
		}
		
		g_XP[id][Class] = CLASS_NONE;
	}
#else
	public SaveData( id )
	{
		if(sqlv_connect(g_hVault))
		{
			new iPos, szSave[(XPDATA * 10) + 1];
			
			for (new i = 0 ; i < XPDATA ; i++)
			{
				iPos += formatex(szSave[iPos] ,charsmax(szSave) , "%10d" , g_XP[id][i]);
				sqlv_set_data(g_hVault, g_szAuthID[id], szSave);
			}
			
			sqlv_disconnect(g_hVault);
		}
		else
		{
			set_fail_state("Error Connecting to SQLVault");
		}
	}

	public LoadData(id)
	{
		if(sqlv_connect(g_hVault))
		{
			new iPos, szNum[11] , szLoad[(XPDATA * 10 )+1];
			
			sqlv_get_data(g_hVault, g_szAuthID[id], szLoad , charsmax(szLoad));
			
			for (new i = 0 ; i < XPDATA ; i++)
			{    
				iPos += copy(szNum , 10 , szLoad[ iPos ]);
				g_XP[id][i] = str_to_num(szNum); 
			}
			
			g_XP[id][Class] = CLASS_NONE;
			
			sqlv_disconnect(g_hVault);
		}
		else
		{
			set_fail_state("Error Connecting to SQLVault");
		}
	}
#endif

//Natives

public _set_user_xp(iPlugin, iParams)
{
	new id = get_param(1);
	new iAmmount = get_param(2);
	g_XP[id][XP][g_XP[id][Class]] = iAmmount;
	CheckLevel(id);
}

public _rem_user_xp(iPlugin, iParams)
{
	new id = get_param(1);
	new iAmmount = get_param(2);
	g_XP[id][XP][g_XP[id][Class]] -= iAmmount;
	CheckLevel(id);
}

public _add_user_xp(iPlugin, iParams)
{
	new id = get_param(1);
	new iAmmount = get_param(2);
	g_XP[id][XP][g_XP[id][Class]] += iAmmount;
	CheckLevel(id);
}

public _get_user_totalxp(iPlugin, iParams)
{
	new id = get_param(1);
	
	return g_XP[id][XPTotal];
}

public _get_user_xp(iPlugin, iParams)
{
	new id = get_param(1);
	
	return g_XP[id][XP][g_XP[id][Class]];
}

public _get_user_class(iPlugin, iParams)
{
	new id = get_param(1);
	set_string(2, g_RankDesc[g_XP[id][Class]], get_param(3));
	return 2;
}

public _get_user_rank(iPlugin, iParams)
{
	new id = get_param(1);
	set_string(2, g_RankDesc[g_XP[id][Rank]], get_param(2));
	return 2;
}