///////////////////////////////////////////////////////////
//
// "RoyDarkle"
// Ryan Thaut
// 11.08.2007
//
// Last Modified: 01.17.2010
// Version: 1.24
//
// Sections:
//		Colors			- all the colors used by the scheme
//		BaseSettings	- contains settings for app to use to draw controls
//		Controls		- contains all controls and their attributes
//		Fonts			- list of all the fonts used by app
//		Appearances		- description of all the borders
//
///////////////////////////////////////////////////////////
Scheme
{
	//////////////////////// COLORS ///////////////////////////
	// color details
	// this is a list of all the colors used by the scheme
	Colors
	{
		// Basic Colors
		"Black"									"000 000 000 255"
		"Blank"									"255 255 255 000"
		"White"									"255 255 255 255"
		
		// Frame Colors
		"FrameBaseColor"						"019 020 022 255"
		"BaseBorderColor"						"064 064 064 255"
		
		"FrameBorderLight"						"196 196 196 255"
		"FrameBorderDark"						"000 000 000 255"
		
		// Tab Colors
		"TabNormalTextColor"					"166 166 166 255"
		"TabHoverTextColor"						"255 255 255 255"
		"TabActiveTextColor"					"255 255 255 255"
		"TabBorderOverlapColor"					"020 021 023 255"
		
		// Text Colors
		"DarkTextColor"							"064 064 064 255"
		"DefaultTextColorLight"					"255 255 255 255"
		"DefaultTextColorDark"					"000 000 000 255"
		"DimTextColor"							"096 096 096 255"
		"DisabledTextColor"						"166 166 166 255"
		"HoverTextColor"						"201 224 250 255"
		"HoverTextColorLight"					"200 200 200 255"
		"HoverTextColorDark"					"000 064 128 255"
		"SelectedTextColor"						"255 255 255 255"
		"SelectedBGColor"						"000 064 128 255"
		"URLTextColor"							"201 224 250 255"
		"NotificationBodyText"					"200 200 200 255"
		
		"ProgressColor"							"050 150 255 255"
		
		// Scroll Bar Colors
		"ScrollButtonColor"						"166 166 166 255"
		"ScrollButtonHoverColor"				"255 255 255 255"
		"ScrollTrackColor"						"019 020 022 255"
		
		"TitleTopLight"							"134 134 134 255"
		"TitleTopDark"							"075 076 080 255"
		"TitleBottomLight"						"028 028 030 255"
		"TitleBottomDark"						"019 020 022 255"
		
		"ToolTipTopColor"						"080 080 080 255"
		"ToolTipBottomColor"					"019 020 022 255"
		"ToolTipBorderColor"					"135 135 135 255"
		
		// Divider Colors
		"DividerDark"							"000 064 128 255"
		
		// Border Colors
		"BorderBright"							"100 100 100 255"
		"BorderDark"							"040 040 040 255"
		"BorderSelection"						"000 000 000 255"
	}
	

	///////////////////// BASE SETTINGS ////////////////////////
	//
	// default settings for all panels
	// controls use these to determine their settings
	BaseSettings
	{
		// vgui_controls color specifications
		Border.Bright							BorderBright
		Border.Dark								BorderDark
		Border.Selection						BorderSelection
		CheckButton.BgColor						Blank
		CheckButton.Border1  					Blank
		CheckButton.Border2  					Blank
		CheckButton.Check						White
		DragDrop.DragFrame						"255 255 255 192"
		DragDrop.DropFrame						"255 255 255 255"
		Frame.ClientInsetX						10
		Frame.ClientInsetY						35
		Frame.BgColor							DefaultTextColorLight
		Frame.OutOfFocusBgColor					DefaultTextColorLight
		Frame.FocusTransitionEffectTime			"0"
		Frame.TransitionEffectTime				"0.25"
		Frame.OnDragAlphaDelayTime				"0.15"
		Frame.OnDragAlphaMultiplier				"1.0"
		Frame.AutoSnapRange						"6"
		Frame.UsesAlphaBlending					1
		FrameSystemButton.Icon					"Resource/icon_steam"
		FrameSystemButton.DisabledIcon			"Resource/icon_steam_disabled"
		Notifications.PanelPosition				"BottomRight"
		Notifications.SlideDirection			"Vertical"
		Notifications.FadeInTime				"0.55"
		Notifications.FadeOutTime				"0.55"
		Notifications.DisplayTime				"6.0"
		Notifications.StackSize					"3"
		ListPanel.TextColor						DefaultTextColorLight
		ListPanel.BgColor						Blank
		ListPanel.SelectedTextColor				SelectedTextColor
		ListPanel.SelectedBgColor				SelectedBGColor
		ListPanel.SelectedOutOfFocusBgColor		SelectedBGColor
		ListPanel.DisabledTextColor				DisabledTextColor
		ListPanel.DisabledSelectedTextColor		DisabledTextColor
		ListPanel.EmptyListInfoTextColor		DimTextColor
		ListPanel.RowHeight						20
		ListPanel.PerPixelScrolling				1
		Menu.TextInset							6
		Panel.FgColor							DefaultTextColorLight
		Panel.BgColor							ScrollTrackColor
		PropertySheet.TransitionEffectTime		0
		PropertySheet.TabGap					0
		RichText.TextColor						DefaultTextColorLight
		RichText.BgColor						Blank
		RichText.SelectedTextColor				SelectedTextColor
		RichText.SelectedBgColor				SelectedBGColor
		RichText.InsetX							6
		RichText.InsetY							6
		RichText.URLColor						HoverTextColor
		RuleColor								Blank
		ScrollBar.Wide							18
		SectionedListPanel.CollapserWidth		16
		TextEntry.CursorColor					White
		TextEntry.IMEBGColor					"225 225 225 255"
		TextEntry.IMEFGColor					DefaultTextColorLight
		
		// Steam-Specific Settings
		GamesList.InstalledAppColor				DefaultTextColorLight
		GamesList.NotInstalledAppColor			DarkTextColor
		GamesList.ReadyStatusColor				DisabledTextColor
		GamesList.UpdatingStatusColor			DefaultTextColorLight
		GamesList.NotInstalledStatusColor		DarkTextColor
		
		// Friends List Colors
		Friends.InGameColor						"000 181 000 255"
		Friends.OnlineColor						"033 124 214 255"
		Friends.OfflineColor					"128 128 128 255"
		Friends.IgnoredColor					"181 000 000 255"
		Friends.NoAvatarOver					DefaultTextColorLight
		Friends.SectionHeader					HoverTextColor
		
		// P2P Graph Colors
		P2P.DownloadColor						"193 193 193 255"
		P2P.UploadColor							"136 172 187 255"
		P2PBlockStatus.Outline					"100 100 100 255"
		P2PBlockStatus.CompletionBar			"020 000 255 255"
		P2PBlockStatus.CompletionBarBg			"073 073 073 255"
		P2PBlockStatus.BlockStatusUnknown		"255 000 000 192"
		P2PBlockStatus.BlockStatusLow			"073 078 073 255"
		P2PBlockStatus.BlockStatusHigh			"000 094 200 255"
		P2PBlockStatusDetails.c_dling			"255 000 000 255"
		P2PBlockStatusDetails.c_both			"000 127 255 255"
		P2PBlockStatusDetails.c_peer			"200 225 255 255"
		P2PBlockStatusDetails.c_local			"100 180 100 255"
		P2PBlockStatusDetails.c_missing			"255 255 255 255"
		P2PBlockStatusDetails.c_error			"127 127 127 255"
		P2PBlockStatusDetails.c_unused			"000 000 000 255"
		
		// Chat Window Colors
		ChatOthersTextColor						DefaultTextColorLight
		ChatOwnTextColor						DisabledTextColor
		ChatGradientTop							DimTextColor
		ChatGradientBottom						FrameBaseColor
		Slider.NobColor							HoverTextColorDark
		
		// Console Colors
		Console.RemoteCommandText				"000 000 255 255"
		Console.ErrorText						"255 000 000 255"
		Console.SelectedText					"000 000 255 255"
		Console.DefaultText						"255 255 255 255"
	}
	
	//
	//////////////////// CONTROLS //////////////////////////////
	//
	// describes how controls are rendered
	
	Controls
	{
		// typical control states:	default  disabled
		// button control states:	keyfocus  mouseover  mousedown  keyfocus_mouseover  defaultbutton  defaultbutton_mouseover
		// radio/checkbox states:	selected  selected_disabled  selected_keyfocus  selected_mouseover  selected_mousedown  selected_keyfocus_mouseover
		
		// color types:				textcolor  shadowtextcolor  selectedtextcolor  selectedbgcolor
		
		BaseControls
		{
			Button
			{
				appearance						ButtonBorder
				textcolor						DefaultTextColorLight
				mousedown
				{	
					appearance					ButtonDepressedBorder
					textcolor					DisabledTextColor
				}
				keyfocus	
				{ 
					appearance					ButtonBorder
					textcolor					DefaultTextColorLight
				}
				mouseover
				{
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				keyfocus_mouseover		
				{ 
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				defaultbutton
				{ 
					appearance					ButtonDefaultBorder
					textcolor					DefaultTextColorLight
				}
				defaultbutton_mouseover		
				{ 
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				disabled
				{
					appearance					ButtonDisabledBorder
					textcolor					DimTextColor
				}
			}
			
			GripPanel
			{
				textcolor						Blank
				bgcolor							Blank
			}
			
			CheckButton
			{
				textcolor						DefaultTextColorLight
				image							Graphics/Check
				mouseover
				{
					textcolor 					HoverTextColor
					image						Graphics/Check_MouseOver
				}
				mousedown	
				{
					textcolor 					HoverTextColor
					image 						Graphics/Check_MouseDown
				}
				selected	
				{
					textcolor 					DefaultTextColorLight
					image 						Graphics/Check_Selected
				}
				keyfocus
				{
					textcolor 					HoverTextColor
					image						Graphics/Check_MouseOver
				}
				keyfocus_mouseover
				{
					textcolor 					HoverTextColor
					image						Graphics/Check_MouseOver
				}
				selected_mouseover	
				{ 
					textcolor 					HoverTextColor
					image						Graphics/Check_Selected_MouseOver
				}
				selected_mousedown
				{
					textcolor 					HoverTextColor
					image						Graphics/Check_MouseDown
				}
				selected_keyfocus
				{
					textcolor 					HoverTextColor
					image						Graphics/Check_Selected_MouseOver
				}
				selected_keyfocus_mouseover
				{
					textcolor 					HoverTextColor
					image						Graphics/Check_Selected_MouseOver
				}
				disabled
				{
					textcolor					DisabledTextColor
					image 						Graphics/Check_Disabled
				}
				selected_disabled
				{
					textcolor					DisabledTextColor
					image						Graphics/Check_Selected_Disabled
				}
			}
			
			CheckButtonList
			{
				appearance						PanelExteriorBorder_Alt
				bgcolor							FrameBaseColor
			}
			
			ComboBox
			{
				appearance						ComboBoxBorder
				bgcolor							Blank
				selectedbgcolor 				Blank
				selectedtextcolor 				DefaultTextColorLight
				textcolor						DefaultTextColorLight
				mouseover
				{
					textcolor 					DefaultTextColorLight
				}
				keyfocus
				{
					textcolor 					DefaultTextColorLight
				}
				disabled
				{
					textcolor 					DisabledTextColor
				}
			}
			
			ComboBoxButton
			{
				bgcolor							Blank
				textcolor						DefaultTextColorLight
				mouseover
				{
					textcolor 					HoverTextColor
				}
				disabled
				{
					textcolor 					DisabledtTextColor
				}
			}
			
			ContextLabel
			{
				textcolor						DefaultTextColorLight
			}
			
			Divider
			{
				appearance						DividerBorder
			}
			
			Frame
			{
				appearance						FrameBorder
			}
			
			FrameButton
			{
				appearance						FrameButtonBorder
				textcolor						White
				mouseover
				{
					appearance 					FrameButtonBorderOver
				}
				mousedown
				{
					appearance 					FrameButtonBorderDown
				}
				keyfocus
				{
					appearance 					FrameButtonBorderDown
				}
				outoffocus	
				{
					appearance					FrameButtonBorder
				}
			}
			
			FrameSystemButton
			{
				appearance						NoBorder
				bgcolor							Blank
				textcolor						White
			}
			
			FrameTitle
			{
				bgcolor							Blank
				textcolor						White
				outoffocus
				{
					bgcolor						Blank
					textcolor					White
				}
			}
			
			FrameBRGripPanel
			{
				textcolor						Blank
				appearance						NoBorder
			}
			
			CChatTitlePanel
			{
				appearance						NoBorder
				bgcolor							Blank
			}
			
			CChatFriendTitlePanel
			{
				appearance						NoBorder
				bgcolor							Blank
			}	
			
			CChatHistoryPanel
			{
				appearance						PanelExteriorBorder_Alt
				bgcolor							FrameBaseColor
				textcolor						DefaultTextColorLight
			}
			
			CChatTextEntry
			{
				appearance						ChatInputBorder
				textcolor						DefaultTextColorLight
				selectedtextcolor				SelectedTextColor	
				selectedbgcolor					SelectedBGColor
				disabled
				{
					appearance					ChatInputBorderDisabled
					textcolor					DimTextColor
					selectedtextcolor			SelectedTextColor	
					selectedbgcolor				SelectedBGColor
				}		
			}
			
			CChatUserPanel
			{
				appearance						PanelExteriorBorder
				bgcolor							FrameBaseColor
				scrollbar_visible
				{
					appearance					PanelExteriorBorder
				}
			}
			
			CChatInviteBG
			{
				appearance						CChatInviteBG
			}
			
			CVoiceChatOffBG
			{
				appearance						VoiceChatOffBG
			}
			
			CVoiceChatOnBG
			{
				appearance						VoiceChatOnBG
			}
			
			CChatTitlePanelAffordance
			{
				appearance						NoBorder
				bgcolor							Blank
				textcolor						DefaultTextColorLight
				mouseover
				{
					appearance					FriendPanelAffordanceMouseover
				}
				mousedown
				{
					appearance					FriendPanelAffordanceMousedown
				}
				keyfocus
				{
					appearance					FriendPanelAffordanceMouseover
				}
				keyfocus_mouseover
				{
					appearance					FriendPanelAffordanceMouseover
				}
			}
			
			CFriendPanel
			{
				appearance						NoBorder
				bgcolor							Blank
				mouseover
				{
					appearance					FriendPanelMouseOver
				}
				selected
				{
					appearance					FriendPanelSelected
				}
				compact
				{
					appearance					NoBorder
					bgcolor						Blank
				}
				compact_selected
				{
					appearance					NoBorder
					bgcolor						Blank
				}
			}
			
			CFriendPanelAffordance
			{
				appearance						NoBorder
				bgcolor							Blank
				mouseover
				{
					appearance					FriendPanelAffordanceMouseover
				}
				mousedown
				{
					appearance					FriendPanelAffordanceMousedown
				}
				keyfocus
				{
					appearance					FriendPanelAffordanceMouseover
				}
				keyfocus_mouseover
				{
					appearance					FriendPanelAffordanceMouseover
				}
			}
			
			CFriendsListSectionHeader
			{
				textcolor						DefaultTextColorLight
				appearance
				{
					render_bg
					{
						"1"						"fill( x0, y1 - 1, x1 - 10, y1, HoverTextColor )"
					}
				}
			}
			
			CFriendsListSectionAffordance
			{
				textcolor						DefaultTextColorLight
				mouseover
				{
					textcolor					HoverTextColor
				}
			}
			
			CTaskbarButton
			{
				appearance						NoBorder
				bgcolor							Blank
				textcolor						White
				mouseover
				{
					appearance					NoBorder
					bgcolor						Blank
					textcolor					HoverTextColorLight
				}
				selected
				{
					appearance					NoBorder
					bgcolor						Blank
					textcolor					White
				}
				selected_mouseover
				{
					appearance					NoBorder
					bgcolor						Blank
					textcolor					HoverTextColorLight
				}
			}
			
			COverlayTaskbar
			{
				bgcolor							Blank
				appearance						OverlayTaskBar
			}
			
			COverlayMain
			{
				bgcolor							"000 000 000 128"
			}
			
			GraphPanel
			{
				textcolor						HoverTextColor
				appearance						PanelExteriorBorder
			}
			
			HTML
			{
				appearance						HTMLExteriorBorder
				bgcolor							Blank
			}
			
			HTMLInterior
			{
				appearance						HTMLInteriorBorder
				bgcolor							Blank
			}
			
			icon_button_news
			{
				appearance						ButtonBorder
				textcolor						DefaultTextColorLight
				mousedown
				{	
					appearance					ButtonDepressedBorder
					textcolor					DisabledTextColor
				}
				keyfocus	
				{ 
					appearance					ButtonBorder
					textcolor					DefaultTextColorLight
				}
				mouseover
				{
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				keyfocus_mouseover		
				{ 
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				defaultbutton
				{ 
					appearance					ButtonDefaultBorder
					textcolor					DefaultTextColorLight
				}
				defaultbutton_mouseover		
				{ 
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				disabled
				{
					appearance					ButtonDisabledBorder
					textcolor					DisabledTextColor
				}
			}
			
			icon_button_friends
			{
				appearance						ButtonBorder
				textcolor						DefaultTextColorLight
				mousedown
				{	
					appearance					ButtonDepressedBorder
					textcolor					DisabledTextColor
				}
				keyfocus	
				{ 
					appearance					ButtonBorder
					textcolor					DefaultTextColorLight
				}
				mouseover
				{
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				keyfocus_mouseover		
				{ 
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				defaultbutton
				{ 
					appearance					ButtonDefaultBorder
					textcolor					DefaultTextColorLight
				}
				defaultbutton_mouseover		
				{ 
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				disabled
				{
					appearance					ButtonDisabledBorder
					textcolor					DisabledTextColor
				}
			}
			
			icon_button_servers
			{
				appearance						ButtonBorder
				textcolor						DefaultTextColorLight
				mousedown
				{	
					appearance					ButtonDepressedBorder
					textcolor					DisabledTextColor
				}
				keyfocus	
				{ 
					appearance					ButtonBorder
					textcolor					DefaultTextColorLight
				}
				mouseover
				{
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				keyfocus_mouseover		
				{ 
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				defaultbutton
				{ 
					appearance					ButtonDefaultBorder
					textcolor					DefaultTextColorLight
				}
				defaultbutton_mouseover		
				{ 
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				disabled
				{
					appearance					ButtonDisabledBorder
					textcolor					DisabledTextColor
				}
			}
			
			icon_button_settings
			{
				appearance						ButtonBorder
				textcolor						DefaultTextColorLight
				mousedown
				{	
					appearance					ButtonDepressedBorder
					textcolor					DisabledTextColor
				}
				keyfocus	
				{ 
					appearance					ButtonBorder
					textcolor					DefaultTextColorLight
				}
				mouseover
				{
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				keyfocus_mouseover		
				{ 
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				defaultbutton
				{ 
					appearance					ButtonDefaultBorder
					textcolor					DefaultTextColorLight
				}
				defaultbutton_mouseover		
				{ 
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				disabled
				{
					appearance					ButtonDisabledBorder
					textcolor					DisabledTextColor
				}
			}
			
			icon_button_support
			{
				appearance						ButtonBorder
				textcolor						DefaultTextColorLight
				mousedown
				{	
					appearance					ButtonDepressedBorder
					textcolor					DisabledTextColor
				}
				keyfocus	
				{ 
					appearance					ButtonBorder
					textcolor					DefaultTextColorLight
				}
				mouseover
				{
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				keyfocus_mouseover		
				{ 
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				defaultbutton
				{ 
					appearance					ButtonDefaultBorder
					textcolor					DefaultTextColorLight
				}
				defaultbutton_mouseover		
				{ 
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				disabled
				{
					appearance					ButtonDisabledBorder
					textcolor					DisabledTextColor
				}
			}
			
			icon_button_MiniMeShrink
			{
				bgcolor							Blank
				appearance						MiniMeShrinkBorder
				mousedown
				{
					appearance 					MiniMeShrinkBorder
					textcolor					Blank
				}
				keyfocus
				{
					appearance					MiniMeShrinkBorder
					textcolor 					Blank
				}
				mouseover
				{
					appearance 					MiniMeShrinkBorder_mouseover
					textcolor					Blank
				}
				disabled
				{
					appearance 					MiniMeShrinkBorder
					textcolor 					Blank
				}
				keyfocus_mouseover
				{
					appearance 					MiniMeShrinkBorder_mouseover
					textcolor 					Blank
				} 
				defaultbutton
				{
					appearance 					MiniMeShrinkBorder
					textcolor 					Blank
				}
				defaultbutton_mouseover
				{
					appearance 					MiniMeShrinkBorder_mouseover
					textcolor					Blank
				}
			}
			
			icon_button_MiniMeExpand
			{
				bgcolor							Blank
				appearance						MiniMeExpandBorder
				mousedown
				{
					appearance 					MiniMeExpandBorder
					textcolor					Blank
				}
				keyfocus
				{
					appearance					MiniMeExpandBorder
					textcolor 					Blank
				}
				mouseover
				{
					appearance 					MiniMeExpandBorder_mouseover
					textcolor					Blank
				}
				disabled
				{
					appearance 					MiniMeExpandBorder
					textcolor 					Blank
				}
				keyfocus_mouseover
				{
					appearance 					MiniMeExpandBorder_mouseover
					textcolor 					Blank
				} 
				defaultbutton
				{
					appearance 					MiniMeExpandBorder
					textcolor 					Blank
				}
				defaultbutton_mouseover
				{
					appearance 					MiniMeExpandBorder_mouseover
					textcolor					Blank
				}
			}
			
			icon_button_home
			{
				bgcolor							Blank
				appearance						HomeBorder
				mousedown
				{
					appearance					HomeBorder_down
					textcolor					Blank
				}
				keyfocus
				{
					appearance					HomeBorder
					textcolor					Blank
				}
				mouseover
				{
					appearance					HomeBorder_over
					textcolor					Blank
				}
				disabled
				{
					appearance					HomeBorder
					textcolor					Blank
				}
				keyfocus_mouseover
				{
					appearance					HomeBorder_over
					textcolor					Blank
				} 
				defaultbutton
				{
					appearance					HomeBorder
					textcolor					Blank
				}
				defaultbutton_mouseover
				{
					appearance 					HomeBorder_over
					textcolor					Blank
				}
			}
			
			icon_button_reload
			{
				bgcolor							Blank
				appearance						ReloadBorder
				mousedown
				{
					appearance 					ReloadBorder_down
					textcolor					Blank
				}
				keyfocus
				{
					appearance 					ReloadBorder
					textcolor					Blank
				}
				mouseover
				{
					appearance 					ReloadBorder_over
					textcolor					Blank
				}
				disabled
				{
					appearance					ReloadBorder
					textcolor 					Blank
				}
				keyfocus_mouseover
				{
					appearance					ReloadBorder_over
					textcolor					Blank
				} 
				defaultbutton
				{
					appearance 					ReloadBorder
					textcolor					Blank
				}
				defaultbutton_mouseover
				{
					appearance 					ReloadBorder_over
					textcolor					Blank
				}
			}
			
			icon_button_back
			{
				bgcolor							Blank
				appearance						BackBorder
				mousedown
				{
					appearance 					BackBorder_down
					textcolor					Blank
				}
				keyfocus
				{
					appearance 					BackBorder
					textcolor					Blank
				}
				mouseover
				{
					appearance 					BackBorder_over
					textcolor					Blank
				}
				disabled
				{
					appearance 					BackBorder_disabled
					textcolor 					Blank
				}
				keyfocus_mouseover
				{
					appearance 					BackBorder_over
					textcolor					Blank
				} 
				defaultbutton
				{
					appearance 					BackBorder
					textcolor					Blank
				}
				defaultbutton_mouseover
				{
					appearance 					BackBorder_over
					textcolor					Blank
				}
			}
			
			icon_button_forward
			{
				bgcolor							Blank
				appearance						ForwardBorder
				mousedown
				{
					appearance 					ForwardBorder_down
					textcolor					Blank
				}
				keyfocus
				{
					appearance 					ForwardBorder
					textcolor					Blank
				}
				mouseover
				{
					appearance 					ForwardBorder_over
					textcolor					Blank
				}
				disabled
				{
					appearance					ForwardBorder_disabled
					textcolor 					Blank
				}
				keyfocus_mouseover
				{
					appearance 					ForwardBorder_over
					textcolor					Blank
				} 
				defaultbutton
				{
					appearance 					ForwardBorder
					textcolor					Blank
				}
				defaultbutton_mouseover
				{
					appearance 					ForwardBorder_over
					textcolor					Blank
				}
			}
			
			icon_button_stop
			{
				bgcolor							Blank
				appearance						StopBorder
				mousedown
				{
					appearance					StopBorder_down
					textcolor					Blank
				}
				keyfocus
				{
					appearance 					StopBorder
					textcolor					Blank
				}
				mouseover
				{
					appearance 					StopBorder_over
					textcolor					Blank
				}
				disabled
				{
					appearance					StopBorder
					textcolor 					Blank
				}
				keyfocus_mouseover
				{
					appearance 					StopBorder_over
					textcolor					Blank
				} 
				defaultbutton
				{
					appearance 					StopBorder
					textcolor					Blank
				}
				defaultbutton_mouseover
				{
					appearance 					StopBorder_over
					textcolor					Blank
				}
			}
			
			Label
			{
				selectedtextcolor				HoverTextColor
				textcolor						DefaultTextColorLight
			}
			
			LabelDull
			{
				selectedtextcolor				SelectedTextColor
				textcolor						DisabledTextColor
			}
			
			LabelBright
			{
				selectedtextcolor				HoverTextColor
				textcolor						HoverTextColor
			}
			
			ListPanel
			{
				appearance						ListPanelExteriorBorder
				scrollbar_visible
				{
					appearance					ListPanelExteriorBorder
				}
			}
			
			ListPanelCheckBox
			{
				textcolor						DefaultTextColorLight
				image							Graphics/Check
				mouseover
				{
					textcolor 					HoverTextColor
					image						Graphics/Check_MouseOver
				}
				mousedown	
				{
					textcolor 					HoverTextColor
					image 						Graphics/Check_MouseDown
				}
				selected	
				{
					textcolor 					DefaultTextColorLight
					image 						Graphics/Check_Selected
				}
				keyfocus
				{
					textcolor 					HoverTextColor
					image						Graphics/Check_MouseOver
				}
				keyfocus_mouseover
				{
					textcolor 					HoverTextColor
					image						Graphics/Check_MouseOver
				}
				selected_mouseover	
				{ 
					textcolor 					HoverTextColor
					image						Graphics/Check_Selected_MouseOver
				}
				selected_mousedown
				{
					textcolor 					HoverTextColor
					image						Graphics/Check_MouseDown
				}
				selected_keyfocus
				{
					textcolor 					HoverTextColor
					image						Graphics/Check_Selected_MouseOver
				}
				selected_keyfocus_mouseover
				{
					textcolor 					HoverTextColor
					image						Graphics/Check_Selected_MouseOver
				}
				disabled
				{
					textcolor					DisabledTextColor
					image 						Graphics/Check_Disabled
				}
				selected_disabled
				{
					textcolor					DisabledTextColor
					image						Graphics/Check_Selected_Disabled
				}
			}
			
			ListPanelInterior
			{
				bgcolor							FrameBaseColor
			}
			
			ListPanelSectionHeader
			{
				bgcolor							HoverTextColor
				textcolor						DefaultTextColorLight
			}
			
			ListPanelSectionCollapser
			{
				bgcolor							Blank
				textcolor						DefaultTextColorLight
			}
			
			ListPanelColumnHeader	
			{
				appearance						ListPanel.HeaderButtonBorder
				textcolor  						DefaultTextColorLight
				mouseover
				{
					textcolor 					HoverTextColor
				}
			}
			
			ListViewPanel
			{
				appearance						NoBorder
			}
			
			Menu
			{
				appearance						MenuBorder
			}
			
			MenuBar		
			{
				bgcolor							Blank
			}
			
			MenuBarItem
			{
				bgcolor							Blank
				textcolor						DefaultTextColorLight
				mouseover
				{
					bgcolor						SelectedBGColor
					textcolor					SelectedTextColor
				}
				mousedown
				{
					bgcolor						SelectedBGColor
					textcolor					SelectedTextColor
				}
				selected
				{
					bgcolor						SelectedBGColor
					textcolor					SelectedTextColor
				}
			}
			
			MenuItem
			{
				bgcolor							FrameBaseColor
				textcolor						DisabledTextColor
				mouseover
				{
					appearance					MenuItemSelected
					textcolor 					DefaultTextColorLight
				}
				mousedown
				{
					appearance					MenuItemSelected
					textcolor 					DefaultTextColorLight
				}
				selected
				{
					appearance					MenuItemSelected
					textcolor 					DefaultTextColorLight
				}
				disabled
				{
					textcolor					DimTextColor
				}
			}
			
			MenuSeparator
			{
				appearance						DividerBorder
			}
			
			NotificationFrame
			{
				appearance						ToolTipBorder
				textcolor						DefaultTextColorLight
			}
			
			PanelListPanel
			{
				appearance						PanelExteriorBorder
				scrollbar_visible
				{
					appearance					PanelExteriorBorder
				}
			}
			
			PanelHorizListPanel
			{
				appearance						PanelExteriorBorder
				scrollbar_visible
				{
					appearance					PanelExteriorBorder
				}
			}
			
			PageTab
			{
				
				textcolor						TabNormalTextColor
				appearance						TabNormalBorder
				mouseover
				{
					appearance					TabHoverBorder
					textcolor 					TabHoverTextColor
				}
				mousedown
				{
					appearance					TabNormalBorder
					textcolor					TabActiveTextColor
				}
				active	
				{ 
					appearance					TabActiveBorder
					textcolor					TabActiveTextColor
				}
				keyfocus		
				{
					appearance					TabActiveBorder
					textcolor					TabActiveTextColor
				}
				keyfocus_mouseover
				{
					appearance					TabActiveBorder
					textcolor					TabActiveTextColor
				}
			}
			
			PropertyPage
			{
				appearance						PropertyPageBorder
			}
			
			SteamGamesPage
			{
				bgcolor							Blank
			}
			
				
			PropertySheet
			{
				bgcolor							Blank
				appearance						PropertySheetBorder
				bgcolor							Blank
			}
			
			ProgressBar
			{
				textcolor						ProgressColor
				bgcolor							Blank
				appearance						InputBorder
			}
			
			RadioButton
			{
				
				textcolor						DefaultTextColorLight
				image							Graphics/Radio
				mouseover
				{
					textcolor 					HoverTextColor
					image						Graphics/Radio_MouseOver
				}
				mousedown	
				{
					textcolor 					DefaultTextColorLight
					image 						Graphics/Radio_Selected
				}
				selected	
				{
					textcolor					DefaultTextColorLight
					image 						Graphics/Radio_Selected
				}
				keyfocus
				{
					textcolor 					HoverTextColor 
					image						Graphics/Radio_Selected
				}
				keyfocus_mouseover
				{
					textcolor 					HoverTextColor 
					image						Graphics/Radio_Selected_MouseOver
				}
				selected_mouseover	
				{ 
					textcolor 					HoverTextColor 
					image						Graphics/Radio_Selected
				}
				selected_mousedown
				{
					textcolor 					DefaultTextColorLight
					image						Graphics/Radio_Selected_MouseOver
				}
				selected_keyfocus
				{
					textcolor 					HoverTextColor
					image						Graphics/Radio_Selected
				}
				selected_keyfocus_mouseover
				{
					textcolor 					HoverTextColor  
					image						Graphics/Radio_Selected_MouseOver
				}
				disabled
				{
					textcolor					DisabledTextColor
					image 						Graphics/Radio_Disabled
				}
				selected_disabled
				{
					textcolor					DisabledTextColor
					image						Graphics/Radio_Disabled
				}
			}
			
			RichText
			{
				appearance						PanelExteriorBorder
				scrollbar_visible
				{
					appearance					PanelExteriorBorder
				}
			}
			
			RichTextInterior
			{
				appearance						NoBorder
				scrollbar_visible
				{
					appearance					NoBorder
				}
			}
			
			ScrollBarSlider
			{
				slider		
				{
					appearance 					ScrollBarSliderBorder
					bgcolor 					Blank
				}
				slider_horiz
				{
					appearance 					Horiz_ScrollBarSliderBorder
					bgcolor 					Blank
				}
			}
			
			ScrollBarButton
			{
				appearance						ScrollBarButtonBorder
				textcolor						ScrollButtonColor
				mouseover	
				{
					appearance					ScrollBarButtonMouseOverBorder
					textcolor 					ScrollButtonHoverColor
				}
			}
			
			SectionedListPanel					// Mini Games & Friends List
			{
				appearance						NoBorder
				bgcolor							FrameBaseColor
				scrollbar_visible
				{
					appearance					NoBorder
				}
			}
			
			SectionedListPanelInterior
			{
				bgcolor							Blank
				textcolor						HoverTextColor
			}
			
			SectionedListPanelItem
			{
				textcolor						DefaultTextColorLight
				selected
				{
					textcolor					DefaultTextColorLight
					appearance					GamesListSelected
				}
			}
			
			SectionedListPanelHeader
			{
				textcolor						DefaultTextColorLight
				appearance
				{
					render_bg
					{
						"1"						"fill( x0, y1 - 3, x1 - 10, y1 - 2, HoverTextColor )"
					}
				}
			}
			
			SectionedListPanelCollapser
			{
				bgcolor							Blank
				textcolor						DefaultTextColorLight
			}
			
			Slider
			{
				bgcolor							Blank
				textcolor						DimTextColor
				selectedtextcolor				DimTextColor
				disabled
				{
					textcolor					Blank
				}
			}
			
			SplitterHandle
			{
				appearance						NoBorder
				bgcolor							HoverTextColor
			}
			
			TextEntry
			{
				appearance						InputBorder
				textcolor						DefaultTextColorLight
				selectedtextcolor				SelectedTextColor	
				selectedbgcolor					SelectedBGColor
				disabled
				{
					appearance					InputBorderDisabled
					textcolor					DimTextColor
					selectedtextcolor			SelectedTextColor	
					selectedbgcolor				SelectedBGColor
				}	
			}
			
			ToggleButton
			{
				appearance						ButtonBorder
				bgcolor							Blank
				textcolor						DefaultTextColorLight
				mousedown
				{
					appearance					ButtonDepressedBorder
					textcolor					DisabledTextColor
				}
				keyfocus
				{
					appearance					ButtonBorder
					textcolor					DefaultTextColorLight
				}
				mouseover
				{
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				keyfocus_mouseover
				{
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				defaultbutton
				{
					appearance					ButtonDefaultBorder
					textcolor					DefaultTextColorLight
				}
				defaultbutton_mouseover
				{
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				selected
				{
					appearance					ButtonBorder
					textcolor					DefaultTextColorLight
				}
				selected_mousedown
				{
					appearance					ButtonDepressedBorder
					textcolor					DefaultTextColorLight
				}
				selected_keyfocus
				{
					appearance					ButtonBorder
					textcolor					DefaultTextColorLight
				}
				selected_mouseover
				{
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				selected_keyfocus_mouseover
				{
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				disabled
				{
					appearance					ButtonDisabledBorder
					textcolor					DisabledTextColor
				}
			}
			
			TooltipWindow
			{
				appearance						ToolTipBorder
				textcolor						DefaultTextColorLight
			}
			
			TreeView
			{
				bgcolor							Blank
				textcolor						DefaultTextColorLight
			}
			
			TreeNode
			{
				bgcolor							Blank
				textcolor						DefaultTextColorLight
			}
			
			TreeViewSubPanel
			{
				appearance						PanelExteriorBorder
				bgcolor							FrameBaseColor
				textcolor						HoverTextColor
			}
			
			TreeNodeText
			{
				bgcolor							Blank
				textcolor						DefaultTextColorLight
				selectedtextcolor				SelectedTextColor
				selectedbgcolor					SelectedBGColor
			}
			
			URLLabel
			{
				textcolor						URLTextColor
			}
			
			WizardPanel
			{
				appearance						FrameBorder
			}
			
			WizardSubPanel
			{
				appearance						NoBorder
				bgcolor							Blank
			}
		}
		
		WizardSubPanelControls
		{
			Button
			{
				appearance						ButtonBorder
				textcolor						DefaultTextColorLight
				mousedown
				{	
					appearance					ButtonDepressedBorder
					textcolor					DisabledTextColor
				}
				keyfocus	
				{ 
					appearance					ButtonBorder
					textcolor					DefaultTextColorLight
				}
				mouseover
				{
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				keyfocus_mouseover		
				{ 
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				defaultbutton
				{ 
					appearance					ButtonDefaultBorder
					textcolor					DefaultTextColorLight
				}
				defaultbutton_mouseover		
				{ 
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				disabled
				{
					appearance					ButtonDisabledBorder
					textcolor					DisabledTextColor
				}
			}
			
			ToggleButton
			{
				appearance						ButtonBorder
				bgcolor							Blank
				textcolor						DefaultTextColorLight
				mousedown
				{
					appearance					ButtonDepressedBorder
					textcolor					DisabledTextColor
				}
				keyfocus
				{
					appearance					ButtonBorder
					textcolor					DefaultTextColorLight
				}
				mouseover
				{
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				keyfocus_mouseover
				{
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				defaultbutton
				{
					appearance					ButtonDefaultBorder
					textcolor					DefaultTextColorLight
				}
				defaultbutton_mouseover
				{
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				selected
				{
					appearance					ButtonBorder
					textcolor					DefaultTextColorLight
				}
				selected_mousedown
				{
					appearance					ButtonDepressedBorder
					textcolor					DefaultTextColorLight
				}
				selected_keyfocus
				{
					appearance					ButtonBorder
					textcolor					DefaultTextColorLight
				}
				selected_mouseover
				{
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				selected_keyfocus_mouseover
				{
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				disabled
				{
					appearance					ButtonDisabledBorder
					textcolor					DisabledTextColor
				}
			}
			
			LabelDull
			{
				selectedtextcolor				SelectedTextColor
				textcolor						DisabledTextColor
			}
			
			TextEntry
			{
				appearance						InputBorder
				textcolor						DefaultTextColorLight
				selectedtextcolor				SelectedTextColor	
				selectedbgcolor					SelectedBGColor
				disabled
				{
					appearance					InputBorderDisabled
					textcolor					DimTextColor
					selectedtextcolor			SelectedTextColor	
					selectedbgcolor				SelectedBGColor
				}
			}
			
			ComboBox
			{
				appearance						ComboBoxBorder
				bgcolor							Blank
				selectedbgcolor 				Blank
				selectedtextcolor 				DefaultTextColorLight
				textcolor						DefaultTextColorLight
				mouseover
				{
					textcolor 					DefaultTextColorLight
				}
				keyfocus
				{
					textcolor 					DefaultTextColorLight
				}
				disabled
				{
					textcolor 					DisabledTextColor
				}
			}
			
			ComboBoxButton
			{
				bgcolor							Blank
				textcolor						DefaultTextColorLight
				mouseover
				{
					textcolor 					HoverTextColor
				}
				disabled
				{
					textcolor 					DisabledtTextColor
				}
			}
			
			CheckButton
			{
				textcolor						DefaultTextColorLight
				image							Graphics/Check
				mouseover
				{
					textcolor 					HoverTextColor
					image						Graphics/Check_MouseOver
				}
				mousedown	
				{
					textcolor 					HoverTextColor
					image 						Graphics/Check_MouseDown
				}
				selected	
				{
					textcolor 					DefaultTextColorLight
					image 						Graphics/Check_Selected
				}
				keyfocus
				{
					textcolor 					HoverTextColor
					image						Graphics/Check_MouseOver
				}
				keyfocus_mouseover
				{
					textcolor 					HoverTextColor
					image						Graphics/Check_MouseOver
				}
				selected_mouseover	
				{ 
					textcolor 					HoverTextColor
					image						Graphics/Check_Selected_MouseOver
				}
				selected_mousedown
				{
					textcolor 					HoverTextColor
					image						Graphics/Check_MouseDown
				}
				selected_keyfocus
				{
					textcolor 					HoverTextColor
					image						Graphics/Check_Selected_MouseOver
				}
				selected_keyfocus_mouseover
				{
					textcolor 					HoverTextColor
					image						Graphics/Check_Selected_MouseOver
				}
				disabled
				{
					textcolor					DisabledTextColor
					image 						Graphics/Check_Disabled
				}
				selected_disabled
				{
					textcolor					DisabledTextColor
					image						Graphics/Check_Selected_Disabled
				}
			}
			
			ProgressBar
			{
				textcolor						ProgressColor
				bgcolor							Blank
				appearance						InputBorder
			}
			
			ListPanel
			{
				appearance						ListPanelExteriorBorder
				scrollbar_visible
				{
					appearance					ListPanelExteriorBorder
				}
			}
			
			ListPanelInterior
			{
				bgcolor							FrameBaseColor
			}
			
			ListPanelSectionHeader
			{
				bgcolor							HoverTextColor
				textcolor						DefaultTextColorLight
			}
			
			ListPanelSectionCollapser
			{
				textcolor						Blank
				bgcolor							DefaultTextColorLight
			}
			
			RichText
			{
				appearance						PanelExteriorBorder
				scrollbar_visible
				{
					appearance					PanelExteriorBorder
				}
			}
			
			RichTextInterior
			{
				bgcolor							FrameBaseColor
			}
			
			SectionedListPanelInterior
			{
				bgcolor							FrameBaseColor
			}
			
			SectionedListPanelItem
			{
				textcolor						DefaultTextColorLight
				selected
				{
					textcolor					DefaultTextColorLight
					appearance					GamesListSelected
				}
			}
			
			HTML
			{
				appearance						HTMLExteriorBorder
				bgcolor							Blank
			}
			
			HTMLInterior
			{
				appearance						HTMLInteriorBorder
				bgcolor							Blank
			}
		}
		
		PropertyPageControls
		{
			Button
			{
				appearance						ButtonBorder
				textcolor						DefaultTextColorLight
				mousedown
				{	
					appearance					ButtonDepressedBorder
					textcolor					DisabledTextColor
				}
				keyfocus	
				{ 
					appearance					ButtonBorder
					textcolor					DefaultTextColorLight
				}
				mouseover
				{
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				keyfocus_mouseover		
				{ 
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				defaultbutton
				{ 
					appearance					ButtonDefaultBorder
					textcolor					DefaultTextColorLight
				}
				defaultbutton_mouseover		
				{ 
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				disabled
				{
					appearance					ButtonDisabledBorder
					textcolor					DisabledTextColor
				}
			}
			
			ToggleButton
			{
				appearance						ButtonBorder
				bgcolor							Blank
				textcolor						DefaultTextColorLight
				mousedown
				{
					appearance					ButtonDepressedBorder
					textcolor					DisabledTextColor
				}
				keyfocus
				{
					appearance					ButtonBorder
					textcolor					DefaultTextColorLight
				}
				mouseover
				{
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				keyfocus_mouseover
				{
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				defaultbutton
				{
					appearance					ButtonDefaultBorder
					textcolor					DefaultTextColorLight
				}
				defaultbutton_mouseover
				{
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				selected
				{
					appearance					ButtonBorder
					textcolor					DefaultTextColorLight
				}
				selected_mousedown
				{
					appearance					ButtonDepressedBorder
					textcolor					DefaultTextColorLight
				}
				selected_keyfocus
				{
					appearance					ButtonBorder
					textcolor					DefaultTextColorLight
				}
				selected_mouseover
				{
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				selected_keyfocus_mouseover
				{
					appearance					ButtonMouseOverBorder
					textcolor					DefaultTextColorLight
				}
				disabled
				{
					appearance					ButtonDisabledBorder
					textcolor					DisabledTextColor
				}
			}
			
			LabelDull
			{
				selectedtextcolor				SelectedTextColor
				textcolor						DisabledTextColor
			}
			
			TextEntry
			{
				appearance						InputBorder
				textcolor						DefaultTextColorLight
				selectedtextcolor				SelectedTextColor	
				selectedbgcolor					SelectedBGColor
				disabled
				{
					appearance					InputBorderDisabled
					textcolor					DimTextColor
					selectedtextcolor			SelectedTextColor	
					selectedbgcolor				SelectedBGColor
				}
			}
			
			ComboBox
			{
				appearance						ComboBoxBorder
				bgcolor							Blank
				selectedbgcolor 				Blank
				selectedtextcolor 				DefaultTextColorLight
				textcolor						DefaultTextColorLight
				mouseover
				{
					textcolor 					DefaultTextColorLight
				}
				keyfocus
				{
					textcolor 					DefaultTextColorLight
				}
				disabled
				{
					textcolor 					DisabledTextColor
				}
			}
			
			ComboBoxButton
			{
				bgcolor							Blank
				textcolor						DefaultTextColorLight
				mouseover
				{
					textcolor 					HoverTextColor
				}
				disabled
				{
					textcolor 					DisabledtTextColor
				}
			}
			
			CheckButton
			{
				textcolor						DefaultTextColorLight
				image							Graphics/Check
				mouseover
				{
					textcolor 					HoverTextColor
					image						Graphics/Check_MouseOver
				}
				mousedown	
				{
					textcolor 					HoverTextColor
					image 						Graphics/Check_MouseDown
				}
				selected	
				{
					textcolor 					DefaultTextColorLight
					image 						Graphics/Check_Selected
				}
				keyfocus
				{
					textcolor 					HoverTextColor
					image						Graphics/Check_MouseOver
				}
				keyfocus_mouseover
				{
					textcolor 					HoverTextColor
					image						Graphics/Check_MouseOver
				}
				selected_mouseover	
				{ 
					textcolor 					HoverTextColor
					image						Graphics/Check_Selected_MouseOver
				}
				selected_mousedown
				{
					textcolor 					HoverTextColor
					image						Graphics/Check_MouseDown
				}
				selected_keyfocus
				{
					textcolor 					HoverTextColor
					image						Graphics/Check_Selected_MouseOver
				}
				selected_keyfocus_mouseover
				{
					textcolor 					HoverTextColor
					image						Graphics/Check_Selected_MouseOver
				}
				disabled
				{
					textcolor					DisabledTextColor
					image 						Graphics/Check_Disabled
				}
				selected_disabled
				{
					textcolor					DisabledTextColor
					image						Graphics/Check_Selected_Disabled
				}
			}
			
			ProgressBar
			{
				textcolor						ProgressColor
				appearance						InputBorder
			}
			
			ListPanel
			{
				appearance						ListPanelExteriorBorder
				scrollbar_visible
				{
					appearance					ListPanelExteriorBorder
				}
			}
			
			ListPanelInterior
			{
				bgcolor							FrameBaseColor
			}
			
			ListPanelSectionHeader
			{
				bgcolor							HoverTextColor
				textcolor						DefaultTextColorLight
			}
			
			ListPanelSectionCollapser
			{
				bgcolor							Blank
				textcolor						DefaultTextColorLight
			}
			
			RichText
			{
				appearance						PanelExteriorBorder
				scrollbar_visible
				{
					appearance					PanelExteriorBorder
				}
			}
			
			RichTextInterior
			{
				bgcolor							FrameBaseColor
			}
			
			SectionedListPanel
			{
				appearance						NoBorder
				scrollbar_visible
				{
					appearance					NoBorder
				}
			}
			
			SectionedListPanelInterior
			{
				appearance						SectionedListPanelInteriorBorder
				scrollbar_visible
				{
					appearance					SectionedListPanelInteriorBorderScroll
				}
			}
			
			HTML
			{
				appearance						HTMLExteriorBorder
				bgcolor							Blank
			}
			
			HTMLInterior
			{
				appearance						HTMLInteriorBorder
				bgcolor							Blank
			}
		}
	}

	

	//
	//////////////////////// layout /////////////////////////////
	//
	// describes default layouts for controls that have and control their own children
	// works just like a normal settings .res file, except only positioning attributes are recognized
	LayoutTemplates
	{
		Frame
		{
			frame_menu
			{
				xpos						10
				ypos						7
				wide						16
				tall						16
				visible						1
			}
			
			frame_title
			{
				xpos							30
				ypos							0
				wide							r64
				tall							30
				AutoResize						1
			}
			
			frame_captiongrip
			{
				xpos							4
				ypos							4
				wide							r20
				tall							20
				AutoResize						1
			}
			
			frame_minimize
			{
				xpos							r70
				ypos							8
				wide							28
				tall							15
				PinCorner						1
			}
			
			frame_close
			{
				xpos							r40
				ypos							8
				wide							28
				tall							15
				PinCorner						1
			}

			frame_brGrip
			{
				xpos							r23
				ypos							r23
				wide							20
				tall							20
				PinCorner						3
			}
		}
		
		PropertyDialog
		{
			sheet
			{
				xpos							8
				ypos							26
				wide							r8
				tall							r48
			}
			
			// these buttons are still a bit special - if some of them are hidden, they shuffle
			// across taking the place of other buttons to make sure there aren't gaps
			ApplyButton
			{
				xpos							r84
				ypos							r36
				wide							72
				tall							24
			}
			
			CancelButton
			{
				xpos							r164
				ypos							r36
				wide							72
				tall							24
			}
			
			OKButton
			{
				xpos							r244
				ypos							r36
				wide							72
				tall							24
			}
		}
		
		WizardPanel
		{
			subpanel
			{
				xpos							8
				ypos							28
				wide							r8
				tall							r48
				AutoResize						3
			}
		
			PrevButton
			{
				xpos							r280
				ypos							r36
				wide							84
				tall							24
				PinCorner						3
			}
			NextButton
			{
				xpos							r188
				ypos							r36
				wide							84
				tall							24
				PinCorner						3
			}
			CancelButton
			{
				xpos							r96
				ypos							r36
				wide							84
				tall							24
				PinCorner						3
			}
			FinishButton
			{
				xpos							r96
				ypos							r36
				wide							84
				tall							24
				PinCorner						3
			}
		}
	
	}

	//
	//////////////////////// FONTS /////////////////////////////
	//
	// describes all the fonts
	Fonts
	{
		// fonts are used in order that they are listed
		// fonts listed later in the order will only be used if they fulfill a range not already filled
		// if a font fails to load then the subsequent fonts will replace
		// fonts are used in order that they are listed
		"Default"
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"13"
				"weight"						"0"
			}
		}
		"DefaultBold"
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"16"
				"weight"						"1000"
			}
		}
		"DefaultUnderline"
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"13"
				"weight"						"0"
				"underline" 					"1"
			}
		}
		"DefaultSmall"
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"11"
				"weight"						"0"
			}
		}
		"ListSmall"
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"12"
				"weight"						"0"
			}
		}
		"DefaultVerySmall"
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"12"
				"weight"						"800"
			}
		}
		"DefaultLarge"
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"18"
				"weight"						"0"
			}
		}
		"UiBold"
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"14"
				"weight"						"1000"
			}
		}
		"HeadlineLarge"
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"22"
				"weight"						"1000"
				"antialias"						"1"
			}
		}
		"UiHeadline"
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"13"
				"weight"						"0"
			}
		}
		"MenuLarge"
		{
			"1"
			{
				"name"							"Verdana"
				"tall"							"16"
				"weight"						"600"
				"antialias" 					"1"
			}
		}
		"Marlett"
		{
			"1"
			{
				"name"							"Marlett"
				"tall"							"14"
				"weight"						"0"
				"symbol"						"1"
			}
		}
		MarlettLarge
		{
			"1"
			{
				"name"							"Marlett"
				"tall"							"16"
				"weight"						"0"
				"symbol"						"1"
			}
		}
		"DefaultFixed"
		{
			"1"
			{
				"name"							"Lucida Console"
				"tall"							"10"
				"weight"						"0"
			}
		}
		FriendsSmall
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"12"
				"weight"						"800"
			}
		}
		FriendsMedium
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"14"
				"weight"						"800"
			}
		}
		FriendsVerySmall
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"12"
				"weight"						"0"
			}
		}
		FriendsVerySmallUnderline
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"12"
				"weight"						"0"
				"underline"						"1"
			}
		}
		OverlayTaskbarFont
		{
			"1"
			{
				"name"							"Tahoma"
				"tall"							"16"
				"weight"						"1000"
			}
		}
	}
	

	//
	//////////////////// Appearances //////////////////////////////
	//
	// describes all the appearance types
	Appearances
	{
		// render render_bg
		// image fill gradient corner dashedrect
	
		BaseBorder		NoBorder
		ComboBoxBorder	NoBorder
		BrowserBorder	NoBorder
		CheckBorder		NoBorder
		
		FrameButtonBorder
		{
			inset							"6 -1 0 0"
			render_bg
			{
				"1"							"image( x0, y0, x1, y1, Graphics/FrameButton )"
			}
		}
		
		FrameButtonBorderOver
		{
			inset							"6 -1 0 0"
			render_bg
			{
				"1"							"image( x0, y0, x1, y1, Graphics/FrameButtonOver )"
			}
		}
		
		FrameButtonBorderDown
		{
			inset							"7 0 0 0"
			render_bg
			{
				"1"							"image( x0, y0, x1, y1, Graphics/FrameButtonDown )"
			}
		}

		ListPanel.HeaderButtonBorder
		{
			inset							"0 3 0 0"
			render_bg
			{
				"1"							"gradient( x0, y0, x1, y1 + 1, FrameBaseColor, BaseBorderColor )"
				"2"							"fill( x0, y1, x1, y1 + 1, BaseBorderColor )"
				"3"							"fill( x1 - 1, y0, x1, y1, BaseBorderColor )"
			}
		}
		
		PropertySheetBorder
		{
			render_bg
			{
				"1"							"fill( x0, y0, x1, y0 + 1, FrameBorderDark )"
				"2"							"fill( x0 - 1, y0, x0, y1, FrameBorderDark )"
				"3"							"fill( x0, y1, x1, y1 + 1, FrameBorderDark )"
				"4"							"fill( x1, y0, x1 + 1, y1, FrameBorderDark )"
			}
		}

		PropertyPageBorder
		{
			render_bg
			{
				"1"							"fill( x0, y0, x1, y1, FrameBaseColor )"
				"2"							"fill( x0, y0, x1, y0 + 1, BaseBorderColor )"
				"3"							"fill( x0, y0, x0 + 1, y1, BaseBorderColor )"
				"4"							"fill( x0, y1 - 1, x1, y1, BaseBorderColor )"
				"5"							"fill( x1 - 1, y0, x1, y1, BaseBorderColor )"
			}
		}
		
		TitleButtonBorder					RaisedBorder
		
		TitleButtonDepressedBorder 			InsetBorder
		
		TitleButtonDisabledBorder
		{
			"backgroundtype" 				"0"
		}
		
		MenuBorder
		{
			"corner_rounding" "3"
			
			Right
			{
				"0"
				{
					"color" "BaseBorderColor"
					"offset" "0 0"
				}
			}

			Left
			{
				"0"
				{
					"color" "BaseBorderColor"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"0"
				{
					"color" "BaseBorderColor"
					"offset" "0 0"
				}
			}

			Top
			{
				"0"
				{
					"color" "BaseBorderColor"
					"offset" "0 0"
				}
			}
		}
		
		FrameBorder
		{
			"corner_rounding"				"12"
			render_bg
			{
				"1"							"gradient( x0, y0, x1, y0 + 15, TitleTopLight, TitleTopDark )"
				"1"							"gradient( x0, y0 + 15, x1, y0 + 30, TitleBottomLight, TitleBottomDark )"
				"2"							"fill( x0, y0 + 30, x1, y1, FrameBaseColor )"
				"3"							"image( x0, y0 + 30, x1, y1 - 30, Graphics/FrameGradient )"
				
				"4"							"fill( x0 + 1, y0 + 1, x1 - 1, y0 + 2, FrameBorderLight  )"			//	Top (Inner)
				"5"							"fll( x0 + 1, y0 + 1, x0 + 2, y1 - 1, FrameBorderLight )"			//	Left (Inner)
				"6"							"fill( x0, y0, x1, y0 + 1, FrameBorderDark )"							//	Left (Outer)
				"7"							"fill( x0, y0, x0 + 1, y1, FrameBorderDark)"							//	Top (Outer)
				
				"8"							"fill( x1 - 2, y0 + 2, x1 - 1, y1 - 1, FrameBorderLight )"			//	Right (Inner)
				"9"							"fill( x0 + 2, y1 - 2, x1 - 1, y1 - 1, FrameBorderLight )"			//	Bottom (Inner)
				"10"						"fill( x1 - 1, y0 + 1, x1, y1, FrameBorderDark )"						//	Right (Outer)
				"11"						"fill( x0 + 1, y1 - 1, x1, y1, FrameBorderDark )"						//	Bottom (Outer)
				
				"12"						"image( x0, y0, x0 + 6, y0 + 6, Graphics/FrameTL )"
				"13"						"image( x1 - 6, y0, x1, y0 + 6, Graphics/FrameTR )"
				"14"						"image( x0, y1 - 6, x0 + 6, y1, Graphics/FrameBL )"
				"15"						"image( x1 - 6, y1 - 6, x1, y1, Graphics/FrameBR )"
			}
		}
		
		DividerBorder
		{
			render_bg
			{
				"1"						"fill( x0, y0, x1, y1, FrameBaseColor )"
			}
			render
			{
				"2"						"fill( x0, y0 + 1, x1, y0 + 2, DividerDark )"
			}
		}
		
		InsetBorder
		{
			"inset" "0 0 1 1"
			Right
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Left
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}

		DepressedBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}

		RaisedBorder
		{
			"inset" "0 0 1 1"
			
			render
			{
				"1"		"fill( x1, y0 + 1, x1 - 1, y1, Border.Dark )"		// right
				"2"		"fill( x0, y0, x0 + 1, y1 - 1, Border.Bright )"		// left
				"3"		"fill( x0, y0, x1, y0 + 1, Border.Bright )"			// top
				"4"		"fill( x0 + 1, y1 - 1, x1, y1, Border.Dark )"		// bottom
			}
		}
		
		ResizeBorder
		{
			render
			{
				"1"		"image( x0, y0, x1, y1, Graphics/resizer )"
			}
		}

		ResizeMouseoverBorder
		{
			render
			{
				"1"		"image( x0, y0, x1, y1, Graphics/resizer_mouseover )"
			}
		}
		
		ResizeMousedownBorder
		{
			render
			{
				"1"		"image( x0, y0, x1, y1, Graphics/resizer_mousedown )"
			}
		}

		ScrollBarButtonBorder
		{
			"inset"							"0 2 0 0"
			render_bg
			{
				"1"							"fill( x0, y0, x1, y1, FrameBaseColor )"
				"2"							"image( x0, y0, x1, y1, Graphics/ScrollButton )"
			}
		}
		
		ScrollBarButtonMouseOverBorder
		{
			"inset"							"0 2 0 0"
			render_bg
			{
				"1"							"fill( x0, y0, x1, y1, FrameBaseColor )"
				"2"							"image( x0, y0, x1, y1, Graphics/ScrollButtonOver )"
			}
		}
		
		ScrollBarSliderBorder
		{
			render_bg
			{
				"1"							"image( x0, y0, x1 - 1, y0 + 5, Graphics/ScrollSliderVTop )"
				"2"							"image( x0, y0 + 5, x1 - 1, y1 - 5, Graphics/ScrollSliderVMiddle )"
				"3"							"image( x0, y1 - 5, x1 - 1, y1, Graphics/ScrollSliderVBottom )"
			}
		}
		
		Horiz_ScrollBarSliderBorder
		{
			render_bg
			{
				"1"							"image( x0, y0, x0 + 5, y1 - 1, Graphics/ScrollSliderHLeft )"
				"2"							"image( x0 + 5, y0, x1 - 5, y1 - 1, Graphics/ScrollSliderHMiddle )"
				"3"							"image( x1 - 5, y0, x1, y1 - 1, Graphics/ScrollSliderHRight )"
			}
		}
		
		OverlayTaskBar
		{
			render
			{
				"1"				"fill( x0, y0, x1, y0 + 1, BaseBorderColor )"
			}
			render_bg
			{
				"1"				"fill( x0, y0, x1, y1, FrameBaseColor )"
			}
		}
		
		TabNormalBorder
		{
			inset							"2 0 0 0"
			render_bg
			{
				"1"							"image( x0, y0, x0 + 5, y1, Graphics/TabNormalLeft )"
				"2"							"image( x0 + 5, y0, x1 - 5, y1, Graphics/TabNormalMiddle )"
				"3"							"image( x1 - 5, y0, x1, y1, Graphics/TabNormalRight )"
			}
		}
		
		TabHoverBorder
		{
			inset							"2 0 0 0"
			render_bg
			{
				"1"							"image( x0, y0, x0 + 5, y1, Graphics/TabHoverLeft )"
				"2"							"image( x0 + 5, y0, x1 - 5, y1, Graphics/TabHoverMiddle )"
				"3"							"image( x1 - 5, y0, x1, y1, Graphics/TabHoverRight )"
			}
		}

		TabActiveBorder
		{
			inset							"2 0 0 0"
			render_bg
			{
				"1"						"image( x0, y0 - 1, x0 + 5, y1, Graphics/TabActiveLeft )"
				"2"						"image( x0 + 5, y0 - 1, x1 - 5, y1, Graphics/TabActiveMiddle )"
				"3"						"image( x1 - 5, y0 - 1, x1, y1, Graphics/TabActiveRight )"
			}
			render
			{
				"1"						"fill( x0 + 2, y1 - 1, x1 - 2, y1, TabBorderOverlapColor )"
			}
		}

		ToolTipBorder
		{
			"corner_rounding" "2"
			render_bg
			{
				"1"		"gradient( x0, y0, x1, y1, ToolTipTopColor, ToolTipBottomColor )"
			}
			
			Right
			{
				"0"
				{
					"color" "ToolTipBorderColor"
					"offset" "0 0"
				}
			}

			Left
			{
				"0"
				{
					"color" "ToolTipBorderColor"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"0"
				{
					"color" "ToolTipBorderColor"
					"offset" "0 0"
				}
			}

			Top
			{
				"0"
				{
					"color" "ToolTipBorderColor"
					"offset" "0 0"
				}
			}
		}
		
		MiniMeShrinkBorder
		{
			inset							"0 0 0 0"
			render_bg
			{
				"1"							"image( x0, y0, x1, y1, Icons/Shrink )"
			}
		}
		
		MiniMeShrinkBorder_mouseover
		{
			inset							"0 0 0 0"
			render_bg
			{
			"1"								"image( x0, y0, x1, y1, Icons/Shrink_Over )"
			}
		}
		
		MiniMeExpandBorder
		{
			inset							"0 0 0 0"
			render_bg
			{
				"1"							"image( x0, y0, x1, y1, Icons/Expand )"
			}
		}
		
		MiniMeExpandBorder_mouseover
		{
			inset							"0 0 0 0"
			render_bg
			{
				"1"							"image( x0, y0, x1, y1, Icons/Expand_Over )"
			}
		}
		
		HomeBorder
		{
			render
			{
				"1"							"image( x0, y0, x1, y1, Icons/HomeNormal )"
			}
		}
		
		HomeBorder_over
		{
			render
			{
				"1"							"image( x0, y0, x1, y1, Icons/HomeOver )"
			}
		}
		
		HomeBorder_down
		{
			render
			{
				"1"							"image( x0, y0, x1, y1, Icons/HomeDown )"
			}
		}
		
		ReloadBorder
		{
			render
			{
				"1"							"image( x0, y0, x1, y1, Icons/ReloadNormal )"
			}
		}
		
		ReloadBorder_over
		{
			render
			{
				"1"							"image( x0, y0, x1, y1, Icons/ReloadOver )"
			}
		}
		
		ReloadBorder_down
		{
			render
			{
				"1"							"image( x0, y0, x1, y1, Icons/ReloadDown )"
			}
		}
		
		BackBorder
		{
			inset							"0 0 0 0"
			render_bg
			{
				"1"							"image( x0, y0, x1, y1, Icons/BackNormal )"
			}
		}
		
		BackBorder_over
		{
			inset							"0 0 0 0"
			render_bg
			{
				"1"							"image( x0, y0, x1, y1, Icons/BackOver )"
			}
		}
		
		BackBorder_down
		{
			inset							"0 0 0 0"
			render_bg
			{
				"1"							"image( x0, y0, x1, y1, Icons/BackDown )"
			}
		}
		
		BackBorder_disabled
		{
			inset							"0 0 0 0"
			render_bg
			{
				"1"							"image( x0, y0, x1, y1, Icons/BackDisabled )"
			}
		}
		
		ForwardBorder
		{
			inset							"0 0 0 0"
			render_bg
			{
				"1"							"image( x0, y0, x1, y1, Icons/ForwardNormal )"
			}
		}
		
		ForwardBorder_over
		{
			inset							"0 0 0 0"
			render_bg
			{
				"1"							"image( x0, y0, x1, y1, Icons/ForwardOver )"
			}
		}
		
		ForwardBorder_down
		{
			inset							"0 0 0 0"
			render_bg
			{
				"1"							"image( x0, y0, x1, y1, Icons/ForwardDown )"
			}
		}
		
		ForwardBorder_disabled
		{
			inset							"0 0 0 0"
			render_bg
			{
				"1"							"image( x0, y0, x1, y1, Icons/ForwardDisabled )"
			}
		}
		
		StopBorder
		{
			render
			{
				"1"							"image( x0, y0, x1, y1, Icons/StopNormal )"
			}
		}
		
		StopBorder_over
		{
			render
			{
				"1"							"image( x0, y0, x1, y1, Icons/StopOver )"
			}
		}
		
		StopBorder_down
		{
			render
			{
				"1"							"image( x0, y0, x1, y1, Icons/StopDown )"
			}
		}
		
		ComboBoxBorder
		{
			inset							"4 -2 0 0"
			render_bg
			{
				"1"							"image( x0 - 3, y0 - 2, x0 + 7, y0 + 8, Buttons/NormalTopLeft )"
				"2"							"image( x0 - 3, y0 + 8, x0 + 7, y1 - 8, Buttons/NormalMiddleLeft )"
				"3"							"image( x0 - 3, y1 - 8, x0 + 7, y1 + 2, Buttons/NormalBottomLeft )"
				
				"4"							"image( x0 + 7, y0 - 2, x1 - 9, y0 + 8, Buttons/NormalTopMiddle )"
				"5"							"image( x0 + 7, y0 + 8, x1 - 9, y1 - 8, Buttons/NormalMiddleMiddle )"
				"6"							"image( x0 + 7, y1 - 8, x1 - 9, y1 + 2, Buttons/NormalBottomMiddle )"
				
				"7"							"image( x1 - 9, y0 - 2, x1 + 1, y0 + 8, Buttons/NormalTopRight )"
				"8"							"image( x1 - 9, y0 + 8, x1 + 1, y1 - 8, Buttons/NormalMiddleRight )"
				"9"							"image( x1 - 9, y1 - 8, x1 + 1, y1 + 2, Buttons/NormalBottomRight )"
			}
		}
		
		ButtonBorder
		{
			inset							"4 0 0 0"
			render_bg
			{
				"1"							"image( x0 - 4, y0 - 2, x0 + 6, y0 + 8, Buttons/NormalTopLeft )"
				"2"							"image( x0 - 4, y0 + 8, x0 + 6, y1 - 9, Buttons/NormalMiddleLeft )"
				"3"							"image( x0 - 4, y1 - 9, x0 + 6, y1 + 1, Buttons/NormalBottomLeft )"
				
				"4"							"image( x0 + 6, y0 - 2, x1 - 6, y0 + 8, Buttons/NormalTopMiddle )"
				"5"							"image( x0 + 6, y0 + 8, x1 - 6, y1 - 9, Buttons/NormalMiddleMiddle )"
				"6"							"image( x0 + 6, y1 - 9, x1 - 6, y1 + 1, Buttons/NormalBottomMiddle )"
				
				"7"							"image( x1 - 6, y0 - 2, x1 + 4, y0 + 8, Buttons/NormalTopRight )"
				"8"							"image( x1 - 6, y0 + 8, x1 + 4, y1 - 9, Buttons/NormalMiddleRight )"
				"9"							"image( x1 - 6, y1 - 9, x1 + 4, y1 + 1, Buttons/NormalBottomRight )"
			}
		}

		ButtonDefaultBorder
		{
			inset							"4 0 0 0"
			render_bg
			{
				"1"							"image( x0 - 4, y0 - 2, x0 + 6, y0 + 8, Buttons/DefaultTopLeft )"
				"2"							"image( x0 - 4, y0 + 8, x0 + 6, y1 - 9, Buttons/DefaultMiddleLeft )"
				"3"							"image( x0 - 4, y1 - 9, x0 + 6, y1 + 1, Buttons/DefaultBottomLeft )"
				
				"4"							"image( x0 + 6, y0 - 2, x1 - 6, y0 + 8, Buttons/DefaultTopMiddle )"
				"5"							"image( x0 + 6, y0 + 8, x1 - 6, y1 - 9, Buttons/DefaultMiddleMiddle )"
				"6"							"image( x0 + 6, y1 - 9, x1 - 6, y1 + 1, Buttons/DefaultBottomMiddle )"
				
				"7"							"image( x1 - 6, y0 - 2, x1 + 4, y0 + 8, Buttons/DefaultTopRight )"
				"8"							"image( x1 - 6, y0 + 8, x1 + 4, y1 - 9, Buttons/DefaultMiddleRight )"
				"9"							"image( x1 - 6, y1 - 9, x1 + 4, y1 + 1, Buttons/DefaultBottomRight )"
			}
		}
		
		ButtonMouseOverBorder
		{
			inset							"4 0 0 0"
			render_bg
			{
				"1"							"image( x0 - 4, y0 - 2, x0 + 6, y0 + 8, Buttons/HoverTopLeft )"
				"2"							"image( x0 - 4, y0 + 8, x0 + 6, y1 - 9, Buttons/HoverMiddleLeft )"
				"3"							"image( x0 - 4, y1 - 9, x0 + 6, y1 + 1, Buttons/HoverBottomLeft )"
				
				"4"							"image( x0 + 6, y0 - 2, x1 - 6, y0 + 8, Buttons/HoverTopMiddle )"
				"5"							"image( x0 + 6, y0 + 8, x1 - 6, y1 - 9, Buttons/HoverMiddleMiddle )"
				"6"							"image( x0 + 6, y1 - 9, x1 - 6, y1 + 1, Buttons/HoverBottomMiddle )"
				
				"7"							"image( x1 - 6, y0 - 2, x1 + 4, y0 + 8, Buttons/HoverTopRight )"
				"8"							"image( x1 - 6, y0 + 8, x1 + 4, y1 - 9, Buttons/HoverMiddleRight )"
				"9"							"image( x1 - 6, y1 - 9, x1 + 4, y1 + 1, Buttons/HoverBottomRight )"
			}
		}

		ButtonDepressedBorder
		{
			inset							"5 1 0 0"
			render_bg
			{
				"1"							"image( x0 - 4, y0 - 2, x0 + 6, y0 + 8, Buttons/DownTopLeft )"
				"2"							"image( x0 - 4, y0 + 8, x0 + 6, y1 - 9, Buttons/DownMiddleLeft )"
				"3"							"image( x0 - 4, y1 - 9, x0 + 6, y1 + 1, Buttons/DownBottomLeft )"
				
				"4"							"image( x0 + 6, y0 - 2, x1 - 6, y0 + 8, Buttons/DownTopMiddle )"
				"5"							"image( x0 + 6, y0 + 8, x1 - 6, y1 - 9, Buttons/DownMiddleMiddle )"
				"6"							"image( x0 + 6, y1 - 9, x1 - 6, y1 + 1, Buttons/DownBottomMiddle )"
				
				"7"							"image( x1 - 6, y0 - 2, x1 + 4, y0 + 8, Buttons/DownTopRight )"
				"8"							"image( x1 - 6, y0 + 8, x1 + 4, y1 - 9, Buttons/DownMiddleRight )"
				"9"							"image( x1 - 6, y1 - 9, x1 + 4, y1 + 1, Buttons/DownBottomRight )"
			}
		}

		ButtonDisabledBorder
		{
			inset							"4 0 0 0"
			render_bg
			{
				"1"							"image( x0 - 4, y0 - 2, x0 + 6, y0 + 8, Buttons/DisabledTopLeft )"
				"2"							"image( x0 - 4, y0 + 8, x0 + 6, y1 - 9, Buttons/DisabledMiddleLeft )"
				"3"							"image( x0 - 4, y1 - 9, x0 + 6, y1 + 1, Buttons/DisabledBottomLeft )"
				
				"4"							"image( x0 + 6, y0 - 2, x1 - 6, y0 + 8, Buttons/DisabledTopMiddle )"
				"5"							"image( x0 + 6, y0 + 8, x1 - 6, y1 - 9, Buttons/DisabledMiddleMiddle )"
				"6"							"image( x0 + 6, y1 - 9, x1 - 6, y1 + 1, Buttons/DisabledBottomMiddle )"
				
				"7"							"image( x1 - 6, y0 - 2, x1 + 4, y0 + 8, Buttons/DisabledTopRight )"
				"8"							"image( x1 - 6, y0 + 8, x1 + 4, y1 - 9, Buttons/DisabledMiddleRight )"
				"9"							"image( x1 - 6, y1 - 9, x1 + 4, y1 + 1, Buttons/DisabledBottomRight )"
			}
		}
		
		SectionedListPanelInteriorBorder
		{
			render_bg
			{
				"1"							"fill( x0, y0, x1, y1, FrameBaseColor )"
			}
			render
			{
				"2"							"fill( x0, y0, x0 + 1, y1, BaseBorderColor )"
				"3"							"fill( x0, y1 - 1, x1, y1, BaseBorderColor )"
				"4"							"fill( x1 - 1, y0, x1, y1, BaseBorderColor )"
			}
		}
		
		SectionedListPanelInteriorBorderScroll
		{
			render_bg
			{
				"1"							"fill( x0, y0, x1, y1, FrameBaseColor )"
			}
			render
			{
				"2"							"fill( x0, y0, x0 + 1, y1, BaseBorderColor )"
				"3"							"fill( x0, y1 - 1, x1 + 17, y1, BaseBorderColor )"
				"4"							"fill( x1 + 17, y0, x1 + 18, y1, BaseBorderColor )"
			}
		}
		
		HTMLExteriorBorder
		{
			render
			{
				"1"							"fill( x0, y0, x0 + 1, y1, BaseBorderColor )"
				"2"							"fill( x0, y1 - 1, x1, y1, BaseBorderColor )"
				"3"							"fill( x1 - 1, y0, x1, y1, BaseBorderColor )"
				"4"							"fill( x0, y0 - 1, x1, y0, BaseBorderColor )"
			}
		}
		
		HTMLInteriorBorder
		{
			render
			{
				"1"							"fill( x0, y0, x0 + 1, y1, BaseBorderColor )"
				"2"							"fill( x0, y1 - 1, x1, y1, BaseBorderColor )"
				"4"							"fill( x0, y0 - 1, x1, y0, BaseBorderColor )"
			}
		}
		
		PanelExteriorBorder_Alt
		{
			render
			{
				"1"							"fill( x0, y0, x0 + 1, y1, BaseBorderColor )"
				"2"							"fill( x0, y1 - 1, x1, y1, BaseBorderColor )"
				"3"							"fill( x1 - 1, y0, x1, y1, BaseBorderColor )"
				"4"							"fill( x0, y0 - 1, x1, y0, BaseBorderColor )"
			}
		}
		
		PanelExteriorBorder
		{
			render
			{
				"1"							"fill( x0, y0, x0 + 1, y1, BaseBorderColor )"
				"2"							"fill( x0, y1 - 1, x1, y1, BaseBorderColor )"
				"3"							"fill( x1 - 1, y0, x1, y1, BaseBorderColor )"
				"4"							"fill( x0, y0, x1, y0 + 1, BaseBorderColor )"
			}
		}
		
		ListPanelExteriorBorder
		{
			render_bg
			{
				"1"							"gradient( x0, y0, x1, y0 + 21, FrameBaseColor, BaseBorderColor )"
				"2"							"fill( x0, y0 + 20, x1, y0 + 21, BaseBorderColor )"
			}
			render
			{
				"3"							"fill( x0, y0, x0 + 1, y1, BaseBorderColor )"
				"4"							"fill( x0, y1, x1, y1 + 1, BaseBorderColor )"
				"5"							"fill( x1 - 1, y0, x1, y1, BaseBorderColor )"
				"6"							"fill( x0, y0, x1, y0 + 1, BaseBorderColor )"
			}
		}

		InputBorder
		{
			inset							"4 0 0 0"
			render_bg
			{
				"1"							"image( x0 - 3, y0 - 2, x0 + 7, y0 + 8, Buttons/InputTopLeft )"
				"2"							"image( x0 - 3, y0 + 8, x0 + 7, y1 - 8, Buttons/InputMiddleLeft )"
				"3"							"image( x0 - 3, y1 - 8, x0 + 7, y1 + 2, Buttons/InputBottomLeft )"
				
				"4"							"image( x0 + 7, y0 - 2, x1 - 9, y0 + 8, Buttons/InputTopMiddle )"
				"5"							"image( x0 + 7, y0 + 8, x1 - 9, y1 - 8, Buttons/InputMiddleMiddle )"
				"6"							"image( x0 + 7, y1 - 8, x1 - 9, y1 + 2, Buttons/InputBottomMiddle )"
				
				"7"							"image( x1 - 9, y0 - 2, x1 + 1, y0 + 8, Buttons/InputTopRight )"
				"8"							"image( x1 - 9, y0 + 8, x1 + 1, y1 - 8, Buttons/InputMiddleRight )"
				"9"							"image( x1 - 9, y1 - 8, x1 + 1, y1 + 2, Buttons/InputBottomRight )"
			}
		}

		InputBorderDisabled
		{
			inset							"1 -1 0 0"
			render_bg
			{
				"1"							"image( x0 - 4, y0 - 2, x0 + 6, y0 + 8, Buttons/DisabledTopLeft )"
				"2"							"image( x0 - 4, y0 + 8, x0 + 6, y1 - 9, Buttons/DisabledMiddleLeft )"
				"3"							"image( x0 - 4, y1 - 9, x0 + 6, y1 + 1, Buttons/DisabledBottomLeft )"
				
				"4"							"image( x0 + 6, y0 - 2, x1 - 6, y0 + 8, Buttons/DisabledTopMiddle )"
				"5"							"image( x0 + 6, y0 + 8, x1 - 6, y1 - 9, Buttons/DisabledMiddleMiddle )"
				"6"							"image( x0 + 6, y1 - 9, x1 - 6, y1 + 1, Buttons/DisabledBottomMiddle )"
				
				"7"							"image( x1 - 6, y0 - 2, x1 + 4, y0 + 8, Buttons/DisabledTopRight )"
				"8"							"image( x1 - 6, y0 + 8, x1 + 4, y1 - 9, Buttons/DisabledMiddleRight )"
				"9"							"image( x1 - 6, y1 - 9, x1 + 4, y1 + 1, Buttons/DisabledBottomRight )"
			}
		}

		ChatInputBorder
		{
			inset							"4 4 0 0"
			render_bg
			{
				"1"							"image( x0 - 3, y0 - 2, x0 + 7, y0 + 8, Buttons/InputTopLeft )"
				"2"							"image( x0 - 3, y0 + 8, x0 + 7, y1 - 8, Buttons/InputMiddleLeft )"
				"3"							"image( x0 - 3, y1 - 8, x0 + 7, y1 + 2, Buttons/InputBottomLeft )"
				
				"4"							"image( x0 + 7, y0 - 2, x1 - 9, y0 + 8, Buttons/InputTopMiddle )"
				"5"							"image( x0 + 7, y0 + 8, x1 - 9, y1 - 8, Buttons/InputMiddleMiddle )"
				"6"							"image( x0 + 7, y1 - 8, x1 - 9, y1 + 2, Buttons/InputBottomMiddle )"
				
				"7"							"image( x1 - 9, y0 - 2, x1 + 1, y0 + 8, Buttons/InputTopRight )"
				"8"							"image( x1 - 9, y0 + 8, x1 + 1, y1 - 8, Buttons/InputMiddleRight )"
				"9"							"image( x1 - 9, y1 - 8, x1 + 1, y1 + 2, Buttons/InputBottomRight )"
			}
		}

		ChatInputBorderDisabled
		{
			inset							"1 0 0 0"
			render_bg
			{
				"1"							"image( x0 - 4, y0 - 2, x0 + 6, y0 + 8, Buttons/DisabledTopLeft )"
				"2"							"image( x0 - 4, y0 + 8, x0 + 6, y1 - 9, Buttons/DisabledMiddleLeft )"
				"3"							"image( x0 - 4, y1 - 9, x0 + 6, y1 + 1, Buttons/DisabledBottomLeft )"
				
				"4"							"image( x0 + 6, y0 - 2, x1 - 6, y0 + 8, Buttons/DisabledTopMiddle )"
				"5"							"image( x0 + 6, y0 + 8, x1 - 6, y1 - 9, Buttons/DisabledMiddleMiddle )"
				"6"							"image( x0 + 6, y1 - 9, x1 - 6, y1 + 1, Buttons/DisabledBottomMiddle )"
				
				"7"							"image( x1 - 6, y0 - 2, x1 + 4, y0 + 8, Buttons/DisabledTopRight )"
				"8"							"image( x1 - 6, y0 + 8, x1 + 4, y1 - 9, Buttons/DisabledMiddleRight )"
				"9"							"image( x1 - 6, y1 - 9, x1 + 4, y1 + 1, Buttons/DisabledBottomRight )"
			}
		}
		
		MenuItemSelected
		{
			"inset"							"2 0 0 0"
			render_bg
			{
				"1"							"fill( x0, y0, x1, y1, FrameBaseColor )"
				"2"							"image( x0, y0, x0 + 2, y1, Graphics/GamesListLeftSelected )"
				"3"							"image( x0 + 2, y0, x1, y1, Graphics/GamesListMiddleSelected )"
			}
		}
		
		GamesListSelected
		{
			"inset"							"2 0 0 0"
			render_bg
			{
				"1"							"image( x0, y0, x0 + 2, y1, Graphics/GamesListLeftSelected )"
				"2"							"image( x0 + 2, y0, x1, y1, Graphics/GamesListMiddleSelected )"
			}
		}
		
		NoBorder
		{
			"inset" "0 0 0 0"
			render
			{
			}
		}
		
		CChatInviteBG
		{
			render_bg
			{
				"1"							"fill( x0, y0, x1, y1, FrameBaseColor )"
			}
			render
			{
				"2"							"fill( x0, y0, x0 + 1, y1, BaseBorderColor )"
				"3"							"fill( x0, y1 - 1, x1, y1, BaseBorderColor )"
				"4"							"fill( x1 - 1, y0, x1, y1, BaseBorderColor )"
				"5"							"fill( x0, y0, x1, y0 + 1, BaseBorderColor )"
			}
		}
		
		VoiceChatOffBG
		{
			inset							"1 1 1 1"
			render_bg
			{
				"1"							"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, FrameBaseColor )"
			}
			render
			{
				"2"							"fill( x0, y0, x0 + 1, y1, BaseBorderColor )"
				"3"							"fill( x0, y1 - 1, x1, y1, BaseBorderColor )"
				"4"							"fill( x1 - 1, y0, x1, y1, BaseBorderColor )"
				"5"							"fill( x0, y0, x1, y0 + 1, BaseBorderColor )"
			}
		}
		
		VoiceChatOnBG
		{
			inset							"1 1 1 1"
			render_bg
			{
				"1"							"gradient( x0 + 1, y0 + 1, x1 - 1, y1 - 1, ChatGradientTop, ChatGradientBottom )"
			}
			render
			{
				"2"							"fill( x0, y0, x0 + 1, y1, BaseBorderColor )"
				"3"							"fill( x0, y1 - 1, x1, y1, BaseBorderColor )"
				"4"							"fill( x1 - 1, y0, x1, y1, BaseBorderColor )"
				"5"							"fill( x0, y0, x1, y0 + 1, BaseBorderColor )"
			}
		}

		FriendPanelMouseOver
		{
			render_bg
			{
				"1"							"image( x0, y0 + 2, x0 + 5, y0 + 50, Graphics/FriendsPanelLeftOver )"
				"2"							"image( x0 + 5, y0 + 2, x1 - 5, y0 + 50, Graphics/FriendsPanelMiddleOver )"
				"3"							"image( x1 - 7, y0 + 2, x1 - 2, y0 + 50, Graphics/FriendsPanelRightOver )"
			}
		}

		FriendPanelSelected
		{
			render_bg
			{
				"1"							"image( x0, y0 + 2, x0 + 5, y0 + 50, Graphics/FriendsPanelLeftSelected )"
				"2"							"image( x0 + 5, y0 + 2, x1 - 5, y0 + 50, Graphics/FriendsPanelMiddleSelected )"
				"3"							"image( x1 - 7, y0 + 2, x1 - 2, y0 + 50, Graphics/FriendsPanelRightSelected )"
			}
		}
		
		FriendPanelAffordanceMouseover
		{
			render_bg
			{
				"1"							"fill(  x0 + 3, y0 + 1, x1 - 2, y1 - 2, Black )"
				"1"							"fill(  x0 + 2, y0 + 2, x1 - 1, y1 - 3, Black )"
			}
		}
		
		FriendPanelAffordanceMousedown
		{
			render_bg
			{
				"1"							"fill(  x0 + 3, y0 + 2, x1 - 2, y1 - 2, Blank )"
				"1"							"fill(  x0 + 2, y0 + 3, x1 - 1, y1 - 3, Blank )"
			}
		}
	}
}
