/*
Base Builder Zombie Mod
By: Tirant
*/

#include <amxmodx>
#include <amxmisc>
#include <cstrike>
#include <fakemeta>
#include <engine>
#include <hamsandwich>
#include <fun>
#include <csstats>
#include <csx>
#include <xs>

// Plugin Version
new VERSION[]="5.4"
new formatmodname[] = "^x01 [^x04 Base Builder^x01 ]"

//Models
new const g_ZombieModel[] = "classic2"

//Sounds
new g_RoundStart[] = "basebuilder/round_start.wav"

#define MAX_PLAYERS 32
#define AMMO_SLOT 376
#define MODELSET_TASK 100
#define MODELCHANGE_DELAY 0.5
#define MAXENTS 1365
#define TASK_ROUND 1023
#define AUTO_TEAM_JOIN_DELAY 0.1
#define TEAM_SELECT_VGUI_MENU_ID 2

#define AFTER_BUILD ADMIN_LEVEL_A
#define DEAD_BUILD ADMIN_LEVEL_B
#define REMOVE_BLOCK ADMIN_LEVEL_C
#define DEAD_REMOVE ADMIN_LEVEL_D
#define LOCK_BLOCKS ADMIN_KICK
#define PAIN_SHOCK_FREE ADMIN_KICK
#define BAD_SPAWN ADMIN_KICK
#define BUILD_BAN ADMIN_KICK
#define REVIVE ADMIN_KICK
#define SWAP ADMIN_KICK
#define START_ROUND ADMIN_BAN

#if cellbits == 32
    #define OFFSET_BUYZONE 235
#else
    #define OFFSET_BUYZONE 268
#endif

#define LockBlock(%1)     ( entity_set_int( %1, EV_INT_iuser1, 1 ) )
#define UnlockBlock(%1)   ( entity_set_int( %1, EV_INT_iuser1, 0 ) )
#define IsBlockLocked(%1) ( entity_get_int( %1, EV_INT_iuser1 ) == 1 )

// CS Weapon CBase Offsets (win32)
const OFFSET_WEAPONOWNER = 41

// Linux diff's
const OFFSET_LINUX_WEAPONS = 4

new gmsgStatusText
new gmsgSayText
new gHudSyncInfo
new g_MaxPlayers
const fPainShock = 108

new bool:g_CanBuild
new bool:g_ZombiesReleased
new g_RoundNum
new g_iEntBarrier
new bool:g_BuildBan[MAX_PLAYERS+1]
new g_pEnt[MAX_PLAYERS+1], g_pDist[MAX_PLAYERS+1]
new bool:g_MovingEnt[MAXENTS]
new g_EntMover[MAXENTS]
new g_LastMover[MAXENTS]
new g_EntOwner[MAXENTS]
new g_OwnedEnts[33]

//Custom Model Stuff
new Float:g_ModelsTargetTime, Float:g_RoundStartTime
new g_HasCustomModel[MAX_PLAYERS+1], g_PlayerModel[MAX_PLAYERS+1][32]

new g_ModName[32]
new g_CurrentWeapon[MAX_PLAYERS+1]
new g_PrimaryWeapon[MAX_PLAYERS+1]

// Allowed weapons for zombies
const ZOMBIE_ALLOWED_WEAPONS_BITSUM = (1<<CSW_KNIFE)

new g_pcvar_team, g_pcvar_class, g_pcvar_buildtime, g_pcvar_zombiehp, g_pcvar_maxrounds, g_pcvar_basecalc,
	g_pcvar_givenades, g_pcvar_allowedweps, g_pcvar_tournymode, g_pcvar_showmovers, g_pcvar_healthtime,
	g_pcvar_blockgrav, g_pcvar_knockback, g_pcvar_entmindist, g_pcvar_entsetdist, g_pcvar_entmaxdist,
	g_pcvar_roundnum, g_pcvar_roundtime, g_pcvar_resetent, g_pcvar_zresptime, g_pcvar_maxclaimable,
	g_pcvar_claimable
	
new g_friend[MAX_PLAYERS+1]

//Cached Stuff for Players
new g_isconnected[MAX_PLAYERS+1]
new g_isalive[MAX_PLAYERS+1] 
new g_ishuman[MAX_PLAYERS+1]
new g_iszombie[MAX_PLAYERS+1]

//CSDM-Style Weapons Menu
new bool:firsttime[MAX_PLAYERS+1],bool:ask[MAX_PLAYERS+1]
new weapon_picked[2][MAX_PLAYERS+1],cur_offset[MAX_PLAYERS+1],options_on_menu[8][MAX_PLAYERS+1]

new count_down

// Weapon entity names
new const WEAPONENTNAMES[][] = { "", "weapon_p228", "", "weapon_scout", "weapon_hegrenade", "weapon_xm1014", "weapon_c4", "weapon_mac10",
			"weapon_aug", "weapon_smokegrenade", "weapon_elite", "weapon_fiveseven", "weapon_ump45", "weapon_sg550",
			"weapon_galil", "weapon_famas", "weapon_usp", "weapon_glock18", "weapon_awp", "weapon_mp5navy", "weapon_m249",
			"weapon_m3", "weapon_m4a1", "weapon_tmp", "weapon_g3sg1", "weapon_flashbang", "weapon_deagle", "weapon_sg552",
			"weapon_ak47", "weapon_knife", "weapon_p90" }
			
static const WEAPONNAMES[24][23] = { "Schmidt Scout", "XM1014 M4", "Ingram MAC-10", "Steyr AUG A1", "UMP 45", "SG-550 Auto-Sniper",
			"IMI Galil", "Famas", "AWP Magnum Sniper", "MP5 Navy", "M249 Para Machinegun", "M3 Super 90", "M4A1 Carbine",
			"Schmidt TMP", "G3SG1 Auto-Sniper", "SG-552 Commando", "AK-47 Kalashnikov", "ES P90", "P228 Compact",
			"Dual Elite Berettas", "Fiveseven", "USP .45 ACP Tactical", "Glock 18C", "Desert Eagle .50 AE"
}

public plugin_init()
{
	register_plugin("Base Builder Zombie Mod", VERSION, "Tirant")
	register_cvar("base_builder", VERSION, FCVAR_SPONLY|FCVAR_SERVER)
	set_cvar_string("base_builder", VERSION)
	
	g_pcvar_buildtime = register_cvar("bb_build_time", "150")
	g_pcvar_zombiehp = register_cvar("bb_zombie_health", "2500")
	g_pcvar_basecalc = register_cvar("bb_calc_maxbase", "0")
	g_pcvar_tournymode = register_cvar("bb_tournament_mode", "0")
	g_pcvar_showmovers = register_cvar("bb_show_moving", "1")
	g_pcvar_blockgrav = register_cvar("bb_block_gravity", "0")
	g_pcvar_knockback = register_cvar("bb_pain_shock_free", "0")
	g_pcvar_entmaxdist = register_cvar("bb_max_move_dist", "960")
	g_pcvar_entmindist = register_cvar("bb_min_move_dist", "25")
	g_pcvar_entsetdist = register_cvar("bb_min_dist_set", "50")
	g_pcvar_healthtime = register_cvar("bb_health_time", "12")
	g_pcvar_resetent = register_cvar("bb_reset_blocks", "1")
	g_pcvar_roundtime = register_cvar("bb_roundtime", "9")
	g_pcvar_zresptime = register_cvar("bb_zombie_respawn_time", "5")
	g_pcvar_roundnum = register_cvar("bb_rounds", "4")
	g_pcvar_maxrounds = get_cvar_num("mp_maxrounds")
	g_pcvar_maxclaimable = register_cvar("bb_claim_max", "6")
	g_pcvar_claimable = register_cvar("bb_claim_mode", "0")
		
	//AJC for auto team (if needed)
	g_pcvar_team = register_cvar("bb_team", "5")
	g_pcvar_class = register_cvar("bb_class", "5")
		
	//Guns Menu
	g_pcvar_givenades = register_cvar("bb_give_nades","h") //h f s, put multiple letters for multiple nades
	g_pcvar_allowedweps = register_cvar("bb_weapons","abcdeghijlmnqrstuvwx")
	
	//Client Commands
	register_clcmd("+grab","cmdMoveEnt",_," - Starts moving the selected object") 		//command to move stuff around
	register_clcmd("-grab","cmdStopEnt",_," - Stops moving the selected object") 		//command to move stuff around
	register_clcmd("say /respawn","Respawn_Zombie",_," - Respawn while dead (Zombie)")	//command to respawn (zombies only)
	register_clcmd("say /fixspawn","cmdBadSpawn",_," - Respawn while dead (Survivor)")	//command to respawn (humans only before buildtime)
	register_clcmd("say /help","cmdHelp",_," - Displays the help hud") 			//command to see /help menu
	register_clcmd("say /rules","cmdHelp",_," - Displays the help hud") 			//command to see /help menu
	register_clcmd("say /round","cmdCheckRound",_," - Displays the round number")		//command to see the current round number
	register_clcmd("say round","cmdCheckRound",_," - Displays the round number")		//command to see the current round number
	
	//Guns Menu
	register_clcmd("say guns","cmdGuns",_," - Opens the guns menu") 				//Guns Menu CMD
	register_clcmd("say_team guns","cmdGuns",_," - Opens the guns menu")			//Guns Menu CMD
	register_clcmd("say /guns","cmdGuns",_," - Opens the guns menu")			//Guns Menu CMD
	register_clcmd("say_team /guns","cmdGuns",_," - Opens the guns menu")			//Guns Menu CMD
	
	//Admin Commands
	register_concmd("removeaim","cmdRemoveEnt",_," - Deletes an object") 			//Removes an object (C alive, D dead)
	register_concmd("lockaim","cmdLockBlock",_," - Locks/Unlocks an object from moving")	//Once to lock, again to unlock
	register_concmd("unclaimaim","cmdRemoveClaim",_," - Removes a claim on an object")	//Makes block claimable by everyone
	register_concmd("say /fixspawns","cmdBadSpawn_Survivor",_," - Respawns all dead CTs") 	//Global /fixspawn command (Kick)
	register_concmd("say /respawns","cmdBadSpawn_Zombie",_," - Respawns all dead Ts") 	//Global /respawn command (Kick)
	register_concmd("bb_buildban","cmdBuildBan",_,"<player>") 				//Bans targeted player from building
	register_concmd("bb_unbuildban","cmdBuildUnban",_,"<player>") 				//Unbans   "	   "     "     "
	register_concmd("bb_revive","cmdRevive",_,"<player>")					//revives targetted player
	register_concmd("bb_swap","cmdSwap",_,"<player>")					//swaps the selected player to the opposite team
	register_concmd("bb_startround","cmdStartRound",_," - Ends the build phase")		//do i really have to explain this?
	
	//Blocked Commands
	register_clcmd("drop", "clcmd_drop")
	register_clcmd("buy", "clcmd_buy")
	
	new tournymode = get_pcvar_num(g_pcvar_tournymode)
	if (tournymode != 1)
	{
		register_clcmd("chooseteam", "clcmd_changeteam")
		register_clcmd("jointeam", "clcmd_changeteam")
	}
	
	register_forward(FM_GetGameDescription, "fw_GetGameDescription")
	register_forward(FM_SetClientKeyValue, "fw_SetClientKeyValue")
	register_forward(FM_ClientUserInfoChanged, "fw_ClientUserInfoChanged")
	register_forward(FM_PlayerPreThink, "fw_Player_PreThink")
	register_forward(FM_ClientKill, "fw_Suicide")
	//register_forward(FM_CmdStart, "fw_CmdStart")
	if (get_pcvar_num(g_pcvar_showmovers) == 1)
		register_forward(FM_TraceLine, "fw_Traceline")
	
	RegisterHam(Ham_Touch, "weapon_shield", "ham_WeaponCleaner_Post", 1)
	RegisterHam(Ham_Touch, "weaponbox", "ham_WeaponCleaner_Post", 1)
	RegisterHam(Ham_Spawn, "player", "ham_PlayerSpawn_Post", 1)
	for (new i = 1; i < sizeof WEAPONENTNAMES; i++)
		if (WEAPONENTNAMES[i][0]) RegisterHam(Ham_Item_Deploy, WEAPONENTNAMES[i], "ham_ItemDeploy_Post", 1)

	
	register_message(get_user_msgid("TextMsg"), "msgRoundEnd")
	register_message(get_user_msgid("StatusIcon"), "msgStatusIcon")
	register_message(get_user_msgid("StatusValue"), "msgStatusValue");
	if (tournymode != 1)
	{
		register_message(get_user_msgid("ShowMenu"), "message_show_menu")
		register_message(get_user_msgid("VGUIMenu"), "message_vgui_menu")
	}
	
	register_event("HLTV", "event_round_start", "a", "1=0", "2=0")
	register_event("AmmoX", "ev_AmmoX", "be", "1=1", "1=2", "1=3", "1=4", "1=5", "1=6", "1=7", "1=8", "1=9", "1=10")
	register_event("StatusValue", "ev_SetTeam", "be", "1=1");
	register_event("StatusValue", "ev_ShowStatus", "be", "1=2", "2!0");
	register_event("StatusValue", "ev_HideStatus", "be", "1=1", "2=0");
	register_event("Health", "ev_Health", "be", "1>0");
		
	register_logevent("logevent_round_start",2, "1=Round_Start")
	register_logevent("logevent_round_end", 2, "1=Round_End")
	
	register_menucmd(register_menuid("WeaponMethodMenu"),(1<<0)|(1<<1)|(1<<2),"weapon_method_pushed")
	register_menucmd(register_menuid("PrimaryWeaponSelect"),(1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)|(1<<8)|(1<<9),"prim_weapons_pushed")
	register_menucmd(register_menuid("SecWeaponSelect"),(1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7),"sec_weapons_pushed")

	set_msg_block(get_user_msgid("ClCorpse"), BLOCK_SET)
	
	//Formats the Mod Name
	formatex(g_ModName, charsmax(g_ModName), "Base Builder %s", VERSION)
	
	register_dictionary("basebuilder.txt");
	
	gmsgSayText = get_user_msgid("SayText")
	gmsgStatusText = get_user_msgid("StatusText");
	gHudSyncInfo = CreateHudSyncObj();
	g_MaxPlayers = get_maxplayers()

	if (tournymode != 1)
	{
		server_cmd("mp_limitteams 1")
		server_cmd("mp_autoteambalance 1")
	}
	else
	{
		server_cmd("mp_limitteams 0")
		server_cmd("mp_autoteambalance 0")		
	}
	new roundnum = get_pcvar_num(g_pcvar_roundnum)
	server_cmd("mp_freezetime 0")
	server_cmd("mp_flashlight 0")
	server_cmd("mp_maxrounds %d", roundnum)
	server_cmd("mp_winlimit %d", roundnum)
	server_cmd("mp_roundtime %d", get_pcvar_num(g_pcvar_roundtime))
	
	g_iEntBarrier = find_ent_by_tname( -1, "barrier" );
}

public plugin_precache()
{
	new szModel[ 64 ];
	formatex( szModel, charsmax( szModel ), "models/player/%s/%s.mdl", g_ZombieModel, g_ZombieModel );
	engfunc( EngFunc_PrecacheModel, szModel );
	
	engfunc( EngFunc_PrecacheSound, g_RoundStart )

	new ent = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "info_bomb_target"))
	if (ent) 
	{
		dllfunc(DLLFunc_Spawn, ent)
		set_pev(ent, pev_solid, SOLID_NOT)
	}
	
	new iBuyZone = create_entity("info_map_parameters");
	DispatchKeyValue(iBuyZone, "bombradius", "0");
	DispatchKeyValue(iBuyZone, "buying", "3");
	DispatchSpawn(iBuyZone);
}

// Event Round Start (This is before freeze time)
public event_round_start()
{
	g_RoundStartTime = get_gametime()
	g_ZombiesReleased = false
	
	if (get_pcvar_num(g_pcvar_resetent) == 1)
	{
		new cname[10], tname[7];
		for (new iEnt = g_MaxPlayers+1; iEnt < MAXENTS; iEnt++)
		{
			if( is_valid_ent(iEnt) )
			{
				entity_get_string(iEnt, EV_SZ_classname, cname, 9);
				entity_get_string(iEnt, EV_SZ_targetname, tname, 6);
				if ( !IsBlockLocked(iEnt) && iEnt != g_iEntBarrier && equal(cname, "func_wall") && !equal(tname, "ignore"))
					engfunc( EngFunc_SetOrigin, iEnt, Float:{ 0.0, 0.0, 0.0 } );
			}
		}
	}
}

public cmdHelp(id)
{
	set_hudmessage(255, 255, 255, -1.0, 0.45, 0, 1.0, 15.0, 0.1, 0.2, 2)
	new nLen, szHelp[512]
	nLen += format( szHelp[nLen], 511-nLen, "%L", LANG_SERVER, "WELCOME_MSG", VERSION);
	nLen += format( szHelp[nLen], 511-nLen, "%L", LANG_SERVER, "BIND_KEY");
	nLen += format( szHelp[nLen], 511-nLen, "%L", LANG_SERVER, "RULE1");
	nLen += format( szHelp[nLen], 511-nLen, "%L", LANG_SERVER, "RULE2");
	nLen += format( szHelp[nLen], 511-nLen, "%L", LANG_SERVER, "RULE3");
	nLen += format( szHelp[nLen], 511-nLen, "%L", LANG_SERVER, "RULE4");
	nLen += format( szHelp[nLen], 511-nLen, "%L", LANG_SERVER, "RULE5");
	show_hudmessage(id, szHelp);
}

// Log Event Round Start (This is AFTER freeze time)
public logevent_round_start()
{
	set_pev(g_iEntBarrier,pev_solid,SOLID_BSP)
	set_pev(g_iEntBarrier,pev_rendermode,1)
	DispatchKeyValue(g_iEntBarrier, "renderamt", "255");
	
	set_hudmessage(255, 255, 255, -1.0, 0.45, 0, 1.0, 10.0, 0.1, 0.2, 1)
	new nLen, szMsg[128]
	nLen += format( szMsg[nLen], 127-nLen, "%L", LANG_SERVER, "WELCOME_MSG", VERSION);
	nLen += format( szMsg[nLen], 127-nLen, "%L", LANG_SERVER, "BIND_KEY");
	show_hudmessage(0, szMsg);
	
	print_color(0, "%s %s ^x04- ^x01%L", formatmodname, VERSION, LANG_SERVER, "ROUND_MSG")
	print_color(0, "%s Round: %d of %d", formatmodname, (g_RoundNum+1), g_pcvar_maxrounds)
	
	remove_task(TASK_ROUND)
	remove_task(30000)
	
	new iBuildTime = get_pcvar_num( g_pcvar_buildtime );
	set_task(1.0, "CountDown", 30000, "", 0, "a", iBuildTime);
	count_down = (iBuildTime-1);
	set_task(float(iBuildTime), "Release_Zombies", TASK_ROUND)
	
	if (get_pcvar_num(g_pcvar_basecalc) == 1)
		set_task(5.0, "Base_Calc")
		
	set_task(5.0, "Fix_Spawns")
	
	g_CanBuild = true

	arrayset(g_MovingEnt, false, MAXENTS)
	arrayset(g_EntOwner, 0, MAXENTS)
	arrayset(g_OwnedEnts, 0, g_MaxPlayers+1)
}

public CountDown()
{
	set_hudmessage(255, 255, 255, -1.0, 0.0, 0, 0.1, 0.9, 0.1, 0.2, 3)
	show_hudmessage(0, "%L", LANG_SERVER, "BUILD_TIME", count_down--);
	
	if (count_down < 0)
	{
		remove_task(30000);
	}
}

//Resets stuff and swaps teams so they respawn correctly
public logevent_round_end()
{
	if (!g_CanBuild && get_pcvar_num(g_pcvar_tournymode) != 1)
	{
		new players[32], num
		get_players(players, num)
		
		new player
		for (new i = 0; i < num; i++)
		{
			player = players[i]
			cs_set_user_team(player, cs_get_user_team(player) == CS_TEAM_T ? CS_TEAM_CT:CS_TEAM_T)
			
			if (cs_get_user_team(player) == CS_TEAM_T)
			{
				g_iszombie[player] = true
				g_ishuman[player] = false
			}
			if (cs_get_user_team(player) == CS_TEAM_CT)
			{
				g_ishuman[player] = true
				g_iszombie[player] = false
			}
		}
		print_color(0, "^x04%L", LANG_SERVER, "TEAMS_SWAPPED")
	}
	
	remove_task(TASK_ROUND)
	remove_task(30000)
		
	return PLUGIN_HANDLED
}

//Death events for respanws and HUD information
public client_death(g_attacker, g_victim, wpnindex, hitplace, TK)
{
	cmdStopEnt(g_victim)
	
	set_hudmessage(_, _, _, _, _, _, _, _, _, _, 4);
	show_hudmessage(g_victim, "");
	
	g_isalive[g_victim] = false
	
	if (g_iszombie[g_victim])
	{
		set_hudmessage(255, 255, 255, -1.0, 0.45, 0, 1.0, 10.0, 0.1, 0.2, 1)
		show_hudmessage(g_victim, "%L", LANG_SERVER, "DEAD_ZOMBIE", get_pcvar_num(g_pcvar_zresptime));
		set_task(get_pcvar_float(g_pcvar_zresptime), "Respawn_Zombie", g_victim)
	}
	if (g_ishuman[g_victim])
	{
		set_hudmessage(255, 255, 255, -1.0, 0.45, 0, 1.0, 10.0, 0.1, 0.2, 1)
		show_hudmessage(g_victim, "%L", LANG_SERVER, "DEAD_SURVIVOR");
	}
}

public ham_TakeDamage_Post(victim, inflictor, attacker, Float:damage, bits)
{
	if(get_pcvar_num(g_pcvar_knockback) == 1 && access(victim, PAIN_SHOCK_FREE) && g_iszombie[victim])
	{
		set_pdata_float(victim, fPainShock, 1.0, 5)
	}
}

public client_disconnect(id)
{
	cmdStopEnt(id)

	g_isconnected[id] = false
	g_isalive[id] = false
	g_ishuman[id] = false
	g_iszombie[id] = false

	return PLUGIN_CONTINUE
}

//Respawns late joiners, cts only if build time is still on
public client_putinserver(id)
{
	set_task(7.0,"Respawn_Human",id);
	g_isconnected[id] = true
	firsttime[id] = true
	ask[id] = true
}

public Release_Zombies()
{
	g_CanBuild = false
	g_ZombiesReleased = true
	remove_task(30000);
	
	new players[32], num
	get_players(players, num)

	new player
	for(new i = 0; i < num; i++)
	{
		player = players[i]
		if (g_isalive[player])
		{
			if (get_user_godmode(player))
				set_user_godmode(player, 0)
			if (g_ishuman[player])
			{
				cmdStopEnt(player)

				new weapon[32]
				get_pcvar_string(g_pcvar_givenades,weapon,31)
			
				new he, flash, smoke
				for(new i=0;i<strlen(weapon);i++)
				{
					switch(weapon[i])
					{
						case 'h': he++
						case 'f': flash++
						case 's': smoke++
					}
				}
				if(he) give_item(player,"weapon_hegrenade"), cs_set_user_bpammo(player,CSW_HEGRENADE,he)
				if(flash) give_item(player,"weapon_flashbang"), cs_set_user_bpammo(player,CSW_FLASHBANG,flash)
				if(smoke) give_item(player,"weapon_smokegrenade"), cs_set_user_bpammo(player,CSW_SMOKEGRENADE,smoke)
				
				if (g_PrimaryWeapon[player])
				{
					get_weaponname(g_PrimaryWeapon[player],weapon,31)
					engclient_cmd(player, weapon);
				}
			}
		}
	}
			
	set_pev(g_iEntBarrier,pev_solid,SOLID_NOT)
	DispatchKeyValue(g_iEntBarrier, "renderamt", "0");
	
	g_RoundNum++
	set_hudmessage(255, 255, 255, -1.0, 0.45, 0, 1.0, 10.0, 0.1, 0.2, 1)
	show_hudmessage(0, "%L", LANG_SERVER, "RELEASE_MSG");
	client_cmd(0, "spk %s", g_RoundStart)
}

//Called on zombie death function
public Respawn_Zombie(id)
{
	if (g_isconnected[id] && cs_get_user_team(id) == CS_TEAM_T)
	{
		if (get_user_health(id) == get_pcvar_float(g_pcvar_zombiehp) || !is_user_alive(id))
			ExecuteHamB(Ham_CS_RoundRespawn, id)
		else
			client_print(id, print_center, "%L", LANG_SERVER, "FAIL_RESPAWN");
	}
}

//Called on all players for late joiners, parent is above
public Respawn_Human(id)
{
	if (!g_isconnected[id] || g_isalive[id] || cs_get_user_team(id) == CS_TEAM_SPECTATOR || cs_get_user_team(id) == CS_TEAM_UNASSIGNED)
		return PLUGIN_HANDLED
		
	if (!g_isalive[id] && g_iszombie[id])
		ExecuteHamB(Ham_CS_RoundRespawn, id)
				
	if (!g_isalive[id] && g_iszombie[id])
		set_task(3.0,"Respawn_Human",id)
			
	if (g_CanBuild)
	{
		if (!g_isalive[id])
			ExecuteHamB(Ham_CS_RoundRespawn, id)
				
		if (!g_isalive[id])
			set_task(3.0,"Respawn_Human",id)
	}
	return PLUGIN_HANDLED
}

//Sets player health and weapons
public Add_Effects(id)
{
	if (!g_isconnected[id] || !g_isalive[id])
		return PLUGIN_HANDLED
	
	strip_user_weapons(id)
	give_item(id, "weapon_knife")
	
	if (cs_get_user_team(id) == CS_TEAM_T)
	{
		if (g_CanBuild)
			set_user_godmode(id, 1)

		set_pev(id, pev_health, get_pcvar_float(g_pcvar_zombiehp)) // use decimal number
	}
	if (cs_get_user_team(id) == CS_TEAM_CT)
	{
		weapon_method_menu(id)
	}
	ShowHealth(id)
	return PLUGIN_HANDLED
}

//AmmoX Ensures BackPack ammo is always full
public ev_AmmoX(id)
{
	set_pdata_int(id, AMMO_SLOT + read_data(1), 200, 5)
} 

public fw_GetGameDescription()
{
	forward_return(FMV_STRING, g_ModName)
	
	return FMRES_SUPERCEDE;
}

public ham_PlayerSpawn_Post(id)
{
	if (!is_user_alive(id) || !cs_get_user_team(id))
		return
		
	set_task(1.0, "Add_Effects", id)
	if (cs_get_user_team(id) == CS_TEAM_CT)
	{
		g_ishuman[id] = true
		g_iszombie[id] = false
	}
	if (cs_get_user_team(id) == CS_TEAM_T)
	{
		g_iszombie[id] = true
		g_ishuman[id] = false
	}
		
	g_isalive[id] = true
	remove_task(id + MODELSET_TASK)
	if (g_iszombie[id])
	{
		copy(g_PlayerModel[id], charsmax(g_PlayerModel[]), g_ZombieModel)
		new currentmodel[32]
		fm_get_user_model(id, currentmodel, charsmax(currentmodel))
		if (!equal(currentmodel, g_PlayerModel[id]))
		{
			if (get_gametime() - g_RoundStartTime < 5.0)
				set_task(5.0 * MODELCHANGE_DELAY, "fm_user_model_update", id + MODELSET_TASK)
			else
				fm_user_model_update(id + MODELSET_TASK)
		}
	}
	else if (g_HasCustomModel[id])
	{
		fm_reset_user_model(id)
	}
}

public fw_SetClientKeyValue(id, const infobuffer[], const key[])
{   
	if (g_HasCustomModel[id] && equal(key, "model"))
		return FMRES_SUPERCEDE
	return FMRES_IGNORED
}

public fw_ClientUserInfoChanged(id)
{
	if (!g_HasCustomModel[id])
		return FMRES_IGNORED
	static currentmodel[32]
	fm_get_user_model(id, currentmodel, charsmax(currentmodel))
	if (!equal(currentmodel, g_PlayerModel[id]) && !task_exists(id + MODELSET_TASK))
		fm_set_user_model(id + MODELSET_TASK)
	return FMRES_IGNORED
}

public fm_user_model_update(taskid)
{
	static Float:current_time
	current_time = get_gametime()
	
	if (current_time - g_ModelsTargetTime >= MODELCHANGE_DELAY)
	{
		fm_set_user_model(taskid)
		g_ModelsTargetTime = current_time
	}
	else
	{
		set_task((g_ModelsTargetTime + MODELCHANGE_DELAY) - current_time, "fm_set_user_model", taskid)
		g_ModelsTargetTime = g_ModelsTargetTime + MODELCHANGE_DELAY
	}
}

public fm_set_user_model(player)
{
	player -= MODELSET_TASK
	engfunc(EngFunc_SetClientKeyValue, player, engfunc(EngFunc_GetInfoKeyBuffer, player), "model", g_PlayerModel[player])
	g_HasCustomModel[player] = true
}

stock fm_get_user_model(player, model[], len)
{
	engfunc(EngFunc_InfoKeyValue, engfunc(EngFunc_GetInfoKeyBuffer, player), "model", model, len)
}

stock fm_reset_user_model(player)
{
	g_HasCustomModel[player] = false
	dllfunc(DLLFunc_ClientUserInfoChanged, player, engfunc(EngFunc_GetInfoKeyBuffer, player))
}

public cmdMoveEnt(id)
{
	if (g_BuildBan[id] == true)
		return PLUGIN_HANDLED
	
	if (g_iszombie[id] && !access(id, AFTER_BUILD))
      		return PLUGIN_HANDLED 
			
	if (!g_CanBuild && !access(id, AFTER_BUILD))
	{
		client_print (id, print_center, "%L", LANG_SERVER, "FAIL_TIME_UP")
		return PLUGIN_HANDLED 
	}
	
	if (!g_isalive[id] && !access(id, DEAD_BUILD))
	{
		client_print (id, print_center, "%L", LANG_SERVER, "FAIL_DEAD")
		return PLUGIN_HANDLED 
	}

	if (g_pEnt[id] && is_valid_ent(g_pEnt[id])) 
		cmdStopEnt(id)
	
	new ent, bodypart
	get_user_aiming (id,ent,bodypart)
	
	if (!is_valid_ent(ent) || ent == g_iEntBarrier)
	{
		return PLUGIN_HANDLED
	}
	
	if (ent <= g_MaxPlayers && g_isalive[ent])
	{	
		return PLUGIN_HANDLED
	}
		
	if (IsBlockLocked(ent) || g_MovingEnt[ent])
	{
		return PLUGIN_HANDLED
	}

	if (get_pcvar_num(g_pcvar_claimable) == 1)
	{
		if (!g_EntOwner[ent])
		{
			if ((g_OwnedEnts[id]<get_pcvar_num(g_pcvar_maxclaimable)) || get_pcvar_num(g_pcvar_maxclaimable) == 0)
			{
				g_EntOwner[ent] = id
				g_OwnedEnts[id]++
			}
			else
			{
				client_print (id, print_center, "%L", LANG_SERVER, "FAIL_MAXOWNED", get_pcvar_num(g_pcvar_maxclaimable))
				//return PLUGIN_HANDLED 
			}
		}
		else if (g_EntOwner[ent] != id && !access(id, AFTER_BUILD))
		{
			client_print (id, print_center, "%L", LANG_SERVER, "FAIL_ALREADYOWNED")
			return PLUGIN_HANDLED 
		}
	}
	
	new tname[7], cname[10];
	entity_get_string(ent, EV_SZ_targetname, tname, 6);
	entity_get_string(ent, EV_SZ_classname, cname, 9);
	if (!equal(cname, "func_wall") || equal(tname, "ignore"))
	{
		return PLUGIN_HANDLED
	}
	
	new origin[3], entOrigin[3], Float:orig[3], Float:mins[3], Float:maxs[3], dist
	
	entity_get_vector(ent, EV_VEC_origin, orig);
	entity_get_vector(ent, EV_VEC_mins, mins);
	entity_get_vector(ent, EV_VEC_maxs, maxs);

	entOrigin[0] = floatround((mins[0] + maxs[0]) / 2 + orig[0]);
	entOrigin[1] = floatround((mins[1] + maxs[1]) / 2 + orig[1]);
	entOrigin[2] = floatround((mins[2] + maxs[2]) / 2 + orig[2]);
	
	get_user_origin(id, origin);

	dist = get_distance(origin, entOrigin);
	
	new max = get_pcvar_num(g_pcvar_entmaxdist)
	new min = get_pcvar_num(g_pcvar_entmindist)
	if (min) //min
	{
		if(dist < min) //minimum
			dist = get_pcvar_num(g_pcvar_entsetdist);
	}

	if (max) //maximum
	{
		if (dist > max)
			return PLUGIN_HANDLED
	}
	
	DispatchKeyValue(ent, "rendermode", "1");
	DispatchKeyValue(ent, "renderamt", "100");
	DispatchKeyValue(ent, "rendercolor", "255.0 0.0 0.0");

	g_MovingEnt[ent] = true
	g_EntMover[ent] = id
	g_pEnt[id] = ent
	g_pDist[id] = dist
	
	if (!g_CanBuild && access(id, AFTER_BUILD))
	{
		new adminauthid[35],adminname[35]
		get_user_authid (id,adminauthid,34)
		get_user_name(id,adminname,34)
		Log("[MOVE] Admin: %s || SteamID: %s moved an entity", adminname, adminauthid)
	}
	
	return PLUGIN_HANDLED
}

/*public fw_CmdStart(id, uc, random)
{
	new buttons = get_uc(uc, UC_Buttons)
	if(g_CanBuild && (buttons & IN_ATTACK))
	{
		buttons &= ~IN_ATTACK
		set_uc(uc, UC_Buttons, buttons)
		return FMRES_SUPERCEDE
	}
	return FMRES_IGNORED
}*/

public fw_Player_PreThink(id)
{
	if (!g_pEnt[id] || !is_valid_ent(g_pEnt[id]))
		return FMRES_HANDLED
	
	new buttons = pev(id, pev_button)
	if(buttons & IN_ATTACK)
	{
		g_pDist[id] += 3;
		
		if (g_pDist[id] > get_pcvar_num(g_pcvar_entmaxdist))
		{
			g_pDist[id] = get_pcvar_num(g_pcvar_entmaxdist)
			client_print(id, print_center, "%L", LANG_SERVER, "OBJECT_MAX")
		}
		else
			client_print(id, print_center, "%L", LANG_SERVER, "OBJECT_PUSH")
	}
	else if(buttons & IN_ATTACK2)
	{
		g_pDist[id] -= 3;
			
		if (g_pDist[id] < get_pcvar_num(g_pcvar_entsetdist))
		{
			g_pDist[id] = get_pcvar_num(g_pcvar_entsetdist)
			client_print(id, print_center, "%L", LANG_SERVER, "OBJECT_MIN")
		}
		else
			client_print(id, print_center, "%L", LANG_SERVER, "OBJECT_PULL")
	}
	
	GrabThink(id)
	
	return FMRES_HANDLED
}

public GrabThink(id)
{
	new Float:aiming[3], origin[3], Float:mins[3], Float:maxs[3], Float:neworigin[3], ent
	
	ent = g_pEnt[id]

	if (!g_isconnected[id] || (ent <= g_MaxPlayers)? !g_isconnected[id]:!is_valid_ent(ent))
	{
		cmdStopEnt(id)
		return PLUGIN_HANDLED
	}
	
	entity_get_vector(ent, EV_VEC_mins, mins);
	entity_get_vector(ent, EV_VEC_maxs, maxs);
	
	get_user_origin(id, origin, 3);
	IVecFVec(origin, aiming);
	get_user_origin(id, origin);
	
	aiming[0] -= float(origin[0]);
	aiming[1] -= float(origin[1]);
	aiming[2] -= float(origin[2]);

	new Float:scalar = float(g_pDist[id]) / vector_length(aiming);

	origin[0] += floatround(aiming[0] * scalar - (mins[0] + maxs[0]) / 2);
	origin[1] += floatround(aiming[1] * scalar - (mins[1] + maxs[1]) / 2);
	origin[2] += floatround(aiming[2] * scalar - (mins[2] + maxs[2]) / 2);
	
	IVecFVec(origin, neworigin);
	entity_set_origin(ent, neworigin);
	
	return PLUGIN_CONTINUE
}

public cmdStopEnt(id)
{
	g_MovingEnt[g_pEnt[id]] = false
	DispatchKeyValue(g_pEnt[id], "rendermode", "0");
	DispatchKeyValue(g_pEnt[id], "renderamt", "255");
	DispatchKeyValue(g_pEnt[id], "rendercolor", "0.0 0.0 0.0");
	if (get_pcvar_num(g_pcvar_blockgrav) == 1)
		drop_to_floor(g_pEnt[id])
	g_EntMover[g_pEnt[id]] = 0
	g_LastMover[g_pEnt[id]] = id
	g_pEnt[id] = 0
}

public fw_Traceline(Float:start[3], Float:end[3], conditions, id, trace)
{
	if (!is_user_connected(id)) return PLUGIN_HANDLED
	
	new ent = get_tr2(trace, TR_pHit)
	
	if (pev_valid(ent))
	{
		new ent,body
		get_user_aiming(id,ent,body)
		
		new cname[10], tname[7];
		entity_get_string(ent, EV_SZ_classname, cname, 9);
		entity_get_string(ent, EV_SZ_targetname, tname, 6);
		if (equal(cname, "func_wall") && !equal(tname, "ignore") && ent != g_iEntBarrier && get_pcvar_num(g_pcvar_showmovers) == 1)
		{
			if (g_CanBuild || access(id, ADMIN_KICK))
			{
				if (IsBlockLocked(ent))
				{
					set_hudmessage(255, 0, 0, -1.0, 0.55, 1, 0.01, 3.0, 0.01, 0.01);
					ShowSyncHudMsg(id, gHudSyncInfo, "%L", LANG_SERVER, "OBJECT_LOCKED");
					return PLUGIN_HANDLED
				}
				set_hudmessage(0, 50, 255, -1.0, 0.55, 1, 0.01, 3.0, 0.01, 0.01);
				if (get_pcvar_num(g_pcvar_claimable) == 0)
				{
					new currentmover[35], lastmover[35]
					if (g_EntMover[ent])
					{
						get_user_name(g_EntMover[ent],currentmover,34)
						if (!g_LastMover[ent]) ShowSyncHudMsg(id, gHudSyncInfo, "%L", LANG_SERVER, "OBJECT_INFO1", currentmover);
					}
					if (g_LastMover[ent])
					{
						get_user_name(g_LastMover[ent],lastmover,34)
						if (!g_EntMover[ent]) ShowSyncHudMsg(id, gHudSyncInfo, "%L", LANG_SERVER, "OBJECT_INFO2", lastmover);
					}
					if (g_LastMover[ent] && g_EntMover[ent]) ShowSyncHudMsg(id, gHudSyncInfo, "%L", LANG_SERVER, "OBJECT_INFO3", currentmover, lastmover);
					else if (!g_LastMover[ent] && !g_EntMover[ent]) ShowSyncHudMsg(id, gHudSyncInfo, "%L", LANG_SERVER, "OBJECT_INFO4");
				}
				else
				{
					if (g_EntOwner[ent])
					{
						new entowner[35]
						get_user_name(g_EntOwner[ent],entowner,34)
						ShowSyncHudMsg(id, gHudSyncInfo, "%L", LANG_SERVER, "OBJECT_OWNER", entowner);
					}
					else 
					{
						ShowSyncHudMsg(id, gHudSyncInfo, "%L", LANG_SERVER, "OBJECT_OWNER_NONE");
					}
				}
			}
		}
	}
	if (!pev_valid(ent)) ClearSyncHud(id, gHudSyncInfo);
	
	return PLUGIN_HANDLED
}

public cmdLockBlock(id)
{
	if (!access(id, LOCK_BLOCKS))
		return PLUGIN_HANDLED
		
	new ent, bodypart
	get_user_aiming (id,ent,bodypart)
	
	new tname[7], cname[10];
	entity_get_string(ent, EV_SZ_targetname, tname, 6);
	entity_get_string(ent, EV_SZ_classname, cname, 9);

	if (!ent || !is_valid_ent(ent) || is_user_alive(ent) || ent == g_iEntBarrier || !equal(cname, "func_wall") || equal(tname, "ignore")) return PLUGIN_HANDLED
	
	if (!IsBlockLocked(ent) && !g_MovingEnt[ent])
	{
		LockBlock(ent)
		DispatchKeyValue(ent, "rendermode", "1");
		DispatchKeyValue(ent, "rendercolor", "125.0 0.0 0.0");
		
		g_OwnedEnts[g_EntOwner[ent]]--
		g_EntOwner[ent] = 0
	}
	else if (IsBlockLocked(ent))
	{
		UnlockBlock(ent)
		DispatchKeyValue(ent, "rendermode", "0");
	}
	return PLUGIN_HANDLED
}

public cmdRemoveClaim(id)
{
	if (!access(id, LOCK_BLOCKS))
      		return PLUGIN_HANDLED 
		
	new ent, bodypart
	get_user_aiming (id,ent,bodypart)
	
	new tname[7], cname[10];
	entity_get_string(ent, EV_SZ_targetname, tname, 6);
	entity_get_string(ent, EV_SZ_classname, cname, 9);

	if (!ent || !is_valid_ent(ent) || is_user_alive(ent) || ent == g_iEntBarrier || !equal(cname, "func_wall") || equal(tname, "ignore") || IsBlockLocked(ent)) return PLUGIN_HANDLED

	g_OwnedEnts[g_EntOwner[ent]]--
	g_EntOwner[ent] = 0
	
	return PLUGIN_HANDLED
}

public cmdRemoveEnt(id)
{
	if (!access(id, REMOVE_BLOCK))
      		return PLUGIN_HANDLED 

	if (!g_isalive[id] && !access(id, DEAD_REMOVE))
	{
		client_print (id, print_center, "%L", LANG_SERVER, "FAIL_REMOVE")
		return PLUGIN_HANDLED 
	}
      	
	new ent, bodypart
	get_user_aiming (id,ent,bodypart)
	
	if(!is_valid_ent(ent) || ent == g_iEntBarrier || (ent <= g_MaxPlayers && g_isalive[ent]))
		return PLUGIN_HANDLED
	
	if(IsBlockLocked(ent) || g_MovingEnt[ent])
		return PLUGIN_HANDLED

	new tname[7], cname[10];
	entity_get_string(ent, EV_SZ_targetname, tname, 6);
	entity_get_string(ent, EV_SZ_classname, cname, 9);
	if(!equal(cname, "func_wall"))
		return PLUGIN_HANDLED
	
	if(equal(tname, "ignore"))
		return PLUGIN_HANDLED
		
	g_OwnedEnts[g_EntOwner[ent]]--
	g_EntOwner[ent] = 0
	
	remove_entity(ent)
	
	new adminauthid[35],adminname[35]
	get_user_authid (id,adminauthid,34)
	get_user_name(id,adminname,34)
	Log("[REMOVE] Admin: %s || SteamID: %s removed an entity", adminname, adminauthid)
	
	return PLUGIN_HANDLED
}

// Ham Weapon Deploy Forward (forces knife only)
public ham_ItemDeploy_Post(weapon_ent)
{
	static owner
	owner = get_pdata_cbase(weapon_ent, OFFSET_WEAPONOWNER, OFFSET_LINUX_WEAPONS);
	
	static weaponid
	weaponid = cs_get_weapon_id(weapon_ent)
	
	g_CurrentWeapon[owner] = weaponid
	
	if (g_iszombie[owner] && !((1<<weaponid) & ZOMBIE_ALLOWED_WEAPONS_BITSUM))
	{
		g_CurrentWeapon[owner] = CSW_KNIFE
		engclient_cmd(owner, "weapon_knife")
	}
	else if (g_CanBuild && g_ishuman[owner])
	{
		g_CurrentWeapon[owner] = CSW_KNIFE
		engclient_cmd(owner, "weapon_knife")
		client_print(owner, print_center, "%L", LANG_SERVER, "FAIL_KNIFE_ONLY");
	}
}

public msgRoundEnd(const MsgId, const MsgDest, const MsgEntity)
{
	static Message[192]
	get_msg_arg_string(2, Message, 191)
	
	set_hudmessage(255, 255, 255, -1.0, 0.40, 0, 6.0, 6.0, 0.1, 0.2, 1)
	
	if(equal(Message, "#Game_bomb_drop"))
		return PLUGIN_HANDLED
	
	if (equal(Message, "#Terrorists_Win"))
	{
		show_hudmessage(0, "Zombies Win!")
		set_msg_arg_string(2, "")
		switch (random_num(1, 4))
		{
			case 1: client_cmd(0, "spk ambience/the_horror1.wav")
			case 2: client_cmd(0, "spk ambience/the_horror2.wav")
			case 3: client_cmd(0, "spk ambience/the_horror3.wav")
			case 4: client_cmd(0, "spk ambience/the_horror4.wav")
		}
		return PLUGIN_HANDLED
	}
	else if (equal(Message, "#Target_Saved") || equal(Message, "#CTs_Win"))
	{
		show_hudmessage(0, "Builders Win!")
		set_msg_arg_string(2, "")
		switch (random_num(1, 3))
		{
			case 1: client_cmd(0, "spk barney/ba_another.wav")
			case 2: client_cmd(0, "spk barney/ba_firepl.wav")
			case 3: client_cmd(0, "spk barney/ba_seethat.wav")
		}
		return PLUGIN_HANDLED
	}
	return PLUGIN_HANDLED
}

public ham_WeaponCleaner_Post(iEntity)
{
	call_think(iEntity)
}

public message_show_menu(msgid, dest, id) 
{
	if (!should_autojoin(id))
		return PLUGIN_CONTINUE

	static team_select[] = "#Team_Select"
	static menu_text_code[sizeof team_select]
	get_msg_arg_string(4, menu_text_code, sizeof menu_text_code - 1)
	if (!equal(menu_text_code, team_select))
		return PLUGIN_CONTINUE

	set_force_team_join_task(id, msgid)

	return PLUGIN_HANDLED
}

public message_vgui_menu(msgid, dest, id) 
{
	if (get_msg_arg_int(1) != TEAM_SELECT_VGUI_MENU_ID || !should_autojoin(id))
		return PLUGIN_CONTINUE
		
	set_force_team_join_task(id, msgid)

	return PLUGIN_HANDLED
}

bool:should_autojoin(id) 
{
	return (!get_user_team(id))
}

set_force_team_join_task(id, menu_msgid) 
{
	static param_menu_msgid[2]
	param_menu_msgid[0] = menu_msgid
	set_task(AUTO_TEAM_JOIN_DELAY, "task_force_team_join", id, param_menu_msgid, sizeof param_menu_msgid)
}

public task_force_team_join(menu_msgid[], id) 
{
	if (get_user_team(id))
		return

	static team[2], class[2]
	get_pcvar_string(g_pcvar_team, team, sizeof team - 1)
	get_pcvar_string(g_pcvar_class, class, sizeof class - 1)
	force_team_join(id, menu_msgid[0], team, class)
}

stock force_team_join(id, menu_msgid, /* const */ team[] = "5", /* const */ class[] = "0") 
{
	static jointeam[] = "jointeam"
	if (class[0] == '0') {
		engclient_cmd(id, jointeam, team)
		return
	}

	static msg_block, joinclass[] = "joinclass"
	msg_block = get_msg_block(menu_msgid)
	set_msg_block(menu_msgid, BLOCK_SET)
	engclient_cmd(id, jointeam, team)
	engclient_cmd(id, joinclass, class)
	set_msg_block(menu_msgid, msg_block)
}

public clcmd_changeteam(id)
{
	if (g_CanBuild) 
		weapon_method_menu(id)
	else 
		client_print (id, print_center, "%L", LANG_SERVER, "FAIL_WEAPONS")
	
	if (g_iszombie[id])
		client_print (id, print_center, "%L", LANG_SERVER, "FAIL_ZOMBIE")
		
	return PLUGIN_HANDLED
}

public clcmd_drop(id)
{
	client_print (id, print_center, "%L", LANG_SERVER, "FAIL_DROP")
	return PLUGIN_HANDLED
}

public clcmd_buy(id)
{
	client_print (id, print_center, "%L", LANG_SERVER, "FAIL_BUY")
	return PLUGIN_HANDLED
}

public fw_Suicide(id)
{
	client_print (id, print_center, "%L", LANG_SERVER, "FAIL_SUICIDE")
	console_print (id, "%L", LANG_SERVER, "FAIL_SUICIDE")
	return FMRES_SUPERCEDE;
}

public Base_Calc()
{
	new players[32], num, ct, basenum
	get_players(players, num)
	new player
	for(new i = 0; i < num; i++)
	{
		player = players[i]
		if (cs_get_user_team(player) == CS_TEAM_CT)
			ct++

		if (ct < 6)
			basenum = 2
		else
			basenum = (ct/3)
	}
	print_color(0, "%s %L", formatmodname, LANG_SERVER, "BASE_CALC", basenum)
}

public cmdBadSpawn_Survivor(id)
{
	if (access(id, BAD_SPAWN))
	{
		new players[32], num
		get_players(players, num)
			
		new player
		for(new i = 0; i < num; i++)
		{
			player = players[i]
			if (cs_get_user_team(player) == CS_TEAM_CT && !is_user_alive(player) && g_isconnected[player] && g_CanBuild)
				ExecuteHamB(Ham_CS_RoundRespawn, player)
		}
	}
}

public Fix_Spawns()
{
	new players[32], num
	get_players(players, num)
			
	new player
	for(new i = 0; i < num; i++)
	{
		player = players[i]
		if (cs_get_user_team(player) == CS_TEAM_CT && !is_user_alive(player) && g_isconnected[player] && g_CanBuild)
			ExecuteHamB(Ham_CS_RoundRespawn, player)
	}
}

public cmdBadSpawn(id)
{
	if (g_isconnected[id] && g_ishuman[id] && g_CanBuild)
		ExecuteHamB(Ham_CS_RoundRespawn, id)
}

public cmdBadSpawn_Zombie(id)
{
	if (access(id, BAD_SPAWN))
	{
		new players[32], num
		get_players(players, num)
			
		new player
		for(new i = 0; i < num; i++)
		{
			player = players[i]
			if (cs_get_user_team(player) == CS_TEAM_T && !is_user_alive(player) && g_isconnected[player])
				ExecuteHamB(Ham_CS_RoundRespawn, player)
		}
	}
}

public msgStatusIcon(const iMsgId, const iMsgDest, const iPlayer)
{
	if(is_user_alive(iPlayer)) 
	{
		static szMsg[8]
		get_msg_arg_string(2, szMsg, 7)
    
		if(equal(szMsg, "buyzone"))
		{
			set_pdata_int(iPlayer, OFFSET_BUYZONE, get_pdata_int(iPlayer, OFFSET_BUYZONE) & ~(1<<0))
			return PLUGIN_HANDLED
		}
	}
	return PLUGIN_CONTINUE
}

public cmdBuildBan(id)
{
	if (access(id, BUILD_BAN))
	{
		new arg[32]
		read_argv(1, arg, 31)
		new player = cmd_target(id, arg, CMDTARGET_OBEY_IMMUNITY)
		g_BuildBan[player] = true
		cmdStopEnt(player)
		
		new adminauthid[35],adminname[35],playername[35],playerauthid[35]
		get_user_name(id,adminname,34)
		get_user_authid (id,adminauthid,34)
		get_user_name(player, playername, 34)
		get_user_authid (player,playerauthid,34)
		Log("[MOVE] Admin: %s || SteamID: %s banned Player: %s || SteamID: %s from building", adminname, adminauthid, playername, playerauthid)
		
		client_print(id, print_console, "%L", LANG_SERVER, "BUILD_BAN1", playername)
		client_print(player, print_center, "%L", LANG_SERVER, "BUILD_BAN2")
	}
}

public cmdBuildUnban(id)
{
	if (access(id, BUILD_BAN))
	{
		new arg[32], playername[35]
	
		read_argv(1, arg, 31)
		new player = cmd_target(id, arg, CMDTARGET_OBEY_IMMUNITY)
		get_user_name(player, playername, 34)
		client_print(id, print_console, "%L", LANG_SERVER, "UNBUILD_BAN1", playername)
		g_BuildBan[player] = false
		print_color(player, "%s %L", formatmodname, LANG_SERVER, "UNBUILD_BAN2")
	}
}

public cmdRevive(id)
{
	if (access(id, REVIVE))
	{
		new arg[32]
		read_argv(1, arg, 31)
		new player = cmd_target(id, arg, CMDTARGET_OBEY_IMMUNITY)

		if (is_user_alive(player))
		{
			client_print(id, print_console, "%L", LANG_SERVER, "FAIL_REVIVE")
			return PLUGIN_HANDLED
		}
		
		ExecuteHamB(Ham_CS_RoundRespawn, player)
		
		new adminauthid[35],adminname[35],playername[35],playerauthid[35]
		get_user_name(id,adminname,34)
		get_user_authid (id,adminauthid,34)
		get_user_name(player, playername, 34)
		get_user_authid (player,playerauthid,34)
		Log("[REVIVE] Admin: %s || SteamID: %s revived Player: %s || SteamID: %s", adminname, adminauthid, playername, playerauthid)
		
		client_print(id, print_console, "%L", LANG_SERVER, "REVIVE1", playername)
		client_print(player, print_center, "%L", LANG_SERVER, "REVIVE2")
	}
	return PLUGIN_HANDLED
}

public cmdSwap(id)
{
	if (access(id, SWAP))
	{
		new arg[32]
		read_argv(1, arg, 31)
		new player = cmd_target(id, arg, CMDTARGET_OBEY_IMMUNITY)

		if (!is_user_connected(player)) return PLUGIN_HANDLED
		
		cs_set_user_team(player, cs_get_user_team(player) == CS_TEAM_T ? CS_TEAM_CT:CS_TEAM_T)
			
		if (cs_get_user_team(player) == CS_TEAM_T)
		{
			g_iszombie[player] = true
			g_ishuman[player] = false
		}
		if (cs_get_user_team(player) == CS_TEAM_CT)
		{
			g_ishuman[player] = true
			g_iszombie[player] = false
		}
		
		if (is_user_alive(player))
			ExecuteHamB(Ham_CS_RoundRespawn, player)
		
		new adminauthid[35],adminname[35],playername[35],playerauthid[35]
		get_user_name(id,adminname,34)
		get_user_authid (id,adminauthid,34)
		get_user_name(player, playername, 34)
		get_user_authid (player,playerauthid,34)
		Log("[TEAM-SWAP] Admin: %s || SteamID: %s swapped Player: %s || SteamID: %s", adminname, adminauthid, playername, playerauthid)
		
		client_print(id, print_console, "%L", LANG_SERVER, "SWAP1", playername)
		client_print(player, print_center, "%L", LANG_SERVER, "SWAP2")
	}
	return PLUGIN_HANDLED
}

public cmdStartRound(id)
{
	if (access(id, START_ROUND))
	{
		if (count_down<10)
		{
			client_print(id, print_console, "%L", LANG_SERVER, "FAIL_START_ROUND")
			return PLUGIN_HANDLED
		}
		
		Release_Zombies()
		
		new adminauthid[35],adminname[35]
		get_user_name(id,adminname,34)
		get_user_authid (id,adminauthid,34)
		Log("[START_ROUND] Admin: %s || SteamID: %s started the round", adminname, adminauthid)
		
		client_print(id, print_center, "%L", LANG_SERVER, "START_ROUND")
		client_print(id, print_chat, "^x04%L", LANG_SERVER, "START_ROUND")
	}
	return PLUGIN_HANDLED
}

public cmdCheckRound(id)
{
	if (g_ZombiesReleased) print_color(id, "%s Round: %d of %d", formatmodname, (g_RoundNum), g_pcvar_maxrounds)
	else if (!g_ZombiesReleased) print_color(id, "%s Round: %d of %d", formatmodname, (g_RoundNum+1), g_pcvar_maxrounds)
}

public msgStatusValue()
{
	//Block the name info, of person you aim at
	set_msg_block(gmsgStatusText, BLOCK_SET);
}

public ev_SetTeam(id)
{
	g_friend[id] = read_data(2)
}

public ev_ShowStatus(id) //called when id looks at someone
{
	new name[32], pid = read_data(2);
	new stats[8],bodyhits[8]
	
	get_user_name(pid, name, 31);
	new color1 = 0, color2 = 0;

	if (get_user_team(pid) == 1)
		color1 = 255;
	else
		color2 = 255;

	new Float:height=0.35
	//height=0.60

	if (g_friend[id] == 1)	// friend
	{
		new clip, ammo, wpnid = get_user_weapon(pid, clip, ammo);
		new wpnname[32];

		if (wpnid)
			xmod_get_wpnname(wpnid, wpnname, 31);

		new rank = get_user_stats(pid, stats, bodyhits)
		set_hudmessage(color1, 50, color2, -1.0, height, 1, 0.01, 3.0, 0.01, 0.01);
		ShowSyncHudMsg(id, gHudSyncInfo, "%L", LANG_SERVER, "PLAYER_INFO1", name, rank, get_user_health(pid), wpnname);
	} 
	if (g_friend[id] != 1) //enemy
	{
		new rank = get_user_stats(pid, stats, bodyhits)
		set_hudmessage(color1, 50, color2, -1.0, height, 1, 0.01, 3.0, 0.01, 0.01);
		ShowSyncHudMsg(id, gHudSyncInfo, "%L", LANG_SERVER, "PLAYER_INFO2", name, rank);
	}
}

public ev_HideStatus(id)
{
	ClearSyncHud(id, gHudSyncInfo);
}

public weapon_method_menu(id)
{
	if(firsttime[id])
	{
		firsttime[id] = false
		prim_weapons_menu(id,0)
	}
	else
	{
		cur_offset[id] = 0
		if(ask[id])
		{
			show_menu(id,(1<<0)|(1<<1)|(1<<2),"Weapon Selection Method^n^n1. New Guns^n2. Last Guns^n3. Last Guns + Save",-1,"WeaponMethodMenu")
		}
		else
		{
			give_weapons(id)
		}
	}
}

public weapon_method_pushed(id,key)
{
	switch(key)
	{
		case 0:
		{
			ask[id] = true
			prim_weapons_menu(id,0)
		}	
		case 1:
		{
			ask[id] = true
			give_weapons(id)
		}
		case 2:
		{
			print_color(id, "%s %L", formatmodname, LANG_SERVER, "GUNS_MSG")
			ask[id] = false
			give_weapons(id)
		}
	}
	return PLUGIN_HANDLED;
}

public prim_weapons_menu(id,offset)
{
	if(offset<0) offset = 0

	new cvar_value[32]
	get_pcvar_string(g_pcvar_allowedweps,cvar_value,31)
	new flags = read_flags(cvar_value)

	new keys, curnum, menu[2048]
	for(new i=offset;i<19;i++)
	{
		if(flags & power(2,i))
		{
			options_on_menu[curnum][id] = i
			keys += (1<<curnum)
	
			curnum++
			format(menu,2047,"%s^n%d. %s",menu,curnum,WEAPONNAMES[i])
	
			if(curnum==8)
			break;
		}
	}

	format(menu,2047,"\yPrimary Weapon:\w^n%s^n",menu)
	if(curnum==8 && offset<12)
	{
		keys += (1<<8)
		format(menu,2047,"%s^n9. Next",menu)
	}
	if(offset)
	{
		keys += (1<<9)
		format(menu,2047,"%s^n0. Back",menu)
	}

	show_menu(id,keys,menu,-1,"PrimaryWeaponSelect")
}

public prim_weapons_pushed(id,key)
{
	if(key<8)
	{
		weapon_picked[0][id] = options_on_menu[key][id]
		cur_offset[id] = 0
		sec_weapons_menu(id,0)
	}
	else
	{
		if(key==8)
			cur_offset[id] += 8
		if(key==9)
			cur_offset[id] -= 8
		prim_weapons_menu(id,cur_offset[id])
	}
	return ;
}

public sec_weapons_menu(id,offset)
{
	if(offset<0) offset = 0

	new cvar_value[32]
	get_pcvar_string(g_pcvar_allowedweps,cvar_value,31)
	new flags = read_flags(cvar_value)

	new keys, curnum, menu[2048]
	for(new i=18;i<24;i++)
	{
		if(flags & power(2,i))
		{
		options_on_menu[curnum][id] = i
		keys += (1<<curnum)

		curnum++
		format(menu,2047,"%s^n%d. %s",menu,curnum,WEAPONNAMES[i])
		}
	}

	format(menu,2047,"\ySecondary Weapon:\w^n%s",menu)

	show_menu(id,keys,menu,-1,"SecWeaponSelect")
}

public sec_weapons_pushed(id,key)
{
	if(key<8)
	{
		weapon_picked[1][id] = options_on_menu[key][id]
	}
	give_weapons(id)
	return ;
}

public give_weapons(id)
{
	strip_user_weapons(id)

	give_item(id,"weapon_knife")
   
	new weapon[32]
	new csw = csw_contant(weapon_picked[0][id])
	get_weaponname(csw,weapon,31)
	give_item(id,weapon)
	cs_set_user_bpammo(id,csw,999)
	g_PrimaryWeapon[id] = csw

	csw = csw_contant(weapon_picked[1][id])
	get_weaponname(csw,weapon,31)
	give_item(id,weapon)
	cs_set_user_bpammo(id,csw,999)
}

public csw_contant(weapon)
{
	new num = 29
	switch(weapon)
	{
		case 0: num = 3
		case 1: num = 5
		case 2: num = 7
		case 3: num = 8
		case 4: num = 12
		case 5: num = 13
		case 6: num = 14
		case 7: num = 15
		case 8: num = 18
		case 9: num = 19
		case 10: num = 20
		case 11: num = 21
		case 12: num = 22
		case 13: num = 23
		case 14: num = 24
		case 15: num = 27
		case 16: num = 28
		case 17: num = 30
		case 18: num = 1
		case 19: num = 10
		case 20: num = 11
		case 21: num = 16
		case 22: num = 17
		case 23: num = 26
		case 24:
		{
			new s_weapon[32]
		
			get_pcvar_string(g_pcvar_allowedweps,s_weapon,31)
		   
			new flags = read_flags(s_weapon)
			do
			{
				num = random_num(0,18)
				if(!(num & flags))
				{
					num = -1
				}
			}
			while(num==-1)
			num = csw_contant(num)
		}
		case 25:
		{
			new s_weapon[32]

			get_pcvar_string(g_pcvar_allowedweps,s_weapon,31)
		
			new flags = read_flags(s_weapon)
			do
			{
				num = random_num(18,23)
				if(!(num & flags))
				{
					num = -1
				}
			}
			while(num==-1)
			num = csw_contant(num)
		}
	}
	return num;
}


public cmdGuns(id)
{
	if(!g_isalive[id] || !g_isconnected[id] || !g_CanBuild)
		return PLUGIN_HANDLED
	
	if(!g_ishuman[id])
		return PLUGIN_HANDLED	

	ask[id] = true
	weapon_method_menu(id)
	return PLUGIN_HANDLED
}

public ev_Health(id)
{
	ShowHealth(id);
}

public ShowHealth(id)
{
	if (is_user_alive(id))
	{
		new Float:hud_time = get_pcvar_float(g_pcvar_healthtime);
		
		set_hudmessage(255, 255, 255, -1.0, 0.9, 0, hud_time, hud_time, 0.1, 0.2, 4);
		show_hudmessage(id, "%L", LANG_SERVER, "PLAYER_HEALTH", get_user_health(id));
		
		set_task(hud_time - 0.1, "ShowHealth", id);
	}
}

Log(const message_fmt[], any:...)
{
	static message[256];
	vformat(message, sizeof(message) - 1, message_fmt, 2);
	
	static filename[96];
	static dir[64];
	if( !dir[0] )
	{
		get_basedir(dir, sizeof(dir) - 1);
		add(dir, sizeof(dir) - 1, "/logs");
	}
	
	format_time(filename, sizeof(filename) - 1, "%m-%d-%Y");
	format(filename, sizeof(filename) - 1, "%s/BB_ACTIVITY_%s.log", dir, filename);
	
	log_to_file(filename, "%s", message);
}

print_color(target, const message[], any:...)
{
	static buffer[512], i, argscount
	argscount = numargs()
	
	// Send to everyone
	if (!target)
	{
		static player
		for (player = 1; player <= g_MaxPlayers; player++)
		{
			if (!g_isconnected[player])
				continue;

			static changed[5], changedcount
			changedcount = 0

			for (i = 2; i < argscount; i++)
			{
				if (getarg(i) == LANG_PLAYER)
				{
					setarg(i, 0, player)
					changed[changedcount] = i
					changedcount++
				}
			}
			vformat(buffer, charsmax(buffer), message, 3)

			message_begin(MSG_ONE_UNRELIABLE, gmsgSayText, _, player)
			write_byte(player)
			write_string(buffer)
			message_end()
			
			for (i = 0; i < changedcount; i++)
				setarg(changed[i], 0, LANG_PLAYER)
		}
	}
	// Send to specific target
	else
	{
		vformat(buffer, charsmax(buffer), message, 3)

		message_begin(MSG_ONE, gmsgSayText, _, target)
		write_byte(target)
		write_string(buffer)
		message_end()
	}
}

