option explicit ' enforced variable declarations, leave this alone.
dim DRAW_LESSTHANOREQUALTO,SORT_TYPE' dim for pseudo constants.
if wscript.version <5.5 then msgbox "Windows Scripting Host version is too low to run this script."&vbcrlf&"Go to http://msdn.microsoft.com/scripting for updates",vbokonly,"Low version of WSH"
dim FSO,TSO,Script_Path,Include_Path,newcommands,Commands,levels()
redim levels(0): redim Commands(0)
set FSO=createobject("scripting.filesystemobject") 'create filesystem access object
class Access: public Level: public Name: public InFile: end class
class Command: public Name: public FunctionName: public Level: public Description: public InFile: end class

Script_Path =array("..\scripting\examples","..\scripting\myscripts") ' create scripts entries
Include_Path=array("..\scripting\include") 'create includes entries

'------------------------------------hide commands above this level 0=off

DRAW_LESSTHANOREQUALTO              = 0

'------------------------------------commands table options

Const COMMANDS_DRAW_TABLE           = true

    Const DRAW_EMPTY_DESCRIPTORS    = false
    Const ON_STRING_ACCESS_REMOVE   = true
    Const DRAW_CHECKBOX_TABLE       = false
    
    Const COMMANDS_DRAW_LEVELS      = false
     Const COMMANDS_SHOW_LEVELS     = true
      Const COMMANDS_ACCESS_NUMERIC = false
            
    Const COMMANDS_DRAW_FUNCTIONS   = false
     Const COMMANDS_SHOW_FUNCTIONS  = true
        
    Const COMMANDS_DRAW_PLUGINS     = false
     Const COMMANDS_SHOW_PLUGINS    = true
        
'-------------------------------------commands table sorting options

    Const SORTBY_NOSORT             = &h0
    Const SORTBY_NAME               = &h1
    Const SORTBY_ACCESS             = &h2
    Const SORTBY_PLUGIN             = &h4
    
    ' this combined value determines the sorting
    ' AND or OR the above constants together, eg: SORTBY_PLUGIN AND SORTBY_ACCESS
    
    SORT_TYPE                       = SORTBY_NAME
        
'-------------------------------------access table options

Const ACCESS_DRAW_TABLE             = false
    Const ACCESS_DRAW_PLUGINS       = true
    Const ACCESS_DRAW_INSTANCES     = true

'-----------------------------------------------------------------------------------------------------------------------

'------------------------------------------------------------------------------------------------------------------------
' start here
    main()
' end
'------------------------------------------------------------------------------------------------------------------------

'------------------------------------------------------------------------------------------------------------------------
private sub main()
    LoadAccessFromIncludes
    LoadScripts
    
    SortCommands SORT_TYPE
    
    set TSO=fso.opentextfile("Output.html",2,true)
    
        WriteHTMLHeader
            CreateCheckBoxTable
            CreateCommandsTable
            CreateAccessTable
        WriteHTMLFooter
    
    tso.close: set tso=nothing
    
    msgbox "Command list written to Output.html file ",vbokonly,"File written"
end sub
'------------------------------------------------------------------------------------------------------------------------
public sub LoadScripts
    dim x,folder,file
    for x=0 to ubound(Script_Path)
        if fso.folderexists(Script_Path(x)) then
            set folder =fso.getfolder(Script_Path(x))
            for each file in folder.files
                if len(file.name) >4 then
                    if lcase(right(file.name,4))=".sma" and lcase(left(file.name,7))="plugin_" then
                        LoadAccessFromScript Script_Path(x)&"\"&File.name
                        LoadCommandsFromScript Script_Path(x)&"\"&File.name
                    end if
                end if
            next
        end if
    next
end sub
'------------------------------------------------------------------------------------------------------------------------
public function LoadAccessFromIncludes()
    dim x,InVar,regex,folder,file,tso
    set regex= new regexp
    for x =0 to ubound(Include_Path)
        regex.pattern = "#define (ACCESS_.*?[A-Za-z_-]) (1<<(?:3[0-1]|[1-2][0-9]|[0-9])|[0-9]{0,10})"            
        if fso.folderexists(Include_path(x)) then
            set folder=fso.getfolder(Include_path(x))
            for each file in folder.files
                if len(file.name)> 4 then
                    if lcase(right(file.name,4))=".inc" then
                        set    tso=fso.opentextfile(Include_Path(x)&"\"&file.name,1,false)
                        do while tso.atendofstream=false
                            invar=tso.readline
                            if regex.test(invar) =true then
                                AddLevel Invar,regex.pattern,file.name
                            end if    
                        loop
                        tso.close
                        set tso=nothing                        
                    end if
                end if
            next
            set folder=nothing
        end if
    next
end function
'------------------------------------------------------------------------------------------------------------------------
public sub Addlevel(Line,Pattern,FileName)
    dim regex,matches,match,rightstr,leftstr,number
    set regex= new regexp
    regex.pattern=pattern
    set matches=regex.execute(line)
    set match=matches(0)
    if typename(levels(ubound(levels)))<> "Empty" then redim preserve levels(ubound(levels)+1)
    if instr(1,match.submatches(1),"<<")>0 then
        rightstr=right(match.submatches(1),(len(match.submatches(1))-instrrev(match.submatches(1),"<<"))-1)
        if not isnumeric(rightstr) then exit sub
        leftstr=left(match.submatches(1),instr(1,match.submatches(1),"<<")-1)
        if not isnumeric(leftstr) then exit sub
        if cint(rightstr)>31 then exit sub
        number= 2 ^ cint(rightstr)        
    else
        number=match.submatches(1)
    end if
    
    set levels(ubound(levels))=new Access
    levels(ubound(Levels)).level=number
    levels(ubound(Levels)).name=match.submatches(0)
    
    if instr(1,FileName,"\")> 0 then
        levels(ubound(levels)).InFile = right(FileName,len(FileName)-(instrrev(FileName,"\")))
    else
        levels(ubound(levels)).InFile=FileName
    end if
    
    set match=nothing
    set matches=nothing
    set regex=nothing
end sub
'------------------------------------------------------------------------------------------------------------------------
private sub AddCommand(Line,Pattern,FileName)
    dim regex,matches,match,bound
    set regex= new regexp
    regex.pattern=pattern
    set matches=regex.execute(line)
    set match=matches(0)
    if typename(Commands(ubound(Commands)))<> "Empty" then redim preserve Commands(ubound(Commands)+1) 'else msgbox "found emtpy"
    bound=ubound(commands)
    set Commands(bound)=new Command
    Commands(bound).name=match.submatches(0)
    Commands(bound).functionname=match.submatches(1)
    Commands(bound).level=match.submatches(2)
    Commands(bound).description =replace(replace(replace(match.submatches(3),">","&gt;"),"<","&lt;"),"^"&chr(34),chr(34))
    if instr(1,FileName,"\")>0 then
        Commands(bound).InFile    =right(filename,len(FileName)-instrrev(FileName,"\"))
    else
        Commands(bound).InFile =FileName
    end if
    if len(Commands(bound).InFile)>4 then
        if lcase(right(Commands(bound).InFile,4))=".sma" then
            Commands(bound).InFile=left(Commands(bound).InFile,len(Commands(bound).InFile)-4)
        end if
    end if
    set regex=nothing
    set matches=nothing
end sub
'------------------------------------------------------------------------------------------------------------------------
private sub SortCommands(SortType)
    if (SortType and SORTBY_PLUGIN) = SORTBY_PLUGIN then
        Commands = SortArrayByPlugin(Commands)
    end if
    
    if (SortType and SORTBY_ACCESS) = SORTBY_ACCESS then
        Commands = SortArrayByAccess(Commands)
    elseif (SortType and SORTBY_NAME) = SORTBY_NAME then
        Commands = SortArrayByName(Commands)
    end if
end sub
'------------------------------------------------------------------------------------------------------------------------
private function SortArrayByAccess(InArray)
    dim x,tempaccess,tempindex,Temp_Array,y,Access_Array,Index_Array,ArrayBound
    
    Temp_Array=InArray
    ArrayBound=ubound(InArray)
    redim Index_Array(ArrayBound)
    redim Access_Array(ArrayBound)
    
    for x = 0 to ArrayBound
        Index_Array(x)=x: Access_Array(x)= GetAccessFromName(x)    
    next
    
    y=false
    do while y =false
        x =0: y=true 
        do while x < ArrayBound
            if Access_Array(x) > Access_Array(x+1) then
                tempaccess =Access_Array(x+1): Access_Array(x+1) =Access_Array(x): Access_Array(x)=tempaccess
                tempindex =Index_Array(x+1): Index_Array(x+1) =Index_Array(x): Index_Array(x)=tempindex
                y=false
            end if
            x=x+1
        loop
    loop
        
    for x =0 to ArrayBound
        set Temp_Array(x) = InArray(Index_Array(x))
    next
    
    SortArrayByAccess=Temp_Array
    
end function
'------------------------------------------------------------------------------------------------------------------------
private function SortArrayByPlugin(InArray)
    ' find the number of individual plugins.
    dim x,y,z,Plugins_Array,Plugin_Names,Temp_Array,OutArray()
    redim Plugins_Array(0)
    redim Temp_Array(0)
    redim  OutArray(ubound(InArray))
    
    for x=0 to ubound(InArray)
        if instr(1,Plugin_Names,InArray(x).InFile)=0 then
            Plugin_Names = Plugin_Names & vbcrlf & InArray(x).InFile
            if Plugins_Array(ubound(Plugins_Array)) <> "" then redim preserve Plugins_Array(ubound(Plugins_Array)+1)
            Plugins_Array(ubound(Plugins_Array))=InArray(x).InFile
        end if
    next
        
    for x=0 to ubound(Plugins_Array)
        for y=0 to ubound(InArray)
            if InArray(y).InFile=Plugins_Array(x) then
                if typename(Temp_Array(ubound(Temp_Array)))<> "Empty" then redim preserve Temp_Array(ubound(Temp_Array)+1)
                set Temp_Array(ubound(Temp_Array)) = new Command
                set Temp_Array(ubound(Temp_Array)) = InArray(y)
            end if
        next
        Plugins_Array(x) = Temp_Array
        redim Temp_Array(0)
    next
    
    z=0
    for x=0 to ubound(Plugins_Array)
        redim TempArray(Ubound(Plugins_Array(x)))
        Temp_Array=Plugins_Array(x)
        for y=0 to ubound(Temp_Array)
            set OutArray(z)=Temp_Array(y)
            z=z+1
        next
    next
    
    SortArrayByPlugin=OutArray
    
end function
'------------------------------------------------------------------------------------------------------------------------
private function SortArrayByName(InArray)
    dim x,tempaccess,tempindex,Temp_Array,y,Name_Array,Index_Array,ArrayBound
    
    Temp_Array=InArray
    ArrayBound=ubound(InArray)
    redim Index_Array(ArrayBound)
    redim Name_Array(ArrayBound)
    
    for x = 0 to ArrayBound
        Index_Array(x)=(x)
        Name_Array(x)= InArray(x).Name    
    next
    
    y=false
    do while y =false
        x =0: y=true 
        do while x < ArrayBound
            if Name_Array(x) > Name_Array(x+1) then
                tempaccess =Name_Array(x+1): Name_Array(x+1) =Name_Array(x): Name_Array(x)=tempaccess
                tempindex =Index_Array(x+1): Index_Array(x+1) =Index_Array(x): Index_Array(x)=tempindex
                y=false
            end if
            x=x+1
        loop
    loop
        
    for x =0 to ArrayBound
        set Temp_Array(x) = InArray(Index_Array(x))
    next
    
    SortArrayByName=Temp_Array
    
end function
'------------------------------------------------------------------------------------------------------------------------

public sub LoadAccessFromScript(ScriptPath)
    dim lTSO,InVar,regex
    if fso.fileexists(Scriptpath) then
        set regex= new regexp
        regex.pattern="#define (ACCESS_.*?[A-Za-z_-]) (1<<(?:3[0-1]|[1-2][0-9]|[0-9])|[0-9]{0,10})"
        set lTSo=fso.opentextfile(ScriptPath,1,false)
        do while lTSO.atendofstream<>true
            invar=lTSO.readline
            if regex.test(InVar) then AddLevel inVar,regex.pattern,scriptpath
        loop
        lTSO.close
        set lTSO=nothing
        set regex=nothing        
    end if
end sub
'------------------------------------------------------------------------------------------------------------------------
public sub LoadCommandsFromScript(ScriptPath)
    dim lTSO,InVar,regex
    if fso.fileexists(Scriptpath) then
        set regex= new regexp
        regex.pattern="plugin_registercmd\([ \t]*\""(.*?)\""[ \t]*,[ \t]*\""(.*?)\""[ \t]*,[ \t]*(.*?)[ \t]*(?:\)|,[ \t]*\""(.*?)\""[ \t]*\));"
        set lTSo=fso.opentextfile(ScriptPath,1,false)
        do while lTSO.atendofstream<>true
            invar=lTSO.readline
            if regex.test(InVar) then AddCommand inVar,regex.pattern,scriptpath
        loop
        lTSO.close
        set lTSO=nothing
        set regex=nothing        
    end if
end sub
'------------------------------------------------------------------------------------------------------------------------
private function GetString(String)
    dim lTSO,InVar,RetVar,readme
    set lTSO=fso.opentextfile(wscript.scriptfullname,1,false)
    do while lTSO.atendofstream<>true
        invar=ltso.readline
        if readme=false then
            if instr(1,invar,chr(60)&string&chr(62)) >0 then readme=true
        else
            if instr(1,invar,chr(60)&string&chr(62)) >0 then
                readme=false
                exit do
            else
                if len(Invar)>0 then Retvar=RetVar&vbcrlf&right(Invar,len(Invar)-1)
            end if
        end if
    loop
    lTSO.close
    set lTSO=nothing
    GetString = RetVar
end function
'------------------------------------------------------------------------------------------------------------------------
public sub WriteHTMLHeader
    TSO.write("<!DOCTYPE HTML PUBLIC ""-//W3C//DTD HTML 4.01 Transitional//EN"">")
    TSO.write("<html>"&vbcrlf&"<head>"&vbcrlf&"<title>Admin Mod Commands</title>"&vbcrlf&vbcrlf)
    WriteHTMLStyle
    TSO.write(GetString("SCRIPT MARKER"))
    TSO.write(vbcrlf&vbcrlf&"</head>"&vbcrlf&vbcrlf&"<body>"&vbcrlf)
end sub
'------------------------------------------------------------------------------------------------------------------------
private sub WriteHTMLStyle
    TSO.writeline("<style type=""text/css"">"&vbcrlf&"A { text-decoration: none; border-bottom: none; }")
    TSO.writeline(".name { display:inline-block; }")
    if COMMANDS_SHOW_LEVELS =true then TSO.writeline(".access { font-size:80%; display:inline-block; text-align: center; }") else TSO.writeline(".access { font-size:80%; display:none; }") 
    TSO.writeline(".description { display:inline-block; }")
    if COMMANDS_SHOW_FUNCTIONS =true then TSO.writeline(".function { display:inline-block; }") else TSO.writeline(".function { display:none; }")
    if COMMANDS_SHOW_PLUGINS =true then TSO.writeline(".plugin { display:inline-block; }") else TSO.writeline(".plugin { display:none; }")
    TSO.writeline("</style>"&vbcrlf)
end sub
'------------------------------------------------------------------------------------------------------------------------
private sub WriteHTMLFooter
    TSO.write("</body></html>")
end sub
'------------------------------------------------------------------------------------------------------------------------
public function CreateCommandsTable
    if COMMANDS_DRAW_TABLE =false then exit function
    if ubound(commands)=0 and typename(Commands(ubound(Commands)))= "Empty" then ErrorExit()
    dim OutVar,LineVar,x,y
    
    TSO.writeline("<table ID=commands border=1 cellspacing=0 frame=box rules=all align=center>"&vbcrlf)
    
    TSO.writeline("<tr>"&vbcrlf&"<td ID=CommandNameLabel style=""display: inline-block;""><b>Command</b></td>")
    
    if COMMANDS_DRAW_LEVELS =true then
        TSO.write("<td ID=CommandAccessLabel style=""")
        if COMMANDS_SHOW_LEVELS =true then TSO.write("display: inline-block;") else TSO.write("display: none;")
        TSO.write("""><b>Access Level</b></td>"&vbcrlf)
    end if
    
    TSO.writeline("<td ID=CommandDescriptionLabel style=""display: inline-block;""><b>Description</b></td>")

    if COMMANDS_DRAW_PLUGINS =true then
        TSO.write("<td ID=CommandFunctionLabel style=""")
        if COMMANDS_SHOW_PLUGINS =true then TSO.write("display: inline-block;") else TSO.write("display: none;")
        TSO.write("""><b>Function</b></td>"&vbcrlf)
    end if
    
    if COMMANDS_DRAW_FUNCTIONS =true then
        TSO.write("<td ID=CommandPluginLabel style=""")
        if COMMANDS_SHOW_FUNCTIONS =true then TSO.write("display: inline-block;") else TSO.write("display: none;")
        TSO.write("""><b>Plugin</b></td>"&vbcrlf)
    end if
    
    TSO.writeline("</tr>"&vbcrlf)

    for x=0 to ubound(Commands)
        LineVar="<tr><td class=name>"&Commands(x).name
        'if COMMANDS_DRAW_LEVELS =true then LineVar=LineVar&"</td><td class=access>"
        if COMMANDS_DRAW_LEVELS =true then
        	LineVar=LineVar & "<td class=access>"
	        if ACCESS_DRAW_TABLE =true then 
	            if COMMANDS_ACCESS_NUMERIC =false then
	            	Linevar=linevar&"<a href=""#"&Commands(x).level&""">"&Commands(x).level&"</a>" 
	            else
	            	Linevar=linevar&"<a href=""#"&Commands(x).level&""">"&cstr(GetAccessFromName(x))&"</a>"
	            end if
	        else
	            if COMMANDS_ACCESS_NUMERIC =false then
	            	LineVar=LineVar&Commands(x).level 
	            else
	            	LineVar=LineVar&cstr(GetAccessFromName(x))
	            end if
	        end if
	   	end if
        if Commands(x).description="" then LineVar=LineVar&"</td><td class=description>" else LineVar=LineVar&"</td><td class=description>"&Commands(x).description
        if COMMANDS_DRAW_FUNCTIONS =true then LineVar=LineVar&"</td><td class=function>"&Commands(x).functionname
        if COMMANDS_DRAW_PLUGINS =true then LineVar=LineVar&"</td><td class=plugin>"&Commands(x).InFile
        LineVar=LineVar&"</td></tr>"&vbcrlf
        if DRAW_EMPTY_DESCRIPTORS =false and Commands(x).Description="" then LineVar=""
        if DRAW_LESSTHANOREQUALTO >0 then
            y=GetAccessFromName(x)
            if isnumeric(y) then
                if (DRAW_LESSTHANOREQUALTO or y) <> DRAW_LESSTHANOREQUALTO then    LineVar=""
            else
                if ON_STRING_ACCESS_REMOVE =true then LineVar=""
            end if
        end if
        TSO.write(LineVar)
    next
    OutVar=OutVar&"</table>"&vbcrlf&vbcrlf
    
    TSO.writeline(Outvar)
end function
'------------------------------------------------------------------------------------------------------------------------
public function CreateAccessTable
    if ACCESS_DRAW_TABLE =false then exit function
    dim x,y,z,LineVar,OutVar
    TSO.write("<p>&nbsp;</p>")
    TSO.writeline("<table border=1 cellspacing=0 frame=box rules=all align=center>")
    TSO.write("<tr><td>Name</td><td>Level</td>")
    if ACCESS_DRAW_PLUGINS =true then TSO.write("<td>Declared In</td>")
    if ACCESS_DRAW_INSTANCES=true then TSO.write("<td>Instances</td>")
    TSO.write("</tr>"&vbcrlf)
    
    for x=0 to ubound(Levels)
        TSO.write("<tr><td class=access><a name="""&Levels(x).name&""">"&Levels(x).name&"</a></td><td>"&levels(x).level&"</td>")
        if ACCESS_DRAW_PLUGINS =true then TSO.write("<td>"&Levels(x).InFile&"</td>")
        if ACCESS_DRAW_INSTANCES =true then
            TSO.write("<td>")
            if x<>0 and x <>ubound(levels) then
                for y = 0 to x-1 'previously declared
                    if levels(x).name=levels(y).name then
                        if lcase(right(levels(y).InFile,4))=".sma" then
                            TSO.write("<b>(also:</b>"&levels(y).Infile&"<b>,</b>"&levels(y).level&"<b>)</b><br>")
                        else
                            TSO.write("<b>(previously:</b>"&levels(y).Infile&"<b>,</b>"&levels(y).level&"<b>)</b><br>")
                        end if
                    end if
                next
                for z =x+1 to ubound(levels) 'redeclared
                    if levels(x).name=levels(z).name then
                        if lcase(right(levels(y).InFile,4))=".sma" then
                            TSO.write("<b>(also:</b>"&levels(z).Infile&"<b>,</b>"&levels(z).level&"<b>)</b><br>")
                        else
                            TSO.write("<b>(later:</b>"&levels(z).Infile&"<b>,</b>"&levels(z).level&"<b>)</b><br>")
                        end if
                    end if
                next
            end if
            TSO.write("</td>")
        end if
        TSO.write("</tr>"&vbcrlf)
    next
    TSO.write("</table>"&vbcrlf)
end function
'------------------------------------------------------------------------------------------------------------------------
public function CreateCheckBoxTable
    if DRAW_CHECKBOX_TABLE =true then
        if COMMANDS_DRAW_TABLE =false then exit function
        TSO.write("<table border=1 cellspacing=0 frame=box rules=all align=right><tr>"&vbcrlf)
        TSO.write("<td><input type=""checkbox"" name=""showaccess"" value=""0"" onclick=""toggle(this,'name');"" CHECKED DISABLED>Show Names</td>"&vbcrlf)
        
        if COMMANDS_DRAW_LEVELS = true then 
            TSO.write("<td><input type=""checkbox"" name=""showaccess"" value=""0"" onclick=""toggle(this,'access');"" ")
            if COMMANDS_SHOW_LEVELS = true then TSO.write("CHECKED")
            TSO.write(">Show access levels</td>"&vbcrlf)
        end if
    
        TSO.write("<td><input type=""checkbox"" name=""showaccess"" value=""0"" onclick=""toggle(this,'description');"" CHECKED DISABLED>Show descriptions</td>"&vbcrlf)
        
        if COMMANDS_DRAW_FUNCTIONS = true then 
            TSO.write("<td><input type=""checkbox"" name=""showaccess"" value=""0"" onclick=""toggle(this,'function');"" ")
            if COMMANDS_SHOW_FUNCTIONS =true then TSO.write("CHECKED")
            TSO.write(">Show functions</td>"&vbcrlf)
        end if
        
        if COMMANDS_DRAW_PLUGINS =true then
            TSO.write("<td><input type=""checkbox"" name=""showaccess"" value=""0"" onclick=""toggle(this,'plugin');"" ")
            if COMMANDS_SHOW_PLUGINS =true then TSO.write("CHECKED")
            TSO.write(">Show plugins</td>"&vbcrlf)
        end if
        
        TSO.write("</tr></table>"&vbcrlf&"<p>&nbsp;</p>"&vbcrlf&vbcrlf)
    end if
end function
'------------------------------------------------------------------------------------------------------------------------
private function GetAccessFromName(z)
    dim x,w
    dim y(): redim y(0)
    for x = 0 to ubound(Levels)
        if Levels(x).name = Commands(z).level then
            if typename(y(ubound(y)))<> "Empty" then redim preserve y(ubound(y)+1)
            set y(ubound(y)) =new Access
            set y(ubound(y))=Levels(x)
        end if
    next
    if typename(y(ubound(y)))= "Empty" then exit function
    for x =0 to ubound(y)
        if y(x).InFile=Commands(z).infile then 
            GetAccessFromName=y(x).Level
            exit function
        end if
    next
    w=0
    for x =0 to ubound(y)
        if y(x).Level > w then w= y(x).level
    next
    GetAccessFromName =clng(w)
    
end function
'----------------------------------------------------------------------------------------------------------------------------
Private Sub GetCommand
    dim Command
    Set Command = WScript.Arguments
    if Command.count>0 then
        if isnumeric(Command(0)) then DRAW_LESSTHANOREQUALTO=Commands(0)
    end if
end sub
'------------------------------------------------------------------------------------------------------------------------
private sub ErrorExit
    msgbox "an error has occured, please check your settings",vbokonly,"error"
    tso.close
    fso.deletefile "Output.html",true
    wscript.quit
end sub
'------------------------------------------------------------------------------------------------------------------------            
'<SCRIPT MARKER>
'<SCRIPT type="text/javascript">
'function toggle (Check,Type) {
'   var cr,i;
'   var coll=document.getElementById('commands').getElementsByTagName("TD");
'   if (coll!=null) {
'       for (i=0; i<coll.length; i++)
'       if (coll[i].className == Type) {
'           if (Check.checked==false) { coll[i].style.display='none'; }    else { coll[i].style.display='block'; }
'        }
'    }
'    
'    if (Type =='name') {
'        cr=document.getElementById('CommandNameLabel');
'    } else if (Type == 'access') {
'        cr=document.getElementById('CommandAccessLabel');
'    } else if ( Type == 'description' ) {
'        cr=document.getElementById('CommandDescriptionLabel');
'    } else if ( Type == 'function' ) {
'        cr=document.getElementById('CommandFunctionLabel');
'    } else if ( Type == 'plugin' ) {
'        cr=document.getElementById('CommandPluginLabel');
'    }
'    if (cr!=null)
'        if (Check.checked==false) {cr.style.display='none'; } else { cr.style.display='block';}
'}
'</SCRIPT>
'<SCRIPT MARKER>