/* 		USP Ninjas Mod v1.0.3

	Features:
	
	-USP Silence
	-Footsteps
	-No Fall Damage
	-Slay Upon Unislenced Kill
	-Rules
	-Team Swaps
	-Extreme Fun
	
	
	Credits:
	
	ConnorMcLeod 	- Helping with the correct USP silence code and freeze
	IneedHelp 	- Providing a helpful base for the plugin
	Exolent 	- Helping with the Team Switch small team define problem
	Seta00 		- Helping with the Team Switch small team define problem
*/

#include <amxmodx>
#include <cstrike>
#include <hamsandwich>
#include <engine>
#include <fun>
#include <fakemeta>

#define PLUGIN_NAME 	"USP Ninjas"
#define PLUGIN_VERS 	"1.0.3"
#define PLUGIN_AUTH 	"wrecked"

#define    EXTRAOFFSET_WEAPONS            4
#define    m_pPlayer                    41
#define    m_flNextSecondaryAttack        47
#define    OFFSET_SILENCER_FIREMODE        74

#define    TASK_ID    19966

#define set_usp_silent(%1)    set_pdata_int(%1, OFFSET_SILENCER_FIREMODE, USP_SILENCED, EXTRAOFFSET_WEAPONS)
#define get_weapon_owner(%1)    get_pdata_cbase(%1, m_pPlayer, EXTRAOFFSET_WEAPONS) 

const USP_SILENCED = (1<<0)

const MAX_PLAYERS = 32

const XTRA_OFS_PLAYER = 5
const m_pActiveItem = 373

const Ham:Ham_Player_ResetMaxSpeed = Ham_Item_PreFrame

new const g_iHudColors[3] = { 255, 255, 255 }

new g_bNoFallDamage[MAX_PLAYERS+1]

new g_iMaxPlayers
new g_iHudSyncMsg
new g_pRestartPointer

new pFootsteps
new pNoFallDamage
new pszPrefix
new pHideTimer
new pRulesFile

new bool:g_bSilencer[33]

new HamHook:g_iHhResetMaxSpeed


public plugin_init() 
{
				register_plugin( PLUGIN_NAME, PLUGIN_VERS, PLUGIN_AUTH )
	
				register_clcmd( "say usprules", "uspRules", ADMIN_ALL, "Показывает правила в MOTD окне" )
				register_clcmd( "say_team usprules", "uspRules", ADMIN_ALL, "Показывает правила в MOTD окне" )
				register_clcmd( "say /usprules", "uspRules", ADMIN_ALL, "Показывает правила в MOTD окне" )
				register_clcmd( "say_team /usprules", "uspRules", ADMIN_ALL, "Показывает правила в MOTD окне" )

	pFootsteps =		register_cvar( "un_footsteps", "0" )		// To set the footsteps
	pNoFallDamage = 	register_cvar( "un_nofalldamage", "1" )		// Gives the option to set no fall damage
	pszPrefix =		register_cvar( "un_prefix", "[USP]" )		// Prefix before most messages
	pHideTimer = 		register_cvar( "un_hidetimer", "15" )		// Time the hiders get to hide for
	pRulesFile =		register_cvar( "un_rulesfile", "motd2.html" ) 	// Rules file to read from
	
	g_iMaxPlayers = 	get_maxplayers( )
	g_iHudSyncMsg = 	CreateHudSyncObj( )
	g_pRestartPointer = 	get_cvar_pointer( "sv_restart" );

				register_event( "HLTV", "Event_HLTV_New_Round", "a", "1=0", "2=0" )
	
				register_logevent( "LogEvent_RoundStart", 2, "1=Round_Start" )
				register_logevent( "LogEvent_RoundEnd", 2, "0=World triggered", "1=Round_Draw", "1=Round_End" );
	
				RegisterHam( Ham_Spawn, "player", "Fwd_PlayerSpawn_Post", 1 )
				RegisterHam( Ham_Killed, "player", "Fwd_PlayerKilled_Pre", 0 )
				RegisterHam( Ham_TakeDamage, "player", "Ham_CBasePlayer_TakeDamage_Pre" )
				RegisterHam( Ham_Item_Deploy, "weapon_usp", "Fwd_Usp_Deploy", 1 )
				RegisterHam( Ham_Weapon_SecondaryAttack, "weapon_usp", "Fwd_Usp_SecondaryAttack", 1 )
	g_iHhResetMaxSpeed =	RegisterHam( Ham_Player_ResetMaxSpeed, "player", "CBasePlayer_ResetMaxSpeed", 1 )
	
				register_dictionary( "uspninjas.txt" )
}

public Fwd_Usp_Deploy( iEnt )
{
	set_usp_silent( iEnt )
	
	SendWeaponAnim( get_weapon_owner( iEnt ), 6 )
}

public Fwd_Usp_SecondaryAttack( iEnt )
{
	set_usp_silent( iEnt )
	SendWeaponAnim( get_weapon_owner( iEnt ), 0 )

	set_pdata_float( iEnt, m_flNextSecondaryAttack, 9999.9, EXTRAOFFSET_WEAPONS ) 
}

public Event_HLTV_New_Round()
{
	EnableHamForward( g_iHhResetMaxSpeed )
}

public LogEvent_RoundEnd( id )
{
	mpFootsteps( )
	hideTimer( )
	
	if (!GetTeam(1))
	{
		set_hudmessage(g_iHudColors[0], g_iHudColors[1], g_iHudColors[2], -1.0, 0.35, 0, 2.0, 2.0, 0.1, 0.2, -1)
		ShowSyncHudMsg(0, g_iHudSyncMsg, "- CT выиграли! - Смена команд...")
		
		TeamSwitch()
	}
	else if (!GetTeam(2))
	{
		set_hudmessage(g_iHudColors[0], g_iHudColors[1], g_iHudColors[2], -1.0, 0.35, 0, 2.0, 2.0, 0.1, 0.2, -1)
		ShowSyncHudMsg(0, g_iHudSyncMsg, "- T выиграли! - Смены не будет..")
	}
	else
	{
		set_hudmessage(g_iHudColors[0], g_iHudColors[1], g_iHudColors[2], -1.0, 0.35, 0, 2.0, 2.0, 0.1, 0.2, -1)
		ShowSyncHudMsg(0, g_iHudSyncMsg, "- Ничья -")
	}
}

public LogEvent_RoundStart()
{
	DisableHamForward( g_iHhResetMaxSpeed )
}

public CBasePlayer_ResetMaxSpeed( id )
{
    if( is_user_connected( id ) && cs_get_user_team( id ) == CS_TEAM_T )
    {
        new Float:flMaxSpeed

        new iActiveItem = get_pdata_cbase( id, m_pActiveItem, XTRA_OFS_PLAYER )
        if( iActiveItem > 0 )
        {
		ExecuteHam( Ham_CS_Item_GetMaxSpeed, iActiveItem, flMaxSpeed )
        }
        else
        {
		flMaxSpeed = 250.0
        }

        set_pev( id, pev_maxspeed, flMaxSpeed )
    }
}  
		
public Fwd_PlayerSpawn_Post( id )
{
	if ( !is_user_alive( id ) )
		return PLUGIN_HANDLED;
		
	else
	{
		new UspEntity = find_ent_by_owner( -1, "weapon_usp", id )
		
		strip_user_weapons( id )
		
		give_item ( id, "weapon_usp" )
		cs_set_user_bpammo ( id, 16, 24 )
		g_bSilencer[id] = bool:cs_get_weapon_silen(UspEntity)
		
		give_item ( id, "weapon_knife" )
			
		if( cs_get_user_team( id ) == CS_TEAM_T )
		{
			g_bNoFallDamage[ id ] = false
		}
		
		if( cs_get_user_team( id ) != CS_TEAM_T )
		{
			set_pev( id, pev_takedamage, 0 )
			
			set_task( 15.0, "removeSpawnProtect", id + TASK_ID )
			
			g_bNoFallDamage[ id ] = true
		}
		
		client_print( id, print_chat, "%L", pszPrefix, "USP_RULES" )
		
		return PLUGIN_CONTINUE;
	}
	return PLUGIN_CONTINUE;
}

public Fwd_PlayerKilled_Pre(attacker, victim, gib)
{
	if (!is_user_connected(victim))
		return;

	if (attacker == victim)
		return;

	new vName[32], aName[32]

	get_user_name(victim, vName, 31)
	get_user_name(attacker, aName, 31)

	if (!g_bSilencer[victim])
	{
		user_silentkill(attacker)
		user_silentkill(victim)
		
		client_print(0, print_chat, "%L", "USP_KILLED_NOSILENCE", pszPrefix, vName, aName)
	}
}

public Ham_CBasePlayer_TakeDamage_Pre( const id, const iInflictor, const iAttacker, const Float:flDamage, const iDamageType )
{
	if( iDamageType == DMG_FALL && g_bNoFallDamage[id] && get_pcvar_num( pNoFallDamage ) == 1 )
	{
		SetHamReturnInteger(0)
		
		return HAM_SUPERCEDE
	}
	return HAM_IGNORED
}

public removeSpawnProtect( get_id )
{
	new protectid = get_id - TASK_ID
	
	set_pev( protectid, pev_takedamage, 1 )
}

public uspRules( id )
{
	if( file_exists( "motd2.html" ) == 1 )
	{
		show_motd( id, "motd2.html" )
		
		client_print( 0, print_chat, "%L", "USP_ADVERTISE", PLUGIN_NAME, PLUGIN_VERS )
	}
	else
	{
		client_print( id, print_chat, "%L", pszPrefix, "USP_RULES_NOTFOUND" )
		
		log_amx( "Файл: %s не был найден. Пожалуйста сделайте этот файл или ваши правила игры не будут показаны!", pRulesFile )
		
		client_print( 0, print_chat, "%L", "USP_ADVERTISE", PLUGIN_NAME, PLUGIN_VERS )
		
		return;
	}
}

public mpFootsteps( )
{
	if( get_pcvar_num( pFootsteps ) == 0 )
	{
		set_cvar_num( "mp_footsteps", 1 )
	}
	
	else
	{
		set_cvar_num( "mp_footsteps", 0 )
	}
	return PLUGIN_CONTINUE;
}

public hideTimer( )
{
	if( get_pcvar_num( pHideTimer ) <= 0 )
	{
		set_cvar_num( "mp_freezetime", 0 )
	}
	else
	{
		set_cvar_num( "mp_freezetime", get_pcvar_num( pHideTimer ) )
	}
	return PLUGIN_CONTINUE;
}

GetTeam(_team)
{
	static Team
	Team = 0
	
	for (new i = 1; i <= g_iMaxPlayers; i++)
	{
		if (!is_user_alive(i))
			continue;
		
		if (get_user_team(i) == _team)
			Team++
	}
	return Team
}

SendWeaponAnim(id, iAnim)
{
	entity_set_int( id, EV_INT_weaponanim, iAnim )

	message_begin( MSG_ONE, SVC_WEAPONANIM, _, id )
	write_byte( iAnim )
	write_byte( entity_get_int( id, EV_INT_body ) )
	message_end( )
}

TeamSwitch()
{
	new CsTeams:Team
	
	for (new i = 1; i <= g_iMaxPlayers; i++)
	{
		if (!is_user_connected(i))
			continue;
		
		Team = cs_get_user_team(i)
		
		switch(Team)
		{
			case CS_TEAM_CT: cs_set_user_team(i, CS_TEAM_T)
			case CS_TEAM_T: cs_set_user_team(i, CS_TEAM_CT)
		}
	}
	set_pcvar_num(g_pRestartPointer, 1)
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang3082\\ f0\\ fs16 \n\\ par }
*/
