/* Copyright (C) 2006-2008 Space Headed Productions
* 
* WeaponMod is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation.
*
* WeaponMod is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with WeaponMod; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/ 

#include <amxmodx>
#include <fakemeta>
#include <weaponmod>

// Plugin informations
new const PLUGIN[] = "WPN GameInfo TS"
new const VERSION[] = "0.8"
new const AUTHOR[] = "DevconeS"

// Offsets
#define OFFSET_MONEY	301	// Couldn't find that one right now
#define OFFSET_DEATHS	711
#define OFFSET_SLOTS	333

enum
{
	cur_wpnid,
	cur_ammo1,
	cur_ammo2
}

// GameInfos
new const WEAPON_INDEX = 0			// Weapon Index of the weapon that should be replaced
new const WEAPON_COMMAND[] = "weapon_0"	// Command to take the weapon
new const WEAPON_V_MODEL[] = "models/v_melee.mdl"		// Viewmodel of the weapon that should be replaced
new const WEAPON_P_MODEL[] = ""		// Playermodel of the weapon that should be replaced
new const GUNSHOT_DECALS[] = {60, 61, 62, 63, 64}	// Gunshot decal list
new const EXPLOSION_DECALS[] = {65, 66, 67}		// Explosion decal list
new const SMALL_EXPLOSION_DECALS[] = {47, 48, 49}		// Small Explosion decal list
new const LARGE_BLOOD_DECALS[] = {218, 219}		// Large blood decals
new const SMALL_BLOOD_DECALS[] = {204, 205, 206, 207, 208, 209, 210, 211}	// Small blood decals

// User Messages
new g_msgClipInfo
new g_msgWeaponInfo
new g_msgScoreInfo
new g_msgDeathMsg

// CVAR Pointers
new g_Enabled

// Weapon Info
new g_UserWeapon[33][3]

// Register the plugin
public plugin_init()
{
	// Important informations :)
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	// Events
	register_event("WeaponInfo", "eventWeaponInfo", "b")
	
	// User Messages
	g_msgClipInfo = get_user_msgid("ClipInfo")
	g_msgWeaponInfo = get_user_msgid("WeaponInfo")
	g_msgScoreInfo = get_user_msgid("ScoreInfo")
	g_msgDeathMsg = get_user_msgid("DeathMsg")
	
	wpn_gameinfo_init()
}

public plugin_cfg()
{
	// CVARs
	g_Enabled = get_cvar_pointer("wpn_enabled")
}

// Start sending some infos to WeaponMod :)
wpn_gameinfo_init()
{
	// Let WeaponMod know that a GameInfo file is installed
	wpn_set_gameinfo(gi_available, 1)
	
	// Is this a Teamplay game?
	wpn_set_gameinfo(gi_teamplay, 0)
}

// These natives are very important since they'll get called by WeaponMod and addons
public plugin_natives()
{
	register_native("wpn_gi_is_default_weapon","native_gi_is_default_weapon")
	register_native("wpn_gi_set_offset_int", "native_gi_set_offset_int")
	register_native("wpn_gi_get_offset_int", "native_gi_get_offset_int")
	register_native("wpn_gi_in_freeze_time", "native_gi_in_freeze_time")
	register_native("wpn_gi_take_default_weapon", "native_gi_take_default_weapon")
	register_native("wpn_gi_get_gunshot_decal", "native_gi_get_gunshot_decal")
	register_native("wpn_gi_get_explosion_decal", "native_gi_get_explosion_decal")
	register_native("wpn_gi_get_smallexplosion_decal", "native_gi_get_smallexpl_decal")
	register_native("wpn_gi_get_blood_decal", "native_gi_get_blood_decal")
	register_native("wpn_gi_get_smallblood_decal", "native_gi_get_smallblood_decal")
	
	// Bug fix for AMXX's broken "get_user_weapon" on TS 3.0
	register_native("wpn_gi_get_user_weapon", "native_gi_get_user_weapon")
}

// Checks if the selected weapon is the default weapon
public native_gi_is_default_weapon()
{
	if(get_param(1) == WEAPON_INDEX)
	{
		return 1
	}
	
	return 0
}

// Sets an offset value
public native_gi_set_offset_int()
{
	return set_offset_value(get_param(1), get_param(2), get_param(3))
}

// Gets an offset value
public native_gi_get_offset_int()
{
	return get_offset_value(get_param(1), get_param(2))
}

// Identifies if the game is currently in the freeze time
public native_gi_in_freeze_time()
{
	return false
}

// Player has to take the default weapon (obviously picked up a new special weapon)
public native_gi_take_default_weapon()
{
	engclient_cmd(get_param(1), WEAPON_COMMAND)
}

// Returns a random gunshot decal
public native_gi_get_gunshot_decal()
{
	return GUNSHOT_DECALS[random_num(0, sizeof(GUNSHOT_DECALS) - 1)]
}

// Returns a random explosion decal
public native_gi_get_explosion_decal()
{
	return EXPLOSION_DECALS[random_num(0, sizeof(EXPLOSION_DECALS) - 1)]
}

// Returns a random small explosion decal
public native_gi_get_smallexpl_decal()
{
	return SMALL_EXPLOSION_DECALS[random_num(0, sizeof(SMALL_EXPLOSION_DECALS) - 1)]
}

// Returns a random large blood decal
public native_gi_get_blood_decal()
{
	return LARGE_BLOOD_DECALS[random_num(0, sizeof(LARGE_BLOOD_DECALS) - 1)]
}

// Returns a random small blood decal
public native_gi_get_smallblood_decal()
{
	return SMALL_BLOOD_DECALS[random_num(0, sizeof(SMALL_BLOOD_DECALS) - 1)]
}

// In order to fix the borken get_user_weapon native, we override it with our own :)
public native_gi_get_user_weapon()
{
	static id
	id = get_param(1)
	
	set_param_byref(2, g_UserWeapon[id][cur_ammo1])
	set_param_byref(3, g_UserWeapon[id][cur_ammo2])
	
	return g_UserWeapon[id][cur_wpnid]
}

// This function is used to update the players Ammo displayed on HUD
public wpn_gi_update_ammo(id, wpnid, pAmmo, sAmmo)
{
	if(wpnid > -1)	// -1 would be no special weapon
	{
		// Primary Ammo
		message_begin(MSG_ONE, g_msgClipInfo,{0, 0, 0}, id)
		write_byte(pAmmo)
		message_end()
			
		// Secondary Ammo
		message_begin(MSG_ONE, g_msgWeaponInfo, {0, 0, 0}, id)
		write_byte(20)
		write_byte(pAmmo)
		write_short(sAmmo)
		write_byte(3)
		write_byte(0)
		message_end()
		
		return PLUGIN_CONTINUE
	}
	
	// Hide Ammo from HUD since user is using the knife
	message_begin(MSG_ONE, g_msgWeaponInfo, {0, 0, 0}, 1)
	write_byte(0)
	write_byte(100)
	write_short(0)
	write_byte(0)
	write_byte(0)
	message_end()
	
	return PLUGIN_CONTINUE
}

// A player was killed by a special weapon
public wpn_gi_player_killed(id, killer, hitplace, wpnid, weapon[], bool:monster)
{
	// Update Scoreboard - Killer
	message_begin(MSG_BROADCAST, g_msgScoreInfo)
	write_byte(killer)
	write_short(get_user_frags(killer))
	write_short(get_offset_value(killer, offset_deaths))
	write_short(0)
	write_short(1)
	message_end()
	
	// Monster's can't be showed inside a death message and do not have a scoreboard :P
	if(!monster)
	{
		// Write death message
		message_begin(MSG_BROADCAST, g_msgDeathMsg)
		write_byte(killer)
		write_byte(id)
		write_byte(hitplace == 1 ? 1 : 0)
		write_string(weapon)
		message_end()
		
		if(id != killer)	// No need to update the scoreboard twice :)
		{
			// Update Scoreboard - Victim
			message_begin(MSG_BROADCAST, g_msgScoreInfo)
			write_byte(id)
			write_short(get_user_frags(id))
			write_short(get_offset_value(id, offset_deaths))
			write_short(0)
			write_short(1)
			message_end()
		}
	}
}

// This forward is used to reset the replaced weapon to its default values
public wpn_gi_reset_weapon(id)
{
	// Models
	set_pev(id, pev_viewmodel, engfunc(EngFunc_AllocString, WEAPON_V_MODEL))
	set_pev(id, pev_weaponmodel, engfunc(EngFunc_AllocString, WEAPON_P_MODEL))
	
	// Somehow we have to calculate the speed by the used slots...
	//new Float:speed
	//set_pev(id, pev_maxspeed, speed)
}

// Handle weapon change
public eventWeaponInfo(id)
{
	// Update weapon information
	new wpnid = read_data(1)
	g_UserWeapon[id][cur_wpnid] = wpnid
	g_UserWeapon[id][cur_ammo1] = read_data(2)
	g_UserWeapon[id][cur_ammo2] = read_data(3)
	
	if(!get_pcvar_num(g_Enabled)) return PLUGIN_CONTINUE
	if(wpn_user_weapon_count(id) > 0)
	{
		if(wpnid == WEAPON_INDEX)
		{
			// Take the last used weapon
			wpn_change_user_weapon(id, wpn_get_user_weapon(id))
		}
	}
	
	return PLUGIN_CONTINUE
}

// Handle draw command
public client_command(id)
{
	if(!get_pcvar_num(g_Enabled)) return PLUGIN_CONTINUE
	
	new cmd[32]
	read_argv(0, cmd, 31)
	
	if(equal(cmd, WEAPON_COMMAND))	// Does he execute the knife command?
	{
		new wpnCount = wpn_user_weapon_count(id)
		if(wpnCount > 0)	// Does he even have a special weapon?
		{
			new clip, ammo
			new weapon = get_user_weapon(id, clip, ammo)
			if(weapon == WEAPON_INDEX)	// Is his current weapon the knife?
			{
				new actWeapon = wpn_get_user_weapon(id)+1
				if(actWeapon >= wpnCount)
				{
					// Weapon index got over the amount of weapons, set it back to the beginning
					actWeapon = -1
				}
				// Now send the changes back to weaponmod :)
				wpn_change_user_weapon(id, actWeapon)
			}
		}
	}
	
	return PLUGIN_CONTINUE
}

/*// Gets the used slots of a player
get_used_slots(id)
{
	new key = OFFSET_SLOTS
	if(is_amd64_server()) key += 25
	
	return get_pdata_int(id, key)
}

// Sets the used slots of a player
set_used_slots(id, slots)
{
	new key = OFFSET_SLOTS
	if(is_amd64_server()) key += 25
	
	set_pdata_int(id, key, slots)
}*/

// Gets offset data
public get_offset_value(id, type)
{
	new key = -1
	switch(type)
	{
		case offset_money: key = OFFSET_MONEY
		case offset_deaths: key = OFFSET_DEATHS
	}
	
	if(key != -1)
	{
		if(is_amd64_server()) key += 25
		return get_pdata_int(id, key)
	}
	
	return -1;
}

// Sets offset data
public set_offset_value(id, type, value)
{
	new key = -1
	switch(type)
	{
		case offset_money: key = OFFSET_MONEY
		case offset_deaths: key = OFFSET_DEATHS
	}
	
	if(key != -1)
	{
		if(is_amd64_server()) key += 25
		set_pdata_int(id, key, value)
	}
	
	return PLUGIN_CONTINUE
}
