/* Copyright (C) 2006-2008 Space Headed Productions
* 
* WeaponMod is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation.
*
* WeaponMod is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with WeaponMod; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/ 

// Uncomment this, to enable UL Money support

#include <amxmodx>
#include <fakemeta>
#include <weaponmod>

// Plugin informations
new const PLUGIN[] = "WPN GameInfo TFC"
new const VERSION[] = "0.4"
new const AUTHOR[] = "DevconeS"

// Offsets
#define OFFSET_MONEY	-1
#define OFFSET_DEATHS	476

// GameInfos
#define MAX_WEAPONS		4	// Amount of weapons that should be replaced
new const WEAPON_INDEX[MAX_WEAPONS] = {5, 3, 23, 4}	// Weapon Index of the weapon that should be replaced
new const Float:WEAPON_RUN_SPEED[MAX_WEAPONS] = {250.0, 250.0, 250.0, 250.0}	// Run speed of the replaced weapon
new const WEAPON_COMMAND[MAX_WEAPONS][] = {"tf_weapon_axe", "tf_weapon_medikit",
									"tf_weapon_knife", "tf_weapon_spanner"}	// Command to take the weapon
new const WEAPON_V_MODEL[MAX_WEAPONS][] = {"models/v_tfc_crowbar.mdl", "models/v_tfc_medkit.mdl",
									"models/v_tfc_knife.mdl", "models/v_tfc_spanner.mdl"}	// Viewmodel of the weapon that should be replaced
new const WEAPON_P_MODEL[MAX_WEAPONS][] = {"models/p_crowbar.mdl", "models/p_medkit.mdl",
									"models/p_knife.mdl", "models/p_spanner.mdl"}	// Playermodel of the weapon that should be replaced

new const GUNSHOT_DECALS[] = {45, 46, 47, 48, 49}	// Gunshot decal list
new const EXPLOSION_DECALS[] = {50, 51, 52}		// Explosion decal list
new const SMALL_EXPLOSION_DECALS[] = {32, 33, 34}		// Small Explosion decal list
new const LARGE_BLOOD_DECALS[] = {208, 209}		// Large blood decals
new const SMALL_BLOOD_DECALS[] = {194, 195, 196, 197, 198, 199, 200, 201}	// Small blood decals

// User Messages
new g_msgCurWeapon
new g_msgAmmoX
new g_msgScoreInfo
new g_msgDeathMsg
new g_msgDamage

// CVAR Pointers
new g_Enabled

// UserInfos
new g_UserWeapon[33]

// Register the plugin
public plugin_init()
{
	// Important informations :)
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	// Events
	register_event("CurWeapon", "eventCurWeapon", "be", "1=1")
	
	// User Messages
	g_msgCurWeapon = get_user_msgid("CurWeapon")
	g_msgAmmoX = get_user_msgid("AmmoX")
	g_msgScoreInfo = get_user_msgid("ScoreInfo")
	g_msgDeathMsg = get_user_msgid("DeathMsg")
	g_msgDamage = get_user_msgid("Damage")
	
	// CVARs
	g_Enabled = get_cvar_pointer("wpn_enabled")
	
	wpn_gameinfo_init()
}

// Start sending some infos to WeaponMod :)
wpn_gameinfo_init()
{
	// Let WeaponMod know that a GameInfo file is installed
	wpn_set_gameinfo(gi_available, 1)
	
	// Is this a Teamplay game?
	wpn_set_gameinfo(gi_teamplay, 1)
}

// These natives are very important since they'll get called by WeaponMod and addons
public plugin_natives()
{
	register_native("wpn_gi_is_default_weapon", "native_gi_is_default_weapon")
	register_native("wpn_gi_set_offset_int", "native_gi_set_offset_int")
	register_native("wpn_gi_get_offset_int", "native_gi_get_offset_int")
	register_native("wpn_gi_in_freeze_time", "native_gi_in_freeze_time")
	register_native("wpn_gi_take_default_weapon", "native_gi_take_default_weapon")
	register_native("wpn_gi_get_gunshot_decal", "native_gi_get_gunshot_decal")
	register_native("wpn_gi_get_explosion_decal", "native_gi_get_explosion_decal")
	register_native("wpn_gi_get_smallexplosion_decal", "native_gi_get_smallexpl_decal")
	register_native("wpn_gi_get_blood_decal", "native_gi_get_blood_decal")
	register_native("wpn_gi_get_smallblood_decal", "native_gi_get_smallblood_decal")
}

// Checks if the selected weapon is the default weapon
public native_gi_is_default_weapon()
{
	static weapon
	static i
	
	weapon = get_param(1)
	
	for(i = 0; i < MAX_WEAPONS; i++)
	{
		if(weapon == WEAPON_INDEX[i])
		{
			return 1
		}
	}
	
	return 0
}

// Sets an offset value
public native_gi_set_offset_int()
{
	return set_offset_value(get_param(1), get_param(2), get_param(3))
}

// Gets an offset value
public native_gi_get_offset_int()
{
	return get_offset_value(get_param(1), get_param(2))
}

// Identifies if the game is currently in the freeze time
public native_gi_in_freeze_time()
{
	return false
}

// Player has to take the default weapon (obviously picked up a new special weapon)
public native_gi_take_default_weapon()
{
	static id
	id = get_param(1)
	engclient_cmd(id, WEAPON_COMMAND[g_UserWeapon[id]])
}

// Returns a random gunshot decal
public native_gi_get_gunshot_decal()
{
	return GUNSHOT_DECALS[random_num(0, sizeof(GUNSHOT_DECALS) - 1)]
}

// Returns a random explosion decal
public native_gi_get_explosion_decal()
{
	return EXPLOSION_DECALS[random_num(0, sizeof(EXPLOSION_DECALS) - 1)]
}

// Returns a random small explosion decal
public native_gi_get_smallexpl_decal()
{
	return SMALL_EXPLOSION_DECALS[random_num(0, sizeof(SMALL_EXPLOSION_DECALS) - 1)]
}

// Returns a random large blood decal
public native_gi_get_blood_decal()
{
	return LARGE_BLOOD_DECALS[random_num(0, sizeof(LARGE_BLOOD_DECALS) - 1)]
}

// Returns a random small blood decal
public native_gi_get_smallblood_decal()
{
	return SMALL_BLOOD_DECALS[random_num(0, sizeof(SMALL_BLOOD_DECALS) - 1)]
}

// This function is used to update the players Ammo displayed on HUD
public wpn_gi_update_ammo(id, wpnid, pAmmo, sAmmo)
{
	if(wpnid > -1)	// -1 would be no special weapon
	{
		// Primary Ammo
		message_begin(MSG_ONE, g_msgCurWeapon, {0, 0, 0}, id)
		write_byte(1)
		write_byte(20)
		write_byte(pAmmo)
		message_end()
			
		// Secondary Ammo
		message_begin(MSG_ONE, g_msgAmmoX, {0, 0, 0}, id)
		write_byte(1)
		write_byte(sAmmo)
		message_end()
		
		return PLUGIN_CONTINUE
	}
	
	// Hide Ammo from HUD since user is using the knife
	message_begin(MSG_ONE, g_msgCurWeapon, {0, 0, 0}, id)
	write_byte(1)
	write_byte(5)
	write_byte(-1)
	message_end()
	
	return PLUGIN_CONTINUE
}

// A player was killed by a special weapon
public wpn_gi_player_killed(id, killer, hitplace, wpnid, weapon[], bool:monster)
{
	// Update Scoreboard - Killer
	emessage_begin(MSG_BROADCAST, g_msgScoreInfo)
	ewrite_byte(killer)
	ewrite_short(get_user_frags(killer))
	ewrite_short(get_offset_value(killer, offset_deaths))
	ewrite_short(0)
	ewrite_short(get_user_team(killer))
	emessage_end()
	
	// Monster's can't be showed inside a death message and do not have a scoreboard :P
	if(!monster)
	{
		// Write death message
		emessage_begin(MSG_BROADCAST, g_msgDeathMsg)
		ewrite_byte(killer)
		ewrite_byte(id)
		ewrite_byte(hitplace == 1 ? 1 : 0)
		ewrite_string(weapon)
		emessage_end()
		
		if(id != killer)	// No need to update the scoreboard twice :)
		{
			// Update Scoreboard - Victim
			emessage_begin(MSG_BROADCAST, g_msgScoreInfo)
			ewrite_byte(id)
			ewrite_short(get_user_frags(id))
			ewrite_short(get_offset_value(id, offset_deaths))
			ewrite_short(0)
			ewrite_short(get_user_team(id))
			emessage_end()
		}
	}
}

// Damage caused by a WeaponMod weapon
public wpn_attack_damage(victim, attacker, wpnid, damage, hitplace, damageType, bool:monster)
{
	if(monster || !pev_valid(victim))
	{
		// Damage was caused to a monster or the victim is not a valid entity, ignore
		return PLUGIN_CONTINUE
	}
	
	// Make sure it's definetely a player and make sure he's alive
	if(pev(victim, pev_flags) & (FL_CLIENT | FL_FAKECLIENT))
	{
		if(is_user_alive(victim))
		{
			// Get attacker's origin
			new origin[3]
			get_user_origin(attacker, origin)
			
			// Write damage message
			message_begin(MSG_ONE_UNRELIABLE, g_msgDamage, {0,0,0}, victim)
			write_byte(0)	// Damage save not supported
			write_byte(damage)
			write_long(damageType)
			write_coord(origin[0])
			write_coord(origin[1])
			write_coord(origin[2])
			message_end()
		}
	}
	return PLUGIN_CONTINUE
}

// This forward is used to reset the replaced weapon to its default values
public wpn_gi_reset_weapon(id)
{
	// Models
	set_pev(id, pev_viewmodel, engfunc(EngFunc_AllocString, WEAPON_V_MODEL[g_UserWeapon[id]]))
	set_pev(id, pev_weaponmodel, engfunc(EngFunc_AllocString, WEAPON_P_MODEL[g_UserWeapon[id]]))
	set_pev(id, pev_maxspeed, WEAPON_RUN_SPEED[g_UserWeapon[id]])
}

// Handle weapon change
public eventCurWeapon(id)
{
	if(!get_pcvar_num(g_Enabled)) return PLUGIN_CONTINUE
	
	if(wpn_user_weapon_count(id) > 0)
	{
		if(read_data(2) == WEAPON_INDEX[g_UserWeapon[id]])
		{
			// Take the last used weapon
			wpn_change_user_weapon(id, wpn_get_user_weapon(id), false)
		}
	}
	
	return PLUGIN_CONTINUE
}

// Handle draw command
public client_command(id)
{
	if(!get_pcvar_num(g_Enabled)) return PLUGIN_CONTINUE
	
	new cmd[32],wpnCount
	read_argv(0, cmd, 31)
	wpnCount = wpn_user_weapon_count(id)
	
	if(wpnCount > 0)	// Just check if the user has at least 1 weapon
	{
		for(new i = 0; i < MAX_WEAPONS; i++)
		{
			if(equal(cmd,WEAPON_COMMAND[i]))
			{
				g_UserWeapon[id] = i
				
				new clip,ammo
				new weapon = get_user_weapon(id, clip, ammo)
				if(weapon == WEAPON_INDEX[i])	// Is his current weapon the knife?
				{
					new actWeapon = wpn_get_user_weapon(id)+1
					if(actWeapon >= wpnCount)
					{
						// Weapon index got over the amount of weapons, set it back to the beginning
						actWeapon = -1
					}
					// Now send the changes back to weaponmod :)
					wpn_change_user_weapon(id, actWeapon)
				}
				
				break	// Weapon found, stop the iteration
			}
		}
	}
	
	return PLUGIN_CONTINUE
}

// Gets offset data
public get_offset_value(id, type)
{
	new key = -1
	switch(type)
	{
		case offset_money: key = OFFSET_MONEY
		case offset_deaths: key = OFFSET_DEATHS
	}
	
	if(key != -1)
	{
		if(is_amd64_server()) key += 25
		return get_pdata_int(id, key)
	}
	
	return -1;
}

// Sets offset data
public set_offset_value(id, type, value)
{
	new key = -1
	switch(type)
	{
		case offset_money: key = OFFSET_MONEY
		case offset_deaths: key = OFFSET_DEATHS
	}
	
	if(key != -1)
	{
		if(is_amd64_server()) key += 25
		set_pdata_int(id, key, value)
	}
	
	return PLUGIN_CONTINUE
}
