/*
Fun Mod
By: ~KiLL | Birdman


Installation:
Put the source code to addons/amxmodx/scripting/ folder and compile it. 
Or use the compiler on www.amxmodx.org to compile.
Put the compiled .amxx file to addons/amxmodx/plugins/ folder.
Add "funmod.amxx" to your amxmodx plugins.ini with out the quotes.
Put the funmod.cfg file in your addons/amxmodx/configs/ folder. If you don't the mod will pause it self.


Change Log:
1.2 - The mod works again, Fixed bug when you stay invisibile after you die.

1.1.1 - Added fm_menuonspawn cvar

1.1 - Added Price Cvars and a Config File. Removed Buying Weapons from menu and Gravity 800.

1.0 - First Release

*/


#include <amxmodx>
#include <amxmisc>
#include <engine>
#include <fun>
#include <cstrike>
new bool:is_enemy[33]


public plugin_init()
{
	register_plugin("Fun Mod","1.2","Birdman")
	register_cvar("fm_enemytime","60")

	register_cvar("fm_invisprice","10000")
	register_cvar("fm_gravprice","2000")
	register_cvar("fm_hpprice","8000")
	register_cvar("fm_glowprice","1000")
	register_cvar("fm_enemylookprice","16000")
	register_cvar("fm_noclipprice","13000")

	register_cvar("fm_givegrav","0.25")
	register_cvar("fm_givehp","500")
	register_cvar("fm_menuonspawn","1")

	register_cvar("fm_invisprice2","9999")
	register_cvar("fm_gravprice2","1999")
	register_cvar("fm_hpprice2","7999")
	register_cvar("fm_glowprice2","999")
	register_cvar("fm_enemylookprice2","15999")
	register_cvar("fm_noclipprice2","12999")
	
	new menuonspawn = get_cvar_num("fm_menuonspawn")
	register_clcmd( "say funmenu","ShowMenu", -1, "Shows The menu" )
	register_clcmd( "say_team funmenu","ShowMenu", -1, "Shows The menu" )
	register_clcmd( "say_team /funmenu","ShowMenu", -1, "Shows The menu" )
	register_clcmd( "say /funmenu","ShowMenu", -1, "Shows The menu" )
	if(menuonspawn = 1) {
		register_event("ResetHUD", "ShowMenu", "b")
	} else { 
		return PLUGIN_CONTINUE
	}
	register_menucmd(register_menuid("\yFun Menu"), (1<<0|1<<1|1<<2|1<<3|1<<4|1<<5|1<<6), "MenuCommand" )
	new basedir[64]
	new cfgfile[64]
	format(cfgfile, 63, "%s/addons/amxmodx/configs/funmod.cfg", basedir)
	if(file_exists(cfgfile)){
		log_amx("Fun Mod Startup :: Loading Configuration File [ funmod.cfg ]...")
		server_cmd("exec %s", cfgfile)
		log_amx("Fun Mod Startup :: Configuration File Loaded [OK]")
	}else{
		log_amx("Fun Mod Startup :: Configuration File NOT FOUND [ Pausing Fun Mod ]")
		server_cmd("amxx pause funmod")
	}

	return PLUGIN_CONTINUE
}

public ShowMenu(id)
{
	new szMenuBody[256]
	new keys
	
	new invisprice = get_cvar_num("fm_invisprice")
	new gravprice = get_cvar_num("fm_gravprice")
	new hpprice = get_cvar_num("fm_hpprice")
	new glowprice = get_cvar_num("fm_glowprice")
	new enemylookprice = get_cvar_num("fm_enemylookprice")
	new noclipprice = get_cvar_num("fm_noclipprice")
	new givegrav = get_cvar_num("fm_givegrav")
	new givehp = get_cvar_num("fm_givehp")

	new nLen = format(szMenuBody, 255, "\yFun Menu^n" )
	nLen += format(szMenuBody[nLen], 255-nLen, "^n\w1. Invisibility - $%d",invisprice )
	nLen += format(szMenuBody[nLen], 255-nLen, "^n\w2. Gravity %d - $%d",givegrav,gravprice )
	nLen += format(szMenuBody[nLen], 255-nLen, "^n\w3. Give me %d hp - $%d",givehp,hpprice )
	nLen += format(szMenuBody[nLen], 255-nLen, "^n\w4. Make me glow - $%d",glowprice )
	nLen += format(szMenuBody[nLen], 255-nLen, "^n\w5. Enemy look - $%d",enemylookprice )
	nLen += format(szMenuBody[nLen], 255-nLen, "^n\w6. Buy NoClip - $%d",noclipprice )
	nLen += format(szMenuBody[nLen], 255-nLen, "^n^n\w0. Exit" )

	keys = (1<<0|1<<1|1<<2|1<<3|1<<4|1<<5|1<<6)
	show_menu( id, keys, szMenuBody, -1 )

	return PLUGIN_CONTINUE
}

public MenuCommand(id, key)
{
	new invisprice = get_cvar_num("fm_invisprice")
	new gravprice = get_cvar_num("fm_gravprice")
	new hpprice = get_cvar_num("fm_hpprice")
	new glowprice = get_cvar_num("fm_glowprice")
	new enemylookprice = get_cvar_num("fm_enemylookprice")
	new noclipprice = get_cvar_num("fm_noclipprice")
	new givegrav = get_cvar_num("fm_givegrav")
	new givehp = get_cvar_num("fm_givehp")
	
	new invisprice2 = get_cvar_num("fm_invisprice2")
	new gravprice2 = get_cvar_num("fm_gravprice2")
	new hpprice2 = get_cvar_num("fm_hpprice2")
	new glowprice2 = get_cvar_num("fm_glowprice2")
	new enemylookprice2 = get_cvar_num("fm_enemylookprice2")
	new noclipprice2 = get_cvar_num("fm_noclipprice2")
	
	switch( key )
	{
		case 0:
		{
			new money=cs_get_user_money(id)
			if(money<=invisprice2){
				client_print(id, print_chat, "[FUN MOD] You need $%d to get invisibility",invisprice)
				return PLUGIN_HANDLED
			}
			else{
				new name[32]
				get_user_name(id,name,31)
				set_user_rendering(id,kRenderFxGlowShell, 0,0,0, kRenderTransAlpha,0)
				cs_set_user_money(id, money-invisprice)
				client_print(id, print_chat, "[FUN MOD] You bought invisibility and you are now invisible for this round.")
				set_hudmessage(200, 50, 0, -1.0, 0.30, 0, 6.0, 6.0, 0.5, 0.15, 1)
				show_hudmessage(0,"%s bought invsibility! You better run for your life!", name)
			}
			new alive=is_user_alive(id)
			if(alive = 0) {
				set_user_rendering(id,kRenderFxGlowShell, 0,0,0, kRenderTransAlpha,25)
			}
		}

		case 1:
		{
			new money=cs_get_user_money(id)
			if(money<=gravprice2){
				client_print(id, print_chat, "[FUN MOD] You need $%d to have your gravity set to %d",gravprice,givegrav)
				return PLUGIN_HANDLED
			}
			else{
				set_user_gravity(id, givegrav)
				cs_set_user_money(id, money-gravprice)
				client_print(id, print_chat, "[FUN MOD] Your gravity is now %d for this round",givegrav)
			}
		}

		case 2:
		{
			new money=cs_get_user_money(id)
			if(money<=hpprice2){
				client_print(id, print_chat, "[FUN MOD] You need $%d to have your health rise %d",hpprice,givehp)
				return PLUGIN_HANDLED
			}
			else{
				set_user_health(id, givehp)
				cs_set_user_money(id, money-hpprice)
				client_print(id, print_chat, "[FUN MOD] You bought %d health for this round only",givehp)
			}
		}

		case 3:
		{
			new money=cs_get_user_money(id)
			if(money<=glowprice2){
				client_print(id, print_chat, "[FUN MOD] You need $%d to glow",glowprice)
				return PLUGIN_HANDLED
			}
			else{
				cs_set_user_money(id, money-glowprice)
				set_user_rendering(id,kRenderFxGlowShell, 0,255,0, kRenderNormal,16)
				client_print(id, print_chat, "[FUN MOD] You bought glow for this round only")
			}
		}

		case 4:
		{
			new money=cs_get_user_money(id)
			if(money<=enemylookprice2){
				client_print(id, print_chat, "[FUN MOD] You need $%d to look like enemy",enemylookprice)
				return PLUGIN_HANDLED
			}
			else{
				new Float:enemy_time = get_cvar_float("fm_enemytime")
				new enemytime = get_cvar_num("fm_enemytime")
				new enemy_id[3]
				num_to_str(id,enemy_id,2)
				{
					if (get_user_team(id)==1)
					{
						cs_set_user_model(id, "sas")
					}
					else
					{
						cs_set_user_model(id, "arctic")
					}
				}
				is_enemy[id]=true
				set_task(enemy_time,"unenemy",1000+id,enemy_id,2)
				cs_set_user_money(id, money-enemylookprice)
				client_print(id, print_chat, "[FUN MOD] You now look like enemy for %d seconds",enemytime)
			}
		}

		case 5:
		{
			new money=cs_get_user_money(id)
			if(money<=noclipprice2){
				client_print(id, print_chat, "[FUN MOD] You need $%d to buy NoClip",noclipprice)
				return PLUGIN_HANDLED
			}
			else{
				set_user_noclip(id, 1)
				cs_set_user_money(id, money-noclipprice)
				client_print(id, print_chat, "[FUN MOD] You bought NoClip for this round only")
			}
		}

		case 6: client_print(id, print_console, "[FUN MOD] You exited the menu" )
	}

	return PLUGIN_HANDLED
}

public unenemy(enemy_id[])
{
	new id = str_to_num(enemy_id)
	cs_reset_user_model(id)
	client_print(id, print_chat, "[FUN MOD] You look like you should now")
	is_enemy[id]=false
}
