$(function () {
	// Check / uncheck all checkboxes
	$('.check_all').click(function() {
		$(this).parents('form').find('input:checkbox').attr('checked', $(this).is(':checked'));   
	});

	$('#forma select[name="select_action"]').change(function () {
		if( $('option:selected', this).val() == 'move' )
		{
			$('#forma select[name="pattern"]').css('display', 'inline');
		}
		else
		{
			$('#forma select[name="pattern"]').css('display', 'none');
		}
	});
});

function remove_row(subjm)
{
	if (confirm('Вы действительно хотите удалить?'))
	{
		$.ajax({
			type:'POST',
			url:'ajax.php?do=nc_patterns_ajax',
			data:({id : subjm,'go' : 3}),
			success:function(result) {
				if( result.indexOf('id="success"') + 1)
				{
					$('.accessMessage').html('');
					humanMsg.displayMsg(result,'success');
					$('tr#' + subjm).remove();
					rePagination(-1);
					$('table').trigger('update');
					$('table').trigger('applyWidgets', 'zebra');
				}
				else
				{
					humanMsg.displayMsg(result,'error');
				}
			}
		});
	}
	return false;
}

function edit_row(subjm)
{
	if($('tr td[id] input').length > 0)
	{
		cancelhandler();
	}

	$('tr#' + subjm + ' td[id]').each( function() {
		var valtext = $(this).text();
		var idtd = $(this).attr("id");
	
		$(this).html($('<input>')
			.attr('type','text')
			.attr('name',idtd)
			.attr('value',valtext)
			.addClass('text small')
		).append($('<input>')
			.attr('type','hidden')
			.attr('name',idtd)
			.attr('value',valtext)
		);
	});

	var $actionstr = $('tr#' + subjm + ' td.delete');

	$actionstr.html($('<a>')
		.click(function() {
			savehandler();
			return false;
		})
		.attr('href','#')
		.addClass('save')
		.text('Save')
	).append(' | ').append($('<a>')
		.click(function() {
			cancelhandler();
			return false;
		})
		.attr('href','#')
		.addClass('cancel')
		.text('Cancel')
	);

	return false;
}

function cancelhandler()
{
	$('tr td[id] input:hidden').each( function() {
		var tempval = $(this).val();
		var tempname = $(this).attr('name');

		$(this).parent().attr('id',tempname).html(tempval);
	});

	var $b = $('tr td.delete .cancel');
	var idrow = $b.parents('tr').attr("id");

	$b.parent().html($('<a>')
		.click(function() {
			return edit_row(idrow);
		})
		.attr('href','#')
		.text('Edit')
	).append(' | ').append($('<a>')
		.click(function() {
			return remove_row(idrow);
		})
		.attr('href','#')
		.text('Delete')
	);
}

function savehandler()
{
	var str = '';

	$('tr td[id] input:text').each( function() {
		var editval = $(this).val();
		var editname = $(this).attr('name');

		str = str + '&' + editname + '=' + editval;
	});

	var $b = $('tr td.delete .save');
	var idrow = $b.parents('tr').attr("id");

	$.ajax({
		type:'POST',
		url:'ajax.php?do=nc_patterns_ajax',
		data:'go=5&editid=' + idrow + str,
		success:function(result) {
			if( result.indexOf('id="success"') + 1)
			{
				$('.accessMessage').html('');
				humanMsg.displayMsg(result,'success');
				$('tr td[id] input:text').each( function() {
					$(this).parent().attr('id',$(this).attr('name')).html($(this).val());
				});
				$b.parent().html($('<a>')
					.click(function() {
						return edit_row(idrow);
					})
					.attr('href','#')
					.text('Edit')
				).append(' | ').append($('<a>')
					.click(function() {
						return remove_row(idrow);
					})
					.attr('href','#')
					.text('Delete')
				);
			}
			else
			{
				humanMsg.displayMsg(result,'error');
			}
		}
	});
}

$(document).ready(function() {
	$('.tablesorter').tablesorter({
		widgets: ['zebra'],
		headers: {0:{sorter: false}}
	});

	$('.cancel').click(cancelhandler);
	$('.save').click(savehandler);

	$('#forma').submit(function() {
		var len = $("tbody input:checked").length;
		if (len > 0)
		{
			var action = $('#forma select[name="select_action"] option:selected').val();
			if (action == 'delete')
			{
				if (confirm('Вы действительно хотите удалить выбранное?'))
				{
					var arr = new Array();
					$('tbody input:checked').each( function() {
						arr.push($(this).val());
					});
	
					$.ajax({
						type:'POST',
						url:'ajax.php?do=nc_patterns_ajax',
						data:({'marked_word[]' : arr,'go' : 4}),
						success:function(result) {
							if( result.indexOf('id="success"') + 1)
							{
								$('.accessMessage').html('');
								humanMsg.displayMsg(result,'success');
								rePagination(-arr.length);
								$('table').trigger('update');
								$('table').trigger('applyWidgets', 'zebra');
							}
							else
							{
								humanMsg.displayMsg(result,'error');
							}
						}
					});
	
					$(this).find('input:checkbox').attr('checked', $(this).is(''));   
				}
			}
			else
			{
				if (confirm('Вы действительно хотите переместить выбранное?'))
				{
					var arr = new Array();
					var act = $('#forma select[name="pattern"] option:selected').val();
					$('tbody input:checked').each( function() {
						arr.push($(this).val());
					});
	
					$.ajax({
						type:'POST',
						url:'ajax.php?do=nc_patterns_ajax',
						data:({'marked_word[]' : arr,'go' : 6,'action' : act}),
						success:function(result) {
							if( result.indexOf('id="success"') + 1)
							{
								$('.accessMessage').html('');
								humanMsg.displayMsg(result,'success');
								rePagination(-arr.length);
								$('table').trigger('update');
								$('table').trigger('applyWidgets', 'zebra');
							}
							else
							{
								humanMsg.displayMsg(result,'error');
							}
						}
					});
	
					$(this).find('input:checkbox').attr('checked', $(this).is(''));   
				}
			}

		} else {
			alert('Записи не выбраны!');
		}

		return false;
	});
});