/*
*********************************************************************************
*
*   Nick Control v1.2
*   Last Update: 25/01/2011
*    a114 Team
*
*   by Hafner
*   Support: http://www.a114games.com/content.php/14-Nick-Control
*
*
*********************************************************************************
*/

#include <amxmodx> 
#include <amxmisc> 
#include <fakemeta>
#include <regex>
#include <sqlx>

#define PLUGIN_NAME		"Nick Control"
#define PLUGIN_VERSION	"1.2"
#define PLUGIN_AUTHOR	"Hafner"

new const blocked_action_list[2][] = 
{
	"whitelist",
	"renamelist"
}

new Regex:g_rgxRes, g_regex_return
new Trie:g_tbAction
new g_serverip[22]

new Handle:info
new Handle:sql
new error[128]

new const g_name[] = "name"
new g_name_change[] = "#Cstrike_Name_Change"
new g_msgid_saytext

new pcvar_sql_table, pcvar_sql_nicklogs, pcvar_sql_servers, pcvar_sql_host, pcvar_sql_user, pcvar_sql_pass, pcvar_sql_db
new pcvar_immunity, pcvar_default_nick, pcvar_maxlen_nick, pcvar_minlen_nick, pcvar_announce, pcvar_savelogs, pcvar_changenick, pcvar_maxrepeat

public plugin_init() 
{ 
	register_plugin ( PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR )
	register_cvar( "acp_nickcontrol", PLUGIN_VERSION, FCVAR_SPONLY | FCVAR_SERVER )
	
	register_dictionary("acp_nickcontrol.txt")

	pcvar_default_nick = register_cvar("acp_nc_default", "CENSORED")
	pcvar_minlen_nick = register_cvar("acp_nc_minlen", "3")
	pcvar_maxlen_nick = register_cvar("acp_nc_maxlen", "25")
	pcvar_maxrepeat = register_cvar("acp_nc_maxrepeat", "3")
	pcvar_immunity = register_cvar("acp_nc_immunity", "a")
	pcvar_announce = register_cvar("acp_nc_announce", "1")
	pcvar_savelogs = register_cvar("acp_nc_savelogs", "1")
	pcvar_changenick = register_cvar("acp_nc_changenick", "1")

	pcvar_sql_table = register_cvar("acp_sql_nickcontrol", "acp_nick_patterns")
	pcvar_sql_servers = register_cvar("acp_sql_servers", "acp_servers")
	pcvar_sql_nicklogs = register_cvar("acp_sql_nicklogs", "acp_nick_logs")

	pcvar_sql_host = register_cvar("acp_sql_host", "localhost")
	pcvar_sql_user = register_cvar("acp_sql_user", "root")
	pcvar_sql_pass = register_cvar("acp_sql_pass", "")
	pcvar_sql_db = register_cvar("acp_sql_db", "amx")

	register_forward(FM_ClientUserInfoChanged, "forward_client_userinfochanged")

	g_msgid_saytext = get_user_msgid("SayText")
}

public plugin_cfg()
{
	g_tbAction = TrieCreate()

	new configsDir[64]
	get_configsdir(configsDir, 63)
	
	server_cmd("exec %s/acpanel/sql.cfg", configsDir)	
	server_cmd("exec %s/acpanel/nickcontrol.cfg", configsDir)

	set_task(0.1, "sql_init")
} 

public sql_init()
{
	new host[32], user[32], pass[32], dbname[32]
	get_pcvar_string(pcvar_sql_host,host,31)
	get_pcvar_string(pcvar_sql_user,user,31)
	get_pcvar_string(pcvar_sql_pass,pass,31)
	get_pcvar_string(pcvar_sql_db,dbname,31)

	info = SQL_MakeDbTuple(host,user,pass,dbname)

	new errno

	if(info) sql = SQL_Connect(info, errno, error, 127);

	if (sql == Empty_Handle)
	{
		server_print("[NickControl] %L", LANG_SERVER, "SQL_CANT_CON", error)
	}
	else
	{
		ServerInitialized()
	}
}

public plugin_end()
{
	TrieDestroy(g_tbAction)

	if(info==Empty_Handle)
		SQL_FreeHandle(info)
}

public ServerInitialized()
{
	LoadPatterns()

	new servername[100], table[32], query[512]

	get_user_ip(0, g_serverip, 21)
	get_cvar_string("hostname",servername,99)
	get_pcvar_string(pcvar_sql_servers, table, 31)

	format(query, 511, "INSERT INTO `%s` (`address`, `hostname`) VALUES ('%s','%s') ON DUPLICATE KEY UPDATE hostname = '%s'", table, g_serverip, servername, servername)

	SQL_ThreadQuery(info, "QueryHandle", query)	
}

public LoadPatterns()
{
	new table[32]	
	get_pcvar_string(pcvar_sql_table, table, 31)

	new Handle:query	
	query = SQL_PrepareQuery(sql, "SELECT `pattern`,`action` FROM `%s`", table)

	if (!SQL_Execute(query))
	{
		SQL_QueryError(query, error, 127)
		server_print("[NickControl] %L", LANG_SERVER, "SQL_CANT_LOAD_PATTERNS", error)

	}
	else if (!SQL_NumResults(query))
	{
		server_print("[NickControl] %L", LANG_SERVER, "NC_NOT_FOUND")

	}
	else
	{
		new nameData[64], blockedCount, g_BlockedAction

		while (SQL_MoreResults(query))
		{
			SQL_ReadResult(query, 0, nameData, sizeof(nameData)-1)
			g_BlockedAction = SQL_ReadResult(query, 1)

			new Array:nicksData

			if( !TrieGetCell(g_tbAction, blocked_action_list[g_BlockedAction], nicksData) )
			{
				nicksData = ArrayCreate(64)
			}

			ArrayPushArray(nicksData,nameData)
			TrieSetCell(g_tbAction, blocked_action_list[g_BlockedAction], nicksData);

			++blockedCount;
			SQL_NextRow(query)
		}
             
		if (blockedCount == 1)
			server_print("[NickControl] %L", LANG_SERVER, "SQL_LOADED_PATTERN")
		else
			server_print("[NickControl] %L", LANG_SERVER, "SQL_LOADED_PATTERNS", blockedCount)

	}

	SQL_FreeHandle(query)
	SQL_FreeHandle(sql)
}

public forward_client_userinfochanged(id, buffer)
{
	if (!is_user_connected(id))
		return FMRES_IGNORED

	static oldname[32], newname[32]
	get_user_name(id, oldname, sizeof oldname - 1)
	engfunc(EngFunc_InfoKeyValue, buffer, g_name, newname, sizeof newname - 1)
	if( equal(newname, oldname) )
		return FMRES_IGNORED

	static iflags, szflags[28]
	get_pcvar_string(pcvar_immunity, szflags, sizeof szflags - 1)
	iflags = read_flags(szflags)

	if( !(get_user_flags(id) & iflags) )
	{
		new bool:notchange = false

		if( get_pcvar_num(pcvar_changenick) )
		{
			if(check_name(id, newname, 2) == 1)
			{
				client_print(id, print_chat, "*** %L", id, "NC_MESSAGE")
				notchange = true
			}
		}
		else
		{
			client_print(id, print_chat, "*** %L", id, "NC_CHANGE")
			notchange = true
		}

		if( notchange )
		{
			engfunc(EngFunc_SetClientKeyValue, id, buffer, g_name, oldname)
			client_cmd(id, "name ^"%s^"; setinfo name ^"%s^"", oldname, oldname)

			return FMRES_SUPERCEDE
		}
	}

	if( get_pcvar_num(pcvar_announce) )
		msg_name_change(id, oldname, newname)

	return FMRES_SUPERCEDE
}

msg_name_change(id, oldname[], newname[])
{
	message_begin(MSG_BROADCAST, g_msgid_saytext)
	write_byte(id)
	write_string(g_name_change)
	write_string(oldname)
	write_string(newname)
	message_end()
}

public client_putinserver(id)
{
	static iflags, szflags[28]
	get_pcvar_string(pcvar_immunity, szflags, sizeof szflags - 1)
	iflags = read_flags(szflags)

	if( get_user_flags(id) & iflags )
		return PLUGIN_CONTINUE		

	new username[44]
	get_user_name(id, username, 43)

	if(check_name(id, username, 1) == 1)
	{
		new default_nick[32]
		get_pcvar_string(pcvar_default_nick, default_nick, 31)
	
		set_user_info(id, "name", default_nick)
	}

	return PLUGIN_CONTINUE
}

public check_name(id, name[], action)
{
	new i_Len = strlen(name), username[44]
	copy(username, sizeof(username) - 1, name)
	strtolower(username)

	if ( (i_Len > get_pcvar_num(pcvar_maxlen_nick)) || (i_Len < get_pcvar_num(pcvar_minlen_nick)) )
	{
		insert_logs(id,name,-1,action)
		return 1
	}

	for (new ib = 0; ib < sizeof( blocked_action_list ); ib++)
	{
		new Array:nicksData

		if(TrieGetCell(g_tbAction, blocked_action_list[ib], nicksData))
		{
			for (new y=0; y < ArraySize(nicksData); y++)
			{
				new buff[64]
				ArrayGetString(nicksData, y, buff, sizeof(buff)-1)
		
				g_rgxRes = regex_match(username, buff, g_regex_return, error, 127)
				if (g_rgxRes >= REGEX_OK)
				{
					regex_free(g_rgxRes)
					insert_logs(id,name,ib,action)
					return ib
				}
			}
		}    
	}

	new i_Repeat = get_pcvar_num(pcvar_maxrepeat)
	if ( i_Repeat > 1 )
	{
		new j = 1
		for (new i=0; i < i_Len-1; i++)
		{
			if (username[i] == username[i+1] )
				j++
			else
				j = 1
			
			if (j == i_Repeat)
			{
				insert_logs(id,name,-2,action)
				return 1
			}
		}
	}

	return 0
}

public insert_logs(id,name[],pattern,action) 
{
	if( is_user_bot(id) || !is_user_connected(id) || !get_pcvar_num(pcvar_savelogs) ) return PLUGIN_HANDLED

	new table[32], authid[32], ip[16], username[44], timestamp = get_systime(0)

	get_pcvar_string(pcvar_sql_nicklogs, table, 31)
	get_user_authid(id, authid, sizeof(authid) - 1)  
	get_user_ip(id, ip, sizeof(ip) - 1, 1)
	copy(username, sizeof(username) - 1, name)
	replace_all(username, sizeof(username) - 1, "'", "\'")

	new query[1001]
	format(query,1000,"INSERT into %s (serverip,name,authid,ip,timestamp,pattern,action) values ('%s','%s','%s','%s','%i','%d','%d')", table, g_serverip, name, authid, ip, timestamp, pattern, action) 
	SQL_ThreadQuery(info, "QueryHandle", query)

	return PLUGIN_CONTINUE
}

public QueryHandle(FailState, Handle:hQuery, Error[], Errcode, Data[], DataSize) 
{ 
	if(FailState != TQUERY_SUCCESS)                       
	{
		log_amx("[NickControl] SQL Error #%d - %s", Errcode, Error)        
	}
	return PLUGIN_CONTINUE
}