<?php

/**
* Smarty Internal Plugin Smarty Template Compiler Base
* 
* This file contains the basic classes and methodes for compiling Smarty templates with lexer/parser
* 
* @package Smarty
* @subpackage Compiler
* @author Uwe Tews 
*/
/**
* Class SmartyTemplateCompiler
*/
class Smarty_Internal_SmartyTemplateCompiler extends Smarty_Internal_TemplateCompilerBase {
    /**
    * Initialize compiler
    */
    public function __construct($lexer_class, $parser_class, $smarty)
    {
        $this->smarty = $smarty;
        parent::__construct(); 
        // get required plugins
        $this->lexer_class = $lexer_class;
        $this->parser_class = $parser_class;
    } 

    /**
    * Methode to compile a Smarty template
    * 
    * @param  $_content template source
    * @return bool true if compiling succeeded, false if it failed
    */
    protected function doCompile($_content)
    {
        /* here is where the compiling takes place. Smarty
       tags in the templates are replaces with PHP code,
       then written to compiled files. */ 
        // init the lexer/parser to compile the template
        $this->lex = new $this->lexer_class($_content, $this);
        $this->parser = new $this->parser_class($this->lex, $this); 
        if (isset($this->smarty->_parserdebug)) $this->parser->PrintTrace();
        // get tokens from lexer and parse them
        while ($this->lex->yylex() && !$this->abort_and_recompile) {
            if (isset($this->smarty->_parserdebug)) echo "<pre>Line {$this->lex->line} Parsing  {$this->parser->yyTokenName[$this->lex->token]} Token ".htmlentities($this->lex->value)."</pre>";
            $this->parser->doParse($this->lex->token, $this->lex->value);
        } 

        if ($this->abort_and_recompile) {
            // exit here on abort
            return false;
        } 
        // finish parsing process
        $this->parser->doParse(0, 0); 
        // check for unclosed tags
        if (count($this->_tag_stack) > 0) {
            // get stacked info
            list($_open_tag, $_data) = array_pop($this->_tag_stack);
            $this->trigger_template_error("unclosed {" . $_open_tag . "} tag");
        } 

        if (!$this->compile_error) {
            // return compiled code
            // return str_replace(array("? >\n<?php","? ><?php"), array('',''), $this->parser->retvalue);
            return $this->parser->retvalue;
        } else {
            // compilation error
            return false;
        } 
    } 
} 

?>
