#include <amxmodx>
#include <amxmisc>
#include <sockets>

#define PLUGIN	"BW Version Checker"
#define AUTHOR	"OT"
#define VERSION	"8.0"

#define PLUGIN_TOPIC				"/showthread.php?t=100886"
#define PLUGIN_HOST					"forums.alliedmods.net"

#define TASKID_GETANSWER			0
#define TASKID_CLOSECONNECTION		1

#define ACCESS_FLAG_TO_ANNOUNCE		ADMIN_SLAY

new g_Socket
new g_Data[1000]
new bool:g_NeedToUpdate
new g_StringVersion[10]
new Float:g_LastSaid[32]

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	register_event("ResetHUD", "event_ResetHUD", "b")
}

public event_ResetHUD(id)
{
	if (get_user_flags(id) & ADMIN_SLAY && g_NeedToUpdate && (get_gametime() - g_LastSaid[id-1] > 5.0))
	{
		client_print(id, print_chat, "[BW Version Checker] Block wallhack verion %s has been released!", g_StringVersion)
		client_print(id, print_chat, "[BW Version Checker] For maximum server protection update installation!")
		g_LastSaid[id-1] = get_gametime()
	}
}

public plugin_cfg()
{
	new error, getbuffer[512]
	g_Socket = socket_open(PLUGIN_HOST, 80, SOCKET_TCP, error)
 
	switch (error)
	{
		case 1:
		{
			log_amx("[BW Version Checker] Unable to create socket.")
			return
		}
		case 2:
		{
			log_amx("[BW Version Checker] Unable to connect to hostname.")
			return
		}
		case 3:
		{
			log_amx("[BW Version Checker] Unable to connect to the HTTP port.")
			return
		}
	}
	
	log_amx("[BW Version Checker] Connection with %s has been established", PLUGIN_HOST)
	
	format(getbuffer, 511, "GET %s HTTP/1.1^nHost:%s^r^n^r^n", PLUGIN_TOPIC, PLUGIN_HOST)
	
	socket_send(g_Socket, getbuffer, 511)
	
	log_amx("[BW Version Checker] Sending Block Wallhack page request.")
	
	set_task(1.0, "task_waitanswer", TASKID_GETANSWER, "", 0, "a", 15)
	set_task(16.0, "task_closeconnection", TASKID_CLOSECONNECTION, "", 0, "", 0)
}

public task_waitanswer(id)
{
	if (socket_change(g_Socket,1))
	{
		socket_recv(g_Socket, g_Data, 999)
		
		new Position = containi(g_Data, "Block Wallhack v")
		
		if (Position >= 0)
		{
			
			log_amx("[BW Version Checker] Page found, comparing versions.")
			
			Position += strlen("Block Wallhack v")
			
			new length
			
			for (new i=0;i<10;i++)
			{
				if ('0' <= g_Data[Position + i] <= '9' || g_Data[Position + i] == '.')
				{
					g_StringVersion[length] = g_Data[Position + i]
					length++
				}
			}
			
			g_NeedToUpdate = (str_to_float(g_StringVersion) > str_to_float(VERSION))
			
			log_amx("[BW Version Checker] Versions has been compared, closing connection. %s!", g_NeedToUpdate ? "Plugin is old" : "Plugin is updated")
			
			socket_close(g_Socket)
			
			remove_task(TASKID_GETANSWER)
			remove_task(TASKID_CLOSECONNECTION)
		}
	}
}

public task_closeconnection(id)
{
	socket_close(g_Socket)
}